/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.strategy.rdbms;

import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.teleporter.configuration.OConfigurationHandler;
import com.orientechnologies.teleporter.configuration.api.OConfiguration;
import com.orientechnologies.teleporter.configuration.api.OConfiguredVertexClass;
import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.context.OTeleporterStatistics;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.factory.OMapperFactory;
import com.orientechnologies.teleporter.importengine.rdbms.dbengine.ODBQueryEngine;
import com.orientechnologies.teleporter.importengine.rdbms.graphengine.OGraphEngineForDB;
import com.orientechnologies.teleporter.mapper.OSource2GraphMapper;
import com.orientechnologies.teleporter.mapper.rdbms.OER2GraphMapper;
import com.orientechnologies.teleporter.mapper.rdbms.classmapper.OEVClassMapper;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import com.orientechnologies.teleporter.model.graphmodel.OVertexType;
import com.orientechnologies.teleporter.nameresolver.ONameResolver;
import com.orientechnologies.teleporter.persistence.handler.ODBMSDataTypeHandler;
import com.orientechnologies.teleporter.strategy.rdbms.OAbstractDBMSImportStrategy;
import com.orientechnologies.teleporter.writer.OGraphModelWriter;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class ODBMSNaiveStrategy
extends OAbstractDBMSImportStrategy {
    public ODBMSNaiveStrategy(String protocol, String serverInitUrl, String dbName) {
        super(protocol, serverInitUrl, dbName);
    }

    @Override
    protected OConfigurationHandler buildConfigurationHandler() {
        return new OConfigurationHandler(false);
    }

    @Override
    public OER2GraphMapper createSchemaMapper(OSourceDatabaseInfo sourceDBInfo, String chosenMapper, String xmlPath, ONameResolver nameResolver, ODBMSDataTypeHandler handler, List<String> includedTables, List<String> excludedTables, OConfiguration migrationConfig) {
        OMapperFactory mapperFactory = new OMapperFactory();
        OER2GraphMapper mapper = (OER2GraphMapper)mapperFactory.buildMapper(chosenMapper, sourceDBInfo, xmlPath, includedTables, excludedTables, migrationConfig);
        mapper.buildSourceDatabaseSchema();
        OTeleporterContext.getInstance().getStatistics().notifyListeners();
        OTeleporterContext.getInstance().getMessageHandler().info((Object)this, "\n");
        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\n%s\n", new Object[]{mapper.getDataBaseSchema().toString()});
        }
        mapper.buildGraphModel(nameResolver);
        OTeleporterContext.getInstance().getStatistics().notifyListeners();
        OTeleporterContext.getInstance().getMessageHandler().info((Object)this, "\n");
        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\n%s\n", new Object[]{mapper.getGraphModel().toString()});
        }
        mapper.applyImportConfiguration();
        OGraphModelWriter graphModelWriter = new OGraphModelWriter(migrationConfig);
        boolean success = graphModelWriter.writeModelOnOrient(mapper, handler, this.dbName, this.protocol);
        if (!success) {
            OTeleporterContext.getInstance().getMessageHandler().error((Object)this, "Writing not complete. Something gone wrong.\n");
            throw new OTeleporterRuntimeException();
        }
        OTeleporterContext.getInstance().getStatistics().notifyListeners();
        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nOrientDB Schema writing complete.\n");
        }
        OTeleporterContext.getInstance().getMessageHandler().info((Object)this, "\n");
        return mapper;
    }

    @Override
    public void executeImport(OSourceDatabaseInfo sourceDBInfo, String dbName, OSource2GraphMapper genericMapper, ODBMSDataTypeHandler handler) {
        ODatabaseSession orientGraph = null;
        try {
            OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
            statistics.startWork4Time = new Date();
            statistics.runningStepNumber = 4;
            OER2GraphMapper mapper = (OER2GraphMapper)genericMapper;
            ODBQueryEngine dbQueryEngine = OTeleporterContext.getInstance().getDbQueryEngine();
            OGraphEngineForDB graphEngine = new OGraphEngineForDB(mapper, handler);
            try {
                orientGraph = OTeleporterContext.getInstance().getOrientDBInstance().open(dbName, "admin", "admin");
            }
            catch (Exception e) {
                String mess = "";
                OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
                OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
                throw new OTeleporterRuntimeException(e);
            }
            super.importEntitiesBelongingToHierarchies(dbQueryEngine, graphEngine, (ODatabaseDocument)orientGraph);
            for (OVertexType currentOutVertexType : mapper.getVertexType2EVClassMappers().keySet()) {
                List<OEVClassMapper> classMappersByVertex = this.mapper.getEVClassMappersByVertex(currentOutVertexType);
                LinkedList<OEntity> mappedEntities = new LinkedList<OEntity>();
                boolean allEntitiesNotBelongingToHierarchies = true;
                for (OEVClassMapper classMapper : classMappersByVertex) {
                    OEntity currentEntity = classMapper.getEntity();
                    if (currentEntity.getHierarchicalBag() != null) {
                        allEntitiesNotBelongingToHierarchies = false;
                        break;
                    }
                    mappedEntities.add(currentEntity);
                }
                if (!allEntitiesNotBelongingToHierarchies) continue;
                String[][] aggregationColumns = null;
                if (mappedEntities.size() > 1) {
                    OConfiguredVertexClass configuredVertex = mapper.getMigrationConfig().getVertexByMappedEntities(mappedEntities);
                    aggregationColumns = super.buildAggregationColumnsFromAggregatedVertex(configuredVertex);
                    if (currentOutVertexType.isAnalyzedInLastMigration()) continue;
                    super.importRecordsFromEntitiesIntoVertexClass(mappedEntities, aggregationColumns, currentOutVertexType, dbQueryEngine, graphEngine, (ODatabaseDocument)orientGraph);
                    continue;
                }
                if (mappedEntities.size() != 1) continue;
                List<OEVClassMapper> classMappersByEntity = this.mapper.getEVClassMappersByEntity((OEntity)mappedEntities.get(0));
                if (classMappersByEntity.size() == 1) {
                    if (currentOutVertexType.isAnalyzedInLastMigration()) continue;
                    super.importRecordsFromEntitiesIntoVertexClass(mappedEntities, aggregationColumns, currentOutVertexType, dbQueryEngine, graphEngine, (ODatabaseDocument)orientGraph);
                    continue;
                }
                if (classMappersByEntity.size() <= 1) continue;
                LinkedList<OVertexType> mappedVertices = new LinkedList<OVertexType>();
                for (OEVClassMapper classMapper : classMappersByEntity) {
                    mappedVertices.add(classMapper.getVertexType());
                }
                if (currentOutVertexType.isAnalyzedInLastMigration()) continue;
                super.importRecordsFromSplitEntityIntoVertexClasses(mappedEntities, mappedVertices, dbQueryEngine, graphEngine, (ODatabaseDocument)orientGraph);
            }
            statistics.notifyListeners();
            statistics.runningStepNumber = -1;
            orientGraph.close();
            OTeleporterContext.getInstance().getMessageHandler().info((Object)this, "\n");
        }
        catch (OTeleporterRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String mess = "Exception during records importing.\n";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            if (orientGraph != null) {
                orientGraph.close();
            }
            throw new OTeleporterRuntimeException(e);
        }
    }
}

