/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.util;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.output.OPluginMessageHandler;
import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import com.orientechnologies.teleporter.util.OFileManager;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class OMigrationConfigManager {
    private static final String configurationDirectoryName = "teleporter-config/";
    private static final String configFileName = "migration-config.json";
    private static final String sourceInfoFileName = "sources-access-info.json";
    private static boolean configPresentInDB;

    public static ODocument loadMigrationConfigFromFile(String configurationPath) {
        return OMigrationConfigManager.loadMigrationConfigFromFile(null, configurationPath, OTeleporterContext.getInstance().getMessageHandler());
    }

    public static ODocument loadMigrationConfigFromFile(Object requester, String configurationPath, OPluginMessageHandler messageHandler) {
        ODocument config = null;
        try {
            config = OFileManager.buildJsonFromFile(configurationPath);
            if (config != null) {
                messageHandler.info(OMigrationConfigManager.class, "Configuration correctly loaded from %s.\n", new Object[]{configurationPath});
            }
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.printExceptionMessage(requester, messageHandler, e, mess, "error");
            OTeleporterContext.printExceptionStackTrace(requester, messageHandler, e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return config;
    }

    public static String buildConfigurationFilePath(String outOrientGraphUri, String configFileName) {
        String outDBConfigPath;
        if (outOrientGraphUri.contains("\\")) {
            outOrientGraphUri = outOrientGraphUri.replace("\\", "/");
        }
        if (outOrientGraphUri.charAt(outOrientGraphUri.length() - 1) != '/') {
            outOrientGraphUri = outOrientGraphUri + "/";
        }
        if ((outDBConfigPath = outOrientGraphUri + configurationDirectoryName + configFileName).contains("plocal:")) {
            outDBConfigPath = outDBConfigPath.replace("plocal:", "");
        } else if (outDBConfigPath.contains("embedded:")) {
            outDBConfigPath = outDBConfigPath.replace("embedded:", "");
        }
        return outDBConfigPath;
    }

    public static void writeConfigurationInTargetDB(ODocument migrationConfig, String outOrientGraphUri) {
        String outDBConfigPath = OMigrationConfigManager.prepareConfigDirectoryForWriting(outOrientGraphUri);
        String jsonSourcesInfo = migrationConfig.toJSON("prettyPrint");
        try {
            OFileManager.writeFileFromText(jsonSourcesInfo, outDBConfigPath, false);
        }
        catch (IOException e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
        }
    }

    public static void writeConfigurationInTargetDB(String migrationConfig, String outOrientGraphUri) throws IOException {
        String outDBConfigPath = OMigrationConfigManager.prepareConfigDirectoryForWriting(outOrientGraphUri);
        OFileManager.writeFileFromText(migrationConfig, outDBConfigPath, false);
    }

    private static String prepareConfigDirectoryForWriting(String outOrientGraphUri) {
        String outDBConfigPath = OMigrationConfigManager.buildConfigurationFilePath(outOrientGraphUri, configFileName);
        File confFileInOrientDB = new File(outDBConfigPath);
        if (confFileInOrientDB.exists()) {
            confFileInOrientDB.delete();
        }
        return outDBConfigPath;
    }

    public static ODocument loadSourceInfo(String outOrientGraphUri) {
        String outDBConfigPath = OMigrationConfigManager.buildConfigurationFilePath(outOrientGraphUri, sourceInfoFileName);
        File confFileInOrientDB = new File(outDBConfigPath);
        configPresentInDB = confFileInOrientDB.exists();
        ODocument sourcesAccessInfo = null;
        try {
            if (configPresentInDB) {
                sourcesAccessInfo = OFileManager.buildJsonFromFile(outDBConfigPath);
                OTeleporterContext.getInstance().getMessageHandler().info(OMigrationConfigManager.class, "Sources' access info correctly loaded from %s.\n", new Object[]{outDBConfigPath});
            } else {
                OTeleporterContext.getInstance().getMessageHandler().info(OMigrationConfigManager.class, "No sources' access info file was found.\n");
            }
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return sourcesAccessInfo;
    }

    public static List<OSourceDatabaseInfo> extractSourceDatabaseInfo(ODocument sourcesInfoDoc) {
        LinkedList<OSourceDatabaseInfo> sourcesInfo = new LinkedList<OSourceDatabaseInfo>();
        List sources = (List)sourcesInfoDoc.field("sources");
        for (ODocument currSourceInfo : sources) {
            String[] fieldNames = currSourceInfo.fieldNames();
            String sourceIdName = fieldNames[0];
            ODocument info = (ODocument)currSourceInfo.field(sourceIdName);
            String driverName = (String)info.field("driverName");
            String url = (String)info.field("url");
            String user = (String)info.field("username");
            String passwd = (String)info.field("password");
            List primaryKey = (List)info.field("primaryKey");
            OSourceDatabaseInfo sourceInfo = new OSourceDatabaseInfo(sourceIdName, driverName, url, user, passwd, primaryKey);
            sourcesInfo.add(sourceInfo);
        }
        return sourcesInfo;
    }

    public static void upsertSourceDatabaseInfo(List<OSourceDatabaseInfo> sourcesInfo, String outOrientGraphUri) {
        String outDBConfigPath = OMigrationConfigManager.buildConfigurationFilePath(outOrientGraphUri, sourceInfoFileName);
        File confFileInOrientDB = new File(outDBConfigPath);
        if (confFileInOrientDB.exists()) {
            confFileInOrientDB.delete();
        }
        ODocument sourcesInfoDoc = new ODocument();
        LinkedList<ODocument> sources = new LinkedList<ODocument>();
        for (OSourceDatabaseInfo currSourceInfo : sourcesInfo) {
            ODocument source = new ODocument();
            ODocument sourceInfo = new ODocument();
            sourceInfo.field("driverName", (Object)currSourceInfo.getDriverName());
            sourceInfo.field("url", (Object)currSourceInfo.getUrl());
            sourceInfo.field("username", (Object)currSourceInfo.getUsername());
            sourceInfo.field("password", (Object)currSourceInfo.getPassword());
            source.field(currSourceInfo.getSourceIdName(), (Object)sourceInfo);
            sources.add(source);
        }
        sourcesInfoDoc.field("sources", sources);
        String jsonSourcesInfo = sourcesInfoDoc.toJSON("prettyPrint");
        try {
            OFileManager.writeFileFromText(jsonSourcesInfo, outDBConfigPath, false);
        }
        catch (IOException e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
        }
    }

    public static String getConfigurationDirectoryName() {
        return configurationDirectoryName;
    }

    public static String getConfigFileName() {
        return configFileName;
    }

    public static String getSourceInfoFileName() {
        return sourceInfoFileName;
    }
}

