/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.writer;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.teleporter.configuration.api.OConfiguration;
import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.context.OTeleporterStatistics;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.mapper.rdbms.OER2GraphMapper;
import com.orientechnologies.teleporter.model.dbschema.OAttribute;
import com.orientechnologies.teleporter.model.dbschema.ODataBaseSchema;
import com.orientechnologies.teleporter.model.dbschema.OLogicalRelationship;
import com.orientechnologies.teleporter.model.graphmodel.OEdgeType;
import com.orientechnologies.teleporter.model.graphmodel.OElementType;
import com.orientechnologies.teleporter.model.graphmodel.OGraphModel;
import com.orientechnologies.teleporter.model.graphmodel.OModelProperty;
import com.orientechnologies.teleporter.model.graphmodel.OVertexType;
import com.orientechnologies.teleporter.persistence.handler.ODriverDataTypeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OGraphModelWriter {
    private Map<String, OType> orientdbTypeName2orientdbType;
    private OConfiguration previousConfiguration;

    public OGraphModelWriter() {
        this.init();
    }

    public OGraphModelWriter(OConfiguration previousConfig) {
        this.previousConfiguration = previousConfig;
        this.init();
    }

    private void init() {
        this.orientdbTypeName2orientdbType = new HashMap<String, OType>();
        this.orientdbTypeName2orientdbType.put("boolean", OType.BOOLEAN);
        this.orientdbTypeName2orientdbType.put("integer", OType.INTEGER);
        this.orientdbTypeName2orientdbType.put("decimal", OType.DECIMAL);
        this.orientdbTypeName2orientdbType.put("short", OType.SHORT);
        this.orientdbTypeName2orientdbType.put("long", OType.LONG);
        this.orientdbTypeName2orientdbType.put("float", OType.FLOAT);
        this.orientdbTypeName2orientdbType.put("double", OType.DOUBLE);
        this.orientdbTypeName2orientdbType.put("datetime", OType.DATETIME);
        this.orientdbTypeName2orientdbType.put("date", OType.DATE);
        this.orientdbTypeName2orientdbType.put("string", OType.STRING);
        this.orientdbTypeName2orientdbType.put("binary", OType.BINARY);
        this.orientdbTypeName2orientdbType.put("byte", OType.BYTE);
    }

    public boolean writeModelOnOrient(OER2GraphMapper mapper, ODriverDataTypeHandler handler, String dbName, String protocol) {
        int numberOfEdges;
        int numberOfVertices;
        ODatabaseSession orientGraph;
        boolean success = false;
        OGraphModel graphModel = mapper.getGraphModel();
        try {
            if (!OTeleporterContext.getInstance().getOrientDBInstance().exists(dbName)) {
                switch (protocol) {
                    case "embedded": {
                        OTeleporterContext.getInstance().getOrientDBInstance().create(dbName, ODatabaseType.PLOCAL);
                        break;
                    }
                    case "plocal": {
                        OTeleporterContext.getInstance().getOrientDBInstance().create(dbName, ODatabaseType.PLOCAL);
                        break;
                    }
                    case "memory": {
                        OTeleporterContext.getInstance().getOrientDBInstance().create(dbName, ODatabaseType.MEMORY);
                        break;
                    }
                    case "remote": {
                        String message = "Cannot create a new database in remote. Try to create a new empty database and restart the migration.\nThe current job will be aborted.";
                        throw new OTeleporterRuntimeException(message);
                    }
                    default: {
                        String message = "Protocol not correct. Migration will be aborted.";
                        throw new OTeleporterRuntimeException(message);
                    }
                }
            }
            orientGraph = OTeleporterContext.getInstance().getOrientDBInstance().open(dbName, "admin", "admin");
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        statistics.startWork3Time = new Date();
        statistics.runningStepNumber = 3;
        OSchema orientSchema = orientGraph.getMetadata().getSchema();
        statistics.totalNumberOfVertexTypes = numberOfVertices = graphModel.getVerticesType().size();
        statistics.totalNumberOfEdgeTypes = numberOfEdges = graphModel.getEdgesType().size();
        statistics.totalNumberOfIndices = numberOfVertices;
        Collection orientClasses = orientSchema.getClasses();
        for (OClass currOrientClass : orientClasses) {
            String orientClassName = currOrientClass.getName();
            if (orientClassName.startsWith("O") || orientClassName.startsWith("V") || orientClassName.startsWith("E") || orientClassName.startsWith("_") || graphModel.getVertexTypeByNameIgnoreCase(orientClassName) != null || graphModel.getEdgeTypeByNameIgnoreCase(orientClassName) != null) continue;
            orientSchema.dropClass(orientClassName);
        }
        if (!this.inheritanceChangesPresent(graphModel, (ODatabaseDocument)orientGraph)) {
            try {
                OType type;
                if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                    OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nWriting vertex-types on OrientDB Schema...\n");
                }
                Iterator<OModelProperty> it = null;
                int iteration = 1;
                for (OVertexType oVertexType : graphModel.getVerticesType()) {
                    OClass newVertexType;
                    if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nWriting '%s' vertex-type  (%s/%s)...\n", new Object[]{oVertexType.getName(), iteration, numberOfVertices});
                    }
                    if ((newVertexType = orientGraph.getClass(oVertexType.getName())) == null) {
                        OElementType parentType = oVertexType.getParentType();
                        if (parentType != null) {
                            OClass superClass = orientGraph.createClassIfNotExist(parentType.getName(), new String[]{"V"});
                            newVertexType = orientGraph.createClass(oVertexType.getName(), new String[]{superClass.getName()});
                        } else {
                            newVertexType = orientGraph.createVertexClass(oVertexType.getName());
                        }
                        OModelProperty currentProperty = null;
                        it = oVertexType.getProperties().iterator();
                        while (it.hasNext()) {
                            currentProperty = it.next();
                            if (!currentProperty.isIncludedInMigration()) continue;
                            type = currentProperty.getOrientdbType() == null ? handler.resolveType(currentProperty.getOriginalType().toLowerCase(Locale.ENGLISH)) : this.resolveOrientDBType(currentProperty.getOrientdbType());
                            if (type != null) {
                                String propertyName = currentProperty.getName();
                                OProperty orientdbProperty = newVertexType.createProperty(propertyName, type);
                                if (currentProperty.isMandatory() != null) {
                                    orientdbProperty.setMandatory(currentProperty.isMandatory().booleanValue());
                                }
                                if (currentProperty.isReadOnly() != null) {
                                    orientdbProperty.setReadonly(currentProperty.isReadOnly().booleanValue());
                                }
                                if (currentProperty.isNotNull() == null) continue;
                                orientdbProperty.setNotNull(currentProperty.isNotNull().booleanValue());
                                continue;
                            }
                            it.remove();
                            statistics.warningMessages.add(currentProperty.getOriginalType() + " type is not supported, the correspondent property will be dropped.");
                        }
                        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nVertex-type '%s' wrote.\n", new Object[]{oVertexType.getName()});
                        }
                    } else {
                        boolean updated = this.checkAndUpdateClass((ODatabaseDocument)orientGraph, oVertexType, handler);
                        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                            if (updated) {
                                OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nVertex-type '%s' updated.\n", new Object[]{oVertexType.getName()});
                            } else {
                                OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nVertex-type '%s' already present in the Orient schema.\n", new Object[]{oVertexType.getName()});
                            }
                        }
                    }
                    ++iteration;
                    ++statistics.wroteVertexType;
                }
                if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                    OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nWriting edge-types on OrientDB Schema...\n");
                }
                iteration = 1;
                for (OEdgeType currentEdgeType : graphModel.getEdgesType()) {
                    OClass newEdgeType;
                    if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nWriting '%s' edge-type  (%s/%s)...\n", new Object[]{currentEdgeType.getName(), iteration, numberOfEdges});
                    }
                    if ((newEdgeType = orientGraph.getClass(currentEdgeType.getName())) == null) {
                        newEdgeType = orientGraph.createEdgeClass(currentEdgeType.getName());
                        OModelProperty currentProperty = null;
                        it = currentEdgeType.getProperties().iterator();
                        while (it.hasNext()) {
                            currentProperty = it.next();
                            if (!currentProperty.isIncludedInMigration()) continue;
                            type = currentProperty.getOrientdbType() == null ? handler.resolveType(currentProperty.getOriginalType().toLowerCase(Locale.ENGLISH)) : this.resolveOrientDBType(currentProperty.getOrientdbType());
                            if (type != null) {
                                OProperty orientdbProperty = newEdgeType.createProperty(currentProperty.getName(), type);
                                if (currentProperty.isMandatory() != null) {
                                    orientdbProperty.setMandatory(currentProperty.isMandatory().booleanValue());
                                }
                                if (currentProperty.isReadOnly() != null) {
                                    orientdbProperty.setReadonly(currentProperty.isReadOnly().booleanValue());
                                }
                                if (currentProperty.isNotNull() == null) continue;
                                orientdbProperty.setNotNull(currentProperty.isNotNull().booleanValue());
                                continue;
                            }
                            it.remove();
                            statistics.warningMessages.add(currentProperty.getOriginalType() + " type is not supported, the correspondent property will be dropped.");
                        }
                        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nEdge-type '%s' wrote.\n", new Object[]{currentEdgeType.getName()});
                        }
                    } else {
                        boolean updated = this.checkAndUpdateClass((ODatabaseDocument)orientGraph, currentEdgeType, handler);
                        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                            if (updated) {
                                OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nEdge-type '%s' updated.\n", new Object[]{currentEdgeType.getName()});
                            } else {
                                OTeleporterContext.getInstance().getMessageHandler().debug((Object)"\nEdge-type '%s' already present in the Orient schema.\n", currentEdgeType.getName());
                            }
                        }
                    }
                    ++iteration;
                    ++statistics.wroteEdgeType;
                }
                if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                    OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nBuilding indexes on properties belonging to the original primary keys...\n");
                }
                Object var19_26 = null;
                ArrayList<String> properties = null;
                iteration = 1;
                OIndexManagerProxy indexManager = (OIndexManagerProxy)orientGraph.getMetadata().getIndexManager();
                for (OVertexType currentVertexType : graphModel.getVerticesType()) {
                    String string = currentVertexType.getName();
                    properties = new ArrayList<String>();
                    for (OModelProperty currentProperty : currentVertexType.getProperties()) {
                        if (!currentProperty.isFromPrimaryKey()) continue;
                        properties.add(currentProperty.getName());
                    }
                    this.buildIndexOnExternalKey((ODatabaseDocument)orientGraph, numberOfVertices, iteration, string, properties, indexManager, currentVertexType);
                    ++iteration;
                    ++statistics.wroteIndexes;
                }
                iteration = 1;
                ODataBaseSchema dbSchema = mapper.getDataBaseSchema();
                for (OLogicalRelationship logicalRelationship : dbSchema.getLogicalRelationships()) {
                    OVertexType currentInVertexType = mapper.getVertexTypeByEntity(logicalRelationship.getParentEntity());
                    String string = currentInVertexType.getName();
                    properties = new ArrayList();
                    String indexClassName = string + ".";
                    for (OAttribute attribute : logicalRelationship.getToColumns()) {
                        String correspondentPropertyName = mapper.getPropertyNameByVertexTypeAndAttribute(currentInVertexType, attribute.getName());
                        properties.add(correspondentPropertyName);
                        indexClassName = indexClassName + correspondentPropertyName + "_";
                    }
                    indexClassName = indexClassName.substring(0, indexClassName.lastIndexOf("_"));
                    this.buildLogicalIndex((ODatabaseDocument)orientGraph, numberOfVertices, iteration, string, properties, indexManager, currentInVertexType, indexClassName);
                    OVertexType currentOutVertexType = mapper.getVertexTypeByEntity(logicalRelationship.getForeignEntity());
                    String string2 = currentOutVertexType.getName();
                    properties = new ArrayList();
                    indexClassName = string2 + ".";
                    for (OAttribute attribute : logicalRelationship.getFromColumns()) {
                        String correspondentPropertyName = mapper.getPropertyNameByVertexTypeAndAttribute(currentOutVertexType, attribute.getName());
                        properties.add(correspondentPropertyName);
                        indexClassName = indexClassName + correspondentPropertyName + "_";
                    }
                    indexClassName = indexClassName.substring(0, indexClassName.lastIndexOf("_"));
                    this.buildLogicalIndex((ODatabaseDocument)orientGraph, numberOfVertices, iteration, string2, properties, indexManager, currentInVertexType, indexClassName);
                }
            }
            catch (OException e) {
                String mess = "";
                OTeleporterContext.getInstance().printExceptionMessage((Exception)((Object)e), mess, "error");
                OTeleporterContext.getInstance().printExceptionStackTrace((Exception)((Object)e), "error");
                throw new OTeleporterRuntimeException(e);
            }
        } else {
            OTeleporterContext.getInstance().getMessageHandler().error((Object)this, "Changes on entities involved in hierarchical trees detected: Teleporter cannot support these variation and neithergrant coherence between the two databases. Rebuild the schema from scratch.\n");
            throw new OTeleporterRuntimeException();
        }
        statistics.notifyListeners();
        statistics.runningStepNumber = -1;
        orientGraph.close();
        success = true;
        return success;
    }

    private void buildIndexOnExternalKey(ODatabaseDocument orientGraph, int numberOfVertices, int iteration, String currentType, List<String> properties, OIndexManagerProxy indexManager, OVertexType currentVertexType) {
        boolean isPresent;
        String indexClassName = currentType + ".pkey";
        OIndex classIndex = indexManager.getClassIndex(currentType, indexClassName);
        if (classIndex != null) {
            List fieldNames = classIndex.getDefinition().getFields();
            for (String field : fieldNames) {
                if (properties.contains(field)) continue;
                indexManager.dropIndex(indexClassName);
                break;
            }
        }
        if (!(isPresent = indexManager.existsIndex(indexClassName))) {
            String propertiesList = "";
            int j = 0;
            for (String property : properties) {
                propertiesList = j == properties.size() - 1 ? propertiesList + property : propertiesList + property + ",";
                ++j;
            }
            if (!propertiesList.isEmpty()) {
                if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                    OTeleporterContext.getInstance().getMessageHandler().debug((Object)"\nBuilding index for '%s' on %s  (%s/%s)...\n", currentVertexType.getName(), new Object[]{propertiesList, iteration, numberOfVertices});
                }
                String statement = "create index `" + currentType + ".pkey` on `" + currentType + "` (" + propertiesList + ") unique_hash_index";
                OCommandSQL sqlCommand = new OCommandSQL(statement);
                orientGraph.command((OCommandRequest)sqlCommand).execute(new Object[0]);
                if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                    OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nIndex for %s built.\n", new Object[]{currentVertexType.getName()});
                }
            } else {
                OTeleporterContext.getInstance().getStatistics().warningMessages.add("The table '" + currentVertexType.getName() + "' has not primary key constraints defined in the db schema, thus the correspondent Class Vertex in Orient will not have a default index on the property deriving from the original primary key.");
            }
        } else if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nIndex for %s already present in the Orient schema.\n", new Object[]{currentVertexType.getName()});
        }
    }

    private void buildLogicalIndex(ODatabaseDocument orientGraph, int numberOfVertices, int iteration, String currentType, List<String> properties, OIndexManagerProxy indexManager, OVertexType currentVertexType, String indexClassName) {
        boolean isPresent = indexManager.existsIndex(indexClassName);
        if (!isPresent) {
            String propertiesList = "";
            int j = 0;
            for (String property : properties) {
                propertiesList = j == properties.size() - 1 ? propertiesList + property : propertiesList + property + ",";
                ++j;
            }
            if (!propertiesList.isEmpty()) {
                if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                    OTeleporterContext.getInstance().getMessageHandler().debug((Object)"\nBuilding index for '%s' on %s  (%s/%s)...\n", currentVertexType.getName(), new Object[]{propertiesList, iteration, numberOfVertices});
                }
                String statement = "create index `" + indexClassName + "` on `" + currentType + "` (" + propertiesList + ") notunique_hash_index";
                OCommandSQL sqlCommand = new OCommandSQL(statement);
                orientGraph.command((OCommandRequest)sqlCommand).execute(new Object[0]);
                if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                    OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nIndex for %s built.\n", new Object[]{currentVertexType.getName()});
                }
            } else {
                OTeleporterContext.getInstance().getStatistics().warningMessages.add("The table '" + currentVertexType.getName() + "' has not primary key constraints defined in the db schema, thus the correspondent Class Vertex in Orient will not have a default index on the property deriving from the original primary key.");
            }
        } else if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nIndex for %s already present in the Orient schema.\n", new Object[]{currentVertexType.getName()});
        }
    }

    private boolean checkAndUpdateClass(ODatabaseDocument orientGraph, OElementType currentElementType, ODriverDataTypeHandler handler) {
        boolean updated = false;
        OClass orientElementType = null;
        if (currentElementType instanceof OVertexType) {
            orientElementType = orientGraph.getClass(currentElementType.getName());
        } else if (currentElementType instanceof OEdgeType) {
            orientElementType = orientGraph.getClass(currentElementType.getName());
        } else {
            OTeleporterContext.getInstance().getMessageHandler().error((Object)"Fatal error: current element type '%s' is not instance neither of Vertex Type nor of EdgeType.\n", currentElementType.getName());
            throw new OTeleporterRuntimeException();
        }
        String className = currentElementType.getName();
        if (!orientElementType.getName().equals(className)) {
            orientElementType.setName(className);
        }
        for (OModelProperty currentModelProperty : currentElementType.getProperties()) {
            if (!currentModelProperty.isIncludedInMigration()) continue;
            OProperty orientSchemaProperty = orientElementType.getProperty(currentModelProperty.getName());
            OType newResolvedType = currentModelProperty.getOrientdbType() != null ? this.resolveOrientDBType(currentModelProperty.getOrientdbType()) : handler.resolveType(currentModelProperty.getOriginalType().toLowerCase(Locale.ENGLISH));
            if (orientSchemaProperty != null) {
                OType actualOrientType = orientSchemaProperty.getType();
                if (actualOrientType.toString().equalsIgnoreCase(newResolvedType.toString())) continue;
                orientElementType.dropProperty(currentModelProperty.getName());
                orientElementType.createProperty(currentModelProperty.getName(), newResolvedType);
                continue;
            }
            orientElementType.createProperty(currentModelProperty.getName(), newResolvedType);
            updated = true;
        }
        Iterator it2 = orientElementType.declaredProperties().iterator();
        LinkedList<String> toDrop = new LinkedList<String>();
        while (it2.hasNext()) {
            OProperty orientSchemaProperty2 = (OProperty)it2.next();
            if (currentElementType.getPropertyByName(orientSchemaProperty2.getName()) != null && currentElementType.getPropertyByName(orientSchemaProperty2.getName()).isIncludedInMigration()) continue;
            toDrop.add(orientSchemaProperty2.getName());
            updated = true;
        }
        for (String propertyName : toDrop) {
            orientElementType.dropProperty(propertyName);
        }
        return updated;
    }

    public boolean inheritanceChangesPresent(OGraphModel graphModel, ODatabaseDocument orientGraph) {
        for (OVertexType currentVertexType : graphModel.getVerticesType()) {
            OClass orientCorrespondentVertexType = orientGraph.getClass(currentVertexType.getName());
            if (currentVertexType == null || orientCorrespondentVertexType == null) continue;
            if (currentVertexType.getParentType() == null && !orientCorrespondentVertexType.isSubClassOf("V") || currentVertexType.getParentType() != null && orientCorrespondentVertexType.isSubClassOf("V")) {
                return true;
            }
            if (currentVertexType.getParentType() == null || orientCorrespondentVertexType.isSubClassOf("V") || currentVertexType.getParentType().getName().equals(((OClass)orientCorrespondentVertexType.getSuperClasses().get(0)).getName())) continue;
            return true;
        }
        return false;
    }

    public OType resolveOrientDBType(String orientdbTypeName) {
        orientdbTypeName = orientdbTypeName.toLowerCase(Locale.ENGLISH);
        return this.orientdbTypeName2orientdbType.get(orientdbTypeName);
    }
}

