/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.lock.OSimpleLockManager;
import com.orientechnologies.common.exception.OException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OSimpleLockManagerImpl<T>
implements OSimpleLockManager<T> {
    private final Lock lock = new ReentrantLock();
    private final Map<T, Condition> map = new HashMap<T, Condition>();
    private final long timeout;

    public OSimpleLockManagerImpl(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void lock(T key) {
        this.lock.lock();
        try {
            try {
                Condition c;
                do {
                    if ((c = this.map.get(key)) == null) continue;
                    if (this.timeout == 0L) {
                        c.await();
                        continue;
                    }
                    if (c.await(this.timeout, TimeUnit.MILLISECONDS)) continue;
                    throw new OLockException(String.format("Time out acquire lock for resource: '%s' ", key));
                } while (c != null);
                c = this.lock.newCondition();
                this.map.put(key, c);
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OInterruptedException("Interrupted Lock"), e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void unlock(T key) {
        this.lock.lock();
        try {
            Condition c = this.map.remove(key);
            assert (c != null);
            c.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

