/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import java.util.concurrent.atomic.AtomicReference;

public class ODatabaseRecordThreadLocal
extends ThreadLocal<ODatabaseDocumentInternal> {
    private static final AtomicReference<ODatabaseRecordThreadLocal> INSTANCE = new AtomicReference();

    public static ODatabaseRecordThreadLocal instance() {
        ODatabaseRecordThreadLocal dbInst = INSTANCE.get();
        if (dbInst != null) {
            return dbInst;
        }
        if (INSTANCE.get() == null) {
            Orient inst = Orient.instance();
            inst.registerListener(new OOrientListenerAbstract(){

                @Override
                public void onStartup() {
                }

                @Override
                public void onShutdown() {
                    INSTANCE.set(null);
                }
            });
            INSTANCE.compareAndSet(null, new ODatabaseRecordThreadLocal());
        }
        return INSTANCE.get();
    }

    @Override
    public ODatabaseDocumentInternal get() {
        ODatabaseDocumentInternal db = (ODatabaseDocumentInternal)super.get();
        if (db == null) {
            if (Orient.instance().getDatabaseThreadFactory() == null) {
                throw new ODatabaseException("The database instance is not set in the current thread. Be sure to set it with: ODatabaseRecordThreadLocal.instance().set(db);");
            }
            db = Orient.instance().getDatabaseThreadFactory().getThreadDatabase();
            if (db == null) {
                throw new ODatabaseException("The database instance is not set in the current thread. Be sure to set it with: ODatabaseRecordThreadLocal.instance().set(db);");
            }
            this.set(db);
        }
        return db;
    }

    @Override
    public void remove() {
        super.remove();
    }

    @Override
    public void set(ODatabaseDocumentInternal value) {
        super.set(value);
    }

    public ODatabaseDocumentInternal getIfDefined() {
        return (ODatabaseDocumentInternal)super.get();
    }

    public boolean isDefined() {
        return super.get() != null;
    }
}

