/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OEmbeddedDatabaseInstanceFactory;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBEmbedded;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public interface OrientDBInternal
extends AutoCloseable {
    public static OrientDBInternal fromUrl(String url, OrientDBConfig configuration) {
        String what = url.substring(0, url.indexOf(58));
        if ("embedded".equals(what)) {
            return OrientDBInternal.embedded(url.substring(url.indexOf(58) + 1), configuration);
        }
        if ("remote".equals(what)) {
            return OrientDBInternal.remote(url.substring(url.indexOf(58) + 1).split(";"), configuration);
        }
        throw new ODatabaseException("not supported database type");
    }

    default public OrientDB newOrientDB() {
        return new OrientDB(this);
    }

    public static OrientDBInternal remote(String[] hosts, OrientDBConfig configuration) {
        OrientDBInternal factory;
        try {
            String className = "com.orientechnologies.orient.core.db.OrientDBRemote";
            ClassLoader loader = configuration != null ? configuration.getClassLoader() : OrientDBInternal.class.getClassLoader();
            Class<?> kass = loader.loadClass(className);
            Constructor<?> constructor = kass.getConstructor(String[].class, OrientDBConfig.class, Orient.class);
            factory = (OrientDBInternal)constructor.newInstance(hosts, configuration, Orient.instance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw OException.wrapException(new ODatabaseException("OrientDB client API missing"), e);
        }
        catch (InvocationTargetException e) {
            throw OException.wrapException(new ODatabaseException("Error creating OrientDB remote factory"), e.getTargetException());
        }
        return factory;
    }

    public static OrientDBInternal embedded(String directoryPath, OrientDBConfig config) {
        return new OrientDBEmbedded(directoryPath, config, Orient.instance());
    }

    public static OrientDBInternal distributed(String directoryPath, OrientDBConfig configuration) {
        OrientDBInternal factory;
        try {
            String className = "com.orientechnologies.orient.core.db.OrientDBDistributed";
            ClassLoader loader = configuration != null ? configuration.getClassLoader() : OrientDBInternal.class.getClassLoader();
            Class<?> kass = loader.loadClass(className);
            Constructor<?> constructor = kass.getConstructor(String.class, OrientDBConfig.class, Orient.class);
            factory = (OrientDBInternal)constructor.newInstance(directoryPath, configuration, Orient.instance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw OException.wrapException(new ODatabaseException("OrientDB distributed API missing"), e);
        }
        catch (InvocationTargetException e) {
            throw OException.wrapException(new ODatabaseException("Error creating OrientDB remote factory"), e.getTargetException());
        }
        return factory;
    }

    public ODatabaseDocumentInternal open(String var1, String var2, String var3);

    public ODatabaseDocumentInternal open(String var1, String var2, String var3, OrientDBConfig var4);

    public void create(String var1, String var2, String var3, ODatabaseType var4);

    public void create(String var1, String var2, String var3, ODatabaseType var4, OrientDBConfig var5);

    public boolean exists(String var1, String var2, String var3);

    public void drop(String var1, String var2, String var3);

    public Set<String> listDatabases(String var1, String var2);

    public ODatabasePoolInternal openPool(String var1, String var2, String var3);

    public ODatabasePoolInternal openPool(String var1, String var2, String var3, OrientDBConfig var4);

    public ODatabaseDocumentInternal poolOpen(String var1, String var2, String var3, ODatabasePoolInternal var4);

    public void restore(String var1, String var2, String var3, ODatabaseType var4, String var5, OrientDBConfig var6);

    public void restore(String var1, InputStream var2, Map<String, Object> var3, Callable<Object> var4, OCommandOutputListener var5);

    @Override
    public void close();

    public void internalClose();

    public void removePool(ODatabasePoolInternal var1);

    public boolean isOpen();

    public boolean isEmbedded();

    public static OrientDBInternal extract(OrientDB orientDB) {
        return orientDB.internal;
    }

    public ODatabaseDocumentInternal openNoAuthenticate(String var1, String var2);

    public ODatabaseDocumentInternal openNoAuthorization(String var1);

    public void initCustomStorage(String var1, String var2, String var3, String var4);

    public void loadAllDatabases();

    public void removeShutdownHook();

    public Collection<OStorage> getStorages();

    public void forceDatabaseClose(String var1);

    public void replaceFactory(OEmbeddedDatabaseInstanceFactory var1);

    public OEmbeddedDatabaseInstanceFactory getFactory();

    default public OStorage fullSync(String dbName, String backupPath, OrientDBConfig config) {
        throw new UnsupportedOperationException();
    }
}

