/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.index.engine.OPrefixBTreeIndexEngine;
import com.orientechnologies.orient.core.storage.index.engine.ORemoteIndexEngine;
import com.orientechnologies.orient.core.storage.index.engine.OSBTreeIndexEngine;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ODefaultIndexFactory
implements OIndexFactory {
    public static final String SBTREE_ALGORITHM = "SBTREE";
    public static final String PREFIX_BTREE_ALGORITHM = "PREFIX_BTREE";
    public static final String SBTREEBONSAI_VALUE_CONTAINER = "SBTREEBONSAISET";
    public static final String NONE_VALUE_CONTAINER = "NONE";
    private static final Set<String> TYPES;
    private static final Set<String> ALGORITHMS;

    public static boolean isMultiValueIndex(String indexType) {
        switch (OClass.INDEX_TYPE.valueOf(indexType)) {
            case UNIQUE: 
            case UNIQUE_HASH_INDEX: 
            case DICTIONARY: 
            case DICTIONARY_HASH_INDEX: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<String> getTypes() {
        return TYPES;
    }

    @Override
    public Set<String> getAlgorithms() {
        return ALGORITHMS;
    }

    @Override
    public OIndexInternal<?> createIndex(String name, OStorage storage, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata, int version) throws OConfigurationException {
        if (valueContainerAlgorithm == null) {
            valueContainerAlgorithm = NONE_VALUE_CONTAINER;
        }
        if (version < 0) {
            version = this.getLastVersion();
        }
        if (SBTREE_ALGORITHM.equals(algorithm) || PREFIX_BTREE_ALGORITHM.equals(algorithm)) {
            return this.createSBTreeIndex(name, indexType, valueContainerAlgorithm, metadata, (OAbstractPaginatedStorage)storage.getUnderlying(), version, algorithm);
        }
        throw new OConfigurationException("Unsupported type: " + indexType);
    }

    private OIndexInternal<?> createSBTreeIndex(String name, String indexType, String valueContainerAlgorithm, ODocument metadata, OAbstractPaginatedStorage storage, int version, String algorithm) {
        int binaryFormatVersion = storage.getConfiguration().getBinaryFormatVersion();
        if (OClass.INDEX_TYPE.UNIQUE.toString().equals(indexType)) {
            return new OIndexUnique(name, indexType, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        if (OClass.INDEX_TYPE.NOTUNIQUE.toString().equals(indexType)) {
            return new OIndexNotUnique(name, indexType, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        if (OClass.INDEX_TYPE.FULLTEXT.toString().equals(indexType)) {
            return new OIndexFullText(name, indexType, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        if (OClass.INDEX_TYPE.DICTIONARY.toString().equals(indexType)) {
            return new OIndexDictionary(name, indexType, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        throw new OConfigurationException("Unsupported type: " + indexType);
    }

    @Override
    public int getLastVersion() {
        return 1;
    }

    @Override
    public OIndexEngine createIndexEngine(String algorithm, String name, Boolean durableInNonTxMode, OStorage storage, int version, Map<String, String> engineProperties) {
        OIndexEngine indexEngine;
        String storageType;
        switch (storageType = storage.getType()) {
            case "memory": 
            case "plocal": {
                if (algorithm.equals(PREFIX_BTREE_ALGORITHM)) {
                    indexEngine = new OPrefixBTreeIndexEngine(name, (OAbstractPaginatedStorage)storage, version);
                    break;
                }
                indexEngine = new OSBTreeIndexEngine(name, (OAbstractPaginatedStorage)storage, version);
                break;
            }
            case "distributed": {
                if (algorithm.equals(PREFIX_BTREE_ALGORITHM)) {
                    indexEngine = new OPrefixBTreeIndexEngine(name, (OAbstractPaginatedStorage)storage.getUnderlying(), version);
                    break;
                }
                indexEngine = new OSBTreeIndexEngine(name, (OAbstractPaginatedStorage)storage.getUnderlying(), version);
                break;
            }
            case "remote": {
                indexEngine = new ORemoteIndexEngine(name);
                break;
            }
            default: {
                throw new OIndexException("Unsupported storage type: " + storageType);
            }
        }
        return indexEngine;
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OClass.INDEX_TYPE.UNIQUE.toString());
        types.add(OClass.INDEX_TYPE.NOTUNIQUE.toString());
        types.add(OClass.INDEX_TYPE.FULLTEXT.toString());
        types.add(OClass.INDEX_TYPE.DICTIONARY.toString());
        TYPES = Collections.unmodifiableSet(types);
        HashSet<String> algorithms = new HashSet<String>();
        algorithms.add(SBTREE_ALGORITHM);
        algorithms.add(PREFIX_BTREE_ALGORITHM);
        ALGORITHMS = Collections.unmodifiableSet(algorithms);
    }
}

