/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization;

import com.orientechnologies.orient.core.serialization.OMemoryStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OBinaryProtocol {
    public static final int SIZE_BYTE = 1;
    public static final int SIZE_CHAR = 2;
    public static final int SIZE_SHORT = 2;
    public static final int SIZE_INT = 4;
    public static final int SIZE_LONG = 8;

    public static byte[] char2bytes(char value, byte[] b, int iBeginOffset) {
        b[iBeginOffset] = (byte)(value >>> 8 & 0xFF);
        b[iBeginOffset + 1] = (byte)(value >>> 0 & 0xFF);
        return b;
    }

    public static int long2bytes(long value, OutputStream iStream) throws IOException {
        int beginOffset = iStream instanceof OMemoryStream ? ((OMemoryStream)iStream).getPosition() : -1;
        iStream.write((int)(value >>> 56) & 0xFF);
        iStream.write((int)(value >>> 48) & 0xFF);
        iStream.write((int)(value >>> 40) & 0xFF);
        iStream.write((int)(value >>> 32) & 0xFF);
        iStream.write((int)(value >>> 24) & 0xFF);
        iStream.write((int)(value >>> 16) & 0xFF);
        iStream.write((int)(value >>> 8) & 0xFF);
        iStream.write((int)(value >>> 0) & 0xFF);
        return beginOffset;
    }

    public static byte[] long2bytes(long value) {
        return OBinaryProtocol.long2bytes(value, new byte[8], 0);
    }

    public static byte[] long2bytes(long value, byte[] b, int iBeginOffset) {
        b[iBeginOffset] = (byte)(value >>> 56 & 0xFFL);
        b[iBeginOffset + 1] = (byte)(value >>> 48 & 0xFFL);
        b[iBeginOffset + 2] = (byte)(value >>> 40 & 0xFFL);
        b[iBeginOffset + 3] = (byte)(value >>> 32 & 0xFFL);
        b[iBeginOffset + 4] = (byte)(value >>> 24 & 0xFFL);
        b[iBeginOffset + 5] = (byte)(value >>> 16 & 0xFFL);
        b[iBeginOffset + 6] = (byte)(value >>> 8 & 0xFFL);
        b[iBeginOffset + 7] = (byte)(value >>> 0 & 0xFFL);
        return b;
    }

    public static int int2bytes(int value, OutputStream iStream) throws IOException {
        int beginOffset = iStream instanceof OMemoryStream ? ((OMemoryStream)iStream).getPosition() : -1;
        iStream.write(value >>> 24 & 0xFF);
        iStream.write(value >>> 16 & 0xFF);
        iStream.write(value >>> 8 & 0xFF);
        iStream.write(value >>> 0 & 0xFF);
        return beginOffset;
    }

    public static byte[] int2bytes(int value) {
        return OBinaryProtocol.int2bytes(value, new byte[4], 0);
    }

    public static byte[] int2bytes(int value, byte[] b, int iBeginOffset) {
        b[iBeginOffset] = (byte)(value >>> 24 & 0xFF);
        b[iBeginOffset + 1] = (byte)(value >>> 16 & 0xFF);
        b[iBeginOffset + 2] = (byte)(value >>> 8 & 0xFF);
        b[iBeginOffset + 3] = (byte)(value >>> 0 & 0xFF);
        return b;
    }

    public static int short2bytes(short value, OutputStream iStream) throws IOException {
        int beginOffset = iStream instanceof OMemoryStream ? ((OMemoryStream)iStream).getPosition() : -1;
        iStream.write(value >>> 8 & 0xFF);
        iStream.write(value >>> 0 & 0xFF);
        return beginOffset;
    }

    public static byte[] short2bytes(short value) {
        return OBinaryProtocol.short2bytes(value, new byte[2], 0);
    }

    public static byte[] short2bytes(short value, byte[] b, int iBeginOffset) {
        b[iBeginOffset] = (byte)(value >>> 8 & 0xFF);
        b[iBeginOffset + 1] = (byte)(value >>> 0 & 0xFF);
        return b;
    }

    public static long bytes2long(byte[] b) {
        return OBinaryProtocol.bytes2long(b, 0);
    }

    public static long bytes2long(InputStream iStream) throws IOException {
        return (long)(0xFF & iStream.read()) << 56 | (long)(0xFF & iStream.read()) << 48 | (long)(0xFF & iStream.read()) << 40 | (long)(0xFF & iStream.read()) << 32 | (long)(0xFF & iStream.read()) << 24 | (long)((0xFF & iStream.read()) << 16) | (long)((0xFF & iStream.read()) << 8) | (long)(0xFF & iStream.read());
    }

    public static long bytes2long(byte[] b, int offset) {
        return (long)(0xFF & b[offset + 7] | (0xFF & b[offset + 6]) << 8 | (0xFF & b[offset + 5]) << 16) | (long)(0xFF & b[offset + 4]) << 24 | (long)(0xFF & b[offset + 3]) << 32 | (long)(0xFF & b[offset + 2]) << 40 | (long)(0xFF & b[offset + 1]) << 48 | (long)(0xFF & b[offset]) << 56;
    }

    public static int bytes2int(byte[] b) {
        return OBinaryProtocol.bytes2int(b, 0);
    }

    public static int bytes2int(InputStream iStream) throws IOException {
        return (0xFF & iStream.read()) << 24 | (0xFF & iStream.read()) << 16 | (0xFF & iStream.read()) << 8 | 0xFF & iStream.read();
    }

    public static int bytes2int(byte[] b, int offset) {
        return b[offset] << 24 | (0xFF & b[offset + 1]) << 16 | (0xFF & b[offset + 2]) << 8 | 0xFF & b[offset + 3];
    }

    public static int bytes2short(InputStream iStream) throws IOException {
        return (short)(iStream.read() << 8 | iStream.read() & 0xFF);
    }

    public static short bytes2short(byte[] b, int offset) {
        return (short)(b[offset] << 8 | b[offset + 1] & 0xFF);
    }

    public static char bytes2char(byte[] b, int offset) {
        return (char)((b[offset] << 8) + (b[offset + 1] & 0xFF));
    }
}

