/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerRaw;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinary;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetwork;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ORecordSerializerFactory {
    private static final ORecordSerializerFactory instance = new ORecordSerializerFactory();
    private Map<String, ORecordSerializer> implementations = new HashMap<String, ORecordSerializer>();
    private ORecordSerializer defaultRecordSerializer;

    public ORecordSerializerFactory() {
        this.register("ORecordDocument2csv", ORecordSerializerSchemaAware2CSV.INSTANCE);
        this.register("json", ORecordSerializerJSON.INSTANCE);
        this.register("ORecordDocumentRaw", new ORecordSerializerRaw());
        this.register("ORecordSerializerBinary", ORecordSerializerBinary.INSTANCE);
        this.register("onet_ser_v0", ORecordSerializerNetwork.INSTANCE);
        this.register("onet_ser_v37", ORecordSerializerNetworkV37.INSTANCE);
        this.defaultRecordSerializer = this.getFormat(OGlobalConfiguration.DB_DOCUMENT_SERIALIZER.getValueAsString());
        if (this.defaultRecordSerializer == null) {
            throw new ODatabaseException("Impossible to find serializer with name " + OGlobalConfiguration.DB_DOCUMENT_SERIALIZER.getValueAsString());
        }
    }

    public void register(String iName, ORecordSerializer iInstance) {
        this.implementations.put(iName, iInstance);
    }

    public Collection<ORecordSerializer> getFormats() {
        return this.implementations.values();
    }

    public ORecordSerializer getFormat(String iFormatName) {
        if (iFormatName == null) {
            return null;
        }
        return this.implementations.get(iFormatName);
    }

    public static ORecordSerializerFactory instance() {
        return instance;
    }

    public void setDefaultRecordSerializer(ORecordSerializer defaultRecordSerializer) {
        this.defaultRecordSerializer = defaultRecordSerializer;
    }

    public ORecordSerializer getDefaultRecordSerializer() {
        return this.defaultRecordSerializer;
    }
}

