/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.TimeZone;

public class HelperClasses {
    protected static final String CHARSET_UTF_8 = "UTF-8";
    protected static final ORecordId NULL_RECORD_ID = new ORecordId(-2, -1L);
    protected static final long MILLISEC_PER_DAY = 86400000L;

    protected static OType readOType(BytesContainer bytes, boolean justRunThrough) {
        if (justRunThrough) {
            ++bytes.offset;
            return null;
        }
        return OType.getById(HelperClasses.readByte(bytes));
    }

    protected static void writeOType(BytesContainer bytes, int pos, OType type) {
        bytes.bytes[pos] = (byte)type.getId();
    }

    protected static byte[] readBinary(BytesContainer bytes) {
        int n = OVarIntSerializer.readAsInteger(bytes);
        byte[] newValue = new byte[n];
        System.arraycopy(bytes.bytes, bytes.offset, newValue, 0, newValue.length);
        bytes.skip(n);
        return newValue;
    }

    protected static String readString(BytesContainer bytes) {
        int len = OVarIntSerializer.readAsInteger(bytes);
        String res = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, len);
        bytes.skip(len);
        return res;
    }

    protected static int readInteger(BytesContainer container) {
        int value = OIntegerSerializer.INSTANCE.deserializeLiteral(container.bytes, container.offset);
        container.offset += 4;
        return value;
    }

    protected static byte readByte(BytesContainer container) {
        return container.bytes[container.offset++];
    }

    protected static long readLong(BytesContainer container) {
        long value = OLongSerializer.INSTANCE.deserializeLiteral(container.bytes, container.offset);
        container.offset += 8;
        return value;
    }

    protected static ORecordId readOptimizedLink(BytesContainer bytes, boolean justRunThrough) {
        int clusterId = OVarIntSerializer.readAsInteger(bytes);
        long clusterPos = OVarIntSerializer.readAsLong(bytes);
        if (justRunThrough) {
            return null;
        }
        return new ORecordId(clusterId, clusterPos);
    }

    protected static String stringFromBytes(byte[] bytes, int offset, int len) {
        try {
            return new String(bytes, offset, len, CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error on string decoding"), e);
        }
    }

    protected static byte[] bytesFromString(String toWrite) {
        try {
            return toWrite.getBytes(CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error on string encoding"), e);
        }
    }

    protected static long convertDayToTimezone(TimeZone from, TimeZone to, long time) {
        Calendar fromCalendar = Calendar.getInstance(from);
        fromCalendar.setTimeInMillis(time);
        Calendar toCalendar = Calendar.getInstance(to);
        toCalendar.setTimeInMillis(0L);
        toCalendar.set(0, fromCalendar.get(0));
        toCalendar.set(1, fromCalendar.get(1));
        toCalendar.set(2, fromCalendar.get(2));
        toCalendar.set(5, fromCalendar.get(5));
        toCalendar.set(11, 0);
        toCalendar.set(12, 0);
        toCalendar.set(13, 0);
        toCalendar.set(14, 0);
        return toCalendar.getTimeInMillis();
    }

    protected static class MapRecordInfo
    extends RecordInfo {
        public String key;
        public OType keyType;

        protected MapRecordInfo() {
        }
    }

    protected static class RecordInfo {
        public int fieldStartOffset;
        public int fieldLength;
        public OType fieldType;

        protected RecordInfo() {
        }
    }

    public static class Triple<T1, T2, T3> {
        private final T1 firstVal;
        private final T2 secondVal;
        private final T3 thirdVal;

        public Triple(T1 firstVal, T2 secondVal, T3 thirdVal) {
            this.firstVal = firstVal;
            this.secondVal = secondVal;
            this.thirdVal = thirdVal;
        }

        public T3 getThirdVal() {
            return this.thirdVal;
        }

        public T1 getFirstVal() {
            return this.firstVal;
        }

        public T2 getSecondVal() {
            return this.secondVal;
        }
    }

    public static class Tuple<T1, T2> {
        private final T1 firstVal;
        private final T2 secondVal;

        Tuple(T1 firstVal, T2 secondVal) {
            this.firstVal = firstVal;
            this.secondVal = secondVal;
        }

        public T1 getFirstVal() {
            return this.firstVal;
        }

        public T2 getSecondVal() {
            return this.secondVal;
        }
    }
}

