/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordFlat;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV0;
import java.util.Base64;

public class ORecordSerializerNetwork
implements ORecordSerializer {
    public static final String NAME = "onet_ser_v0";
    public static final ORecordSerializerNetwork INSTANCE = new ORecordSerializerNetwork();
    private static final byte CURRENT_RECORD_VERSION = 0;
    private final ODocumentSerializer[] serializerByVersion = new ODocumentSerializer[1];

    public ORecordSerializerNetwork() {
        this.serializerByVersion[0] = new ORecordSerializerNetworkV0();
    }

    @Override
    public int getCurrentVersion() {
        return 0;
    }

    @Override
    public int getMinSupportedVersion() {
        return 0;
    }

    public String toString() {
        return NAME;
    }

    @Override
    public ORecord fromStream(byte[] iSource, ORecord iRecord, String[] iFields) {
        if (iSource == null || iSource.length == 0) {
            return iRecord;
        }
        if (iRecord == null) {
            iRecord = new ODocument();
        } else {
            if (iRecord instanceof OBlob) {
                iRecord.fromStream(iSource);
                return iRecord;
            }
            if (iRecord instanceof ORecordFlat) {
                iRecord.fromStream(iSource);
                return iRecord;
            }
        }
        BytesContainer container = new BytesContainer(iSource);
        container.skip(1);
        try {
            if (iFields != null && iFields.length > 0) {
                this.serializerByVersion[iSource[0]].deserializePartial((ODocument)iRecord, container, iFields);
            } else {
                this.serializerByVersion[iSource[0]].deserialize((ODocument)iRecord, container);
            }
        }
        catch (RuntimeException e) {
            OLogManager.instance().warn((Object)this, "Error deserializing record with id %s send this data for debugging: %s ", iRecord.getIdentity().toString(), Base64.getEncoder().encodeToString(iSource));
            throw e;
        }
        return iRecord;
    }

    @Override
    public byte[] toStream(ORecord iSource, boolean iOnlyDelta) {
        if (iSource instanceof OBlob) {
            return iSource.toStream();
        }
        if (iSource instanceof ORecordFlat) {
            return iSource.toStream();
        }
        BytesContainer container = new BytesContainer();
        int pos = container.alloc(1);
        container.bytes[pos] = 0;
        this.serializerByVersion[0].serialize((ODocument)iSource, container, false);
        return container.fitBytes();
    }

    public byte[] serializeValue(Object value, OType type) {
        BytesContainer bytes = new BytesContainer();
        this.serializerByVersion[0].serializeValue(bytes, value, type, null);
        return bytes.fitBytes();
    }

    public Object deserializeValue(byte[] val, OType type) {
        BytesContainer bytes = new BytesContainer(val);
        return this.serializerByVersion[0].deserializeValue(bytes, type, null);
    }

    @Override
    public byte[] writeClassOnly(ORecord iSource) {
        BytesContainer container = new BytesContainer();
        int pos = container.alloc(1);
        container.bytes[pos] = 0;
        this.serializerByVersion[0].serializeWithClassName((ODocument)iSource, container, true);
        return container.fitBytes();
    }

    @Override
    public boolean getSupportBinaryEvaluate() {
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public <RET> RET deserializeFieldFromRoot(byte[] record, String iFieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <RET> RET deserializeFieldFromEmbedded(byte[] record, int offset, String iFieldName, int serializerVersion) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getFieldNamesRoot(ODocument reference, byte[] iSource) {
        if (iSource == null || iSource.length == 0) {
            return new String[0];
        }
        BytesContainer container = new BytesContainer(iSource).skip(1);
        try {
            return this.serializerByVersion[iSource[0]].getFieldNames(reference, container, false);
        }
        catch (RuntimeException e) {
            OLogManager.instance().warn((Object)this, "Error deserializing record to get field-names, send this data for debugging: %s ", Base64.getEncoder().encodeToString(iSource));
            throw e;
        }
    }

    @Override
    public String[] getFieldNamesEmbedded(ODocument reference, byte[] iSource, int offset, int serializerVersion) {
        return this.getFieldNamesRoot(reference, iSource);
    }
}

