/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Map;
import java.util.Optional;

public class CastToVertexStep
extends AbstractExecutionStep {
    private long cost;

    public CastToVertexStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                OResult result = upstream.next();
                long begin = CastToVertexStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (result.getElement().orElse(null) instanceof OVertex) {
                        OResult oResult = result;
                        return oResult;
                    }
                    if (result.isVertex()) {
                        if (result instanceof OResultInternal) {
                            ((OResultInternal)result).setElement(result.getElement().get().asVertex().get());
                        } else {
                            OResultInternal r = new OResultInternal();
                            r.setElement(result.getElement().get().asVertex().get());
                            result = r;
                        }
                    } else {
                        throw new OCommandExecutionException("Current element is not a vertex: " + result);
                    }
                    OResult oResult = result;
                    return oResult;
                }
                finally {
                    if (CastToVertexStep.this.profilingEnabled) {
                        CastToVertexStep.this.cost = CastToVertexStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
                upstream.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ CAST TO VERTEX";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

