/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdatableResult;
import java.util.Map;
import java.util.Optional;

public class CopyRecordContentBeforeUpdateStep
extends AbstractExecutionStep {
    private long cost = 0L;

    public CopyRecordContentBeforeUpdateStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet lastFetched = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return lastFetched.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                OResult result = lastFetched.next();
                long begin = CopyRecordContentBeforeUpdateStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    OResultInternal prevValue;
                    if (result instanceof OUpdatableResult) {
                        prevValue = new OResultInternal();
                        Object rec = result.getElement().get().getRecord();
                        prevValue.setProperty("@rid", rec.getIdentity());
                        prevValue.setProperty("@version", rec.getVersion());
                        if (rec instanceof ODocument) {
                            prevValue.setProperty("@class", ((ODocument)rec).getSchemaClass().getName());
                        }
                        for (String propName : result.getPropertyNames()) {
                            prevValue.setProperty(propName, OLiveQueryHookV2.unboxRidbags(result.getProperty(propName)));
                        }
                    } else {
                        throw new OCommandExecutionException("Cannot fetch previous value: " + result);
                    }
                    ((OUpdatableResult)result).previousValue = prevValue;
                    OResult oResult = result;
                    return oResult;
                }
                finally {
                    if (CopyRecordContentBeforeUpdateStep.this.profilingEnabled) {
                        CopyRecordContentBeforeUpdateStep.this.cost = CopyRecordContentBeforeUpdateStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
                lastFetched.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ COPY RECORD CONTENT BEFORE UPDATE");
        if (this.profilingEnabled) {
            result.append(" (" + this.getCostFormatted() + ")");
        }
        return result.toString();
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

