/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlan;
import java.util.Map;
import java.util.Optional;

public class DistributedExecutionStep
extends AbstractExecutionStep {
    private final OSelectExecutionPlan subExecuitonPlan;
    private final String nodeName;
    private boolean inited;
    private OResultSet remoteResultSet;

    public DistributedExecutionStep(OSelectExecutionPlan subExecutionPlan, String nodeName, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.subExecuitonPlan = subExecutionPlan;
        this.nodeName = nodeName;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.init(ctx);
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                throw new UnsupportedOperationException("Implement distributed execution step!");
            }

            @Override
            public OResult next() {
                throw new UnsupportedOperationException("Implement distributed execution step!");
            }

            @Override
            public void close() {
                DistributedExecutionStep.this.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    public void init(OCommandContext ctx) {
        if (!this.inited) {
            this.inited = true;
            this.remoteResultSet = this.sendSerializedExecutionPlan(this.nodeName, this.subExecuitonPlan, ctx);
        }
    }

    private OResultSet sendSerializedExecutionPlan(String nodeName, OExecutionPlan serializedExecutionPlan, OCommandContext ctx) {
        ODatabaseDocumentInternal db = (ODatabaseDocumentInternal)ctx.getDatabase();
        return db.queryOnNode(nodeName, serializedExecutionPlan, ctx.getInputParameters());
    }

    @Override
    public void close() {
        super.close();
        if (this.remoteResultSet != null) {
            this.remoteResultSet.close();
        }
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        StringBuilder builder = new StringBuilder();
        String ind = OExecutionStepInternal.getIndent(depth, indent);
        builder.append(ind);
        builder.append("+ EXECUTE ON NODE " + this.nodeName + "----------- \n");
        builder.append(this.subExecuitonPlan.prettyPrint(depth + 1, indent));
        builder.append("  ------------------------------------------- \n");
        builder.append("   |\n");
        builder.append("   V\n");
        return builder.toString();
    }
}

