/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Map;
import java.util.Optional;

public class EmptyDataGeneratorStep
extends AbstractExecutionStep {
    private long cost = 0L;
    int size;
    int served = 0;

    public EmptyDataGeneratorStep(int size, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.size = size;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return EmptyDataGeneratorStep.this.served < EmptyDataGeneratorStep.this.size;
            }

            @Override
            public OResult next() {
                long begin = EmptyDataGeneratorStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (EmptyDataGeneratorStep.this.served < EmptyDataGeneratorStep.this.size) {
                        ++EmptyDataGeneratorStep.this.served;
                        OResultInternal result = new OResultInternal();
                        ctx.setVariable("$current", result);
                        OResultInternal oResultInternal = result;
                        return oResultInternal;
                    }
                    throw new IllegalStateException();
                }
                finally {
                    if (EmptyDataGeneratorStep.this.profilingEnabled) {
                        EmptyDataGeneratorStep.this.cost = EmptyDataGeneratorStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }

            @Override
            public void reset() {
                EmptyDataGeneratorStep.this.served = 0;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        String result = spaces + "+ GENERATE " + this.size + " EMPTY " + (this.size == 1 ? "RECORD" : "RECORDS");
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

