/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlan;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FilterNotMatchPatternStep
extends AbstractExecutionStep {
    List<AbstractExecutionStep> subSteps;
    OResultSet prevResult = null;
    private long cost;

    public FilterNotMatchPatternStep(List<AbstractExecutionStep> steps, OCommandContext ctx, boolean enableProfiling) {
        super(ctx, enableProfiling);
        this.subSteps = steps;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        if (!this.prev.isPresent()) {
            throw new IllegalStateException("filter step requires a previous step");
        }
        final OExecutionStepInternal prevStep = (OExecutionStepInternal)this.prev.get();
        return new OResultSet(){
            public boolean finished = false;
            OResult nextItem = null;
            int fetched = 0;

            private void fetchNextItem() {
                this.nextItem = null;
                if (this.finished) {
                    return;
                }
                if (FilterNotMatchPatternStep.this.prevResult == null) {
                    FilterNotMatchPatternStep.this.prevResult = prevStep.syncPull(ctx, nRecords);
                    if (!FilterNotMatchPatternStep.this.prevResult.hasNext()) {
                        this.finished = true;
                        return;
                    }
                }
                while (!this.finished) {
                    while (!FilterNotMatchPatternStep.this.prevResult.hasNext()) {
                        FilterNotMatchPatternStep.this.prevResult = prevStep.syncPull(ctx, nRecords);
                        if (FilterNotMatchPatternStep.this.prevResult.hasNext()) continue;
                        this.finished = true;
                        return;
                    }
                    this.nextItem = FilterNotMatchPatternStep.this.prevResult.next();
                    long begin = FilterNotMatchPatternStep.this.profilingEnabled ? System.nanoTime() : 0L;
                    try {
                        if (!FilterNotMatchPatternStep.this.matchesPattern(this.nextItem, ctx)) break;
                        this.nextItem = null;
                    }
                    finally {
                        if (!FilterNotMatchPatternStep.this.profilingEnabled) continue;
                        FilterNotMatchPatternStep.this.cost = FilterNotMatchPatternStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public boolean hasNext() {
                if (this.fetched >= nRecords || this.finished) {
                    return false;
                }
                if (this.nextItem == null) {
                    this.fetchNextItem();
                }
                return this.nextItem != null;
            }

            @Override
            public OResult next() {
                if (this.fetched >= nRecords || this.finished) {
                    throw new IllegalStateException();
                }
                if (this.nextItem == null) {
                    this.fetchNextItem();
                }
                if (this.nextItem == null) {
                    throw new IllegalStateException();
                }
                OResult result = this.nextItem;
                this.nextItem = null;
                ++this.fetched;
                return result;
            }

            @Override
            public void close() {
                FilterNotMatchPatternStep.this.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private boolean matchesPattern(OResult nextItem, OCommandContext ctx) {
        OSelectExecutionPlan plan = this.createExecutionPlan(nextItem, ctx);
        try (OResultSet rs = plan.fetchNext(1);){
            boolean bl = rs.hasNext();
            return bl;
        }
    }

    private OSelectExecutionPlan createExecutionPlan(final OResult nextItem, OCommandContext ctx) {
        OSelectExecutionPlan plan = new OSelectExecutionPlan(ctx);
        plan.chain(new AbstractExecutionStep(ctx, this.profilingEnabled){
            boolean executed;
            {
                super(ctx, profilingEnabled);
                this.executed = false;
            }

            @Override
            public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
                OInternalResultSet result = new OInternalResultSet();
                if (!this.executed) {
                    result.add(this.copy(nextItem));
                    this.executed = true;
                }
                return result;
            }

            private OResult copy(OResult nextItem2) {
                OResultInternal result = new OResultInternal();
                for (String prop : nextItem2.getPropertyNames()) {
                    result.setProperty(prop, nextItem2.getProperty(prop));
                }
                for (String md : nextItem2.getMetadataKeys()) {
                    result.setMetadata(md, nextItem2.getMetadata(md));
                }
                return result;
            }
        });
        this.subSteps.stream().forEach(step -> plan.chain((OExecutionStepInternal)step));
        return plan;
    }

    @Override
    public List<OExecutionStep> getSubSteps() {
        return this.subSteps;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ NOT (\n");
        this.subSteps.forEach(x -> result.append(x.prettyPrint(depth + 1, indent)).append("\n"));
        result.append(spaces);
        result.append("  )");
        return result.toString();
    }

    @Override
    public void close() {
        super.close();
    }
}

