/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import java.util.Map;
import java.util.Optional;

public class FilterStep
extends AbstractExecutionStep {
    private OWhereClause whereClause;
    OResultSet prevResult = null;
    private long cost;

    public FilterStep(OWhereClause whereClause, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.whereClause = whereClause;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        if (!this.prev.isPresent()) {
            throw new IllegalStateException("filter step requires a previous step");
        }
        final OExecutionStepInternal prevStep = (OExecutionStepInternal)this.prev.get();
        return new OResultSet(){
            public boolean finished = false;
            OResult nextItem = null;
            int fetched = 0;

            private void fetchNextItem() {
                this.nextItem = null;
                if (this.finished) {
                    return;
                }
                if (FilterStep.this.prevResult == null) {
                    FilterStep.this.prevResult = prevStep.syncPull(ctx, nRecords);
                    if (!FilterStep.this.prevResult.hasNext()) {
                        this.finished = true;
                        return;
                    }
                }
                while (!this.finished) {
                    while (!FilterStep.this.prevResult.hasNext()) {
                        FilterStep.this.prevResult = prevStep.syncPull(ctx, nRecords);
                        if (FilterStep.this.prevResult.hasNext()) continue;
                        this.finished = true;
                        return;
                    }
                    this.nextItem = FilterStep.this.prevResult.next();
                    long begin = FilterStep.this.profilingEnabled ? System.nanoTime() : 0L;
                    try {
                        if (FilterStep.this.whereClause.matchesFilters(this.nextItem, ctx)) break;
                        this.nextItem = null;
                    }
                    finally {
                        if (!FilterStep.this.profilingEnabled) continue;
                        FilterStep.this.cost = FilterStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public boolean hasNext() {
                if (this.fetched >= nRecords || this.finished) {
                    return false;
                }
                if (this.nextItem == null) {
                    this.fetchNextItem();
                }
                return this.nextItem != null;
            }

            @Override
            public OResult next() {
                if (this.fetched >= nRecords || this.finished) {
                    throw new IllegalStateException();
                }
                if (this.nextItem == null) {
                    this.fetchNextItem();
                }
                if (this.nextItem == null) {
                    throw new IllegalStateException();
                }
                OResult result = this.nextItem;
                this.nextItem = null;
                ++this.fetched;
                return result;
            }

            @Override
            public void close() {
                FilterStep.this.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        StringBuilder result = new StringBuilder();
        result.append(OExecutionStepInternal.getIndent(depth, indent) + "+ FILTER ITEMS WHERE ");
        if (this.profilingEnabled) {
            result.append(" (" + this.getCostFormatted() + ")");
        }
        result.append("\n");
        result.append(OExecutionStepInternal.getIndent(depth, indent));
        result.append("  ");
        result.append(this.whereClause.toString());
        return result.toString();
    }

    @Override
    public OResult serialize() {
        OResultInternal result = OExecutionStepInternal.basicSerialize(this);
        if (this.whereClause != null) {
            result.setProperty("whereClause", this.whereClause.serialize());
        }
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            OExecutionStepInternal.basicDeserialize(fromResult, this);
            this.whereClause = new OWhereClause(-1);
            this.whereClause.deserialize((OResult)fromResult.getProperty("whereClause"));
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new FilterStep(this.whereClause.copy(), ctx, this.profilingEnabled);
    }
}

