/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.exception.OCommandInterruptedException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.EmptyStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OScriptExecutionPlan;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OForEachBlock;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OIfStatement;
import com.orientechnologies.orient.core.sql.parser.OReturnStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import java.util.Iterator;
import java.util.List;

public class ForEachStep
extends AbstractExecutionStep {
    private final OIdentifier loopVariable;
    private final OExpression source;
    public List<OStatement> body;
    Iterator iterator;
    private OExecutionStepInternal finalResult = null;
    private boolean inited = false;

    public ForEachStep(OIdentifier loopVariable, OExpression oExpression, List<OStatement> statements, OCommandContext ctx, boolean enableProfiling) {
        super(ctx, enableProfiling);
        this.loopVariable = loopVariable;
        this.source = oExpression;
        this.body = statements;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        ((OExecutionStepInternal)this.prev.get()).syncPull(ctx, nRecords);
        if (this.finalResult != null) {
            return this.finalResult.syncPull(ctx, nRecords);
        }
        this.init(ctx);
        while (this.iterator.hasNext()) {
            if (OExecutionThreadLocal.isInterruptCurrentOperation()) {
                throw new OCommandInterruptedException("The command has been interrupted");
            }
            ctx.setVariable(this.loopVariable.getStringValue(), this.iterator.next());
            OScriptExecutionPlan plan = this.initPlan(ctx);
            OExecutionStepInternal result = plan.executeFull();
            if (result == null) continue;
            this.finalResult = result;
            return result.syncPull(ctx, nRecords);
        }
        this.finalResult = new EmptyStep(ctx, false);
        return this.finalResult.syncPull(ctx, nRecords);
    }

    protected void init(OCommandContext ctx) {
        if (!this.inited) {
            Object val = this.source.execute(new OResultInternal(), ctx);
            this.iterator = OMultiValue.getMultiValueIterator(val);
            this.inited = true;
        }
    }

    public OScriptExecutionPlan initPlan(OCommandContext ctx) {
        OBasicCommandContext subCtx1 = new OBasicCommandContext();
        subCtx1.setParent(ctx);
        OScriptExecutionPlan plan = new OScriptExecutionPlan(subCtx1);
        for (OStatement stm : this.body) {
            plan.chain(stm.createExecutionPlan(subCtx1, this.profilingEnabled), this.profilingEnabled);
        }
        return plan;
    }

    public boolean containsReturn() {
        for (OStatement stm : this.body) {
            if (stm instanceof OReturnStatement) {
                return true;
            }
            if (stm instanceof OForEachBlock && ((OForEachBlock)stm).containsReturn()) {
                return true;
            }
            if (!(stm instanceof OIfStatement) || !((OIfStatement)stm).containsReturn()) continue;
            return true;
        }
        return false;
    }
}

