/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RemoveEdgePointersStep
extends AbstractExecutionStep {
    private long cost = 0L;

    public RemoveEdgePointersStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                OResultInternal elem = (OResultInternal)upstream.next();
                long begin = RemoveEdgePointersStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    Set<String> propNames = elem.getPropertyNames();
                    block3: for (String propName : propNames.stream().filter(x -> x.startsWith("in_") || x.startsWith("out_")).collect(Collectors.toList())) {
                        Object val = elem.getProperty(propName);
                        if (val instanceof OElement) {
                            if (!((OElement)val).getSchemaType().map(x -> x.isSubClassOf("E")).orElse(false).booleanValue()) continue;
                            elem.removeProperty(propName);
                            continue;
                        }
                        if (!(val instanceof Iterable)) continue;
                        for (Object o : (Iterable)val) {
                            if (!(o instanceof OElement) || !((OElement)o).getSchemaType().map(x -> x.isSubClassOf("E")).orElse(false).booleanValue()) continue;
                            elem.removeProperty(propName);
                            continue block3;
                        }
                    }
                }
                finally {
                    if (RemoveEdgePointersStep.this.profilingEnabled) {
                        RemoveEdgePointersStep.this.cost = RemoveEdgePointersStep.this.cost + (System.nanoTime() - begin);
                    }
                }
                return elem;
            }

            @Override
            public void close() {
                upstream.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ CHECK AND EXCLUDE (possible) EXISTING EDGES ");
        if (this.profilingEnabled) {
            result.append(" (" + this.getCostFormatted() + ")");
        }
        return result.toString();
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

