/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.IfStep;
import com.orientechnologies.orient.core.sql.executor.ODDLExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.ODeleteExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OForEachExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OIfExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInsertExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OScriptExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OSingleOpExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.ReturnStep;
import com.orientechnologies.orient.core.sql.parser.OIfStatement;
import com.orientechnologies.orient.core.sql.parser.OReturnStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;

public class ScriptLineStep
extends AbstractExecutionStep {
    protected final OInternalExecutionPlan plan;
    boolean executed = false;

    public ScriptLineStep(OInternalExecutionPlan nextPlan, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.plan = nextPlan;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        if (!this.executed) {
            if (this.plan instanceof OInsertExecutionPlan) {
                ((OInsertExecutionPlan)this.plan).executeInternal();
            } else if (this.plan instanceof ODeleteExecutionPlan) {
                ((ODeleteExecutionPlan)this.plan).executeInternal();
            } else if (this.plan instanceof OUpdateExecutionPlan) {
                ((OUpdateExecutionPlan)this.plan).executeInternal();
            } else if (this.plan instanceof ODDLExecutionPlan) {
                ((ODDLExecutionPlan)this.plan).executeInternal((OBasicCommandContext)ctx);
            } else if (this.plan instanceof OSingleOpExecutionPlan) {
                ((OSingleOpExecutionPlan)this.plan).executeInternal((OBasicCommandContext)ctx);
            }
            this.executed = true;
        }
        return this.plan.fetchNext(nRecords);
    }

    public boolean containsReturn() {
        if (this.plan instanceof OScriptExecutionPlan) {
            return ((OScriptExecutionPlan)this.plan).containsReturn();
        }
        if (this.plan instanceof OSingleOpExecutionPlan && ((OSingleOpExecutionPlan)this.plan).statement instanceof OReturnStatement) {
            return true;
        }
        if (this.plan instanceof OIfExecutionPlan) {
            IfStep step = (IfStep)this.plan.getSteps().get(0);
            if (step.positivePlan != null && step.positivePlan.containsReturn()) {
                return true;
            }
            if (step.positiveStatements != null) {
                for (OStatement stm : step.positiveStatements) {
                    if (!this.containsReturn(stm)) continue;
                    return true;
                }
            }
        }
        return this.plan instanceof OForEachExecutionPlan && ((OForEachExecutionPlan)this.plan).containsReturn();
    }

    private boolean containsReturn(OStatement stm) {
        if (stm instanceof OReturnStatement) {
            return true;
        }
        if (stm instanceof OIfStatement) {
            for (OStatement o : ((OIfStatement)stm).getStatements()) {
                if (!this.containsReturn(o)) continue;
                return true;
            }
        }
        return false;
    }

    public OExecutionStepInternal executeUntilReturn(OCommandContext ctx) {
        if (this.plan instanceof OScriptExecutionPlan) {
            return ((OScriptExecutionPlan)this.plan).executeUntilReturn();
        }
        if (this.plan instanceof OSingleOpExecutionPlan && ((OSingleOpExecutionPlan)this.plan).statement instanceof OReturnStatement) {
            return new ReturnStep(((OSingleOpExecutionPlan)this.plan).statement, ctx, this.profilingEnabled);
        }
        if (this.plan instanceof OIfExecutionPlan) {
            return ((OIfExecutionPlan)this.plan).executeUntilReturn();
        }
        throw new IllegalStateException();
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        if (this.plan == null) {
            return "Script Line";
        }
        return this.plan.prettyPrint(depth, indent);
    }
}

