/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class UpdateEdgePointersStep
extends AbstractExecutionStep {
    public UpdateEdgePointersStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            @Override
            public OResult next() {
                OResult result = upstream.next();
                if (result instanceof OResultInternal) {
                    UpdateEdgePointersStep.this.handleUpdateEdge((ODocument)result.getElement().get().getRecord());
                }
                return result;
            }

            private void updateIn(OResult item) {
            }

            private void updateOut(OResult item) {
            }

            @Override
            public void close() {
                upstream.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ UPDATE EDGE POINTERS");
        return result.toString();
    }

    private void handleUpdateEdge(ODocument record) {
        Object currentOut = record.field("out");
        Object currentIn = record.field("in");
        Object prevOut = record.getOriginalValue("out");
        Object prevIn = record.getOriginalValue("in");
        if (currentOut instanceof Collection && ((Collection)currentOut).size() == 1) {
            currentOut = ((Collection)currentOut).iterator().next();
            record.setProperty("out", currentOut);
        }
        if (currentIn instanceof Collection && ((Collection)currentIn).size() == 1) {
            currentIn = ((Collection)currentIn).iterator().next();
            record.setProperty("in", currentIn);
        }
        this.validateOutInForEdge(record, currentOut, currentIn);
        this.changeVertexEdgePointer(record, (OIdentifiable)prevIn, (OIdentifiable)currentIn, "in");
        this.changeVertexEdgePointer(record, (OIdentifiable)prevOut, (OIdentifiable)currentOut, "out");
    }

    private void changeVertexEdgePointer(ODocument edge, OIdentifiable prevVertex, OIdentifiable currentVertex, String direction) {
        if (prevVertex != null && !prevVertex.equals(currentVertex)) {
            ODocument currentVertexDoc;
            ORidBag currentBag;
            String edgeClassName = edge.getClassName();
            if (edgeClassName.equalsIgnoreCase("E")) {
                edgeClassName = "";
            }
            String vertexFieldName = direction + "_" + edgeClassName;
            ODocument prevOutDoc = (ODocument)prevVertex.getRecord();
            ORidBag prevBag = (ORidBag)prevOutDoc.field(vertexFieldName);
            if (prevBag != null) {
                prevBag.remove(edge);
                prevOutDoc.save();
            }
            if ((currentBag = (ORidBag)(currentVertexDoc = (ODocument)currentVertex.getRecord()).field(vertexFieldName)) == null) {
                currentBag = new ORidBag();
                currentVertexDoc.field(vertexFieldName, currentBag);
            }
            currentBag.add(edge);
        }
    }

    private void validateOutInForEdge(ODocument record, Object currentOut, Object currentIn) {
        if (!this.isRecordInstanceOf(currentOut, "V")) {
            throw new OCommandExecutionException("Error updating edge: 'out' is not a vertex - " + currentOut + "");
        }
        if (!this.isRecordInstanceOf(currentIn, "V")) {
            throw new OCommandExecutionException("Error updating edge: 'in' is not a vertex - " + currentIn + "");
        }
    }

    private boolean isRecordInstanceOf(Object iRecord, String orientClass) {
        if (iRecord == null) {
            return false;
        }
        if (!(iRecord instanceof OIdentifiable)) {
            return false;
        }
        ODocument record = (ODocument)((OIdentifiable)iRecord).getRecord();
        if (iRecord == null) {
            return false;
        }
        return record.getSchemaClass().isSubClassOf(orientClass);
    }
}

