/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionFactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class OSQLFunctionFactoryTemplate
implements OSQLFunctionFactory {
    private final Map<String, Object> functions = new HashMap<String, Object>();

    protected void register(OSQLFunction function) {
        this.functions.put(function.getName().toLowerCase(Locale.ENGLISH), function);
    }

    protected void register(String name, Object function) {
        this.functions.put(name.toLowerCase(Locale.ENGLISH), function);
    }

    @Override
    public boolean hasFunction(String name) {
        return this.functions.containsKey(name);
    }

    @Override
    public Set<String> getFunctionNames() {
        return this.functions.keySet();
    }

    @Override
    public OSQLFunction createFunction(String name) throws OCommandExecutionException {
        Object obj = this.functions.get(name);
        if (obj == null) {
            throw new OCommandExecutionException("Unknown function name :" + name);
        }
        if (obj instanceof OSQLFunction) {
            return (OSQLFunction)obj;
        }
        Class clazz = (Class)obj;
        try {
            return (OSQLFunction)clazz.newInstance();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Error in creation of function " + name + "(). Probably there is not an empty constructor or the constructor generates errors"), e);
        }
    }

    public Map<String, Object> getFunctions() {
        return this.functions;
    }
}

