/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class OAlterSequenceStatement
extends ODDLStatement {
    OIdentifier name;
    OExpression start;
    OExpression increment;
    OExpression cache;

    public OAlterSequenceStatement(int id) {
        super(id);
    }

    public OAlterSequenceStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        Object val;
        String sequenceName = this.name.getStringValue();
        if (sequenceName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OAlterSequenceStatement.getDatabase();
        OSequence sequence = database.getMetadata().getSequenceLibrary().getSequence(sequenceName);
        if (sequence == null) {
            throw new OCommandExecutionException("Sequence not found: " + sequenceName);
        }
        OSequence.CreateParams params = new OSequence.CreateParams();
        if (this.start != null) {
            val = this.start.execute((OIdentifiable)null, ctx);
            if (!(val instanceof Number)) {
                throw new OCommandExecutionException("invalid start value for a sequence: " + val);
            }
            params.start = ((Number)val).longValue();
        }
        if (this.increment != null) {
            val = this.increment.execute((OIdentifiable)null, ctx);
            if (!(val instanceof Number)) {
                throw new OCommandExecutionException("invalid increment value for a sequence: " + val);
            }
            params.increment = ((Number)val).intValue();
        }
        if (this.cache != null) {
            val = this.cache.execute((OIdentifiable)null, ctx);
            if (!(val instanceof Number)) {
                throw new OCommandExecutionException("invalid cache value for a sequence: " + val);
            }
            params.cacheSize = ((Number)val).intValue();
        }
        sequence.updateParams(params);
        sequence.save(database);
        OInternalResultSet result = new OInternalResultSet();
        OResultInternal item = new OResultInternal();
        item.setProperty("operation", "alter sequence");
        item.setProperty("sequenceName", sequenceName);
        item.setProperty("start", params.start);
        item.setProperty("increment", params.increment);
        item.setProperty("cacheSize", params.cacheSize);
        result.add(item);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("ALTER SEQUENCE ");
        this.name.toString(params, builder);
        if (this.start != null) {
            builder.append(" START ");
            this.start.toString(params, builder);
        }
        if (this.increment != null) {
            builder.append(" INCREMENT ");
            this.increment.toString(params, builder);
        }
        if (this.cache != null) {
            builder.append(" CACHE ");
            this.cache.toString(params, builder);
        }
    }

    @Override
    public OAlterSequenceStatement copy() {
        OAlterSequenceStatement result = new OAlterSequenceStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.start = this.start == null ? null : this.start.copy();
        result.increment = this.increment == null ? null : this.increment.copy();
        result.cache = this.cache == null ? null : this.cache.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAlterSequenceStatement that = (OAlterSequenceStatement)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.start != null ? !this.start.equals(that.start) : that.start != null) {
            return false;
        }
        if (this.increment != null ? !this.increment.equals(that.increment) : that.increment != null) {
            return false;
        }
        return !(this.cache != null ? !this.cache.equals(that.cache) : that.cache != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        result = 31 * result + (this.increment != null ? this.increment.hashCode() : 0);
        result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
        return result;
    }
}

