/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OArraySelector
extends SimpleNode {
    protected ORid rid;
    protected OInputParameter inputParam;
    protected OExpression expression;
    protected OInteger integer;

    public OArraySelector(int id) {
        super(id);
    }

    public OArraySelector(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.rid != null) {
            this.rid.toString(params, builder);
        } else if (this.inputParam != null) {
            this.inputParam.toString(params, builder);
        } else if (this.expression != null) {
            this.expression.toString(params, builder);
        } else if (this.integer != null) {
            this.integer.toString(params, builder);
        }
    }

    public Integer getValue(OIdentifiable iCurrentRecord, Object iResult, OCommandContext ctx) {
        Object result = null;
        if (this.inputParam != null) {
            result = this.inputParam.getValue(ctx.getInputParameters());
        } else if (this.expression != null) {
            result = this.expression.execute(iCurrentRecord, ctx);
        } else if (this.integer != null) {
            result = this.integer;
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        return null;
    }

    public Object getValue(OResult iCurrentRecord, Object iResult, OCommandContext ctx) {
        Object result = null;
        if (this.inputParam != null) {
            result = this.inputParam.getValue(ctx.getInputParameters());
        } else if (this.expression != null) {
            result = this.expression.execute(iCurrentRecord, ctx);
        } else if (this.integer != null) {
            result = this.integer;
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        return result;
    }

    public boolean needsAliases(Set<String> aliases) {
        if (this.expression != null) {
            return this.expression.needsAliases(aliases);
        }
        return false;
    }

    @Override
    public OArraySelector copy() {
        OArraySelector result = new OArraySelector(-1);
        result.rid = this.rid == null ? null : this.rid.copy();
        result.inputParam = this.inputParam == null ? null : this.inputParam.copy();
        result.expression = this.expression == null ? null : this.expression.copy();
        result.integer = this.integer == null ? null : this.integer.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OArraySelector that = (OArraySelector)o;
        if (this.rid != null ? !this.rid.equals(that.rid) : that.rid != null) {
            return false;
        }
        if (this.inputParam != null ? !this.inputParam.equals(that.inputParam) : that.inputParam != null) {
            return false;
        }
        if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) {
            return false;
        }
        return !(this.integer != null ? !this.integer.equals(that.integer) : that.integer != null);
    }

    public int hashCode() {
        int result = this.rid != null ? this.rid.hashCode() : 0;
        result = 31 * result + (this.inputParam != null ? this.inputParam.hashCode() : 0);
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        result = 31 * result + (this.integer != null ? this.integer.hashCode() : 0);
        return result;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.expression != null) {
            this.expression.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        return this.expression != null && this.expression.refersToParent();
    }

    public void setValue(OResult currentRecord, Object target, Object value, OCommandContext ctx) {
        Object idx = null;
        if (this.rid != null) {
            idx = this.rid.toRecordId(currentRecord, ctx);
        } else if (this.inputParam != null) {
            idx = this.inputParam.getValue(ctx.getInputParameters());
        } else if (this.expression != null) {
            idx = this.expression.execute(currentRecord, ctx);
        } else if (this.integer != null) {
            idx = this.integer.getValue();
        }
        if (target instanceof Set && idx instanceof Number) {
            this.setValue((Set)target, ((Number)idx).intValue(), value, ctx);
        } else if (target instanceof List && idx instanceof Number) {
            this.setValue((List)target, ((Number)idx).intValue(), value, ctx);
        } else if (target instanceof Map) {
            this.setValue((Map)target, idx, value, ctx);
        } else if (target != null && target.getClass().isArray() && idx instanceof Number) {
            this.setArrayValue(target, ((Number)idx).intValue(), value, ctx);
        }
    }

    public void setValue(List target, int idx, Object value, OCommandContext ctx) {
        int originalSize;
        for (int i = originalSize = target.size(); i <= idx; ++i) {
            if (i < originalSize) continue;
            target.add(null);
        }
        target.set(idx, value);
    }

    public void setValue(Set target, int idx, Object value, OCommandContext ctx) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        int originalSize = target.size();
        int max = Math.max(idx, originalSize - 1);
        Iterator targetIterator = target.iterator();
        for (int i = 0; i <= max; ++i) {
            Object next = null;
            if (targetIterator.hasNext()) {
                next = targetIterator.next();
            }
            if (i == idx) {
                result.add(value);
            } else if (i < originalSize) {
                result.add(next);
            } else {
                result.add(null);
            }
            target.clear();
            target.addAll(result);
        }
    }

    public void setValue(Map target, Object idx, Object value, OCommandContext ctx) {
        target.put(idx, value);
    }

    private void setArrayValue(Object target, int idx, Object value, OCommandContext ctx) {
        if (idx >= 0 && idx < Array.getLength(target)) {
            Array.set(target, idx, value);
        }
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.rid != null) {
            result.setProperty("rid", this.rid.serialize());
        }
        if (this.inputParam != null) {
            result.setProperty("inputParam", this.inputParam.serialize());
        }
        if (this.expression != null) {
            result.setProperty("expression", this.expression.serialize());
        }
        if (this.integer != null) {
            result.setProperty("integer", this.integer.serialize());
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("rid") != null) {
            this.rid = new ORid(-1);
            this.rid.deserialize((OResult)fromResult.getProperty("rid"));
        }
        if (fromResult.getProperty("inputParam") != null) {
            this.inputParam = OInputParameter.deserializeFromOResult((OResult)fromResult.getProperty("inputParam"));
        }
        if (fromResult.getProperty("expression") != null) {
            this.expression = new OExpression(-1);
            this.expression.deserialize((OResult)fromResult.getProperty("expression"));
        }
        if (fromResult.getProperty("integer") != null) {
            this.integer = new OInteger(-1);
            this.integer.deserialize((OResult)fromResult.getProperty("integer"));
        }
    }
}

