/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OCreateClassStatement
extends ODDLStatement {
    public OIdentifier name;
    public boolean ifNotExists;
    protected List<OIdentifier> superclasses;
    protected List<OInteger> clusters;
    protected OInteger totalClusterNo;
    protected boolean abstractClass = false;

    public OCreateClassStatement(int id) {
        super(id);
    }

    public OCreateClassStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        OSchema schema = ctx.getDatabase().getMetadata().getSchema();
        if (schema.existsClass(this.name.getStringValue())) {
            if (this.ifNotExists) {
                return new OInternalResultSet();
            }
            throw new OCommandExecutionException("Class " + this.name + " already exists");
        }
        this.checkSuperclasses(schema, ctx);
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "create class");
        result.setProperty("className", this.name.getStringValue());
        OClass clazz = null;
        OClass[] superclasses = this.getSuperClasses(schema);
        if (this.abstractClass) {
            clazz = schema.createAbstractClass(this.name.getStringValue(), superclasses);
            result.setProperty("abstract", this.abstractClass);
        } else if (this.totalClusterNo != null) {
            clazz = schema.createClass(this.name.getStringValue(), this.totalClusterNo.getValue().intValue(), superclasses);
        } else if (this.clusters != null) {
            this.clusters.stream().map(x -> x.getValue().intValue()).collect(Collectors.toList());
            int[] clusterIds = new int[this.clusters.size()];
            for (int i = 0; i < this.clusters.size(); ++i) {
                clusterIds[i] = this.clusters.get(i).getValue().intValue();
            }
            clazz = schema.createClass(this.name.getStringValue(), clusterIds, superclasses);
        } else {
            clazz = schema.createClass(this.name.getStringValue(), superclasses);
        }
        OInternalResultSet rs = new OInternalResultSet();
        rs.add(result);
        return rs;
    }

    private OClass[] getSuperClasses(OSchema schema) {
        if (this.superclasses == null) {
            return new OClass[0];
        }
        return this.superclasses.stream().map(x -> schema.getClass(x.getStringValue())).filter(x -> x != null).collect(Collectors.toList()).toArray(new OClass[0]);
    }

    private void checkSuperclasses(OSchema schema, OCommandContext ctx) {
        if (this.superclasses != null) {
            for (OIdentifier superclass : this.superclasses) {
                if (schema.existsClass(superclass.getStringValue())) continue;
                throw new OCommandExecutionException("Superclass " + superclass + " not found");
            }
        }
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        boolean first;
        builder.append("CREATE CLASS ");
        this.name.toString(params, builder);
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        if (this.superclasses != null && this.superclasses.size() > 0) {
            builder.append(" EXTENDS ");
            first = true;
            for (OIdentifier sup : this.superclasses) {
                if (!first) {
                    builder.append(", ");
                }
                sup.toString(params, builder);
                first = false;
            }
        }
        if (this.clusters != null && this.clusters.size() > 0) {
            builder.append(" CLUSTER ");
            first = true;
            for (OInteger cluster : this.clusters) {
                if (!first) {
                    builder.append(",");
                }
                cluster.toString(params, builder);
                first = false;
            }
        }
        if (this.totalClusterNo != null) {
            builder.append(" CLUSTERS ");
            this.totalClusterNo.toString(params, builder);
        }
        if (this.abstractClass) {
            builder.append(" ABSTRACT");
        }
    }

    @Override
    public OCreateClassStatement copy() {
        OCreateClassStatement result = new OCreateClassStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.superclasses = this.superclasses == null ? null : this.superclasses.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.clusters = this.clusters == null ? null : this.clusters.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.totalClusterNo = this.totalClusterNo == null ? null : this.totalClusterNo.copy();
        result.abstractClass = this.abstractClass;
        result.ifNotExists = this.ifNotExists;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreateClassStatement that = (OCreateClassStatement)o;
        if (this.abstractClass != that.abstractClass) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.superclasses != null ? !this.superclasses.equals(that.superclasses) : that.superclasses != null) {
            return false;
        }
        if (this.clusters != null ? !this.clusters.equals(that.clusters) : that.clusters != null) {
            return false;
        }
        if (this.totalClusterNo != null ? !this.totalClusterNo.equals(that.totalClusterNo) : that.totalClusterNo != null) {
            return false;
        }
        return this.ifNotExists == that.ifNotExists;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.superclasses != null ? this.superclasses.hashCode() : 0);
        result = 31 * result + (this.clusters != null ? this.clusters.hashCode() : 0);
        result = 31 * result + (this.totalClusterNo != null ? this.totalClusterNo.hashCode() : 0);
        result = 31 * result + (this.abstractClass ? 1 : 0);
        return result;
    }

    public List<OIdentifier> getSuperclasses() {
        return this.superclasses;
    }
}

