/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class OCreatePropertyAttributeStatement
extends SimpleNode {
    public OIdentifier settingName;
    public OExpression settingValue;

    public OCreatePropertyAttributeStatement(int id) {
        super(id);
    }

    public OCreatePropertyAttributeStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.settingName.toString(params, builder);
        if (this.settingValue != null) {
            builder.append(" ");
            this.settingValue.toString(params, builder);
        }
    }

    @Override
    public OCreatePropertyAttributeStatement copy() {
        OCreatePropertyAttributeStatement result = new OCreatePropertyAttributeStatement(-1);
        result.settingName = this.settingName == null ? null : this.settingName.copy();
        result.settingValue = this.settingValue == null ? null : this.settingValue.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreatePropertyAttributeStatement that = (OCreatePropertyAttributeStatement)o;
        if (this.settingName != null ? !this.settingName.equals(that.settingName) : that.settingName != null) {
            return false;
        }
        return !(this.settingValue != null ? !this.settingValue.equals(that.settingValue) : that.settingValue != null);
    }

    public int hashCode() {
        int result = this.settingName != null ? this.settingName.hashCode() : 0;
        result = 31 * result + (this.settingValue != null ? this.settingValue.hashCode() : 0);
        return result;
    }

    public Object setOnProperty(OPropertyImpl internalProp, OCommandContext ctx) {
        Boolean attrValue;
        block11: {
            String attrName = this.settingName.getStringValue();
            attrValue = this.settingValue == null ? Boolean.valueOf(true) : this.settingValue.execute((OIdentifiable)null, ctx);
            try {
                if (attrName.equalsIgnoreCase("readonly")) {
                    internalProp.setReadonly(attrValue);
                    break block11;
                }
                if (attrName.equalsIgnoreCase("mandatory")) {
                    internalProp.setMandatory(attrValue);
                    break block11;
                }
                if (attrName.equalsIgnoreCase("notnull")) {
                    internalProp.setNotNull(attrValue);
                    break block11;
                }
                if (attrName.equalsIgnoreCase("max")) {
                    internalProp.setMax("" + attrValue);
                    break block11;
                }
                if (attrName.equalsIgnoreCase("min")) {
                    internalProp.setMin("" + attrValue);
                    break block11;
                }
                if (attrName.equalsIgnoreCase("default")) {
                    if (this.settingValue == null) {
                        throw new OCommandExecutionException("");
                    }
                    internalProp.setDefaultValue("" + attrValue);
                    break block11;
                }
                if (attrName.equalsIgnoreCase("collate")) {
                    internalProp.setCollate("" + attrValue);
                    break block11;
                }
                if (attrName.equalsIgnoreCase("regexp")) {
                    internalProp.setRegexp("" + attrValue);
                    break block11;
                }
                throw new OCommandExecutionException("Invalid attribute definition: '" + attrName + "'");
            }
            catch (Exception e) {
                throw OException.wrapException(new OCommandExecutionException("Cannot set attribute on property " + this.settingName.getStringValue() + " " + attrValue), e);
            }
        }
        return attrValue;
    }
}

