/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.ODeleteExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.ODeleteExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.HashMap;
import java.util.Map;

public class ODeleteStatement
extends OStatement {
    public OFromClause fromClause;
    protected OWhereClause whereClause;
    protected boolean returnBefore = false;
    protected OLimit limit = null;
    protected boolean unsafe = false;

    public ODeleteStatement(int id) {
        super(id);
    }

    public ODeleteStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("DELETE FROM ");
        this.fromClause.toString(params, builder);
        if (this.returnBefore) {
            builder.append(" RETURN BEFORE");
        }
        if (this.whereClause != null) {
            builder.append(" WHERE ");
            this.whereClause.toString(params, builder);
        }
        if (this.limit != null) {
            this.limit.toString(params, builder);
        }
        if (this.unsafe) {
            builder.append(" UNSAFE");
        }
    }

    @Override
    public ODeleteStatement copy() {
        ODeleteStatement result = new ODeleteStatement(-1);
        result.fromClause = this.fromClause == null ? null : this.fromClause.copy();
        result.whereClause = this.whereClause == null ? null : this.whereClause.copy();
        result.returnBefore = this.returnBefore;
        result.limit = this.limit == null ? null : this.limit.copy();
        result.unsafe = this.unsafe;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODeleteStatement that = (ODeleteStatement)o;
        if (this.returnBefore != that.returnBefore) {
            return false;
        }
        if (this.unsafe != that.unsafe) {
            return false;
        }
        if (this.fromClause != null ? !this.fromClause.equals(that.fromClause) : that.fromClause != null) {
            return false;
        }
        if (this.whereClause != null ? !this.whereClause.equals(that.whereClause) : that.whereClause != null) {
            return false;
        }
        return !(this.limit != null ? !this.limit.equals(that.limit) : that.limit != null);
    }

    public int hashCode() {
        int result = this.fromClause != null ? this.fromClause.hashCode() : 0;
        result = 31 * result + (this.whereClause != null ? this.whereClause.hashCode() : 0);
        result = 31 * result + (this.returnBefore ? 1 : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.unsafe ? 1 : 0);
        return result;
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        ODeleteExecutionPlan executionPlan = this.createExecutionPlan(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        ODeleteExecutionPlan executionPlan = this.createExecutionPlan(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public ODeleteExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        ODeleteExecutionPlanner planner = new ODeleteExecutionPlanner(this);
        ODeleteExecutionPlan result = planner.createExecutionPlan(ctx, enableProfiling);
        result.setStatement(this.originalStatement);
        return result;
    }

    public OFromClause getFromClause() {
        return this.fromClause;
    }

    public OWhereClause getWhereClause() {
        return this.whereClause;
    }

    public boolean isReturnBefore() {
        return this.returnBefore;
    }

    public OLimit getLimit() {
        return this.limit;
    }

    public boolean isUnsafe() {
        return this.unsafe;
    }
}

