/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OModifier;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Locale;
import java.util.Map;

public class OOrderByItem {
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    protected String alias;
    protected OModifier modifier;
    protected String recordAttr;
    protected ORid rid;
    protected String type = "ASC";
    protected OExpression collate;
    private OCollate collateStrategy;

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRecordAttr() {
        return this.recordAttr;
    }

    public void setRecordAttr(String recordAttr) {
        this.recordAttr = recordAttr;
    }

    public ORid getRid() {
        return this.rid;
    }

    public void setRid(ORid rid) {
        this.rid = rid;
    }

    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.alias != null) {
            builder.append(this.alias);
            if (this.modifier != null) {
                this.modifier.toString(params, builder);
            }
        } else if (this.recordAttr != null) {
            builder.append(this.recordAttr);
        } else if (this.rid != null) {
            this.rid.toString(params, builder);
        }
        if (this.type != null) {
            builder.append(" " + this.type);
        }
        if (this.collate != null) {
            builder.append(" COLLATE ");
            this.collate.toString(params, builder);
        }
    }

    public int compare(OResult a, OResult b, OCommandContext ctx) {
        Object aVal = null;
        Object bVal = null;
        if (this.rid != null) {
            throw new UnsupportedOperationException("ORDER BY " + this.rid + " is not supported yet");
        }
        int result = 0;
        if (this.recordAttr != null) {
            aVal = a.getProperty(this.recordAttr);
            bVal = b.getProperty(this.recordAttr);
        } else if (this.alias != null) {
            aVal = a.getProperty(this.alias);
            bVal = b.getProperty(this.alias);
        }
        if (this.modifier != null) {
            aVal = this.modifier.execute(a, aVal, ctx);
            bVal = this.modifier.execute(b, bVal, ctx);
        }
        if (this.collate != null && this.collateStrategy == null) {
            Object collateVal = this.collate.execute(new OResultInternal(), ctx);
            if (collateVal == null && (collateVal = this.collate.toString()).equals("null")) {
                collateVal = null;
            }
            if (collateVal != null) {
                this.collateStrategy = OSQLEngine.getCollate(String.valueOf(collateVal));
                if (this.collateStrategy == null) {
                    this.collateStrategy = OSQLEngine.getCollate(String.valueOf(collateVal).toUpperCase(Locale.ENGLISH));
                }
                if (this.collateStrategy == null) {
                    this.collateStrategy = OSQLEngine.getCollate(String.valueOf(collateVal).toLowerCase(Locale.ENGLISH));
                }
                if (this.collateStrategy == null) {
                    throw new OCommandExecutionException("Invalid collate for ORDER BY: " + collateVal);
                }
            }
        }
        if (this.collateStrategy != null) {
            result = this.collateStrategy.compareForOrderBy(aVal, bVal);
        } else if (aVal == null) {
            result = bVal == null ? 0 : -1;
        } else if (bVal == null) {
            result = 1;
        } else if (aVal instanceof Comparable && bVal instanceof Comparable) {
            try {
                result = ((Comparable)aVal).compareTo(bVal);
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during comparision", e, new Object[0]);
                result = 0;
            }
        }
        if (this.type == DESC) {
            result = -1 * result;
        }
        return result;
    }

    public OOrderByItem copy() {
        OOrderByItem result = new OOrderByItem();
        result.alias = this.alias;
        result.modifier = this.modifier == null ? null : this.modifier.copy();
        result.recordAttr = this.recordAttr;
        result.rid = this.rid == null ? null : this.rid.copy();
        result.type = this.type;
        result.collate = this.collate == null ? null : this.collate.copy();
        return result;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.modifier != null) {
            this.modifier.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        if (this.alias != null && this.alias.equalsIgnoreCase("$parent")) {
            return true;
        }
        if (this.modifier != null && this.modifier.refersToParent()) {
            return true;
        }
        return this.collate != null && this.collate.refersToParent();
    }

    public OModifier getModifier() {
        return this.modifier;
    }

    public void setModifier(OModifier modifier) {
        this.modifier = modifier;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("alias", this.alias);
        if (this.modifier != null) {
            result.setProperty("modifier", this.modifier.serialize());
        }
        result.setProperty("recordAttr", this.recordAttr);
        if (this.rid != null) {
            result.setProperty("rid", this.rid.serialize());
        }
        result.setProperty("type", this.type);
        if (this.collate != null) {
            result.setProperty("collate", this.collate.serialize());
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        this.alias = (String)fromResult.getProperty("alias");
        if (fromResult.getProperty("modifier") != null) {
            this.modifier = new OModifier(-1);
            this.modifier.deserialize((OResult)fromResult.getProperty("modifier"));
        }
        this.recordAttr = (String)fromResult.getProperty("recordAttr");
        if (fromResult.getProperty("rid") != null) {
            this.rid = new ORid(-1);
            this.rid.deserialize((OResult)fromResult.getProperty("rid"));
        }
        String string = this.type = DESC.equals(fromResult.getProperty("type")) ? DESC : ASC;
        if (fromResult.getProperty("collate") != null) {
            this.collate = new OExpression(-1);
            this.collate.deserialize((OResult)fromResult.getProperty("collate"));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OOrderByItem that = (OOrderByItem)o;
        if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) {
            return false;
        }
        if (this.modifier != null ? !this.modifier.equals(that.modifier) : that.modifier != null) {
            return false;
        }
        if (this.recordAttr != null ? !this.recordAttr.equals(that.recordAttr) : that.recordAttr != null) {
            return false;
        }
        if (this.rid != null ? !this.rid.equals(that.rid) : that.rid != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return this.collate != null ? this.collate.equals(that.collate) : that.collate == null;
    }

    public int hashCode() {
        int result = this.alias != null ? this.alias.hashCode() : 0;
        result = 31 * result + (this.modifier != null ? this.modifier.hashCode() : 0);
        result = 31 * result + (this.recordAttr != null ? this.recordAttr.hashCode() : 0);
        result = 31 * result + (this.rid != null ? this.rid.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.collate != null ? this.collate.hashCode() : 0);
        return result;
    }

    public OExpression getCollate() {
        return this.collate;
    }
}

