/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OInsertExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OParenthesisExpression
extends OMathExpression {
    protected OExpression expression;
    protected OStatement statement;

    public OParenthesisExpression(int id) {
        super(id);
    }

    public OParenthesisExpression(OrientSql p, int id) {
        super(p, id);
    }

    public OParenthesisExpression(OExpression exp) {
        super(-1);
        this.expression = exp;
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        if (this.expression != null) {
            return this.expression.execute(iCurrentRecord, ctx);
        }
        if (this.statement != null) {
            throw new UnsupportedOperationException("Execution of select in parentheses is not supported");
        }
        return super.execute(iCurrentRecord, ctx);
    }

    @Override
    public Object execute(OResult iCurrentRecord, OCommandContext ctx) {
        if (this.expression != null) {
            return this.expression.execute(iCurrentRecord, ctx);
        }
        if (this.statement != null) {
            OInternalExecutionPlan execPlan = this.statement.createExecutionPlan(ctx, false);
            if (execPlan instanceof OInsertExecutionPlan) {
                ((OInsertExecutionPlan)execPlan).executeInternal();
            }
            OLocalResultSet rs = new OLocalResultSet(execPlan);
            ArrayList<OResult> result = new ArrayList<OResult>();
            while (rs.hasNext()) {
                result.add(rs.next());
            }
            rs.close();
            return result;
        }
        return super.execute(iCurrentRecord, ctx);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("(");
        if (this.expression != null) {
            this.expression.toString(params, builder);
        } else if (this.statement != null) {
            this.statement.toString(params, builder);
        }
        builder.append(")");
    }

    @Override
    protected boolean supportsBasicCalculation() {
        if (this.expression != null) {
            return this.expression.supportsBasicCalculation();
        }
        return true;
    }

    @Override
    public boolean isEarlyCalculated(OCommandContext ctx) {
        return this.expression != null && this.expression.isEarlyCalculated(ctx);
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        return this.expression.needsAliases(aliases);
    }

    @Override
    public boolean isExpand() {
        if (this.expression != null) {
            return this.expression.isExpand();
        }
        return false;
    }

    @Override
    public boolean isAggregate() {
        if (this.expression != null) {
            return this.expression.isAggregate();
        }
        return false;
    }

    @Override
    public boolean isCount() {
        if (this.expression != null) {
            return this.expression.isCount();
        }
        return false;
    }

    @Override
    public SimpleNode splitForAggregation(AggregateProjectionSplit aggregateProj, OCommandContext ctx) {
        if (this.isAggregate()) {
            OParenthesisExpression result = new OParenthesisExpression(-1);
            result.expression = this.expression.splitForAggregation(aggregateProj, ctx);
            return result;
        }
        return this;
    }

    @Override
    public OParenthesisExpression copy() {
        OParenthesisExpression result = new OParenthesisExpression(-1);
        result.expression = this.expression == null ? null : this.expression.copy();
        result.statement = this.statement == null ? null : this.statement.copy();
        return result;
    }

    public void setStatement(OStatement statement) {
        this.statement = statement;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        if (this.expression != null) {
            this.expression.extractSubQueries(collector);
        } else if (this.statement != null) {
            OIdentifier alias = collector.addStatement(this.statement);
            this.statement = null;
            this.expression = new OExpression(alias);
        }
    }

    @Override
    public void extractSubQueries(OIdentifier letAlias, SubQueryCollector collector) {
        if (this.expression != null) {
            this.expression.extractSubQueries(collector);
        } else if (this.statement != null) {
            OIdentifier alias = collector.addStatement(letAlias, this.statement);
            this.statement = null;
            this.expression = new OExpression(alias);
        }
    }

    @Override
    public boolean refersToParent() {
        if (this.expression != null && this.expression.refersToParent()) {
            return true;
        }
        return this.statement != null && this.statement.refersToParent();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OParenthesisExpression that = (OParenthesisExpression)o;
        if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) {
            return false;
        }
        return !(this.statement != null ? !this.statement.equals(that.statement) : that.statement != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        result = 31 * result + (this.statement != null ? this.statement.hashCode() : 0);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        return this.expression.getMatchPatternInvolvedAliases();
    }

    @Override
    public void applyRemove(OResultInternal result, OCommandContext ctx) {
        if (this.expression == null) {
            throw new OCommandExecutionException("Cannot apply REMOVE " + this.toString());
        }
        this.expression.applyRemove(result, ctx);
    }

    @Override
    public OResult serialize() {
        OResultInternal result = (OResultInternal)super.serialize();
        if (this.expression != null) {
            result.setProperty("expression", this.expression.serialize());
        }
        if (this.statement != null) {
            result.setProperty("statement", this.statement.serialize());
        }
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        super.deserialize(fromResult);
        if (fromResult.getProperty("expression") != null) {
            this.expression = new OExpression(-1);
            this.expression.deserialize((OResult)fromResult.getProperty("expression"));
        }
        if (fromResult.getProperty("statement") != null) {
            this.statement = OStatement.deserializeFromOResult((OResult)fromResult.getProperty("statement"));
        }
    }

    @Override
    public boolean isCacheable() {
        if (this.expression != null) {
            return this.expression.isCacheable();
        }
        if (this.statement != null) {
            return this.statement.executinPlanCanBeCached();
        }
        return true;
    }
}

