/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlan;
import com.orientechnologies.orient.core.sql.parser.OExplainResultSet;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.HashMap;
import java.util.Map;

public class OProfileStatement
extends OStatement {
    protected OStatement statement;

    public OProfileStatement(int id) {
        super(id);
    }

    public OProfileStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("EXPLAIN ");
        this.statement.toString(params, builder);
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        OInternalExecutionPlan executionPlan = this.statement.createExecutionPlan(ctx, true);
        if (executionPlan instanceof OUpdateExecutionPlan) {
            ((OUpdateExecutionPlan)executionPlan).executeInternal();
        }
        OLocalResultSet rs = new OLocalResultSet(executionPlan);
        while (rs.hasNext()) {
            rs.next();
        }
        OExplainResultSet result = new OExplainResultSet(rs.getExecutionPlan().orElseThrow(() -> new OCommandExecutionException("Cannot profile command: " + this.statement)));
        rs.close();
        return result;
    }

    @Override
    public OResultSet execute(ODatabase db, Map args, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(args);
        OInternalExecutionPlan executionPlan = this.statement.createExecutionPlan(ctx, true);
        OLocalResultSet rs = new OLocalResultSet(executionPlan);
        while (rs.hasNext()) {
            rs.next();
        }
        OExplainResultSet result = new OExplainResultSet(rs.getExecutionPlan().orElseThrow(() -> new OCommandExecutionException("Cannot profile command: " + this.statement)));
        rs.close();
        return result;
    }

    @Override
    public OInternalExecutionPlan createExecutionPlan(OCommandContext ctx, boolean profile) {
        return this.statement.createExecutionPlan(ctx, true);
    }

    @Override
    public OProfileStatement copy() {
        OProfileStatement result = new OProfileStatement(-1);
        result.statement = this.statement == null ? null : this.statement.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OProfileStatement that = (OProfileStatement)o;
        return !(this.statement != null ? !this.statement.equals(that.statement) : that.statement != null);
    }

    public int hashCode() {
        return this.statement != null ? this.statement.hashCode() : 0;
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }
}

