/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInCondition;
import com.orientechnologies.orient.core.sql.parser.OInOperator;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ORightBinaryCondition
extends SimpleNode {
    OBinaryCompareOperator operator;
    boolean not = false;
    OInOperator inOperator;
    OExpression right;

    public ORightBinaryCondition(int id) {
        super(id);
    }

    public ORightBinaryCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public ORightBinaryCondition copy() {
        ORightBinaryCondition result = new ORightBinaryCondition(-1);
        result.operator = this.operator == null ? null : this.operator.copy();
        result.not = this.not;
        result.inOperator = this.inOperator == null ? null : this.inOperator.copy();
        result.right = this.right == null ? null : this.right.copy();
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.operator != null) {
            builder.append(this.operator.toString());
            builder.append(" ");
            this.right.toString(params, builder);
        } else if (this.inOperator != null) {
            if (this.not) {
                builder.append("NOT ");
            }
            builder.append("IN ");
            this.right.toString(params, builder);
        }
    }

    public Object execute(OResult iCurrentRecord, Object elementToFilter, OCommandContext ctx) {
        if (elementToFilter == null) {
            return null;
        }
        Iterator<Object> iterator = elementToFilter instanceof OIdentifiable ? Collections.singleton(elementToFilter).iterator() : (elementToFilter instanceof Iterable ? ((Iterable)elementToFilter).iterator() : (elementToFilter instanceof Iterator ? (Iterator<Object>)elementToFilter : Collections.singleton(elementToFilter).iterator()));
        ArrayList<Object> result = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (!this.matchesFilters(iCurrentRecord, element, ctx)) continue;
            result.add(element);
        }
        return result;
    }

    public Object execute(OIdentifiable iCurrentRecord, Object elementToFilter, OCommandContext ctx) {
        if (elementToFilter == null) {
            return null;
        }
        Iterator<Object> iterator = elementToFilter instanceof OIdentifiable ? Collections.singleton(elementToFilter).iterator() : (elementToFilter instanceof Iterable ? ((Iterable)elementToFilter).iterator() : (elementToFilter instanceof Iterator ? (Iterator<Object>)elementToFilter : Collections.singleton(elementToFilter).iterator()));
        ArrayList<Object> result = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (!this.matchesFilters(iCurrentRecord, element, ctx)) continue;
            result.add(element);
        }
        return result;
    }

    private boolean matchesFilters(OIdentifiable iCurrentRecord, Object element, OCommandContext ctx) {
        if (this.operator != null) {
            this.operator.execute(element, this.right.execute(iCurrentRecord, ctx));
        } else if (this.inOperator != null) {
            Object rightVal = this.evaluateRight(iCurrentRecord, ctx);
            if (rightVal == null) {
                return false;
            }
            boolean result = OInCondition.evaluateExpression(element, rightVal);
            if (this.not) {
                result = !result;
            }
            return result;
        }
        return false;
    }

    private boolean matchesFilters(OResult iCurrentRecord, Object element, OCommandContext ctx) {
        if (this.operator != null) {
            return this.operator.execute(element, this.right.execute(iCurrentRecord, ctx));
        }
        if (this.inOperator != null) {
            Object rightVal = this.evaluateRight(iCurrentRecord, ctx);
            if (rightVal == null) {
                return false;
            }
            boolean result = OInCondition.evaluateExpression(element, rightVal);
            if (this.not) {
                result = !result;
            }
            return result;
        }
        return false;
    }

    public Object evaluateRight(OIdentifiable currentRecord, OCommandContext ctx) {
        return this.right.execute(currentRecord, ctx);
    }

    public Object evaluateRight(OResult currentRecord, OCommandContext ctx) {
        return this.right.execute(currentRecord, ctx);
    }

    public boolean needsAliases(Set<String> aliases) {
        return this.right != null && this.right.needsAliases(aliases);
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.right != null) {
            this.right.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        return this.right != null && this.right.refersToParent();
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("operator", this.operator.getClass().getName());
        result.setProperty("not", this.not);
        result.setProperty("in", this.inOperator != null);
        result.setProperty("right", this.right.serialize());
        return result;
    }

    public void deserialize(OResult fromResult) {
        try {
            this.operator = (OBinaryCompareOperator)Class.forName(String.valueOf((char[])fromResult.getProperty("operator"))).newInstance();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
        this.not = (Boolean)fromResult.getProperty("not");
        if (Boolean.TRUE.equals(fromResult.getProperty("in"))) {
            this.inOperator = new OInOperator(-1);
        }
        this.right = new OExpression(-1);
        this.right.deserialize((OResult)fromResult.getProperty("right"));
    }
}

