/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OTraverseExecutionPlanner;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OSkip;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OTraverseProjectionItem;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OTraverseStatement
extends OStatement {
    protected List<OTraverseProjectionItem> projections = new ArrayList<OTraverseProjectionItem>();
    protected OFromClause target;
    protected OWhereClause whileClause;
    protected OSkip skip;
    protected OLimit limit;
    protected Strategy strategy;
    protected OInteger maxDepth;

    public OTraverseStatement(int id) {
        super(id);
    }

    public OTraverseStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void validate() throws OCommandSQLParsingException {
        if (this.target.getItem().getStatement() != null) {
            this.target.getItem().getStatement().validate();
        }
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        OInternalExecutionPlan executionPlan = this.createExecutionPlan(ctx, false);
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        OInternalExecutionPlan executionPlan = this.createExecutionPlan(ctx, false);
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OInternalExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OTraverseExecutionPlanner planner = new OTraverseExecutionPlanner(this);
        OInternalExecutionPlan result = planner.createExecutionPlan(ctx, enableProfiling);
        result.setStatement(this.originalStatement);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("TRAVERSE ");
        boolean first = true;
        for (OTraverseProjectionItem item : this.projections) {
            if (!first) {
                builder.append(", ");
            }
            item.toString(params, builder);
            first = false;
        }
        if (this.target != null) {
            builder.append(" FROM ");
            this.target.toString(params, builder);
        }
        if (this.maxDepth != null) {
            builder.append(" MAXDEPTH ");
            this.maxDepth.toString(params, builder);
        }
        if (this.whileClause != null) {
            builder.append(" WHILE ");
            this.whileClause.toString(params, builder);
        }
        if (this.limit != null) {
            builder.append(" ");
            this.limit.toString(params, builder);
        }
        if (this.strategy != null) {
            builder.append(" strategy ");
            switch (this.strategy) {
                case BREADTH_FIRST: {
                    builder.append("breadth_first");
                    break;
                }
                case DEPTH_FIRST: {
                    builder.append("depth_first");
                }
            }
        }
    }

    @Override
    public boolean refersToParent() {
        if (this.projections != null && this.projections.stream().anyMatch(x -> x.refersToParent())) {
            return true;
        }
        if (this.target != null && this.target.refersToParent()) {
            return true;
        }
        return this.whileClause != null && this.whileClause.refersToParent();
    }

    @Override
    public OStatement copy() {
        OTraverseStatement result = new OTraverseStatement(-1);
        result.projections = this.projections == null ? null : this.projections.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.target = this.target == null ? null : this.target.copy();
        result.whileClause = this.whileClause == null ? null : this.whileClause.copy();
        result.limit = this.limit == null ? null : this.limit.copy();
        result.strategy = this.strategy;
        result.maxDepth = this.maxDepth == null ? null : this.maxDepth.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OTraverseStatement that = (OTraverseStatement)o;
        if (this.projections != null ? !this.projections.equals(that.projections) : that.projections != null) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        if (this.whileClause != null ? !this.whileClause.equals(that.whileClause) : that.whileClause != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.strategy != that.strategy) {
            return false;
        }
        return !(this.maxDepth != null ? !this.maxDepth.equals(that.maxDepth) : that.maxDepth != null);
    }

    public int hashCode() {
        int result = this.projections != null ? this.projections.hashCode() : 0;
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        result = 31 * result + (this.whileClause != null ? this.whileClause.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
        result = 31 * result + (this.maxDepth != null ? this.maxDepth.hashCode() : 0);
        return result;
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    public List<OTraverseProjectionItem> getProjections() {
        return this.projections;
    }

    public void setProjections(List<OTraverseProjectionItem> projections) {
        this.projections = projections;
    }

    public OFromClause getTarget() {
        return this.target;
    }

    public void setTarget(OFromClause target) {
        this.target = target;
    }

    public OWhereClause getWhileClause() {
        return this.whileClause;
    }

    public void setWhileClause(OWhereClause whileClause) {
        this.whileClause = whileClause;
    }

    public OLimit getLimit() {
        return this.limit;
    }

    public void setLimit(OLimit limit) {
        this.limit = limit;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public OInteger getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(OInteger maxDepth) {
        this.maxDepth = maxDepth;
    }

    public OSkip getSkip() {
        return this.skip;
    }

    public void setSkip(OSkip skip) {
        this.skip = skip;
    }

    public static enum Strategy {
        DEPTH_FIRST,
        BREADTH_FIRST;

    }
}

