/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class OCacheEntryImpl
implements OCacheEntry {
    private OCachePointer dataPointer;
    private final long fileId;
    private final long pageIndex;
    private final AtomicInteger usagesCount = new AtomicInteger();

    public OCacheEntryImpl(long fileId, long pageIndex, OCachePointer dataPointer) {
        this.fileId = fileId;
        this.pageIndex = pageIndex;
        this.dataPointer = dataPointer;
    }

    @Override
    public OCachePointer getCachePointer() {
        return this.dataPointer;
    }

    @Override
    public void clearCachePointer() {
        this.dataPointer = null;
    }

    @Override
    public void setCachePointer(OCachePointer cachePointer) {
        this.dataPointer = cachePointer;
    }

    @Override
    public long getFileId() {
        return this.fileId;
    }

    @Override
    public long getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void acquireExclusiveLock() {
        this.dataPointer.acquireExclusiveLock();
    }

    @Override
    public void releaseExclusiveLock() {
        this.dataPointer.releaseExclusiveLock();
    }

    @Override
    public void acquireSharedLock() {
        this.dataPointer.acquireSharedLock();
    }

    @Override
    public void releaseSharedLock() {
        this.dataPointer.releaseSharedLock();
    }

    @Override
    public int getUsagesCount() {
        return this.usagesCount.get();
    }

    @Override
    public void incrementUsages() {
        this.usagesCount.incrementAndGet();
    }

    @Override
    public boolean isLockAcquiredByCurrentThread() {
        return this.dataPointer.isLockAcquiredByCurrentThread();
    }

    @Override
    public void decrementUsages() {
        this.usagesCount.decrementAndGet();
    }

    @Override
    public OWALChanges getChanges() {
        return null;
    }

    @Override
    public OLogSequenceNumber getEndLSN() {
        return this.dataPointer.getEndLSN();
    }

    @Override
    public void setEndLSN(OLogSequenceNumber endLSN) {
        this.dataPointer.setEndLSN(endLSN);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCacheEntryImpl that = (OCacheEntryImpl)o;
        return this.fileId == that.fileId && this.pageIndex == that.pageIndex;
    }

    public int hashCode() {
        return Objects.hash(this.fileId, this.pageIndex);
    }

    public String toString() {
        return "OCacheEntryImpl{dataPointer=" + this.dataPointer + ", fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + ", usagesCount=" + this.usagesCount + '}';
    }
}

