/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local.twoq;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OAllCacheEntriesAreUsedException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCacheEntryImpl;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.twoq.ConcurrentLRUList;
import com.orientechnologies.orient.core.storage.cache.local.twoq.LRUList;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;

public final class O2QCache
implements OReadCache {
    private static final int MAX_AMOUNT_OF_WARNINGS_PINNED_PAGES = 10;
    private static final int MAX_PERCENT_OF_PINED_PAGES = 50;
    public static final int MIN_CACHE_SIZE = 256;
    public static final String CACHE_STATE_FILE = "cache.stt";
    public static final String CACHE_STATISTIC_FILE_EXTENSION = ".stt";
    private final LRUList am;
    private final LRUList a1out;
    private final LRUList a1in;
    private final int pageSize;
    private final AtomicInteger pinnedPagesWarningCounter = new AtomicInteger();
    private final AtomicReference<MemoryData> memoryDataContainer = new AtomicReference();
    private final ConcurrentMap<Long, Set<Long>> filePages;
    private final int percentOfPinnedPages;
    private final LongAdder cacheRequests = new LongAdder();
    private final LongAdder cacheHits = new LongAdder();
    private final OReadersWriterSpinLock cacheLock = new OReadersWriterSpinLock();
    private final OPartitionedLockManager<Object> fileLockManager = new OPartitionedLockManager(true);
    private final OPartitionedLockManager<PageKey> pageLockManager = new OPartitionedLockManager();
    private final ConcurrentMap<PinnedPage, OCacheEntry> pinnedPages = new ConcurrentHashMap<PinnedPage, OCacheEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public O2QCache(long readCacheMaxMemory, int pageSize, boolean checkMinSize, int percentOfPinnedPages, boolean printCacheStatistics, int cacheStatisticsInterval) {
        if (percentOfPinnedPages > 50) {
            throw new IllegalArgumentException("Percent of pinned pages cannot be more than " + percentOfPinnedPages + " but passed value is " + percentOfPinnedPages);
        }
        this.percentOfPinnedPages = percentOfPinnedPages;
        this.cacheLock.acquireWriteLock();
        try {
            this.pageSize = pageSize;
            this.filePages = new ConcurrentHashMap<Long, Set<Long>>();
            int normalizedSize = O2QCache.normalizeMemory(readCacheMaxMemory, pageSize);
            if (checkMinSize && normalizedSize < 256) {
                normalizedSize = 256;
            }
            MemoryData memoryData = new MemoryData(normalizedSize, 0);
            this.memoryDataContainer.set(memoryData);
            this.am = new ConcurrentLRUList();
            this.a1out = new ConcurrentLRUList();
            this.a1in = new ConcurrentLRUList();
            if (printCacheStatistics) {
                Orient.instance().scheduleTask(new TimerTask(){

                    @Override
                    public void run() {
                        long cacheRequests = O2QCache.this.cacheRequests.sum();
                        long cacheHits = O2QCache.this.cacheHits.sum();
                        MemoryData memoryData = (MemoryData)O2QCache.this.memoryDataContainer.get();
                        OLogManager.instance().infoNoDb(this, "Read cache stat: cache hits %d percents, cache size is %d percent", cacheRequests > 0L ? 100L * cacheHits / cacheRequests : -1L, 100 * (O2QCache.this.am.size() + O2QCache.this.a1in.size() + memoryData.pinnedPages) / memoryData.maxSize);
                        O2QCache.this.cacheRequests.add(-cacheRequests);
                        O2QCache.this.cacheHits.add(-cacheHits);
                    }
                }, (long)cacheStatisticsInterval * 1000L, (long)cacheStatisticsInterval * 1000L);
            }
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    LRUList getAm() {
        return this.am;
    }

    boolean inPinnedPages(long fileId, long pageIndex) {
        return this.pinnedPages.containsKey(new PinnedPage(fileId, pageIndex));
    }

    LRUList getA1out() {
        return this.a1out;
    }

    LRUList getA1in() {
        return this.a1in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long addFile(String fileName, OWriteCache writeCache) throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            long fileId = writeCache.addFile(fileName);
            Set oldPages = this.filePages.put(fileId, Collections.newSetFromMap(new ConcurrentHashMap()));
            assert (oldPages == null || oldPages.isEmpty());
            long l = fileId;
            return l;
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long addFile(String fileName, long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireWriteLock();
        try {
            long fid = writeCache.addFile(fileName, fileId);
            Set oldPages = this.filePages.put(fid, Collections.newSetFromMap(new ConcurrentHashMap()));
            assert (oldPages == null || oldPages.isEmpty());
            long l = fid;
            return l;
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    @Override
    public final OCacheEntry loadForWrite(long fileId, long pageIndex, boolean checkPinnedPages, OWriteCache writeCache, int pageCount, boolean verifyChecksums, OLogSequenceNumber startLSN) throws IOException {
        OCacheEntry cacheEntry = this.doLoad(fileId, pageIndex, checkPinnedPages, writeCache, pageCount, verifyChecksums);
        if (cacheEntry != null) {
            cacheEntry.acquireExclusiveLock();
            writeCache.updateDirtyPagesTable(cacheEntry.getCachePointer(), startLSN);
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void releaseFromWrite(OCacheEntry cacheEntry, OWriteCache writeCache) {
        OCachePointer cachePointer = cacheEntry.getCachePointer();
        assert (cachePointer != null);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireSharedLock(cacheEntry.getFileId());
            try {
                Lock pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(cacheEntry.getFileId(), cacheEntry.getPageIndex()));
                try {
                    cacheEntry.decrementUsages();
                    assert (cacheEntry.getUsagesCount() >= 0);
                    if (cacheEntry.getUsagesCount() == 0) {
                        writeCache.store(cacheEntry.getFileId(), cacheEntry.getPageIndex(), cacheEntry.getCachePointer());
                    }
                }
                finally {
                    pageLock.unlock();
                }
            }
            finally {
                fileLock.unlock();
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
        cachePointer.releaseExclusiveLock();
    }

    @Override
    public final OCacheEntry loadForRead(long fileId, long pageIndex, boolean checkPinnedPages, OWriteCache writeCache, int pageCount, boolean verifyChecksums) throws IOException {
        return this.doLoad(fileId, pageIndex, checkPinnedPages, writeCache, pageCount, verifyChecksums);
    }

    @Override
    public final void releaseFromRead(OCacheEntry cacheEntry, OWriteCache writeCache) {
        this.doRelease(cacheEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRelease(OCacheEntry cacheEntry) {
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireSharedLock(cacheEntry.getFileId());
            try {
                Lock pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(cacheEntry.getFileId(), cacheEntry.getPageIndex()));
                try {
                    cacheEntry.decrementUsages();
                    assert (cacheEntry.getUsagesCount() >= 0);
                    assert (cacheEntry.getUsagesCount() > 0 || !cacheEntry.isLockAcquiredByCurrentThread());
                }
                finally {
                    pageLock.unlock();
                }
            }
            finally {
                fileLock.unlock();
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void pinPage(OCacheEntry cacheEntry, OWriteCache writeCache) {
        MemoryData memoryData = this.memoryDataContainer.get();
        if (100 * (memoryData.pinnedPages + 1) / memoryData.maxSize > this.percentOfPinnedPages) {
            long warnings;
            if (this.pinnedPagesWarningCounter.get() < 10 && (warnings = (long)this.pinnedPagesWarningCounter.getAndIncrement()) < 10L) {
                OLogManager.instance().warn((Object)this, "Maximum amount of pinned pages is reached, given page " + cacheEntry + " will not be marked as pinned which may lead to performance degradation. You may consider to increase the percent of pinned pages by changing the property '" + OGlobalConfiguration.DISK_CACHE_PINNED_PAGES.getKey() + "'", new Object[0]);
            }
            return;
        }
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireSharedLock(cacheEntry.getFileId());
            PageKey k = new PageKey(cacheEntry.getFileId(), cacheEntry.getPageIndex());
            try {
                Lock pageLock = this.pageLockManager.acquireExclusiveLock(k);
                try {
                    this.remove(cacheEntry.getFileId(), cacheEntry.getPageIndex());
                    this.pinnedPages.put(new PinnedPage(cacheEntry.getFileId(), cacheEntry.getPageIndex()), cacheEntry);
                }
                finally {
                    pageLock.unlock();
                }
            }
            finally {
                fileLock.unlock();
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
        MemoryData newMemoryData = new MemoryData(memoryData.maxSize, memoryData.pinnedPages + 1);
        while (!this.memoryDataContainer.compareAndSet(memoryData, newMemoryData)) {
            memoryData = this.memoryDataContainer.get();
            newMemoryData = new MemoryData(memoryData.maxSize, memoryData.pinnedPages + 1);
        }
        this.removeColdestPagesIfNeeded(writeCache);
    }

    public void changeMaximumAmountOfMemory(long readCacheMaxMemory) throws IllegalStateException {
        MemoryData newMemoryData;
        MemoryData memoryData;
        int newMemorySize = O2QCache.normalizeMemory(readCacheMaxMemory, this.pageSize);
        do {
            if ((memoryData = this.memoryDataContainer.get()).maxSize == newMemorySize) {
                return;
            }
            if (100 * memoryData.pinnedPages / newMemorySize <= this.percentOfPinnedPages) continue;
            throw new IllegalStateException("Cannot decrease amount of memory used by disk cache because limit of pinned pages will be more than allowed limit " + this.percentOfPinnedPages);
        } while (!this.memoryDataContainer.compareAndSet(memoryData, newMemoryData = new MemoryData(newMemorySize, memoryData.pinnedPages)));
        OLogManager.instance().info((Object)this, "Disk cache size was changed from " + memoryData.maxSize + " pages to " + newMemorySize + " pages", new Object[0]);
    }

    private OCacheEntry doLoad(long fileId, long pageIndex, boolean checkPinnedPages, OWriteCache writeCache, int pageCount, boolean verifyChecksums) throws IOException {
        OModifiableBoolean cacheHit = new OModifiableBoolean(false);
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        UpdateCacheResult cacheResult = this.doLoad(fileId, pageIndex, checkPinnedPages, false, false, writeCache, pageCount, verifyChecksums, cacheHit);
        if (cacheResult == null) {
            return null;
        }
        try {
            if (cacheResult.removeColdPages) {
                this.removeColdestPagesIfNeeded(writeCache);
            }
        }
        catch (RuntimeException e) {
            this.releaseFromWrite(cacheResult.cacheEntry, writeCache);
            throw e;
        }
        this.cacheRequests.increment();
        if (cacheHit.getValue()) {
            this.cacheHits.increment();
        }
        return cacheResult.cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UpdateCacheResult doLoad(long fileId, long pageIndex, boolean checkPinnedPages, boolean addNewPages, boolean initNewPage, OWriteCache writeCache, int pageCount, boolean verifyChecksums, OModifiableBoolean cacheHit) throws IOException {
        if (pageCount < 1) {
            throw new IllegalArgumentException("Amount of pages to load from cache should be not less than 1 but passed value is " + pageCount);
        }
        boolean removeColdPages = false;
        OCacheEntry cacheEntry = null;
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireSharedLock(fileId);
            try {
                UpdateCacheResult updateCacheResult;
                PageKey[] pageKeys = new PageKey[pageCount];
                for (int i = 0; i < pageKeys.length; ++i) {
                    pageKeys[i] = new PageKey(fileId, pageIndex + (long)i);
                }
                if (checkPinnedPages && (cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex))) != null) {
                    cacheHit.setValue(true);
                    cacheEntry.incrementUsages();
                    UpdateCacheResult i = new UpdateCacheResult(false, cacheEntry);
                    return i;
                }
                Lock[] pageLocks = this.pageLockManager.acquireExclusiveLocksInBatch((PageKey[])pageKeys);
                try {
                    if (checkPinnedPages) {
                        cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex));
                    }
                    if (cacheEntry == null) {
                        UpdateCacheResult cacheResult = this.updateCache(fileId, pageIndex, addNewPages, initNewPage, writeCache, pageCount, cacheHit, verifyChecksums);
                        if (cacheResult == null) {
                            updateCacheResult = null;
                            return updateCacheResult;
                        }
                        cacheEntry = cacheResult.cacheEntry;
                        removeColdPages = cacheResult.removeColdPages;
                    } else {
                        cacheHit.setValue(true);
                    }
                    cacheEntry.incrementUsages();
                }
                finally {
                    Lock[] lockArray = pageLocks;
                    int n = lockArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Lock pageLock = lockArray[n2];
                        pageLock.unlock();
                        ++n2;
                    }
                    return updateCacheResult;
                }
            }
            finally {
                fileLock.unlock();
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final OCacheEntry allocateNewPage(long fileId, OWriteCache writeCache, boolean verifyChecksums, OLogSequenceNumber startLSN, boolean initPage) throws IOException {
        UpdateCacheResult cacheResult;
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        OModifiableBoolean cacheHit = new OModifiableBoolean(false);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                long filledUpTo = writeCache.getFilledUpTo(fileId);
                assert (filledUpTo >= 0L);
                cacheResult = this.doLoad(fileId, filledUpTo, false, true, initPage, writeCache, 1, verifyChecksums, cacheHit);
            }
            finally {
                fileLock.unlock();
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
        assert (cacheResult != null);
        try {
            if (cacheResult.removeColdPages) {
                this.removeColdestPagesIfNeeded(writeCache);
            }
        }
        catch (RuntimeException e) {
            this.doRelease(cacheResult.cacheEntry);
            throw e;
        }
        OCacheEntry cacheEntry = cacheResult.cacheEntry;
        if (cacheEntry != null) {
            cacheEntry.acquireExclusiveLock();
            writeCache.updateDirtyPagesTable(cacheEntry.getCachePointer(), startLSN);
        }
        assert (cacheHit.getValue());
        this.cacheRequests.increment();
        this.cacheHits.increment();
        return cacheResult.cacheEntry;
    }

    @Override
    public final void clear() {
        this.cacheLock.acquireWriteLock();
        try {
            this.clearCacheContent();
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void truncateFile(long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                writeCache.truncateFile(fileId);
                this.clearFile(fileId);
            }
            finally {
                fileLock.unlock();
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    private void clearFile(long fileId) {
        Set pageEntries = (Set)this.filePages.get(fileId);
        if (pageEntries == null || pageEntries.isEmpty()) {
            assert (this.get(fileId, 0L) == null);
            return;
        }
        for (Long pageIndex : pageEntries) {
            OCacheEntry cacheEntry = this.get(fileId, pageIndex);
            if (cacheEntry == null) {
                cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex));
            }
            if (cacheEntry != null) {
                if (cacheEntry.getUsagesCount() == 0) {
                    OCachePointer cachePointer;
                    cacheEntry = this.remove(fileId, pageIndex);
                    if (cacheEntry == null) {
                        MemoryData memoryData = this.memoryDataContainer.get();
                        cacheEntry = (OCacheEntry)this.pinnedPages.remove(new PinnedPage(fileId, pageIndex));
                        MemoryData newMemoryData = new MemoryData(memoryData.maxSize, memoryData.pinnedPages - 1);
                        while (!this.memoryDataContainer.compareAndSet(memoryData, newMemoryData)) {
                            memoryData = this.memoryDataContainer.get();
                            newMemoryData = new MemoryData(memoryData.maxSize, memoryData.pinnedPages - 1);
                        }
                    }
                    if ((cachePointer = cacheEntry.getCachePointer()) == null) continue;
                    cachePointer.decrementReadersReferrer();
                    cacheEntry.clearCachePointer();
                    continue;
                }
                throw new OStorageException("Page with index " + pageIndex + " for file with id " + fileId + " cannot be freed because it is used.");
            }
            throw new OStorageException("Page with index " + pageIndex + " was  not found in cache for file with id " + fileId);
        }
        assert (this.get(fileId, 0L) == null);
        pageEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void closeFile(long fileId, boolean flush, OWriteCache writeCache) {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                writeCache.close(fileId, flush);
                this.clearFile(fileId);
            }
            finally {
                fileLock.unlock();
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deleteFile(long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                this.clearFile(fileId);
                this.filePages.remove(fileId);
                writeCache.deleteFile(fileId);
            }
            finally {
                fileLock.unlock();
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void closeStorage(OWriteCache writeCache) throws IOException {
        if (writeCache == null) {
            return;
        }
        this.cacheLock.acquireWriteLock();
        try {
            long[] filesToClear;
            for (long fileId : filesToClear = writeCache.close()) {
                this.clearFile(fileId);
            }
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    @Override
    public final void loadCacheState(OWriteCache writeCache) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void storeCacheState(OWriteCache writeCache) {
        if (!OGlobalConfiguration.STORAGE_KEEP_DISK_CACHE_STATE.getValueAsBoolean()) {
            return;
        }
        if (writeCache == null) {
            return;
        }
        this.cacheLock.acquireWriteLock();
        try {
            Path rootDirectory = writeCache.getRootDirectory();
            Path stateFile = rootDirectory.resolve(CACHE_STATE_FILE);
            if (Files.exists(stateFile, new LinkOption[0])) {
                Files.delete(stateFile);
            }
            HashSet<Long> filesToStore = new HashSet<Long>(writeCache.files().values());
            try (FileChannel channel = FileChannel.open(stateFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                OutputStream channelStream = Channels.newOutputStream(channel);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(channelStream, 65536);
                try (DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);){
                    dataOutputStream.writeLong(this.memoryDataContainer.get().maxSize);
                    O2QCache.storeQueueState(writeCache, filesToStore, dataOutputStream, this.am);
                    dataOutputStream.writeInt(-1);
                    O2QCache.storeQueueState(writeCache, filesToStore, dataOutputStream, this.a1in);
                    dataOutputStream.writeInt(-1);
                    O2QCache.storeQueueState(writeCache, filesToStore, dataOutputStream, this.a1out);
                    dataOutputStream.writeInt(-1);
                }
            }
        }
        catch (Exception e) {
            OLogManager.instance().error(this, "Cannot store state of cache for storage placed under %s", e, writeCache.getRootDirectory());
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    private static void storeQueueState(OWriteCache writeCache, Set<Long> filesToStore, DataOutputStream dataOutputStream, LRUList queue) throws IOException {
        Iterator<OCacheEntry> queueIterator = queue.reverseIterator();
        while (queueIterator.hasNext()) {
            OCacheEntry cacheEntry = queueIterator.next();
            long fileId = cacheEntry.getFileId();
            if (!filesToStore.contains(fileId)) continue;
            int internalId = writeCache.internalFileId(fileId);
            dataOutputStream.writeInt(internalId);
            dataOutputStream.writeLong(cacheEntry.getPageIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deleteStorage(OWriteCache writeCache) throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            long[] filesToClear;
            for (long fileId : filesToClear = writeCache.delete()) {
                this.clearFile(fileId);
            }
            Path rootDirectory = writeCache.getRootDirectory();
            Path stateFile = rootDirectory.resolve(CACHE_STATE_FILE);
            if (Files.exists(stateFile, new LinkOption[0])) {
                Files.delete(stateFile);
            }
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    private OCacheEntry get(long fileId, long pageIndex) {
        OCacheEntry cacheEntry = this.am.get(fileId, pageIndex);
        if (cacheEntry != null) {
            assert (this.filePages.get(fileId) != null);
            assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
            return cacheEntry;
        }
        cacheEntry = this.a1out.get(fileId, pageIndex);
        if (cacheEntry != null) {
            assert (this.filePages.get(fileId) != null);
            assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
            return cacheEntry;
        }
        cacheEntry = this.a1in.get(fileId, pageIndex);
        return cacheEntry;
    }

    private void clearCacheContent() {
        OCachePointer cachePointer;
        for (OCacheEntry cacheEntry : this.am) {
            if (cacheEntry.getUsagesCount() == 0) {
                cachePointer = cacheEntry.getCachePointer();
                cachePointer.decrementReadersReferrer();
                cacheEntry.clearCachePointer();
                continue;
            }
            throw new OStorageException("Page with index " + cacheEntry.getPageIndex() + " for file id " + cacheEntry.getFileId() + " is used and cannot be removed");
        }
        for (OCacheEntry cacheEntry : this.a1in) {
            if (cacheEntry.getUsagesCount() == 0) {
                cachePointer = cacheEntry.getCachePointer();
                cachePointer.decrementReadersReferrer();
                cacheEntry.clearCachePointer();
                continue;
            }
            throw new OStorageException("Page with index " + cacheEntry.getPageIndex() + " for file id " + cacheEntry.getFileId() + " is used and cannot be removed");
        }
        this.a1out.clear();
        this.am.clear();
        this.a1in.clear();
        for (Set pages : this.filePages.values()) {
            pages.clear();
        }
        this.clearPinnedPages();
    }

    private void clearPinnedPages() {
        for (OCacheEntry pinnedEntry : this.pinnedPages.values()) {
            if (pinnedEntry.getUsagesCount() == 0) {
                OCachePointer cachePointer = pinnedEntry.getCachePointer();
                cachePointer.decrementReadersReferrer();
                pinnedEntry.clearCachePointer();
                MemoryData memoryData = this.memoryDataContainer.get();
                MemoryData newMemoryData = new MemoryData(memoryData.maxSize, memoryData.pinnedPages - 1);
                while (!this.memoryDataContainer.compareAndSet(memoryData, newMemoryData)) {
                    memoryData = this.memoryDataContainer.get();
                    newMemoryData = new MemoryData(memoryData.maxSize, memoryData.pinnedPages - 1);
                }
                continue;
            }
            throw new OStorageException("Page with index " + pinnedEntry.getPageIndex() + " for file with id " + pinnedEntry.getFileId() + "cannot be freed because it is used.");
        }
        this.pinnedPages.clear();
    }

    private boolean entryIsInAmQueue(long fileId, long pageIndex, OCacheEntry cacheEntry) {
        assert (this.filePages.get(fileId) != null);
        assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
        this.am.putToMRU(cacheEntry);
        return false;
    }

    private boolean entryWasInA1OutQueue(long fileId, long pageIndex, OCachePointer dataPointer, OCacheEntry cacheEntry) {
        assert (this.filePages.get(fileId) != null);
        assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
        assert (dataPointer != null);
        assert (cacheEntry.getCachePointer() == null);
        cacheEntry.setCachePointer(dataPointer);
        this.am.putToMRU(cacheEntry);
        return true;
    }

    private boolean entryIsInA1InQueue(long fileId, long pageIndex) {
        assert (this.filePages.get(fileId) != null);
        assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
        return false;
    }

    private UpdateCacheResult entryIsAbsentInQueues(long fileId, long pageIndex, OCachePointer dataPointer) {
        OCacheEntryImpl cacheEntry = new OCacheEntryImpl(fileId, pageIndex, dataPointer);
        this.a1in.putToMRU(cacheEntry);
        Set pages = (Set)this.filePages.get(fileId);
        if (pages == null) {
            pages = Collections.newSetFromMap(new ConcurrentHashMap());
            Set oldPages = this.filePages.putIfAbsent(fileId, pages);
            if (oldPages != null) {
                pages = oldPages;
            }
        }
        pages.add(pageIndex);
        return new UpdateCacheResult(true, cacheEntry);
    }

    private UpdateCacheResult updateCache(long fileId, long pageIndex, boolean addNewPages, boolean initNewPage, OWriteCache writeCache, int pageCount, OModifiableBoolean cacheHit, boolean verifyChecksums) throws IOException {
        boolean removeColdPages;
        OCachePointer dataPointer;
        assert (pageCount > 0);
        OCacheEntry cacheEntry = this.am.get(fileId, pageIndex);
        if (cacheEntry != null) {
            cacheHit.setValue(true);
            return new UpdateCacheResult(this.entryIsInAmQueue(fileId, pageIndex, cacheEntry), cacheEntry);
        }
        OCachePointer[] dataPointers = null;
        cacheEntry = this.a1out.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            dataPointers = writeCache.load(fileId, pageIndex, pageCount, false, initNewPage, cacheHit, verifyChecksums);
            dataPointer = dataPointers[0];
            removeColdPages = this.entryWasInA1OutQueue(fileId, pageIndex, dataPointer, cacheEntry);
        } else {
            cacheEntry = this.a1in.get(fileId, pageIndex);
            if (cacheEntry != null) {
                removeColdPages = this.entryIsInA1InQueue(fileId, pageIndex);
                cacheHit.setValue(true);
            } else {
                dataPointers = writeCache.load(fileId, pageIndex, pageCount, addNewPages, initNewPage, cacheHit, verifyChecksums);
                if (dataPointers.length == 0) {
                    return null;
                }
                dataPointer = dataPointers[0];
                UpdateCacheResult ucr = this.entryIsAbsentInQueues(fileId, pageIndex, dataPointer);
                cacheEntry = ucr.cacheEntry;
                removeColdPages = ucr.removeColdPages;
            }
        }
        if (dataPointers != null) {
            for (int n = 1; n < dataPointers.length; ++n) {
                removeColdPages = this.processFetchedPage(removeColdPages, dataPointers[n]);
            }
        }
        return new UpdateCacheResult(removeColdPages, cacheEntry);
    }

    private boolean processFetchedPage(boolean removeColdPages, OCachePointer dataPointer) {
        long pageIndex;
        long fileId = dataPointer.getFileId();
        if (this.pinnedPages.containsKey(new PinnedPage(fileId, pageIndex = dataPointer.getPageIndex()))) {
            dataPointer.decrementReadersReferrer();
            return removeColdPages;
        }
        OCacheEntry cacheEntry = this.am.get(fileId, pageIndex);
        if (cacheEntry != null) {
            boolean rcp = this.entryIsInAmQueue(fileId, pageIndex, cacheEntry);
            removeColdPages = removeColdPages || rcp;
            dataPointer.decrementReadersReferrer();
            return removeColdPages;
        }
        cacheEntry = this.a1out.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            boolean rcp = this.entryWasInA1OutQueue(fileId, pageIndex, dataPointer, cacheEntry);
            removeColdPages = removeColdPages || rcp;
            return removeColdPages;
        }
        cacheEntry = this.a1in.get(fileId, pageIndex);
        if (cacheEntry != null) {
            boolean rcp = this.entryIsInA1InQueue(fileId, pageIndex);
            removeColdPages = removeColdPages || rcp;
            dataPointer.decrementReadersReferrer();
            return removeColdPages;
        }
        boolean rcp = this.entryIsAbsentInQueues(fileId, pageIndex, dataPointer).removeColdPages;
        removeColdPages = removeColdPages || rcp;
        return removeColdPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void removeColdestPagesIfNeeded(OWriteCache writeCache) {
        memoryData = this.memoryDataContainer.get();
        if (this.am.size() + this.a1in.size() > memoryData.get2QCacheSize()) {
            try {
                writeCache.checkCacheOverflow();
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OInterruptedException("Check of write cache overflow was interrupted"), e);
            }
        }
        this.cacheLock.acquireWriteLock();
lbl9:
        // 2 sources

        try {
            while (this.am.size() + this.a1in.size() > memoryData.get2QCacheSize()) {
                block17: {
                    if (this.a1in.size() <= MemoryData.access$1200(memoryData)) break block17;
                    removedFromAInEntry = this.a1in.removeLRU();
                    if (removedFromAInEntry == null) {
                        throw new OAllCacheEntriesAreUsedException("All records in aIn queue in 2q cache are used!");
                    }
                    if (!O2QCache.$assertionsDisabled && removedFromAInEntry.getUsagesCount() != 0) {
                        throw new AssertionError();
                    }
                    cachePointer = removedFromAInEntry.getCachePointer();
                    if (cachePointer != null) {
                        cachePointer.decrementReadersReferrer();
                        removedFromAInEntry.clearCachePointer();
                    }
                    this.a1out.putToMRU(removedFromAInEntry);
                    while (this.a1out.size() > MemoryData.access$1300(memoryData)) {
                        removedEntry = this.a1out.removeLRU();
                        if (!O2QCache.$assertionsDisabled && removedEntry.getUsagesCount() != 0) {
                            throw new AssertionError();
                        }
                        if (!O2QCache.$assertionsDisabled && removedEntry.getCachePointer() != null) {
                            throw new AssertionError();
                        }
                        pageEntries = (Set)this.filePages.get(removedEntry.getFileId());
                        pageEntries.remove(removedEntry.getPageIndex());
                    }
                    ** GOTO lbl9
                }
                removedEntry = this.am.removeLRU();
                if (removedEntry == null) {
                    throw new OAllCacheEntriesAreUsedException("All records in aIn queue in 2q cache are used!");
                }
                if (!O2QCache.$assertionsDisabled && removedEntry.getUsagesCount() != 0) {
                    throw new AssertionError();
                }
                cachePointer = removedEntry.getCachePointer();
                if (cachePointer != null) {
                    cachePointer.decrementReadersReferrer();
                    removedEntry.clearCachePointer();
                }
                pageEntries = (Set)this.filePages.get(removedEntry.getFileId());
                pageEntries.remove(removedEntry.getPageIndex());
            }
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    int getMaxSize() {
        return this.memoryDataContainer.get().maxSize;
    }

    @Override
    public final long getUsedMemory() {
        return (long)(this.am.size() + this.a1in.size()) * (long)this.pageSize;
    }

    private OCacheEntry remove(long fileId, long pageIndex) {
        OCacheEntry cacheEntry = this.am.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            if (cacheEntry.getUsagesCount() > 1) {
                throw new IllegalStateException("Record cannot be removed because it is used!");
            }
            return cacheEntry;
        }
        cacheEntry = this.a1out.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        cacheEntry = this.a1in.remove(fileId, pageIndex);
        if (cacheEntry != null && cacheEntry.getUsagesCount() > 1) {
            throw new IllegalStateException("Record cannot be removed because it is used!");
        }
        return cacheEntry;
    }

    private static int normalizeMemory(long maxSize, int pageSize) {
        long tmpMaxSize = maxSize / (long)pageSize;
        if (tmpMaxSize >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmpMaxSize;
    }

    private static final class MemoryData {
        private final int K_IN;
        private final int K_OUT;
        private final int maxSize;
        private final int pinnedPages;

        MemoryData(int maxSize, int pinnedPages) {
            this.K_IN = maxSize - pinnedPages >> 2;
            this.K_OUT = maxSize - pinnedPages >> 1;
            this.maxSize = maxSize;
            this.pinnedPages = pinnedPages;
        }

        int get2QCacheSize() {
            return this.maxSize - this.pinnedPages;
        }

        static /* synthetic */ int access$1200(MemoryData x0) {
            return x0.K_IN;
        }

        static /* synthetic */ int access$1300(MemoryData x0) {
            return x0.K_OUT;
        }
    }

    private static final class UpdateCacheResult {
        private final boolean removeColdPages;
        private final OCacheEntry cacheEntry;

        private UpdateCacheResult(boolean removeColdPages, OCacheEntry cacheEntry) {
            this.removeColdPages = removeColdPages;
            this.cacheEntry = cacheEntry;
        }
    }

    private static final class PageKey
    implements Comparable<PageKey> {
        private final long fileId;
        private final long pageIndex;

        private PageKey(long fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageKey pageKey = (PageKey)o;
            if (this.fileId != pageKey.fileId) {
                return false;
            }
            return this.pageIndex == pageKey.pageIndex;
        }

        @Override
        public int compareTo(PageKey other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            return Long.compare(this.pageIndex, other.pageIndex);
        }

        public int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }
    }

    private static final class PinnedPage
    implements Comparable<PinnedPage> {
        private final long fileId;
        private final long pageIndex;

        private PinnedPage(long fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PinnedPage that = (PinnedPage)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.pageIndex == that.pageIndex;
        }

        public final String toString() {
            return "PinnedPage{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
        }

        public final int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        @Override
        public final int compareTo(PinnedPage other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            return Long.compare(this.pageIndex, other.pageIndex);
        }
    }
}

