/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cluster.v0;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.compression.OCompression;
import com.orientechnologies.orient.core.compression.OCompressionFactory;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfigurationImpl;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.encryption.OEncryptionFactory;
import com.orientechnologies.orient.core.exception.OPaginatedClusterException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPage;
import com.orientechnologies.orient.core.storage.cluster.OClusterPageDebug;
import com.orientechnologies.orient.core.storage.cluster.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.cluster.OPaginatedCluster;
import com.orientechnologies.orient.core.storage.cluster.OPaginatedClusterDebug;
import com.orientechnologies.orient.core.storage.cluster.v0.OClusterPositionMapV0;
import com.orientechnologies.orient.core.storage.cluster.v0.OPaginatedClusterStateV0;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OClusterBrowseEntry;
import com.orientechnologies.orient.core.storage.impl.local.OClusterBrowsePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public final class OPaginatedClusterV0
extends OPaginatedCluster {
    private final boolean addRidMetadata = OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.getValueAsBoolean();
    private static final int BINARY_VERSION = 0;
    private static final int DISK_PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger();
    private static final int LOWEST_FREELIST_BOUNDARY = OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger();
    private static final int FREE_LIST_SIZE = DISK_PAGE_SIZE - LOWEST_FREELIST_BOUNDARY;
    private static final int PAGE_INDEX_OFFSET = 16;
    private static final int RECORD_POSITION_MASK = 65535;
    private static final int ONE_KB = 1024;
    private volatile OCompression compression;
    private volatile OEncryption encryption;
    private final boolean systemCluster;
    private OClusterPositionMapV0 clusterPositionMap;
    private OAbstractPaginatedStorage storageLocal;
    private volatile int id;
    private long fileId;
    private OStoragePaginatedClusterConfiguration config;
    private long pinnedStateEntryIndex;
    private ORecordConflictStrategy recordConflictStrategy;

    public OPaginatedClusterV0(String name, OAbstractPaginatedStorage storage) {
        super(storage, name, ".pcl", name + ".pcl");
        this.systemCluster = OMetadataInternal.SYSTEM_CLUSTER.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(OStorage storage, int id, String clusterName, Object ... parameters) throws IOException {
        this.acquireExclusiveLock();
        try {
            OContextConfiguration ctxCfg = storage.getConfiguration().getContextConfiguration();
            String cfgCompression = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD);
            String cfgEncryption = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD);
            String cfgEncryptionKey = ctxCfg.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY);
            this.config = new OStoragePaginatedClusterConfiguration(storage.getConfiguration(), id, clusterName, null, true, 1.2f, 1.2f, cfgCompression, cfgEncryption, cfgEncryptionKey, null, OStorageClusterConfiguration.STATUS.ONLINE, 0);
            this.config.name = clusterName;
            this.init((OAbstractPaginatedStorage)storage, this.config);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public int getBinaryVersion() {
        return 0;
    }

    @Override
    public void configure(OStorage storage, OStorageClusterConfiguration config) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.init((OAbstractPaginatedStorage)storage, config);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(int startSize) throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                this.initCusterState(atomicOperation);
                this.clusterPositionMap.create(atomicOperation);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    @Override
    public void registerInStorageConfig(OStorageConfigurationImpl root) {
        root.addCluster(this.config);
        root.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        this.acquireExclusiveLock();
        try {
            OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
            this.fileId = this.openFile(atomicOperation, this.getFullName());
            OCacheEntry pinnedStateEntry = this.loadPageForRead(atomicOperation, this.fileId, 0L, false);
            try {
                this.pinPage(atomicOperation, pinnedStateEntry);
                this.pinnedStateEntryIndex = pinnedStateEntry.getPageIndex();
            }
            finally {
                this.releasePageFromRead(atomicOperation, pinnedStateEntry);
            }
            this.clusterPositionMap.open(atomicOperation);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceFile(File file) throws IOException {
        this.acquireExclusiveLock();
        try {
            long tempFileId;
            String tempFileName = file.getName() + "$temp";
            try {
                tempFileId = this.writeCache.addFile(tempFileName);
                this.writeCache.replaceFileContentWith(tempFileId, file.toPath());
                this.readCache.deleteFile(this.fileId, this.writeCache);
                this.writeCache.renameFile(tempFileId, this.getFullName());
                this.fileId = tempFileId;
            }
            finally {
                tempFileId = this.writeCache.fileIdByName(tempFileName);
                if (tempFileId >= 0L) {
                    this.writeCache.deleteFile(tempFileId);
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceClusterMapFile(File file) throws IOException {
        this.acquireExclusiveLock();
        try {
            long tempFileId;
            String tempFileName = file.getName() + "$temp";
            try {
                tempFileId = this.writeCache.addFile(tempFileName);
                this.writeCache.replaceFileContentWith(tempFileId, file.toPath());
                this.readCache.deleteFile(this.clusterPositionMap.getFileId(), this.writeCache);
                this.writeCache.renameFile(tempFileId, this.clusterPositionMap.getFullName());
                this.clusterPositionMap.replaceFileId(tempFileId);
            }
            finally {
                tempFileId = this.writeCache.fileIdByName(tempFileName);
                if (tempFileId >= 0L) {
                    this.writeCache.deleteFile(tempFileId);
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    public void close(boolean flush) throws IOException {
        this.acquireExclusiveLock();
        try {
            if (flush) {
                this.synch();
            }
            this.readCache.closeFile(this.fileId, flush, this.writeCache);
            this.clusterPositionMap.close(flush);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void delete() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                this.deleteFile(atomicOperation, this.fileId);
                this.clusterPositionMap.delete(atomicOperation);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object set(OCluster.ATTRIBUTES attribute, Object value) throws IOException {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = value != null ? value.toString() : null;
        this.acquireExclusiveLock();
        try {
            switch (attribute) {
                case NAME: {
                    this.setNameInternal(stringValue);
                    return null;
                }
                case RECORD_GROW_FACTOR: {
                    this.setRecordGrowFactorInternal(stringValue);
                    return null;
                }
                case RECORD_OVERFLOW_GROW_FACTOR: {
                    this.setRecordOverflowGrowFactorInternal(stringValue);
                    return null;
                }
                case CONFLICTSTRATEGY: {
                    this.setRecordConflictStrategy(stringValue);
                    return null;
                }
                case STATUS: {
                    if (stringValue == null) {
                        throw new IllegalStateException("Value of attribute is null");
                    }
                    Boolean bl = this.storageLocal.setClusterStatus(this.id, OStorageClusterConfiguration.STATUS.valueOf(stringValue.toUpperCase(this.storageLocal.getConfiguration().getLocaleInstance())));
                    return bl;
                }
                case ENCRYPTION: {
                    if (this.getEntries() > 0L) {
                        throw new IllegalArgumentException("Cannot change encryption setting on cluster '" + this.getName() + "' because it is not empty");
                    }
                    this.setEncryptionInternal(stringValue, ODatabaseRecordThreadLocal.instance().get().getStorage().getConfiguration().getContextConfiguration().getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY));
                    return null;
                }
                default: {
                    throw new IllegalArgumentException("Runtime change of attribute '" + (Object)((Object)attribute) + " is not supported");
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean isSystemCluster() {
        return this.systemCluster;
    }

    @Override
    public float recordGrowFactor() {
        this.acquireSharedLock();
        try {
            float f = this.config.recordGrowFactor;
            return f;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public float recordOverflowGrowFactor() {
        this.acquireSharedLock();
        try {
            float f = this.config.recordOverflowGrowFactor;
            return f;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String compression() {
        this.acquireSharedLock();
        try {
            String string = this.config.compression;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String encryption() {
        this.acquireSharedLock();
        try {
            String string = this.config.encryption;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition allocatePosition(byte recordType) throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            OPhysicalPosition oPhysicalPosition;
            this.acquireExclusiveLock();
            try {
                OPhysicalPosition pos = OPaginatedClusterV0.createPhysicalPosition(recordType, this.clusterPositionMap.allocate(atomicOperation), -1);
                this.addAtomicOperationMetadata(new ORecordId(this.id, pos.clusterPosition), atomicOperation);
                oPhysicalPosition = pos;
            }
            catch (Throwable throwable) {
                try {
                    this.releaseExclusiveLock();
                    throw throwable;
                }
                catch (Exception e) {
                    rollback = true;
                    throw e;
                }
            }
            this.releaseExclusiveLock();
            return oPhysicalPosition;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition createRecord(byte[] content, int recordVersion, byte recordType, OPhysicalPosition allocatedPosition) throws IOException {
        content = this.compression.compress(content);
        content = this.encryption.encrypt(content);
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            OPhysicalPosition oPhysicalPosition;
            block20: {
                long clusterPosition;
                this.acquireExclusiveLock();
                int entryContentLength = OPaginatedClusterV0.getEntryContentLength(content.length);
                if (entryContentLength >= OClusterPage.MAX_RECORD_SIZE) break block20;
                byte[] entryContent = new byte[entryContentLength];
                int entryPosition = 0;
                entryContent[entryPosition] = recordType;
                OIntegerSerializer.INSTANCE.serializeNative(content.length, entryContent, ++entryPosition, new Object[0]);
                System.arraycopy(content, 0, entryContent, entryPosition += 4, content.length);
                entryContent[entryPosition += content.length] = 1;
                OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, ++entryPosition, new Object[0]);
                AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                this.updateClusterState(1L, addEntryResult.recordsSizeDiff, atomicOperation);
                if (allocatedPosition != null) {
                    this.clusterPositionMap.update(allocatedPosition.clusterPosition, new OClusterPositionMapBucket.PositionEntry(addEntryResult.pageIndex, addEntryResult.pagePosition), atomicOperation);
                    clusterPosition = allocatedPosition.clusterPosition;
                } else {
                    clusterPosition = this.clusterPositionMap.add(addEntryResult.pageIndex, addEntryResult.pagePosition, atomicOperation);
                }
                this.addAtomicOperationMetadata(new ORecordId(this.id, clusterPosition), atomicOperation);
                OPhysicalPosition oPhysicalPosition2 = OPaginatedClusterV0.createPhysicalPosition(recordType, clusterPosition, addEntryResult.recordVersion);
                this.releaseExclusiveLock();
                return oPhysicalPosition2;
            }
            try {
                long clusterPosition;
                int entrySize = content.length + 4 + 1;
                int fullEntryPosition = 0;
                byte[] fullEntry = new byte[entrySize];
                fullEntry[fullEntryPosition] = recordType;
                OIntegerSerializer.INSTANCE.serializeNative(content.length, fullEntry, ++fullEntryPosition, new Object[0]);
                System.arraycopy(content, 0, fullEntry, fullEntryPosition += 4, content.length);
                long prevPageRecordPointer = -1L;
                long firstPageIndex = -1L;
                int firstPagePosition = -1;
                int version = 0;
                int from = 0;
                int to = from + (OClusterPage.MAX_RECORD_SIZE - 1 - 8);
                int recordsSizeDiff = 0;
                do {
                    byte[] entryContent = new byte[to - from + 1 + 8];
                    System.arraycopy(fullEntry, from, entryContent, 0, to - from);
                    entryContent[entryContent.length - 8 - 1] = from > 0 ? (byte)0 : 1;
                    OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, entryContent.length - 8, new Object[0]);
                    AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                    recordsSizeDiff += addEntryResult.recordsSizeDiff;
                    if (firstPageIndex == -1L) {
                        firstPageIndex = addEntryResult.pageIndex;
                        firstPagePosition = addEntryResult.pagePosition;
                        version = addEntryResult.recordVersion;
                    }
                    long addedPagePointer = OPaginatedClusterV0.createPagePointer(addEntryResult.pageIndex, addEntryResult.pagePosition);
                    if (prevPageRecordPointer >= 0L) {
                        long prevPageIndex = OPaginatedClusterV0.getPageIndex(prevPageRecordPointer);
                        int prevPageRecordPosition = OPaginatedClusterV0.getRecordPosition(prevPageRecordPointer);
                        OCacheEntry prevPageCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, prevPageIndex, false);
                        try {
                            OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false);
                            prevPage.setRecordLongValue(prevPageRecordPosition, -8, addedPagePointer);
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, prevPageCacheEntry);
                        }
                    }
                    prevPageRecordPointer = addedPagePointer;
                    from = to;
                    if ((to += OClusterPage.MAX_RECORD_SIZE - 8 - 1) <= fullEntry.length) continue;
                    to = fullEntry.length;
                } while (from < to);
                this.updateClusterState(1L, recordsSizeDiff, atomicOperation);
                if (allocatedPosition != null) {
                    this.clusterPositionMap.update(allocatedPosition.clusterPosition, new OClusterPositionMapBucket.PositionEntry(firstPageIndex, firstPagePosition), atomicOperation);
                    clusterPosition = allocatedPosition.clusterPosition;
                } else {
                    clusterPosition = this.clusterPositionMap.add(firstPageIndex, firstPagePosition, atomicOperation);
                }
                this.addAtomicOperationMetadata(new ORecordId(this.id, clusterPosition), atomicOperation);
                oPhysicalPosition = OPaginatedClusterV0.createPhysicalPosition(recordType, clusterPosition, version);
            }
            catch (Throwable throwable) {
                try {
                    this.releaseExclusiveLock();
                    throw throwable;
                }
                catch (Exception e) {
                    rollback = true;
                    throw e;
                }
            }
            this.releaseExclusiveLock();
            return oPhysicalPosition;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    private void addAtomicOperationMetadata(ORID rid, OAtomicOperation atomicOperation) {
        if (!this.addRidMetadata) {
            return;
        }
        if (atomicOperation == null) {
            return;
        }
        ORecordOperationMetadata recordOperationMetadata = (ORecordOperationMetadata)atomicOperation.getMetadata("cluster.record.rid");
        if (recordOperationMetadata == null) {
            recordOperationMetadata = new ORecordOperationMetadata();
            atomicOperation.addMetadata(recordOperationMetadata);
        }
        recordOperationMetadata.addRid(rid);
    }

    private static int getEntryContentLength(int grownContentSize) {
        int entryContentLength = grownContentSize + 2 + 4 + 8;
        return entryContentLength;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public ORawBuffer readRecord(long clusterPosition, boolean prefetchRecords) throws IOException {
        int pagesToPrefetch = 1;
        if (prefetchRecords) {
            pagesToPrefetch = OGlobalConfiguration.QUERY_SCAN_PREFETCH_PAGES.getValueAsInteger();
        }
        return this.readRecord(clusterPosition, pagesToPrefetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORawBuffer readRecord(long clusterPosition, int pageCount) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OClusterPositionMapBucket.PositionEntry positionEntry;
            OAtomicOperation atomicOperation;
            block8: {
                ORawBuffer oRawBuffer;
                this.acquireSharedLock();
                try {
                    atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    positionEntry = this.clusterPositionMap.get(clusterPosition, pageCount, atomicOperation);
                    if (positionEntry != null) break block8;
                    oRawBuffer = null;
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oRawBuffer;
            }
            ORawBuffer oRawBuffer = this.internalReadRecord(clusterPosition, positionEntry.getPageIndex(), positionEntry.getRecordPosition(), pageCount, atomicOperation);
            this.releaseSharedLock();
            return oRawBuffer;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORawBuffer internalReadRecord(long clusterPosition, long pageIndex, int recordPosition, int pageCount, OAtomicOperation atomicOperation) throws IOException {
        int recordVersion;
        if (this.getFilledUpTo(atomicOperation, this.fileId) <= pageIndex) {
            return null;
        }
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, pageCount);
        try {
            OClusterPage localPage = new OClusterPage(cacheEntry, false);
            if (localPage.isDeleted(recordPosition)) {
                ORawBuffer oRawBuffer = null;
                return oRawBuffer;
            }
            recordVersion = localPage.getRecordVersion(recordPosition);
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
        byte[] fullContent = this.readFullEntry(clusterPosition, pageIndex, recordPosition, atomicOperation, pageCount);
        if (fullContent == null) {
            return null;
        }
        int fullContentPosition = 0;
        byte recordType = fullContent[fullContentPosition];
        int readContentSize = OIntegerSerializer.INSTANCE.deserializeNative(fullContent, ++fullContentPosition);
        byte[] recordContent = Arrays.copyOfRange(fullContent, fullContentPosition += 4, fullContentPosition + readContentSize);
        recordContent = this.encryption.decrypt(recordContent);
        recordContent = this.compression.uncompress(recordContent);
        return new ORawBuffer(recordContent, recordVersion, recordType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORawBuffer readRecordIfVersionIsNotLatest(long clusterPosition, int recordVersion) throws IOException, ORecordNotFoundException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            ORawBuffer oRawBuffer;
            block15: {
                this.acquireSharedLock();
                try {
                    int loadedRecordVersion;
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition, 1, atomicOperation);
                    if (positionEntry == null) {
                        throw new ORecordNotFoundException(new ORecordId(this.id, clusterPosition), "Record for cluster with id " + this.id + " and position " + clusterPosition + " is absent.");
                    }
                    int recordPosition = positionEntry.getRecordPosition();
                    long pageIndex = positionEntry.getPageIndex();
                    if (this.getFilledUpTo(atomicOperation, this.fileId) <= pageIndex) {
                        throw new ORecordNotFoundException(new ORecordId(this.id, clusterPosition), "Record for cluster with id " + this.id + " and position " + clusterPosition + " is absent.");
                    }
                    OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
                    try {
                        OClusterPage localPage = new OClusterPage(cacheEntry, false);
                        if (localPage.isDeleted(recordPosition)) {
                            throw new ORecordNotFoundException(new ORecordId(this.id, clusterPosition), "Record for cluster with id " + this.id + " and position " + clusterPosition + " is absent.");
                        }
                        loadedRecordVersion = localPage.getRecordVersion(recordPosition);
                    }
                    finally {
                        this.releasePageFromRead(atomicOperation, cacheEntry);
                    }
                    if (loadedRecordVersion <= recordVersion) break block15;
                    oRawBuffer = this.readRecord(clusterPosition, false);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oRawBuffer;
            }
            oRawBuffer = null;
            this.releaseSharedLock();
            return oRawBuffer;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean deleteRecord(long clusterPosition) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 18[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hideRecord(long position) throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            block13: {
                OClusterPositionMapBucket.PositionEntry positionEntry;
                block12: {
                    boolean bl;
                    this.acquireExclusiveLock();
                    try {
                        positionEntry = this.clusterPositionMap.get(position, 1, atomicOperation);
                        if (positionEntry != null) break block12;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.releaseExclusiveLock();
                            throw throwable;
                        }
                        catch (Exception e) {
                            rollback = true;
                            throw e;
                        }
                    }
                    this.releaseExclusiveLock();
                    return bl;
                }
                long pageIndex = positionEntry.getPageIndex();
                if (this.getFilledUpTo(atomicOperation, this.fileId) > pageIndex) break block13;
                boolean bl = false;
                this.releaseExclusiveLock();
                return bl;
            }
            this.updateClusterState(-1L, 0L, atomicOperation);
            this.clusterPositionMap.remove(position, atomicOperation);
            this.addAtomicOperationMetadata(new ORecordId(this.id, position), atomicOperation);
            boolean bl = true;
            this.releaseExclusiveLock();
            return bl;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(long clusterPosition, byte[] content, int recordVersion, byte recordType) throws IOException {
        content = this.compression.compress(content);
        content = this.encryption.encrypt(content);
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            this.acquireExclusiveLock();
            try {
                int to;
                OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition, 1, atomicOperation);
                if (positionEntry == null) {
                    return;
                }
                int nextRecordPosition = positionEntry.getRecordPosition();
                long nextPageIndex = positionEntry.getPageIndex();
                int newRecordPosition = -1;
                long newPageIndex = -1L;
                long prevPageIndex = -1L;
                int prevRecordPosition = -1;
                long nextEntryPointer = -1L;
                int from = 0;
                long sizeDiff = 0L;
                byte[] updateEntry = null;
                do {
                    int updatedEntryPosition;
                    int entrySize;
                    if (updateEntry == null) {
                        if (from == 0) {
                            entrySize = Math.min(OPaginatedClusterV0.getEntryContentLength(content.length), OClusterPage.MAX_RECORD_SIZE);
                            to = entrySize - 14;
                        } else {
                            entrySize = Math.min(content.length - from + 1 + 8, OClusterPage.MAX_RECORD_SIZE);
                            to = from + entrySize - 9;
                        }
                        updateEntry = new byte[entrySize];
                        int entryPosition = 0;
                        if (from == 0) {
                            updateEntry[entryPosition] = recordType;
                            OIntegerSerializer.INSTANCE.serializeNative(content.length, updateEntry, ++entryPosition, new Object[0]);
                            entryPosition += 4;
                        }
                        System.arraycopy(content, from, updateEntry, entryPosition, to - from);
                        entryPosition += to - from;
                        if (nextPageIndex == positionEntry.getPageIndex()) {
                            updateEntry[entryPosition] = 1;
                        }
                        OLongSerializer.INSTANCE.serializeNative(-1L, updateEntry, ++entryPosition, new Object[0]);
                        if (to < content.length) assert (entrySize == OClusterPage.MAX_RECORD_SIZE);
                    } else {
                        entrySize = updateEntry.length;
                        to = from == 0 ? entrySize - 14 : from + entrySize - 9;
                    }
                    int freePageIndex = -1;
                    if (nextPageIndex < 0L) {
                        FindFreePageResult findFreePageResult = this.findFreePage(entrySize, atomicOperation);
                        nextPageIndex = findFreePageResult.pageIndex;
                        freePageIndex = findFreePageResult.freePageIndex;
                    }
                    boolean isNew = false;
                    OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, nextPageIndex, false);
                    if (cacheEntry == null) {
                        cacheEntry = this.addPage(atomicOperation, this.fileId, false);
                        isNew = true;
                    }
                    try {
                        OClusterPage localPage = new OClusterPage(cacheEntry, isNew);
                        int pageFreeSpace = localPage.getFreeSpace();
                        if (freePageIndex < 0) {
                            freePageIndex = OPaginatedClusterV0.calculateFreePageIndex(localPage);
                        } else assert (isNew || freePageIndex == OPaginatedClusterV0.calculateFreePageIndex(localPage));
                        if (nextRecordPosition >= 0) {
                            if (localPage.isDeleted(nextRecordPosition)) {
                                throw new OPaginatedClusterException("Record with rid " + new ORecordId(this.id, clusterPosition) + " was deleted", this);
                            }
                            int currentEntrySize = localPage.getRecordSize(nextRecordPosition);
                            nextEntryPointer = localPage.getRecordLongValue(nextRecordPosition, currentEntrySize - 8);
                            if (currentEntrySize == entrySize) {
                                localPage.replaceRecord(nextRecordPosition, updateEntry, recordVersion);
                                updatedEntryPosition = nextRecordPosition;
                            } else {
                                localPage.deleteRecord(nextRecordPosition);
                                if (localPage.getMaxRecordSize() >= entrySize) {
                                    updatedEntryPosition = localPage.appendRecord(recordVersion, updateEntry);
                                    if (updatedEntryPosition < 0) {
                                        localPage.dumpToLog();
                                        throw new IllegalStateException("Page " + cacheEntry.getPageIndex() + " does not have enough free space to add record content, freePageIndex=" + freePageIndex + ", updateEntry.length=" + updateEntry.length + ", content.length=" + content.length);
                                    }
                                } else {
                                    updatedEntryPosition = -1;
                                }
                            }
                            if (nextEntryPointer >= 0L) {
                                nextRecordPosition = OPaginatedClusterV0.getRecordPosition(nextEntryPointer);
                                nextPageIndex = OPaginatedClusterV0.getPageIndex(nextEntryPointer);
                            } else {
                                nextPageIndex = -1L;
                                nextRecordPosition = -1;
                            }
                        } else {
                            assert (localPage.getFreeSpace() >= entrySize);
                            updatedEntryPosition = localPage.appendRecord(recordVersion, updateEntry);
                            if (updatedEntryPosition < 0) {
                                localPage.dumpToLog();
                                throw new IllegalStateException("Page " + cacheEntry.getPageIndex() + " does not have enough free space to add record content, freePageIndex=" + freePageIndex + ", updateEntry.length=" + updateEntry.length + ", content.length=" + content.length);
                            }
                            nextPageIndex = -1L;
                            nextRecordPosition = -1;
                        }
                        sizeDiff += (long)(pageFreeSpace - localPage.getFreeSpace());
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                    this.updateFreePagesIndex(freePageIndex, cacheEntry.getPageIndex(), atomicOperation);
                    if (updatedEntryPosition < 0) continue;
                    if (from == 0) {
                        newPageIndex = cacheEntry.getPageIndex();
                        newRecordPosition = updatedEntryPosition;
                    }
                    from = to;
                    if (prevPageIndex >= 0L) {
                        OCacheEntry prevCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, prevPageIndex, false);
                        try {
                            OClusterPage prevPage = new OClusterPage(prevCacheEntry, false);
                            prevPage.setRecordLongValue(prevRecordPosition, -8, OPaginatedClusterV0.createPagePointer(cacheEntry.getPageIndex(), updatedEntryPosition));
                        }
                        finally {
                            this.releasePageFromWrite(atomicOperation, prevCacheEntry);
                        }
                    }
                    prevPageIndex = cacheEntry.getPageIndex();
                    prevRecordPosition = updatedEntryPosition;
                    updateEntry = null;
                } while (to < content.length || updateEntry != null);
                while (nextEntryPointer >= 0L) {
                    int freePagesIndex;
                    nextPageIndex = OPaginatedClusterV0.getPageIndex(nextEntryPointer);
                    nextRecordPosition = OPaginatedClusterV0.getRecordPosition(nextEntryPointer);
                    OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, nextPageIndex, false);
                    try {
                        OClusterPage localPage = new OClusterPage(cacheEntry, false);
                        int freeSpace = localPage.getFreeSpace();
                        freePagesIndex = OPaginatedClusterV0.calculateFreePageIndex(localPage);
                        nextEntryPointer = localPage.getRecordLongValue(nextRecordPosition, -8);
                        localPage.deleteRecord(nextRecordPosition);
                        sizeDiff += (long)(freeSpace - localPage.getFreeSpace());
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                    this.updateFreePagesIndex(freePagesIndex, nextPageIndex, atomicOperation);
                }
                assert (newPageIndex >= 0L);
                assert (newRecordPosition >= 0);
                if (newPageIndex != positionEntry.getPageIndex() || newRecordPosition != positionEntry.getRecordPosition()) {
                    this.clusterPositionMap.update(clusterPosition, new OClusterPositionMapBucket.PositionEntry(newPageIndex, newRecordPosition), atomicOperation);
                }
                this.updateClusterState(0L, sizeDiff, atomicOperation);
                this.addAtomicOperationMetadata(new ORecordId(this.id, clusterPosition), atomicOperation);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycleRecord(long clusterPosition, byte[] content, int recordVersion, byte recordType) throws IOException {
        block16: {
            boolean rollback = false;
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            try {
                this.acquireExclusiveLock();
                try {
                    OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition, 1, atomicOperation);
                    if (positionEntry != null) {
                        throw new OPaginatedClusterException("Record with rid " + new ORecordId(this.id, clusterPosition) + " was not deleted", this);
                    }
                    content = this.compression.compress(content);
                    int entryContentLength = OPaginatedClusterV0.getEntryContentLength((content = this.encryption.encrypt(content)).length);
                    if (entryContentLength < OClusterPage.MAX_RECORD_SIZE) {
                        byte[] entryContent = new byte[entryContentLength];
                        int entryPosition = 0;
                        entryContent[entryPosition] = recordType;
                        OIntegerSerializer.INSTANCE.serializeNative(content.length, entryContent, ++entryPosition, new Object[0]);
                        System.arraycopy(content, 0, entryContent, entryPosition += 4, content.length);
                        entryContent[entryPosition += content.length] = 1;
                        OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, ++entryPosition, new Object[0]);
                        AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                        this.updateClusterState(1L, addEntryResult.recordsSizeDiff, atomicOperation);
                        this.clusterPositionMap.resurrect(clusterPosition, new OClusterPositionMapBucket.PositionEntry(addEntryResult.pageIndex, addEntryResult.pagePosition), atomicOperation);
                        this.addAtomicOperationMetadata(new ORecordId(this.id, clusterPosition), atomicOperation);
                        break block16;
                    }
                    int entrySize = content.length + 4 + 1;
                    int fullEntryPosition = 0;
                    byte[] fullEntry = new byte[entrySize];
                    fullEntry[fullEntryPosition] = recordType;
                    OIntegerSerializer.INSTANCE.serializeNative(content.length, fullEntry, ++fullEntryPosition, new Object[0]);
                    System.arraycopy(content, 0, fullEntry, fullEntryPosition += 4, content.length);
                    long prevPageRecordPointer = -1L;
                    long firstPageIndex = -1L;
                    int firstPagePosition = -1;
                    int from = 0;
                    int to = from + (OClusterPage.MAX_RECORD_SIZE - 1 - 8);
                    int recordsSizeDiff = 0;
                    do {
                        byte[] entryContent = new byte[to - from + 1 + 8];
                        System.arraycopy(fullEntry, from, entryContent, 0, to - from);
                        entryContent[entryContent.length - 8 - 1] = from > 0 ? (byte)0 : 1;
                        OLongSerializer.INSTANCE.serializeNative(-1L, entryContent, entryContent.length - 8, new Object[0]);
                        AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, atomicOperation);
                        recordsSizeDiff += addEntryResult.recordsSizeDiff;
                        if (firstPageIndex == -1L) {
                            firstPageIndex = addEntryResult.pageIndex;
                            firstPagePosition = addEntryResult.pagePosition;
                        }
                        long addedPagePointer = OPaginatedClusterV0.createPagePointer(addEntryResult.pageIndex, addEntryResult.pagePosition);
                        if (prevPageRecordPointer >= 0L) {
                            long prevPageIndex = OPaginatedClusterV0.getPageIndex(prevPageRecordPointer);
                            int prevPageRecordPosition = OPaginatedClusterV0.getRecordPosition(prevPageRecordPointer);
                            OCacheEntry prevPageCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, prevPageIndex, false);
                            try {
                                OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false);
                                prevPage.setRecordLongValue(prevPageRecordPosition, -8, addedPagePointer);
                            }
                            finally {
                                this.releasePageFromWrite(atomicOperation, prevPageCacheEntry);
                            }
                        }
                        prevPageRecordPointer = addedPagePointer;
                        from = to;
                        if ((to += OClusterPage.MAX_RECORD_SIZE - 8 - 1) <= fullEntry.length) continue;
                        to = fullEntry.length;
                    } while (from < to);
                    this.updateClusterState(1L, recordsSizeDiff, atomicOperation);
                    this.clusterPositionMap.update(clusterPosition, new OClusterPositionMapBucket.PositionEntry(firstPageIndex, firstPagePosition), atomicOperation);
                    this.addAtomicOperationMetadata(new ORecordId(this.id, clusterPosition), atomicOperation);
                }
                finally {
                    this.releaseExclusiveLock();
                }
            }
            catch (Exception e) {
                rollback = true;
                throw e;
            }
            finally {
                this.endAtomicOperation(rollback);
            }
        }
    }

    @Override
    public long getTombstonesCount() {
        return 0L;
    }

    @Override
    public void truncate() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            this.acquireExclusiveLock();
            try {
                this.truncateFile(atomicOperation, this.fileId);
                this.clusterPositionMap.truncate(atomicOperation);
                this.initCusterState(atomicOperation);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isDeleted(OPhysicalPosition position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getEntries() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFirstPosition() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            long l;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                l = this.clusterPositionMap.getFirstPosition(atomicOperation);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return l;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastPosition() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            long l;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                l = this.clusterPositionMap.getLastPosition(atomicOperation);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return l;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextPosition() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            long l;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                l = this.clusterPositionMap.getNextPosition(atomicOperation);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return l;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public String getFileName() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            String string;
            this.acquireSharedLock();
            try {
                string = this.writeCache.fileNameById(this.fileId);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return string;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public long getFileId() {
        return this.fileId;
    }

    @Override
    public void synch() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            this.acquireSharedLock();
            try {
                this.writeCache.flush(this.fileId);
                this.clusterPositionMap.flush();
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getRecordsSize() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] higherPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                long[] clusterPositions = this.clusterPositionMap.higherPositions(position.clusterPosition, atomicOperation);
                oPhysicalPositionArray = OPaginatedClusterV0.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                long[] clusterPositions = this.clusterPositionMap.ceilingPositions(position.clusterPosition, atomicOperation);
                oPhysicalPositionArray = OPaginatedClusterV0.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] lowerPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                long[] clusterPositions = this.clusterPositionMap.lowerPositions(position.clusterPosition, atomicOperation);
                oPhysicalPositionArray = OPaginatedClusterV0.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] floorPositions(OPhysicalPosition position) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OPhysicalPosition[] oPhysicalPositionArray;
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                long[] clusterPositions = this.clusterPositionMap.floorPositions(position.clusterPosition, atomicOperation);
                oPhysicalPositionArray = OPaginatedClusterV0.convertToPhysicalPositions(clusterPositions);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oPhysicalPositionArray;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public ORecordConflictStrategy getRecordConflictStrategy() {
        return this.recordConflictStrategy;
    }

    private void setRecordConflictStrategy(String stringValue) {
        this.recordConflictStrategy = Orient.instance().getRecordConflictStrategy().getStrategy(stringValue);
        this.config.conflictStrategy = stringValue;
        ((OStorageConfigurationImpl)this.storageLocal.getConfiguration()).update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClusterState(long sizeDiff, long recordsSizeDiff, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true);
        try {
            OPaginatedClusterStateV0 paginatedClusterState = new OPaginatedClusterStateV0(pinnedStateEntry);
            paginatedClusterState.setSize(paginatedClusterState.getSize() + sizeDiff);
            paginatedClusterState.setRecordsSize(paginatedClusterState.getRecordsSize() + recordsSizeDiff);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, pinnedStateEntry);
        }
    }

    private void init(OAbstractPaginatedStorage storage, OStorageClusterConfiguration config) throws IOException {
        OFileUtils.checkValidName(config.getName());
        this.config = (OStoragePaginatedClusterConfiguration)config;
        this.compression = OCompressionFactory.INSTANCE.getCompression(this.config.compression, null);
        this.encryption = OEncryptionFactory.INSTANCE.getEncryption(this.config.encryption, this.config.encryptionKey);
        if (((OStoragePaginatedClusterConfiguration)config).conflictStrategy != null) {
            this.recordConflictStrategy = Orient.instance().getRecordConflictStrategy().getStrategy(((OStoragePaginatedClusterConfiguration)config).conflictStrategy);
        }
        this.storageLocal = storage;
        this.id = config.getId();
        this.clusterPositionMap = new OClusterPositionMapV0(storage, this.getName(), this.getFullName());
    }

    private void setEncryptionInternal(String iMethod, String iKey) {
        try {
            this.encryption = OEncryptionFactory.INSTANCE.getEncryption(iMethod, iKey);
            this.config.encryption = iMethod;
            ((OStorageConfigurationImpl)this.storageLocal.getConfiguration()).update();
        }
        catch (IllegalArgumentException e) {
            throw OException.wrapException(new OPaginatedClusterException("Invalid value for " + (Object)((Object)OCluster.ATTRIBUTES.ENCRYPTION) + " attribute", this), e);
        }
    }

    private void setRecordOverflowGrowFactorInternal(String stringValue) {
        try {
            float growFactor = Float.parseFloat(stringValue);
            if (growFactor < 1.0f) {
                throw new OPaginatedClusterException((Object)((Object)OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR) + " cannot be less than 1", this);
            }
            this.config.recordOverflowGrowFactor = growFactor;
            ((OStorageConfigurationImpl)this.storageLocal.getConfiguration()).update();
        }
        catch (NumberFormatException nfe) {
            throw OException.wrapException(new OPaginatedClusterException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR) + " was passed [" + stringValue + "]", this), nfe);
        }
    }

    private void setRecordGrowFactorInternal(String stringValue) {
        try {
            float growFactor = Float.parseFloat(stringValue);
            if (growFactor < 1.0f) {
                throw new OPaginatedClusterException((Object)((Object)OCluster.ATTRIBUTES.RECORD_GROW_FACTOR) + " cannot be less than 1", this);
            }
            this.config.recordGrowFactor = growFactor;
            ((OStorageConfigurationImpl)this.storageLocal.getConfiguration()).update();
        }
        catch (NumberFormatException nfe) {
            throw OException.wrapException(new OPaginatedClusterException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.RECORD_GROW_FACTOR) + " was passed [" + stringValue + "]", this), nfe);
        }
    }

    private void setNameInternal(String newName) throws IOException {
        this.writeCache.renameFile(this.fileId, newName + this.getExtension());
        this.clusterPositionMap.rename(newName);
        this.config.name = newName;
        this.storageLocal.renameCluster(this.getName(), newName);
        this.setName(newName);
        ((OStorageConfigurationImpl)this.storageLocal.getConfiguration()).update();
    }

    private static OPhysicalPosition createPhysicalPosition(byte recordType, long clusterPosition, int version) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        physicalPosition.recordType = recordType;
        physicalPosition.recordSize = -1;
        physicalPosition.clusterPosition = clusterPosition;
        physicalPosition.recordVersion = version;
        return physicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    private byte[] readFullEntry(long clusterPosition, long pageIndex, int recordPosition, OAtomicOperation atomicOperation, int pageCount) throws IOException {
        byte[] fullContent;
        long nextPagePointer;
        if (this.getFilledUpTo(atomicOperation, this.fileId) <= pageIndex) {
            return null;
        }
        ArrayList<byte[]> recordChunks = new ArrayList<byte[]>();
        int contentSize = 0;
        boolean firstEntry = true;
        do {
            OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, pageCount);
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry, false);
                if (localPage.isDeleted(recordPosition)) {
                    if (recordChunks.isEmpty()) {
                        Iterator iterator = null;
                        return iterator;
                    }
                    throw new OPaginatedClusterException("Content of record " + new ORecordId(this.id, clusterPosition) + " was broken", this);
                }
                byte[] content = localPage.getRecordBinaryValue(recordPosition, 0, localPage.getRecordSize(recordPosition));
                if (firstEntry && content[content.length - 8 - 1] == 0) {
                    byte[] byArray = null;
                    return byArray;
                }
                recordChunks.add(content);
                nextPagePointer = OLongSerializer.INSTANCE.deserializeNative(content, content.length - 8);
                contentSize += content.length - 8 - 1;
                firstEntry = false;
            }
            finally {
                this.releasePageFromRead(atomicOperation, cacheEntry);
            }
            pageIndex = OPaginatedClusterV0.getPageIndex(nextPagePointer);
            recordPosition = OPaginatedClusterV0.getRecordPosition(nextPagePointer);
        } while (nextPagePointer >= 0L);
        if (recordChunks.size() == 1) {
            fullContent = (byte[])recordChunks.get(0);
        } else {
            fullContent = new byte[contentSize + 8 + 1];
            int fullContentPosition = 0;
            for (byte[] recordChuck : recordChunks) {
                System.arraycopy(recordChuck, 0, fullContent, fullContentPosition, recordChuck.length - 8 - 1);
                fullContentPosition += recordChuck.length - 8 - 1;
            }
        }
        return fullContent;
    }

    private static long createPagePointer(long pageIndex, int pagePosition) {
        return pageIndex << 16 | (long)pagePosition;
    }

    private static int getRecordPosition(long nextPagePointer) {
        return (int)(nextPagePointer & 0xFFFFL);
    }

    private static long getPageIndex(long nextPagePointer) {
        return nextPagePointer >>> 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddEntryResult addEntry(int recordVersion, byte[] entryContent, OAtomicOperation atomicOperation) throws IOException {
        int recordSizesDiff;
        int finalVersion;
        int position;
        FindFreePageResult findFreePageResult = this.findFreePage(entryContent.length, atomicOperation);
        int freePageIndex = findFreePageResult.freePageIndex;
        long pageIndex = findFreePageResult.pageIndex;
        boolean newRecord = freePageIndex >= FREE_LIST_SIZE;
        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false);
        if (cacheEntry == null) {
            cacheEntry = this.addPage(atomicOperation, this.fileId, false);
        }
        try {
            OClusterPage localPage = new OClusterPage(cacheEntry, newRecord);
            assert (newRecord || freePageIndex == OPaginatedClusterV0.calculateFreePageIndex(localPage));
            int initialFreeSpace = localPage.getFreeSpace();
            position = localPage.appendRecord(recordVersion, entryContent);
            if (position < 0) {
                localPage.dumpToLog();
                throw new IllegalStateException("Page " + cacheEntry.getPageIndex() + " does not have enough free space to add record content, freePageIndex=" + freePageIndex + ", entryContent.length=" + entryContent.length);
            }
            finalVersion = localPage.getRecordVersion(position);
            int freeSpace = localPage.getFreeSpace();
            recordSizesDiff = initialFreeSpace - freeSpace;
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
        this.updateFreePagesIndex(freePageIndex, pageIndex, atomicOperation);
        return new AddEntryResult(pageIndex, position, finalVersion, recordSizesDiff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindFreePageResult findFreePage(int contentSize, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex;
        int freePageIndex;
        while (true) {
            int realFreePageIndex;
            OCacheEntry pinnedStateEntry;
            freePageIndex = contentSize / 1024;
            if ((freePageIndex -= OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger()) < 0) {
                freePageIndex = 0;
            }
            if ((pinnedStateEntry = this.loadPageForRead(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true)) == null) {
                this.loadPageForRead(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true);
            }
            try {
                OPaginatedClusterStateV0 freePageLists = new OPaginatedClusterStateV0(pinnedStateEntry);
                while ((pageIndex = freePageLists.getFreeListPage(freePageIndex)) < 0L && ++freePageIndex < FREE_LIST_SIZE) {
                }
            }
            finally {
                this.releasePageFromRead(atomicOperation, pinnedStateEntry);
            }
            if (pageIndex < 0L) {
                pageIndex = this.getFilledUpTo(atomicOperation, this.fileId);
            } else {
                --freePageIndex;
            }
            if (freePageIndex >= FREE_LIST_SIZE) break;
            OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false);
            if (cacheEntry == null) {
                this.updateFreePagesList(freePageIndex, -1L, atomicOperation);
                continue;
            }
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry, false);
                realFreePageIndex = OPaginatedClusterV0.calculateFreePageIndex(localPage);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
            }
            if (realFreePageIndex == freePageIndex) break;
            OLogManager.instance().warn((Object)this, "Page in file %s with index %d was placed in wrong free list, this error will be fixed automatically", this.getFullName(), pageIndex);
            this.updateFreePagesIndex(freePageIndex, pageIndex, atomicOperation);
        }
        return new FindFreePageResult(pageIndex, freePageIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFreePagesIndex(int prevFreePageIndex, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        block29: {
            OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false);
            try {
                long oldFreePage;
                OClusterPage localPage = new OClusterPage(cacheEntry, false);
                int newFreePageIndex = OPaginatedClusterV0.calculateFreePageIndex(localPage);
                if (prevFreePageIndex == newFreePageIndex) {
                    return;
                }
                long nextPageIndex = localPage.getNextPage();
                long prevPageIndex = localPage.getPrevPage();
                if (prevPageIndex >= 0L) {
                    OCacheEntry prevPageCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, prevPageIndex, false);
                    try {
                        OClusterPage prevPage = new OClusterPage(prevPageCacheEntry, false);
                        assert (OPaginatedClusterV0.calculateFreePageIndex(prevPage) == prevFreePageIndex);
                        prevPage.setNextPage(nextPageIndex);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, prevPageCacheEntry);
                    }
                }
                if (nextPageIndex >= 0L) {
                    OCacheEntry nextPageCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, nextPageIndex, false);
                    try {
                        OClusterPage nextPage = new OClusterPage(nextPageCacheEntry, false);
                        if (OPaginatedClusterV0.calculateFreePageIndex(nextPage) != prevFreePageIndex) {
                            OPaginatedClusterV0.calculateFreePageIndex(nextPage);
                        }
                        assert (OPaginatedClusterV0.calculateFreePageIndex(nextPage) == prevFreePageIndex);
                        nextPage.setPrevPage(prevPageIndex);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, nextPageCacheEntry);
                    }
                }
                localPage.setNextPage(-1L);
                localPage.setPrevPage(-1L);
                if (prevFreePageIndex < 0 && newFreePageIndex < 0) {
                    return;
                }
                if (prevFreePageIndex >= 0 && prevFreePageIndex < FREE_LIST_SIZE && prevPageIndex < 0L) {
                    this.updateFreePagesList(prevFreePageIndex, nextPageIndex, atomicOperation);
                }
                if (newFreePageIndex < 0) break block29;
                OCacheEntry pinnedStateEntry = this.loadPageForRead(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true);
                try {
                    OPaginatedClusterStateV0 clusterFreeList = new OPaginatedClusterStateV0(pinnedStateEntry);
                    oldFreePage = clusterFreeList.getFreeListPage(newFreePageIndex);
                }
                finally {
                    this.releasePageFromRead(atomicOperation, pinnedStateEntry);
                }
                if (oldFreePage >= 0L) {
                    OCacheEntry oldFreePageCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, oldFreePage, false);
                    try {
                        OClusterPage oldFreeLocalPage = new OClusterPage(oldFreePageCacheEntry, false);
                        assert (OPaginatedClusterV0.calculateFreePageIndex(oldFreeLocalPage) == newFreePageIndex);
                        oldFreeLocalPage.setPrevPage(pageIndex);
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, oldFreePageCacheEntry);
                    }
                    localPage.setNextPage(oldFreePage);
                    localPage.setPrevPage(-1L);
                }
                this.updateFreePagesList(newFreePageIndex, pageIndex, atomicOperation);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFreePagesList(int freeListIndex, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = this.loadPageForWrite(atomicOperation, this.fileId, this.pinnedStateEntryIndex, true);
        try {
            OPaginatedClusterStateV0 paginatedClusterState = new OPaginatedClusterStateV0(pinnedStateEntry);
            paginatedClusterState.setFreeListPage(freeListIndex, pageIndex);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, pinnedStateEntry);
        }
    }

    private static int calculateFreePageIndex(OClusterPage localPage) {
        int newFreePageIndex;
        if (localPage.isEmpty()) {
            newFreePageIndex = FREE_LIST_SIZE - 1;
        } else {
            newFreePageIndex = (localPage.getMaxRecordSize() - 1023) / 1024;
            newFreePageIndex -= LOWEST_FREELIST_BOUNDARY;
        }
        return newFreePageIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCusterState(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry pinnedStateEntry = this.addPage(atomicOperation, this.fileId, false);
        try {
            OPaginatedClusterStateV0 paginatedClusterState = new OPaginatedClusterStateV0(pinnedStateEntry);
            this.pinPage(atomicOperation, pinnedStateEntry);
            paginatedClusterState.setSize(0L);
            paginatedClusterState.setRecordsSize(0L);
            for (int i = 0; i < FREE_LIST_SIZE; ++i) {
                paginatedClusterState.setFreeListPage(i, -1L);
            }
            this.pinnedStateEntryIndex = pinnedStateEntry.getPageIndex();
        }
        finally {
            this.releasePageFromWrite(atomicOperation, pinnedStateEntry);
        }
    }

    private static OPhysicalPosition[] convertToPhysicalPositions(long[] clusterPositions) {
        OPhysicalPosition[] positions = new OPhysicalPosition[clusterPositions.length];
        for (int i = 0; i < positions.length; ++i) {
            OPhysicalPosition physicalPosition = new OPhysicalPosition();
            physicalPosition.clusterPosition = clusterPositions[i];
            positions[i] = physicalPosition;
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPaginatedClusterDebug readDebug(long clusterPosition) throws IOException {
        long nextPagePointer;
        OPaginatedClusterDebug debug = new OPaginatedClusterDebug();
        debug.clusterPosition = clusterPosition;
        debug.fileId = this.fileId;
        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
        OClusterPositionMapBucket.PositionEntry positionEntry = this.clusterPositionMap.get(clusterPosition, 1, atomicOperation);
        if (positionEntry == null) {
            debug.empty = true;
            return debug;
        }
        long pageIndex = positionEntry.getPageIndex();
        int recordPosition = positionEntry.getRecordPosition();
        if (this.getFilledUpTo(atomicOperation, this.fileId) <= pageIndex) {
            debug.empty = true;
            return debug;
        }
        debug.pages = new ArrayList<OClusterPageDebug>();
        int contentSize = 0;
        boolean firstEntry = true;
        do {
            OClusterPageDebug debugPage = new OClusterPageDebug();
            debugPage.pageIndex = pageIndex;
            OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                OClusterPage localPage = new OClusterPage(cacheEntry, false);
                if (localPage.isDeleted(recordPosition)) {
                    if (debug.pages.isEmpty()) {
                        debug.empty = true;
                        OPaginatedClusterDebug oPaginatedClusterDebug = debug;
                        return oPaginatedClusterDebug;
                    }
                    throw new OPaginatedClusterException("Content of record " + new ORecordId(this.id, clusterPosition) + " was broken", this);
                }
                debugPage.inPagePosition = recordPosition;
                debugPage.inPageSize = localPage.getRecordSize(recordPosition);
                byte[] content = localPage.getRecordBinaryValue(recordPosition, 0, debugPage.inPageSize);
                debugPage.content = content;
                if (firstEntry && content[content.length - 8 - 1] == 0) {
                    debug.empty = true;
                    OPaginatedClusterDebug oPaginatedClusterDebug = debug;
                    return oPaginatedClusterDebug;
                }
                debug.pages.add(debugPage);
                nextPagePointer = OLongSerializer.INSTANCE.deserializeNative(content, content.length - 8);
                contentSize += content.length - 8 - 1;
                firstEntry = false;
            }
            finally {
                this.releasePageFromRead(atomicOperation, cacheEntry);
            }
            pageIndex = OPaginatedClusterV0.getPageIndex(nextPagePointer);
            recordPosition = OPaginatedClusterV0.getRecordPosition(nextPagePointer);
        } while (nextPagePointer >= 0L);
        debug.contentSize = contentSize;
        return debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPaginatedCluster.RECORD_STATUS getRecordStatus(long clusterPosition) throws IOException {
        OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
        this.acquireSharedLock();
        try {
            byte status = this.clusterPositionMap.getStatus(clusterPosition, atomicOperation);
            switch (status) {
                case 0: {
                    OPaginatedCluster.RECORD_STATUS rECORD_STATUS = OPaginatedCluster.RECORD_STATUS.NOT_EXISTENT;
                    return rECORD_STATUS;
                }
                case 4: {
                    OPaginatedCluster.RECORD_STATUS rECORD_STATUS = OPaginatedCluster.RECORD_STATUS.ALLOCATED;
                    return rECORD_STATUS;
                }
                case 2: {
                    OPaginatedCluster.RECORD_STATUS rECORD_STATUS = OPaginatedCluster.RECORD_STATUS.PRESENT;
                    return rECORD_STATUS;
                }
                case 1: {
                    OPaginatedCluster.RECORD_STATUS rECORD_STATUS = OPaginatedCluster.RECORD_STATUS.REMOVED;
                    return rECORD_STATUS;
                }
            }
            OPaginatedCluster.RECORD_STATUS rECORD_STATUS = null;
            return rECORD_STATUS;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    public String toString() {
        return "plocal cluster: " + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClusterBrowsePage nextPage(long lastPosition) throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block9: {
                OClusterBrowsePage oClusterBrowsePage;
                this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    OClusterPositionMapV0.OClusterPositionEntry[] nextPositions = this.clusterPositionMap.higherPositionsEntries(lastPosition, atomicOperation);
                    if (nextPositions.length <= 0) break block9;
                    long newLastPosition = nextPositions[nextPositions.length - 1].getPosition();
                    ArrayList<OClusterBrowseEntry> nexv = new ArrayList<OClusterBrowseEntry>();
                    for (OClusterPositionMapV0.OClusterPositionEntry pos : nextPositions) {
                        ORawBuffer buff = this.internalReadRecord(pos.getPosition(), pos.getPage(), pos.getOffset(), 1, atomicOperation);
                        nexv.add(new OClusterBrowseEntry(pos.getPosition(), buff));
                    }
                    oClusterBrowsePage = new OClusterBrowsePage(nexv, newLastPosition);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oClusterBrowsePage;
            }
            OClusterBrowsePage oClusterBrowsePage = null;
            this.releaseSharedLock();
            return oClusterBrowsePage;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    private static final class FindFreePageResult {
        private final long pageIndex;
        private final int freePageIndex;

        private FindFreePageResult(long pageIndex, int freePageIndex) {
            this.pageIndex = pageIndex;
            this.freePageIndex = freePageIndex;
        }
    }

    private static final class AddEntryResult {
        private final long pageIndex;
        private final int pagePosition;
        private final int recordVersion;
        private final int recordsSizeDiff;

        AddEntryResult(long pageIndex, int pagePosition, int recordVersion, int recordsSizeDiff) {
            this.pageIndex = pageIndex;
            this.pagePosition = pagePosition;
            this.recordVersion = recordVersion;
            this.recordsSizeDiff = recordsSizeDiff;
        }
    }
}

