/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.cluster.v0.OPaginatedClusterV0;
import com.orientechnologies.orient.core.storage.cluster.v1.OPaginatedClusterV1;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;

public final class OPaginatedClusterFactory {
    public static final OPaginatedClusterFactory INSTANCE = new OPaginatedClusterFactory();

    public static OCluster createCluster(String name, int configurationVersion, int binaryVersion, OAbstractPaginatedStorage storage) {
        if (configurationVersion >= 0 && configurationVersion < 6) {
            throw new OStorageException("You use deprecated version of storage cluster, this version is not supported in current implementation. Please do export/import or recreate database.");
        }
        switch (binaryVersion) {
            case 0: {
                return new OPaginatedClusterV0(name, storage);
            }
            case 1: {
                return new OPaginatedClusterV1(name, storage);
            }
        }
        throw new IllegalStateException("Invalid binary version of cluster " + binaryVersion);
    }
}

