/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.OShortSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;

public class OWALPageChangesPortion
implements OWALChanges {
    private static final int PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    private static final int CHUNK_SIZE = 32;
    private static final int PORTION_SIZE = 32;
    static final int PORTION_BYTES = 1024;
    private byte[][][] pageChunks;
    private final int pageSize;

    public OWALPageChangesPortion() {
        this(PAGE_SIZE);
    }

    OWALPageChangesPortion(int pageSize) {
        this.pageSize = pageSize;
        if (pageSize % 1024 != 0) {
            throw new IllegalArgumentException("Page size should be a multiple of 1024");
        }
    }

    @Override
    public void setLongValue(ByteBuffer pointer, long value, int offset) {
        byte[] data = new byte[8];
        OLongSerializer.INSTANCE.serializeNative(value, data, 0, new Object[0]);
        this.updateData(pointer, offset, data);
    }

    @Override
    public void setIntValue(ByteBuffer pointer, int value, int offset) {
        byte[] data = new byte[4];
        OIntegerSerializer.INSTANCE.serializeNative(value, data, 0, new Object[0]);
        this.updateData(pointer, offset, data);
    }

    void setShortValue(ByteBuffer pointer, short value, int offset) {
        byte[] data = new byte[2];
        OShortSerializer.INSTANCE.serializeNative(value, data, 0, new Object[0]);
        this.updateData(pointer, offset, data);
    }

    @Override
    public void setByteValue(ByteBuffer pointer, byte value, int offset) {
        byte[] data = new byte[]{value};
        this.updateData(pointer, offset, data);
    }

    @Override
    public void setBinaryValue(ByteBuffer pointer, byte[] value, int offset) {
        this.updateData(pointer, offset, value);
    }

    @Override
    public void moveData(ByteBuffer pointer, int from, int to, int len) {
        byte[] buff = new byte[len];
        this.readData(pointer, from, buff);
        this.updateData(pointer, to, buff);
    }

    @Override
    public long getLongValue(ByteBuffer pointer, int offset) {
        byte[] data = new byte[8];
        this.readData(pointer, offset, data);
        return OLongSerializer.INSTANCE.deserializeNative(data, 0);
    }

    @Override
    public int getIntValue(ByteBuffer pointer, int offset) {
        byte[] data = new byte[4];
        this.readData(pointer, offset, data);
        return OIntegerSerializer.INSTANCE.deserializeNative(data, 0);
    }

    @Override
    public short getShortValue(ByteBuffer pointer, int offset) {
        byte[] data = new byte[2];
        this.readData(pointer, offset, data);
        return OShortSerializer.INSTANCE.deserializeNative(data, 0);
    }

    @Override
    public byte getByteValue(ByteBuffer pointer, int offset) {
        byte[] data = new byte[1];
        this.readData(pointer, offset, data);
        return data[0];
    }

    @Override
    public byte[] getBinaryValue(ByteBuffer pointer, int offset, int len) {
        byte[] data = new byte[len];
        this.readData(pointer, offset, data);
        return data;
    }

    @Override
    public void applyChanges(ByteBuffer pointer) {
        if (this.pageChunks == null) {
            return;
        }
        for (int i = 0; i < this.pageChunks.length; ++i) {
            if (this.pageChunks[i] == null) continue;
            for (int j = 0; j < 32; ++j) {
                byte[] chunk = this.pageChunks[i][j];
                if (chunk == null) continue;
                pointer.position(i * 1024 + j * 32);
                pointer.put(chunk, 0, chunk.length);
            }
        }
    }

    @Override
    public int serializedSize() {
        int offset;
        if (this.pageChunks == null) {
            offset = 2;
        } else {
            offset = 2;
            for (byte[][] pageChunk : this.pageChunks) {
                if (pageChunk == null) continue;
                for (int j = 0; j < 32; ++j) {
                    if (pageChunk[j] == null) continue;
                    ++offset;
                    ++offset;
                    offset += 64;
                }
            }
        }
        return offset;
    }

    @Override
    public int toStream(int offset, byte[] stream) {
        if (this.pageChunks == null) {
            OShortSerializer.INSTANCE.serializeNative((short)0, stream, offset, new Object[0]);
            return offset + 2;
        }
        int countPos = offset;
        int count = 0;
        offset += 2;
        for (int i = 0; i < this.pageChunks.length; ++i) {
            if (this.pageChunks[i] == null) continue;
            for (int j = 0; j < 32; ++j) {
                if (this.pageChunks[i][j] == null) continue;
                OByteSerializer.INSTANCE.serializeNative((byte)i, stream, offset, new Object[0]);
                OByteSerializer.INSTANCE.serializeNative((byte)j, stream, ++offset, new Object[0]);
                System.arraycopy(this.pageChunks[i][j], 0, stream, ++offset, 32);
                offset += 32;
                ++count;
            }
        }
        OShortSerializer.INSTANCE.serializeNative((short)count, stream, countPos, new Object[0]);
        return offset;
    }

    @Override
    public void toStream(ByteBuffer buffer) {
        if (this.pageChunks == null) {
            buffer.putShort((short)0);
            return;
        }
        int countPos = buffer.position();
        buffer.position(countPos + 2);
        int count = 0;
        for (int i = 0; i < this.pageChunks.length; ++i) {
            if (this.pageChunks[i] == null) continue;
            for (int j = 0; j < 32; ++j) {
                if (this.pageChunks[i][j] == null) continue;
                buffer.put((byte)i);
                buffer.put((byte)j);
                buffer.put(this.pageChunks[i][j]);
                ++count;
            }
        }
        buffer.putShort(countPos, (short)count);
    }

    @Override
    public int fromStream(int offset, byte[] stream) {
        int chunkLength = OShortSerializer.INSTANCE.deserializeNative(stream, offset);
        offset += 2;
        for (int c = 0; c < chunkLength; ++c) {
            byte i = OByteSerializer.INSTANCE.deserializeNative(stream, offset);
            byte j = OByteSerializer.INSTANCE.deserializeNative(stream, ++offset);
            ++offset;
            if (this.pageChunks == null) {
                this.pageChunks = new byte[(this.pageSize + 1023) / 1024][][];
            }
            if (this.pageChunks[i] == null) {
                this.pageChunks[i] = new byte[32][];
            }
            if (this.pageChunks[i][j] == null) {
                this.pageChunks[i][j] = new byte[32];
            }
            System.arraycopy(stream, offset, this.pageChunks[i][j], 0, 32);
            offset += 32;
        }
        return offset;
    }

    private void readData(ByteBuffer pointer, int offset, byte[] data) {
        if (this.pageChunks == null) {
            if (pointer != null) {
                pointer.position(offset);
                pointer.get(data, 0, data.length);
            }
            return;
        }
        int portionIndex = offset / 1024;
        if (portionIndex == (offset + data.length - 1) / 1024 && this.pageChunks[portionIndex] == null) {
            if (pointer != null) {
                pointer.position(offset);
                pointer.get(data, 0, data.length);
            }
            return;
        }
        int chunkIndex = (offset - portionIndex * 1024) / 32;
        int chunkOffset = offset - (portionIndex * 1024 + chunkIndex * 32);
        int read = 0;
        while (read < data.length) {
            byte[] chunk = null;
            if (this.pageChunks[portionIndex] != null) {
                chunk = this.pageChunks[portionIndex][chunkIndex];
            }
            int rl = Math.min(32 - chunkOffset, data.length - read);
            if (chunk == null) {
                if (pointer != null) {
                    pointer.position(portionIndex * 1024 + chunkIndex * 32 + chunkOffset);
                    pointer.get(data, read, rl);
                }
            } else {
                try {
                    System.arraycopy(chunk, chunkOffset, data, read, rl);
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "System.arraycopy error: chunk.length = " + chunk.length + ", chunkOffset = " + chunkOffset + ", data.length = " + data.length + ", read = " + read + ", rl = " + rl, e, new Object[0]);
                    throw e;
                }
            }
            chunkOffset = 0;
            if (++chunkIndex != 32 || (read += rl) >= data.length) continue;
            ++portionIndex;
            chunkIndex = 0;
        }
    }

    private void updateData(ByteBuffer pointer, int offset, byte[] data) {
        int portionIndex;
        if (this.pageChunks == null) {
            this.pageChunks = new byte[(this.pageSize + 1023) / 1024][][];
        }
        if (this.pageChunks[portionIndex = offset / 1024] == null) {
            this.pageChunks[portionIndex] = new byte[32][];
        }
        int chunkIndex = (offset - portionIndex * 1024) / 32;
        int chunkOffset = offset - (portionIndex * 1024 + chunkIndex * 32);
        int written = 0;
        while (written < data.length) {
            byte[] chunk = this.pageChunks[portionIndex][chunkIndex];
            if (chunk == null) {
                chunk = new byte[32];
                if (pointer != null) {
                    pointer.position(portionIndex * 1024 + chunkIndex * 32);
                    pointer.get(chunk);
                }
                this.pageChunks[portionIndex][chunkIndex] = chunk;
            }
            int wl = Math.min(32 - chunkOffset, data.length - written);
            System.arraycopy(data, written, chunk, chunkOffset, wl);
            chunkOffset = 0;
            if (++chunkIndex != 32 || (written += wl) >= data.length) continue;
            if (this.pageChunks[++portionIndex] == null) {
                this.pageChunks[portionIndex] = new byte[32][];
            }
            chunkIndex = 0;
        }
    }

    @Override
    public boolean hasChanges() {
        return this.pageChunks != null;
    }
}

