/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileDeletedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileTruncatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ONonTxOperationPerformedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OEmptyWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OWriteableWALRecord;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public final class OWALRecordsFactory {
    private final Map<Byte, Class> idToTypeMap = new HashMap<Byte, Class>();
    public static final OWALRecordsFactory INSTANCE = new OWALRecordsFactory();
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    private static final int MIN_COMPRESSED_RECORD_SIZE = 2048;

    public static OPair<ByteBuffer, Long> toStream(OWriteableWALRecord walRecord) {
        int contentSize = walRecord.serializedSize() + 1;
        long pointer = Native.malloc((long)contentSize);
        ByteBuffer content = new Pointer(pointer).getByteBuffer(0L, (long)contentSize);
        byte recordId = walRecord.getId();
        content.put(recordId);
        walRecord.toStream(content);
        if (contentSize < 2048) {
            return new OPair<ByteBuffer, Long>(content, pointer);
        }
        LZ4Compressor compressor = factory.fastCompressor();
        int maxCompressedLength = compressor.maxCompressedLength(contentSize - 1);
        long compressedPointer = Native.malloc((long)(maxCompressedLength + 5));
        ByteBuffer compressedContent = new Pointer(compressedPointer).getByteBuffer(0L, (long)(maxCompressedLength + 5)).order(ByteOrder.nativeOrder());
        content.position(1);
        compressedContent.position(5);
        int compressedLength = compressor.compress(content, 1, contentSize - 1, compressedContent, 5, maxCompressedLength);
        if (compressedLength + 5 < contentSize) {
            if (pointer > 0L) {
                Native.free((long)pointer);
            }
            compressedContent.limit(compressedLength + 5);
            compressedContent.put(0, (byte)(-(recordId + 1)));
            compressedContent.putInt(1, contentSize);
            return new OPair<ByteBuffer, Long>(compressedContent, compressedPointer);
        }
        Native.free((long)compressedPointer);
        return new OPair<ByteBuffer, Long>(content, pointer);
    }

    public OWriteableWALRecord fromStream(byte[] content) {
        OWriteableWALRecord walRecord;
        if (content[0] < 0) {
            int originalLen = OIntegerSerializer.INSTANCE.deserializeNative(content, 1);
            byte[] restored = new byte[originalLen];
            LZ4FastDecompressor decompressor = factory.fastDecompressor();
            decompressor.decompress(content, 5, restored, 1, restored.length - 1);
            restored[0] = (byte)(-content[0] - 1);
            content = restored;
        }
        switch (content[0]) {
            case 0: {
                walRecord = new OUpdatePageRecord();
                break;
            }
            case 1: {
                walRecord = new OFuzzyCheckpointStartRecord();
                break;
            }
            case 2: {
                walRecord = new OFuzzyCheckpointEndRecord();
                break;
            }
            case 4: {
                walRecord = new OFullCheckpointStartRecord();
                break;
            }
            case 5: {
                walRecord = new OCheckpointEndRecord();
                break;
            }
            case 8: {
                walRecord = new OAtomicUnitStartRecord();
                break;
            }
            case 9: {
                walRecord = new OAtomicUnitEndRecord();
                break;
            }
            case 10: {
                walRecord = new OFileCreatedWALRecord();
                break;
            }
            case 11: {
                walRecord = new ONonTxOperationPerformedWALRecord();
                break;
            }
            case 12: {
                walRecord = new OFileDeletedWALRecord();
                break;
            }
            case 13: {
                walRecord = new OFileTruncatedWALRecord();
                break;
            }
            case 14: {
                walRecord = new OEmptyWALRecord();
                break;
            }
            default: {
                if (this.idToTypeMap.containsKey(content[0])) {
                    try {
                        walRecord = (OWriteableWALRecord)this.idToTypeMap.get(content[0]).newInstance();
                        break;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalStateException("Cannot deserialize passed in record", e);
                    }
                }
                throw new IllegalStateException("Cannot deserialize passed in wal record.");
            }
        }
        walRecord.fromStream(content, 1);
        return walRecord;
    }

    public void registerNewRecord(byte id, Class<? extends OWriteableWALRecord> type) {
        this.idToTypeMap.put(id, type);
    }
}

