/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas;

import com.orientechnologies.common.concur.lock.ScalableRWLock;
import com.orientechnologies.common.directmemory.ODirectMemoryAllocator;
import com.orientechnologies.common.directmemory.OPointer;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.jna.ONative;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.thread.OScheduledThreadPoolExecutorWithLogging;
import com.orientechnologies.common.thread.OThreadPoolExecutorWithLogging;
import com.orientechnologies.common.types.OModifiableLong;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.impl.local.OCheckpointRequestListener;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecordsFactory;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OCASWALPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OEmptyWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OMilestoneWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OSegmentOverflowListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OStartWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OWALFile;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.OWriteableWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.deque.Cursor;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.deque.MPSCFAAArrayDequeue;
import com.sun.jna.Platform;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;

public final class OCASDiskWriteAheadLog
implements OWriteAheadLog {
    private static final XXHashFactory xxHashFactory = XXHashFactory.fastestInstance();
    private static final int XX_SEED = -1756908916;
    private static final int MASTER_RECORD_SIZE = 20;
    private static final int BATCH_READ_SIZE = 320;
    private static final OScheduledThreadPoolExecutorWithLogging commitExecutor = new OScheduledThreadPoolExecutorWithLogging(1, r -> {
        Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
        thread.setDaemon(true);
        thread.setName("OrientDB WAL Flush Task");
        thread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
        return thread;
    });
    private static final OThreadPoolExecutorWithLogging writeExecutor = new OThreadPoolExecutorWithLogging(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
        Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
        thread.setDaemon(true);
        thread.setName("OrientDB WAL Write Task Thread)");
        thread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
        return thread;
    });
    private final int bufferSize;
    private final long walSizeHardLimit;
    private final List<OLowDiskSpaceListener> lowDiskSpaceListeners = new CopyOnWriteArrayList<OLowDiskSpaceListener>();
    private final List<OCheckpointRequestListener> fullCheckpointListeners = new CopyOnWriteArrayList<OCheckpointRequestListener>();
    private final List<OSegmentOverflowListener> segmentOverflowListeners = new CopyOnWriteArrayList<OSegmentOverflowListener>();
    private volatile long walSizeLimit;
    private final long segmentsInterval;
    private final long maxSegmentSize;
    private final long freeSpaceLimit;
    private final MPSCFAAArrayDequeue<OWALRecord> records = new MPSCFAAArrayDequeue();
    private volatile long currentSegment;
    private final AtomicLong segmentSize = new AtomicLong();
    private final AtomicLong logSize = new AtomicLong();
    private final AtomicLong queueSize = new AtomicLong();
    private final int maxCacheSize;
    private final AtomicReference<OLogSequenceNumber> end = new AtomicReference();
    private final ConcurrentSkipListSet<Long> segments = new ConcurrentSkipListSet();
    private final FileStore fileStore;
    private final Path walLocation;
    private final String storageName;
    private final ODirectMemoryAllocator allocator = ODirectMemoryAllocator.instance();
    private final int blockSize;
    private final boolean allowDirectIO;
    private final int pageSize;
    private final int maxRecordSize;
    private volatile OWALFile walFile = null;
    private volatile OLogSequenceNumber flushedLSN = null;
    private final AtomicReference<WrittenUpTo> writtenUpTo = new AtomicReference();
    private long segmentId = -1L;
    private volatile ScheduledFuture<?> recordsWriterFuture;
    private final Path masterRecordPath;
    private volatile OLogSequenceNumber lastCheckpoint;
    private volatile boolean useFirstMasterRecord;
    private final FileChannel masterRecordLSNHolder;
    private final ConcurrentNavigableMap<OLogSequenceNumber, Runnable> events = new ConcurrentSkipListMap<OLogSequenceNumber, Runnable>();
    private final ScalableRWLock segmentLock = new ScalableRWLock();
    private final TreeMap<OLogSequenceNumber, Integer> cutTillLimits = new TreeMap();
    private final Lock cuttingLock = new ReentrantLock();
    private final ConcurrentLinkedQueue<OPair<Long, OWALFile>> fileCloseQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger fileCloseQueueSize = new AtomicInteger();
    private final AtomicReference<CountDownLatch> flushLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(0));
    private volatile Future<?> writeFuture = null;
    private OLogSequenceNumber writtenCheckpoint = null;
    private long lastFSyncTs = -1L;
    private final int fsyncInterval;
    private volatile long segmentAdditionTs;
    private final int commitDelay;
    private long currentPosition = 0L;
    private ByteBuffer writeBuffer = null;
    private OPointer writeBufferPointer = null;
    private int writeBufferPageIndex = -1;
    private OLogSequenceNumber lastLSN = null;
    private OLogSequenceNumber checkPointLSN = null;
    private final boolean callFsync;
    private final boolean printPerformanceStatistic;
    private final int statisticPrintInterval;
    private volatile long bytesWrittenSum = 0L;
    private volatile long bytesWrittenTime = 0L;
    private volatile long fsyncTime = 0L;
    private volatile long fsyncCount = 0L;
    private final LongAdder threadsWaitingSum = new LongAdder();
    private final LongAdder threadsWaitingCount = new LongAdder();
    private long reportTs = -1L;
    private volatile boolean stopWrite = false;

    public OCASDiskWriteAheadLog(String storageName, Path storagePath, Path walPath, int maxPagesCacheSize, int bufferSize, long segmentsInterval, long maxSegmentSize, int commitDelay, boolean filterWALFiles, Locale locale, long walSizeHardLimit, long freeSpaceLimit, int fsyncInterval, boolean allowDirectIO, boolean callFsync, boolean printPerformanceStatistic, int statisticPrintInterval) throws IOException {
        this.bufferSize = bufferSize * 1024 * 1024;
        this.segmentsInterval = segmentsInterval;
        this.callFsync = callFsync;
        this.printPerformanceStatistic = printPerformanceStatistic;
        this.statisticPrintInterval = statisticPrintInterval;
        this.fsyncInterval = fsyncInterval;
        this.walSizeHardLimit = walSizeHardLimit;
        this.freeSpaceLimit = freeSpaceLimit;
        this.walSizeLimit = walSizeHardLimit;
        this.walLocation = OCASDiskWriteAheadLog.calculateWalPath(storagePath, walPath);
        if (!Files.exists(this.walLocation, new LinkOption[0])) {
            Files.createDirectories(this.walLocation, new FileAttribute[0]);
        }
        this.fileStore = Files.getFileStore(this.walLocation);
        this.storageName = storageName;
        this.blockSize = allowDirectIO ? OCASDiskWriteAheadLog.calculateBlockSize(this.walLocation.toAbsolutePath().toString()) : -1;
        if (this.blockSize > 0) {
            this.allowDirectIO = true;
            OLogManager.instance().infoNoDb(this, "Direct IO for WAL located in %s is allowed with block size %d bytes.", this.walLocation.toString(), this.blockSize);
        } else {
            this.allowDirectIO = false;
        }
        if (this.allowDirectIO) {
            this.pageSize = this.blockSize;
            this.maxRecordSize = this.pageSize - 18;
        } else {
            this.pageSize = 4096;
            this.maxRecordSize = 4078;
        }
        OLogManager.instance().infoNoDb(this, "Page size for WAL located in %s is set to %d bytes.", this.walLocation.toString(), this.pageSize);
        this.maxCacheSize = maxPagesCacheSize * this.pageSize;
        this.masterRecordPath = this.walLocation.resolve(storageName + ".wmr");
        this.masterRecordLSNHolder = FileChannel.open(this.masterRecordPath, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
        this.readLastCheckpointInfo();
        this.logSize.set(this.initSegmentSet(filterWALFiles, locale));
        long nextSegmentId = this.segments.isEmpty() ? 1L : this.segments.last() + 1L;
        this.currentSegment = nextSegmentId;
        this.maxSegmentSize = maxSegmentSize;
        this.segmentAdditionTs = System.nanoTime();
        OStartWALRecord startRecord = new OStartWALRecord();
        startRecord.setLsn(new OLogSequenceNumber(this.currentSegment, 18L));
        startRecord.setDistance(0);
        startRecord.setDiskSize(18);
        this.records.offer(startRecord);
        this.writtenUpTo.set(new WrittenUpTo(new OLogSequenceNumber(this.currentSegment, 0L), 0L));
        this.log(new OEmptyWALRecord());
        this.commitDelay = commitDelay;
        this.recordsWriterFuture = commitExecutor.schedule(new RecordsWriter(false, false, true), (long)commitDelay, TimeUnit.MILLISECONDS);
        this.flush();
    }

    public int pageSize() {
        return this.pageSize;
    }

    private static int calculateBlockSize(String path) {
        if (!Platform.isLinux()) {
            return -1;
        }
        boolean linuxVersion = false;
        boolean majorRev = true;
        int minorRev = 2;
        ArrayList<Integer> versionNumbers = new ArrayList<Integer>();
        for (String v : System.getProperty("os.version").split("[.\\-]")) {
            if (!v.matches("\\d")) continue;
            versionNumbers.add(Integer.parseInt(v));
        }
        if ((Integer)versionNumbers.get(0) < 2) {
            return -1;
        }
        if ((Integer)versionNumbers.get(0) == 2) {
            if ((Integer)versionNumbers.get(1) < 4) {
                return -1;
            }
            if ((Integer)versionNumbers.get(1) == 4 && (Integer)versionNumbers.get(2) < 10) {
                return -1;
            }
        }
        int _PC_REC_XFER_ALIGN = 17;
        int fsBlockSize = ONative.instance().pathconf(path, 17);
        int pageSize = ONative.instance().getpagesize();
        fsBlockSize = OCASDiskWriteAheadLog.lcm(fsBlockSize, pageSize);
        if ((fsBlockSize = OCASDiskWriteAheadLog.lcm(fsBlockSize, 512L)) <= 0 || (fsBlockSize & fsBlockSize - 1) != 0) {
            return -1;
        }
        return fsBlockSize;
    }

    private static int lcm(long x, long y) {
        long g = x;
        long yc = y;
        while (yc != 0L) {
            long t = g;
            g = yc;
            yc = t % yc;
        }
        return (int)(x * y / g);
    }

    private void readLastCheckpointInfo() throws IOException {
        boolean firstRecord = true;
        OLogSequenceNumber checkPoint = null;
        if (this.masterRecordLSNHolder.size() > 0L) {
            OLogSequenceNumber firstMasterRecord = this.readMasterRecord(0);
            OLogSequenceNumber secondMasterRecord = this.readMasterRecord(1);
            if (firstMasterRecord == null) {
                firstRecord = true;
                checkPoint = secondMasterRecord;
            } else if (secondMasterRecord == null) {
                firstRecord = false;
                checkPoint = firstMasterRecord;
            } else if (firstMasterRecord.compareTo(secondMasterRecord) >= 0) {
                checkPoint = firstMasterRecord;
                firstRecord = false;
            } else {
                checkPoint = secondMasterRecord;
                firstRecord = true;
            }
        }
        this.lastCheckpoint = checkPoint;
        this.useFirstMasterRecord = firstRecord;
    }

    private void updateCheckpoint(OLogSequenceNumber checkPointLSN) throws IOException {
        if (checkPointLSN == null) {
            return;
        }
        if (this.lastCheckpoint == null || this.lastCheckpoint.compareTo(checkPointLSN) < 0) {
            if (this.useFirstMasterRecord) {
                this.writeMasterRecord(0, checkPointLSN);
                this.useFirstMasterRecord = false;
            } else {
                this.writeMasterRecord(1, checkPointLSN);
                this.useFirstMasterRecord = true;
            }
            this.lastCheckpoint = checkPointLSN;
        }
    }

    private void writeMasterRecord(int index, OLogSequenceNumber masterRecord) throws IOException {
        this.masterRecordLSNHolder.position();
        CRC32 crc32 = new CRC32();
        byte[] serializedLSN = new byte[16];
        OLongSerializer.INSTANCE.serializeLiteral(masterRecord.getSegment(), serializedLSN, 0);
        OLongSerializer.INSTANCE.serializeLiteral(masterRecord.getPosition(), serializedLSN, 8);
        crc32.update(serializedLSN);
        ByteBuffer buffer = ByteBuffer.allocate(20);
        buffer.putInt((int)crc32.getValue());
        buffer.putLong(masterRecord.getSegment());
        buffer.putLong(masterRecord.getPosition());
        buffer.rewind();
        OIOUtils.writeByteBuffer(buffer, this.masterRecordLSNHolder, (long)index * 20L);
    }

    private OLogSequenceNumber readMasterRecord(int index) throws IOException {
        long masterPosition = (long)index * 20L;
        if (this.masterRecordLSNHolder.size() < masterPosition + 20L) {
            OLogManager.instance().debugNoDb(this, "Cannot restore %d WAL master record for storage %s", null, index, this.storageName);
            return null;
        }
        CRC32 crc32 = new CRC32();
        try {
            ByteBuffer buffer = ByteBuffer.allocate(20);
            OIOUtils.readByteBuffer(buffer, this.masterRecordLSNHolder, masterPosition, true);
            buffer.rewind();
            int firstCRC = buffer.getInt();
            long segment = buffer.getLong();
            long position = buffer.getLong();
            byte[] serializedLSN = new byte[16];
            OLongSerializer.INSTANCE.serializeLiteral(segment, serializedLSN, 0);
            OLongSerializer.INSTANCE.serializeLiteral(position, serializedLSN, 8);
            crc32.update(serializedLSN);
            if (firstCRC != (int)crc32.getValue()) {
                OLogManager.instance().errorNoDb(this, "Cannot restore %d WAL master record for storage %s crc check is failed", null, index, this.storageName);
                return null;
            }
            return new OLogSequenceNumber(segment, position);
        }
        catch (EOFException eofException) {
            OLogManager.instance().debugNoDb(this, "Cannot restore %d WAL master record for storage %s", eofException, index, this.storageName);
            return null;
        }
    }

    private long initSegmentSet(boolean filterWALFiles, Locale locale) throws IOException {
        OModifiableLong walSize = new OModifiableLong();
        Stream<Path> walFiles = filterWALFiles ? Files.find(this.walLocation, 1, (path, attributes) -> OCASDiskWriteAheadLog.validateName(path.getFileName().toString(), this.storageName, locale), new FileVisitOption[0]) : Files.find(this.walLocation, 1, (path, attrs) -> OCASDiskWriteAheadLog.validateSimpleName(path.getFileName().toString(), locale), new FileVisitOption[0]);
        if (walFiles == null) {
            throw new IllegalStateException("Location passed in WAL does not exist, or IO error was happened. DB cannot work in durable mode in such case");
        }
        walFiles.forEach(path -> {
            this.segments.add(OCASDiskWriteAheadLog.extractSegmentId(path.getFileName().toString()));
            walSize.increment(path.toFile().length());
        });
        return walSize.value;
    }

    private static long extractSegmentId(String name) {
        Matcher matcher = Pattern.compile("^.*\\.(\\d+)\\.wal$").matcher(name);
        boolean matches = matcher.find();
        assert (matches);
        String order = matcher.group(1);
        try {
            return Long.parseLong(order);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean validateName(String name, String storageName, Locale locale) {
        name = name.toLowerCase(locale);
        storageName = storageName.toLowerCase(locale);
        if (!name.endsWith(".wal")) {
            return false;
        }
        int walOrderStartIndex = name.indexOf(46);
        if (walOrderStartIndex == name.length() - 4) {
            return false;
        }
        String walStorageName = name.substring(0, walOrderStartIndex);
        if (!storageName.equals(walStorageName)) {
            return false;
        }
        int walOrderEndIndex = name.indexOf(46, walOrderStartIndex + 1);
        String walOrder = name.substring(walOrderStartIndex + 1, walOrderEndIndex);
        try {
            Integer.parseInt(walOrder);
        }
        catch (NumberFormatException ignore) {
            return false;
        }
        return true;
    }

    private static boolean validateSimpleName(String name, Locale locale) {
        if (!(name = name.toLowerCase(locale)).endsWith(".wal")) {
            return false;
        }
        int walOrderStartIndex = name.indexOf(46);
        if (walOrderStartIndex == name.length() - 4) {
            return false;
        }
        int walOrderEndIndex = name.indexOf(46, walOrderStartIndex + 1);
        String walOrder = name.substring(walOrderStartIndex + 1, walOrderEndIndex);
        try {
            Integer.parseInt(walOrder);
        }
        catch (NumberFormatException ignore) {
            return false;
        }
        return true;
    }

    private static Path calculateWalPath(Path storagePath, Path walPath) {
        if (walPath == null) {
            return storagePath;
        }
        return walPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OWriteableWALRecord> read(OLogSequenceNumber lsn, int limit) throws IOException {
        this.addCutTillLimit(lsn);
        try {
            OLogSequenceNumber begin = this.begin();
            OLogSequenceNumber endLSN = this.end.get();
            if (begin.compareTo(lsn) > 0) {
                List<OWriteableWALRecord> list = Collections.emptyList();
                return list;
            }
            if (lsn.compareTo(endLSN) > 0) {
                List<OWriteableWALRecord> list = Collections.emptyList();
                return list;
            }
            Cursor<OWALRecord> recordCursor = this.records.peekFirst();
            assert (recordCursor != null);
            OWALRecord record = recordCursor.getItem();
            OLogSequenceNumber logRecordLSN = record.getLsn();
            while (logRecordLSN.getPosition() > 0L && logRecordLSN.compareTo(lsn) <= 0) {
                block21: {
                    do {
                        int compare;
                        if ((compare = logRecordLSN.compareTo(lsn)) == 0 && record instanceof OWriteableWALRecord) {
                            List<OWriteableWALRecord> list = Collections.singletonList((OWriteableWALRecord)record);
                            return list;
                        }
                        if (compare > 0) {
                            List<OWriteableWALRecord> list = Collections.emptyList();
                            return list;
                        }
                        if ((recordCursor = MPSCFAAArrayDequeue.next(recordCursor)) == null) break block21;
                    } while ((logRecordLSN = (record = recordCursor.getItem()).getLsn()).getPosition() >= 0L);
                    List<OWriteableWALRecord> list = Collections.emptyList();
                    return list;
                }
                recordCursor = this.records.peekFirst();
                assert (recordCursor != null);
                record = recordCursor.getItem();
                logRecordLSN = record.getLsn();
            }
            OLogSequenceNumber writtenLSN = this.writtenUpTo.get().lsn;
            while (writtenLSN == null || writtenLSN.compareTo(lsn) < 0) {
                try {
                    this.flushLatch.get().await();
                }
                catch (InterruptedException e) {
                    OLogManager.instance().errorNoDb(this, "WAL write was interrupted", e, new Object[0]);
                }
                writtenLSN = this.writtenUpTo.get().lsn;
                assert (writtenLSN != null);
                if (writtenLSN.compareTo(lsn) < 0) {
                    this.doFlush(false);
                    this.waitTillWriteWillBeFinished();
                }
                writtenLSN = this.writtenUpTo.get().lsn;
            }
            List<OWriteableWALRecord> list = this.readFromDisk(lsn, limit);
            return list;
        }
        finally {
            this.removeCutTillLimit(lsn);
        }
    }

    private void waitTillWriteWillBeFinished() {
        Future<?> wf = this.writeFuture;
        if (wf != null) {
            try {
                wf.get();
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OStorageException("WAL write for storage " + this.storageName + " was interrupted"), e);
            }
            catch (ExecutionException e) {
                throw OException.wrapException(new OStorageException("Error during WAL write for storage " + this.storageName), e);
            }
        }
    }

    OLogSequenceNumber lastCheckpoint() {
        return this.lastCheckpoint;
    }

    long segSize() {
        return this.segmentSize.get();
    }

    long size() {
        return this.logSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<OWriteableWALRecord> readFromDisk(OLogSequenceNumber lsn, int limit) throws IOException {
        ArrayList<OWriteableWALRecord> result = new ArrayList<OWriteableWALRecord>();
        long position = lsn.getPosition();
        long pageIndex = position / (long)this.pageSize;
        long segment = lsn.getSegment();
        int pagesRead = 0;
        SortedSet segs = this.segments.tailSet((Object)segment);
        if (segs.isEmpty()) return Collections.emptyList();
        if ((Long)segs.first() > segment) {
            return Collections.emptyList();
        }
        Iterator segmentsIterator = segs.iterator();
        if (pagesRead >= 320) return result;
        if (!segmentsIterator.hasNext()) return result;
        byte[] recordContent = null;
        int recordLen = -1;
        byte[] recordLenBytes = null;
        int recordLenRead = -1;
        int bytesRead = 0;
        long lsnPos = -1L;
        segment = (Long)segmentsIterator.next();
        String segmentName = this.getSegmentName(segment);
        Path segmentPath = this.walLocation.resolve(segmentName);
        if (!Files.exists(segmentPath, new LinkOption[0])) return result;
        try (OWALFile file = OWALFile.createReadWALFile(segmentPath, this.allowDirectIO, this.blockSize);){
            long chSize = Files.size(segmentPath);
            WrittenUpTo written = this.writtenUpTo.get();
            if (segment == written.lsn.getSegment()) {
                chSize = Math.min(chSize, written.position);
            }
            while (pageIndex * (long)this.pageSize < chSize) {
                file.position(pageIndex * (long)this.pageSize);
                OPointer ptr = this.allocator.allocate(this.pageSize, this.blockSize);
                try {
                    ByteBuffer buffer = ptr.getNativeByteBuffer().order(ByteOrder.nativeOrder());
                    file.readBuffer(buffer);
                    ++pagesRead;
                    if (OCASDiskWriteAheadLog.pageIsBroken(buffer, this.pageSize)) {
                        OLogManager.instance().errorNoDb(this, "WAL page %d of segment %s is broken, read of records will be stopped", null, pageIndex, segmentName);
                        ArrayList<OWriteableWALRecord> arrayList = result;
                        return arrayList;
                    }
                    buffer.position((int)(position - pageIndex * (long)this.pageSize));
                    while (buffer.remaining() > 0) {
                        if (recordLen == -1) {
                            block36: {
                                if (recordLenBytes == null) {
                                    lsnPos = pageIndex * (long)this.pageSize + (long)buffer.position();
                                    if (buffer.remaining() >= 4) {
                                        recordLen = buffer.getInt();
                                        break block36;
                                    } else {
                                        recordLenBytes = new byte[4];
                                        recordLenRead = buffer.remaining();
                                        buffer.get(recordLenBytes, 0, recordLenRead);
                                        continue;
                                    }
                                }
                                if (recordLenRead < 4) {
                                    buffer.get(recordLenBytes, recordLenRead, 4 - recordLenRead);
                                }
                                recordLen = OIntegerSerializer.INSTANCE.deserializeNative(recordLenBytes, 0);
                            }
                            if (recordLen == 0) {
                                recordLen = -1;
                                recordLenBytes = null;
                                recordLenRead = -1;
                                break;
                            }
                            recordContent = new byte[recordLen];
                        }
                        int bytesToRead = Math.min(recordLen - bytesRead, buffer.remaining());
                        buffer.get(recordContent, bytesRead, bytesToRead);
                        if ((bytesRead += bytesToRead) != recordLen) continue;
                        OWriteableWALRecord walRecord = OWALRecordsFactory.INSTANCE.fromStream(recordContent);
                        walRecord.setLsn(new OLogSequenceNumber(segment, lsnPos));
                        recordContent = null;
                        bytesRead = 0;
                        recordLen = -1;
                        recordLenBytes = null;
                        recordLenRead = -1;
                        result.add(walRecord);
                        if (result.size() != limit) continue;
                        ArrayList<OWriteableWALRecord> arrayList = result;
                        return arrayList;
                    }
                }
                finally {
                    this.allocator.deallocate(ptr);
                }
                position = ++pageIndex * (long)this.pageSize + 18L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OWriteableWALRecord> next(OLogSequenceNumber lsn, int limit) throws IOException {
        this.addCutTillLimit(lsn);
        try {
            OLogSequenceNumber begin = this.begin();
            if (begin.compareTo(lsn) > 0) {
                List<OWriteableWALRecord> list = Collections.emptyList();
                return list;
            }
            OLogSequenceNumber end = this.end.get();
            if (lsn.compareTo(end) >= 0) {
                List<OWriteableWALRecord> list = Collections.emptyList();
                return list;
            }
            Cursor<OWALRecord> recordCursor = this.records.peekFirst();
            assert (recordCursor != null);
            OWALRecord logRecord = recordCursor.getItem();
            OLogSequenceNumber logRecordLSN = logRecord.getLsn();
            block9: while (logRecordLSN.getPosition() >= 0L && logRecordLSN.compareTo(lsn) <= 0) {
                block25: {
                    block26: {
                        while (true) {
                            int compare;
                            if ((compare = logRecordLSN.compareTo(lsn)) == 0) {
                                recordCursor = MPSCFAAArrayDequeue.next(recordCursor);
                                while (recordCursor != null) {
                                    OWALRecord nextRecord = recordCursor.getItem();
                                    if (nextRecord instanceof OWriteableWALRecord) {
                                        OLogSequenceNumber nextLSN = nextRecord.getLsn();
                                        if (nextLSN.getPosition() < 0L) {
                                            List<OWriteableWALRecord> list = Collections.emptyList();
                                            return list;
                                        }
                                        if (nextLSN.compareTo(lsn) > 0) {
                                            List<OWriteableWALRecord> list = Collections.singletonList((OWriteableWALRecord)nextRecord);
                                            return list;
                                        }
                                        assert (nextLSN.compareTo(lsn) == 0);
                                    }
                                    recordCursor = MPSCFAAArrayDequeue.next(recordCursor);
                                }
                                recordCursor = this.records.peekFirst();
                                assert (recordCursor != null);
                                logRecord = recordCursor.getItem();
                                logRecordLSN = logRecord.getLsn();
                                continue block9;
                            }
                            if (compare >= 0) break block25;
                            if ((recordCursor = MPSCFAAArrayDequeue.next(recordCursor)) == null) break block26;
                            logRecord = recordCursor.getItem();
                            logRecordLSN = logRecord.getLsn();
                            assert (logRecordLSN.getPosition() >= 0L);
                        }
                    }
                    recordCursor = this.records.peekFirst();
                    assert (recordCursor != null);
                    logRecord = recordCursor.getItem();
                    logRecordLSN = logRecord.getLsn();
                    continue;
                }
                throw new IllegalArgumentException("Invalid LSN was passed " + lsn);
            }
            OLogSequenceNumber writtenLSN = this.writtenUpTo.get().lsn;
            while (writtenLSN == null || writtenLSN.compareTo(lsn) <= 0) {
                try {
                    this.flushLatch.get().await();
                }
                catch (InterruptedException e) {
                    OLogManager.instance().errorNoDb(this, "WAL write was interrupted", e, new Object[0]);
                }
                writtenLSN = this.writtenUpTo.get().lsn;
                assert (writtenLSN != null);
                if (writtenLSN.compareTo(lsn) <= 0) {
                    this.doFlush(false);
                    this.waitTillWriteWillBeFinished();
                }
                writtenLSN = this.writtenUpTo.get().lsn;
            }
            List<OWriteableWALRecord> result = limit <= 0 ? this.readFromDisk(lsn, 0) : this.readFromDisk(lsn, limit + 1);
            List<OWriteableWALRecord> list = result.subList(1, result.size());
            return list;
        }
        finally {
            this.removeCutTillLimit(lsn);
        }
    }

    @Override
    public void addEventAt(OLogSequenceNumber lsn, Runnable event) {
        OLogSequenceNumber localFlushedLsn = this.flushedLSN;
        if (localFlushedLsn != null && lsn.compareTo(localFlushedLsn) <= 0) {
            event.run();
        } else {
            this.events.put(lsn, event);
            OLogSequenceNumber potentiallyUpdatedLocalFlushedLsn = this.flushedLSN;
            if (potentiallyUpdatedLocalFlushedLsn != null && lsn.compareTo(potentiallyUpdatedLocalFlushedLsn) <= 0) {
                commitExecutor.execute(() -> this.fireEventsFor(potentiallyUpdatedLocalFlushedLsn));
            }
        }
    }

    @Override
    public void delete() throws IOException {
        ArrayList<Long> segmentsToDelete = new ArrayList<Long>(this.segments.size());
        segmentsToDelete.addAll(this.segments);
        this.close(false);
        Files.deleteIfExists(this.masterRecordPath);
        Iterator iterator = segmentsToDelete.iterator();
        while (iterator.hasNext()) {
            long segment = (Long)iterator.next();
            String segmentName = this.getSegmentName(segment);
            Path segmentPath = this.walLocation.resolve(segmentName);
            Files.deleteIfExists(segmentPath);
        }
    }

    private static boolean pageIsBroken(ByteBuffer buffer, int walPageSize) {
        buffer.position(8);
        if (buffer.getLong() != 4013014191L) {
            return true;
        }
        short pageSize = buffer.getShort(16);
        if (pageSize == 0 || pageSize > walPageSize) {
            return true;
        }
        buffer.limit(pageSize);
        buffer.position(18);
        XXHash64 hash64 = xxHashFactory.hash64();
        long hash = hash64.hash(buffer, -1756908916L);
        buffer.position(0);
        return hash != buffer.getLong();
    }

    @Override
    public void addCutTillLimit(OLogSequenceNumber lsn) {
        if (lsn == null) {
            throw new NullPointerException();
        }
        this.cuttingLock.lock();
        try {
            this.cutTillLimits.merge(lsn, 1, (a, b) -> a + b);
        }
        finally {
            this.cuttingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCutTillLimit(OLogSequenceNumber lsn) {
        if (lsn == null) {
            throw new NullPointerException();
        }
        this.cuttingLock.lock();
        try {
            Integer oldCounter = this.cutTillLimits.get(lsn);
            if (oldCounter == null) {
                throw new IllegalArgumentException(String.format("Limit %s is going to be removed but it was not added", lsn));
            }
            Integer newCounter = oldCounter - 1;
            if (newCounter == 0) {
                this.cutTillLimits.remove(lsn);
            } else {
                this.cutTillLimits.put(lsn, newCounter);
            }
        }
        finally {
            this.cuttingLock.unlock();
        }
    }

    @Override
    public OLogSequenceNumber logAtomicOperationStartRecord(boolean isRollbackSupported, OOperationUnitId unitId) {
        OAtomicUnitStartRecord record = new OAtomicUnitStartRecord(isRollbackSupported, unitId);
        return this.log(record);
    }

    @Override
    public OLogSequenceNumber logAtomicOperationEndRecord(OOperationUnitId operationUnitId, boolean rollback, OLogSequenceNumber startLsn, Map<String, OAtomicOperationMetadata<?>> atomicOperationMetadata) {
        OAtomicUnitEndRecord record = new OAtomicUnitEndRecord(operationUnitId, rollback, atomicOperationMetadata);
        return this.log(record);
    }

    @Override
    public OLogSequenceNumber logFuzzyCheckPointStart(OLogSequenceNumber flushedLsn) {
        OFuzzyCheckpointStartRecord record = new OFuzzyCheckpointStartRecord(this.lastCheckpoint, flushedLsn);
        this.log(record);
        return record.getLsn();
    }

    @Override
    public OLogSequenceNumber logFuzzyCheckPointEnd() {
        OFuzzyCheckpointEndRecord record = new OFuzzyCheckpointEndRecord();
        this.log(record);
        return record.getLsn();
    }

    @Override
    public OLogSequenceNumber logFullCheckpointStart() {
        return this.log(new OFullCheckpointStartRecord(this.lastCheckpoint));
    }

    @Override
    public OLogSequenceNumber logFullCheckpointEnd() {
        return this.log(new OCheckpointEndRecord());
    }

    @Override
    public OLogSequenceNumber getLastCheckpoint() {
        return this.lastCheckpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLogSequenceNumber log(OWriteableWALRecord writeableRecord) {
        long size;
        long segSize;
        OLogSequenceNumber recordLSN;
        long logSegment;
        this.segmentLock.sharedLock();
        try {
            logSegment = this.currentSegment;
            recordLSN = this.doLogRecord(writeableRecord);
            int diskSize = writeableRecord.getDiskSize();
            segSize = this.segmentSize.addAndGet(diskSize);
            size = this.logSize.addAndGet(diskSize);
            if (segSize == (long)diskSize) {
                this.segments.add(this.currentSegment);
            }
        }
        finally {
            this.segmentLock.sharedUnlock();
        }
        long qsize = this.queueSize.addAndGet(writeableRecord.getDiskSize());
        if (qsize >= (long)this.maxCacheSize) {
            long endTs;
            this.threadsWaitingCount.increment();
            try {
                long startTs = 0L;
                if (this.printPerformanceStatistic) {
                    startTs = System.nanoTime();
                }
                this.flushLatch.get().await();
                if (this.printPerformanceStatistic) {
                    endTs = System.nanoTime();
                    this.threadsWaitingSum.add(endTs - startTs);
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().errorNoDb(this, "WAL write was interrupted", e, new Object[0]);
            }
            qsize = this.queueSize.get();
            if (qsize >= (long)this.maxCacheSize) {
                long startTs = 0L;
                if (this.printPerformanceStatistic) {
                    startTs = System.nanoTime();
                }
                this.doFlush(false);
                if (this.printPerformanceStatistic) {
                    endTs = System.nanoTime();
                    this.threadsWaitingSum.add(endTs - startTs);
                }
            }
        }
        if (this.walSizeLimit > -1L && size > this.walSizeLimit && this.segments.size() > 1) {
            for (OCheckpointRequestListener oCheckpointRequestListener : this.fullCheckpointListeners) {
                oCheckpointRequestListener.requestCheckpoint();
            }
        }
        if (segSize > this.maxSegmentSize) {
            for (OSegmentOverflowListener oSegmentOverflowListener : this.segmentOverflowListeners) {
                oSegmentOverflowListener.onSegmentOverflow(logSegment);
            }
        }
        return recordLSN;
    }

    @Override
    public OLogSequenceNumber begin() {
        long first = this.segments.first();
        return new OLogSequenceNumber(first, 18L);
    }

    @Override
    public OLogSequenceNumber begin(long segmentId) {
        if (this.segments.contains(segmentId)) {
            return new OLogSequenceNumber(segmentId, 18L);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cutAllSegmentsSmallerThan(long segmentId) throws IOException {
        this.cuttingLock.lock();
        try {
            block15: {
                OLogSequenceNumber written;
                Map.Entry<OLogSequenceNumber, Integer> firsEntry;
                this.segmentLock.sharedLock();
                if (segmentId > this.currentSegment) {
                    segmentId = this.currentSegment;
                }
                if ((firsEntry = this.cutTillLimits.firstEntry()) != null && segmentId > firsEntry.getKey().getSegment()) {
                    segmentId = firsEntry.getKey().getSegment();
                }
                if (segmentId > (written = this.writtenUpTo.get().lsn).getSegment()) {
                    segmentId = written.getSegment();
                }
                if (segmentId > this.segments.first()) break block15;
                boolean bl = false;
                this.segmentLock.sharedUnlock();
                return bl;
            }
            try {
                long segment;
                OPair<Long, OWALFile> pair = this.fileCloseQueue.poll();
                while (pair != null) {
                    OWALFile file = (OWALFile)pair.value;
                    this.fileCloseQueueSize.decrementAndGet();
                    if ((Long)pair.key >= segmentId) {
                        if (this.callFsync) {
                            file.force(true);
                        }
                        file.close();
                        break;
                    }
                    file.close();
                    pair = this.fileCloseQueue.poll();
                }
                boolean removed = false;
                Iterator<Long> segmentIterator = this.segments.iterator();
                while (segmentIterator.hasNext() && (segment = segmentIterator.next().longValue()) < segmentId) {
                    segmentIterator.remove();
                    String segmentName = this.getSegmentName(segment);
                    Path segmentPath = this.walLocation.resolve(segmentName);
                    if (!Files.exists(segmentPath, new LinkOption[0])) continue;
                    long length = Files.size(segmentPath);
                    Files.delete(segmentPath);
                    this.logSize.addAndGet(-length);
                    removed = true;
                }
                boolean bl = removed;
                this.segmentLock.sharedUnlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.segmentLock.sharedUnlock();
                throw throwable;
            }
        }
        finally {
            this.cuttingLock.unlock();
        }
    }

    @Override
    public boolean cutTill(OLogSequenceNumber lsn) throws IOException {
        long segmentId = lsn.getSegment();
        return this.cutAllSegmentsSmallerThan(segmentId);
    }

    @Override
    public long activeSegment() {
        return this.currentSegment;
    }

    @Override
    public boolean appendNewSegment() {
        this.segmentLock.exclusiveLock();
        try {
            ++this.currentSegment;
            this.segmentSize.set(0L);
            this.logMilestoneRecord();
            this.segmentAdditionTs = System.nanoTime();
        }
        finally {
            this.segmentLock.exclusiveUnlock();
        }
        return true;
    }

    public void appendSegment(long segmentIndex) {
        if (segmentIndex <= this.currentSegment) {
            return;
        }
        this.segmentLock.exclusiveLock();
        try {
            if (segmentIndex <= this.currentSegment) {
                return;
            }
            this.currentSegment = segmentIndex;
            this.segmentSize.set(0L);
            this.logMilestoneRecord();
            this.segmentAdditionTs = System.nanoTime();
        }
        finally {
            this.segmentLock.exclusiveUnlock();
        }
    }

    public List<String> getWalFiles() {
        ArrayList<String> result = new ArrayList<String>();
        for (long segment : this.segments) {
            String segmentName = this.getSegmentName(segment);
            Path segmentPath = this.walLocation.resolve(segmentName);
            if (!Files.exists(segmentPath, new LinkOption[0])) continue;
            result.add(segmentPath.toAbsolutePath().toString());
        }
        return result;
    }

    public Path getWMRFile() {
        return this.masterRecordPath;
    }

    @Override
    public void moveLsnAfter(OLogSequenceNumber lsn) {
        long segment = lsn.getSegment() + 1L;
        this.appendSegment(segment);
    }

    @Override
    public long[] nonActiveSegments() {
        long segment;
        OLogSequenceNumber writtenUpTo = this.writtenUpTo.get().lsn;
        long maxSegment = this.currentSegment;
        if (writtenUpTo.getSegment() < maxSegment) {
            maxSegment = writtenUpTo.getSegment();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        Iterator<Long> iterator = this.segments.iterator();
        while (iterator.hasNext() && (segment = iterator.next().longValue()) < maxSegment) {
            result.add(segment);
        }
        long[] segs = new long[result.size()];
        for (int i = 0; i < segs.length; ++i) {
            segs[i] = (Long)result.get(i);
        }
        return segs;
    }

    @Override
    public File[] nonActiveSegments(long fromSegment) {
        long segment;
        OLogSequenceNumber writtenUpTo = this.writtenUpTo.get().lsn;
        long maxSegment = this.currentSegment;
        if (writtenUpTo.getSegment() < maxSegment) {
            maxSegment = writtenUpTo.getSegment();
        }
        ArrayList<File> result = new ArrayList<File>();
        Iterator iterator = this.segments.tailSet((Object)fromSegment).iterator();
        while (iterator.hasNext() && (segment = ((Long)iterator.next()).longValue()) < maxSegment) {
            String segmentName = this.getSegmentName(segment);
            Path segmentPath = this.walLocation.resolve(segmentName);
            File segFile = segmentPath.toFile();
            if (!segFile.exists()) continue;
            result.add(segFile);
        }
        return result.toArray(new File[0]);
    }

    private OLogSequenceNumber doLogRecord(OWriteableWALRecord writeableRecord) {
        if (writeableRecord.getBinaryContentLen() < 0) {
            OPair<ByteBuffer, Long> serializedRecord = OWALRecordsFactory.toStream(writeableRecord);
            writeableRecord.setBinaryContent((ByteBuffer)serializedRecord.key, (Long)serializedRecord.value);
        }
        writeableRecord.setLsn(new OLogSequenceNumber(this.currentSegment, -1L));
        this.records.offer(writeableRecord);
        this.calculateRecordsLSNs();
        OLogSequenceNumber recordLSN = writeableRecord.getLsn();
        OLogSequenceNumber endLsn = this.end.get();
        while (!(endLsn != null && recordLSN.compareTo(endLsn) <= 0 || this.end.compareAndSet(endLsn, recordLSN))) {
            endLsn = this.end.get();
        }
        return recordLSN;
    }

    @Override
    public void flush() {
        this.doFlush(true);
        this.waitTillWriteWillBeFinished();
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    public void close(boolean flush) throws IOException {
        if (flush) {
            this.doFlush(true);
        }
        this.stopWrite = true;
        if (this.recordsWriterFuture != null) {
            try {
                this.recordsWriterFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw OException.wrapException(new OStorageException("Error during writing of WAL records in storage " + this.storageName), e);
            }
        }
        if (this.writeFuture != null) {
            try {
                this.writeFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw OException.wrapException(new OStorageException("Error during writing of WAL records in storage " + this.storageName), e);
            }
        }
        OWALRecord record = this.records.poll();
        while (record != null) {
            if (record instanceof OWriteableWALRecord) {
                ((OWriteableWALRecord)record).freeBinaryContent();
            }
            record = this.records.poll();
        }
        try {
            if (this.writeFuture != null) {
                this.writeFuture.get();
            }
        }
        catch (InterruptedException e) {
            OLogManager.instance().errorNoDb(this, "WAL write was interrupted", e, new Object[0]);
        }
        catch (ExecutionException e) {
            OLogManager.instance().errorNoDb(this, "Error during writint of WAL data", e, new Object[0]);
            throw OException.wrapException(new OStorageException("Error during writint of WAL data"), e);
        }
        for (OPair<Long, OWALFile> pair : this.fileCloseQueue) {
            OWALFile file = (OWALFile)pair.value;
            if (this.callFsync) {
                file.force(true);
            }
            file.close();
        }
        this.fileCloseQueueSize.set(0);
        if (this.callFsync) {
            this.walFile.force(true);
        }
        this.walFile.close();
        this.masterRecordLSNHolder.close();
        this.segments.clear();
        this.fileCloseQueue.clear();
        if (this.writeBufferPointer != null) {
            this.allocator.deallocate(this.writeBufferPointer);
            this.writeBuffer = null;
            this.writeBufferPageIndex = -1;
        }
    }

    private void checkFreeSpace() throws IOException {
        long freeSpace = this.fileStore.getUsableSpace();
        if (freeSpace < 0L) {
            return;
        }
        if (this.walSizeHardLimit < 0L && freeSpace > this.freeSpaceLimit) {
            this.walSizeLimit = (this.logSize.get() + freeSpace) / 2L;
        }
        if (freeSpace < this.freeSpaceLimit) {
            for (OLowDiskSpaceListener listener : this.lowDiskSpaceListeners) {
                listener.lowDiskSpace(new OLowDiskSpaceInformation(freeSpace, this.freeSpaceLimit));
            }
        }
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.lowDiskSpaceListeners.add(listener);
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        ArrayList<OLowDiskSpaceListener> itemsToRemove = new ArrayList<OLowDiskSpaceListener>();
        for (OLowDiskSpaceListener lowDiskSpaceListener : this.lowDiskSpaceListeners) {
            if (!lowDiskSpaceListener.equals(listener)) continue;
            itemsToRemove.add(lowDiskSpaceListener);
        }
        this.lowDiskSpaceListeners.removeAll(itemsToRemove);
    }

    @Override
    public void addFullCheckpointListener(OCheckpointRequestListener listener) {
        this.fullCheckpointListeners.add(listener);
    }

    @Override
    public void removeFullCheckpointListener(OCheckpointRequestListener listener) {
        ArrayList<OCheckpointRequestListener> itemsToRemove = new ArrayList<OCheckpointRequestListener>();
        for (OCheckpointRequestListener fullCheckpointRequestListener : this.fullCheckpointListeners) {
            if (!fullCheckpointRequestListener.equals(listener)) continue;
            itemsToRemove.add(fullCheckpointRequestListener);
        }
        this.fullCheckpointListeners.removeAll(itemsToRemove);
    }

    public void addSegmentOverflowListener(OSegmentOverflowListener listener) {
        this.segmentOverflowListeners.add(listener);
    }

    private void doFlush(boolean forceSync) {
        Future<?> future = commitExecutor.submit(new RecordsWriter(forceSync, true, false));
        try {
            future.get();
        }
        catch (Exception e) {
            OLogManager.instance().errorNoDb(this, "Exception during WAL flush", e, new Object[0]);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public OLogSequenceNumber getFlushedLsn() {
        return this.flushedLSN;
    }

    private void calculateRecordsLSNs() {
        ArrayList<OWALRecord> unassignedList = new ArrayList<OWALRecord>();
        Cursor<OWALRecord> cursor = this.records.peekLast();
        while (cursor != null) {
            OWALRecord record = cursor.getItem();
            OLogSequenceNumber lsn = record.getLsn();
            if (lsn.getPosition() != -1L) {
                unassignedList.add(record);
                break;
            }
            unassignedList.add(record);
            Cursor<OWALRecord> nextCursor = MPSCFAAArrayDequeue.prev(cursor);
            if (nextCursor == null && record.getLsn().getPosition() < 0L) {
                System.out.println(cursor.toString());
                throw new IllegalStateException("Invalid last record");
            }
            cursor = nextCursor;
        }
        if (!unassignedList.isEmpty()) {
            ListIterator unassignedRecordsIterator = unassignedList.listIterator(unassignedList.size());
            OWALRecord prevRecord = (OWALRecord)unassignedRecordsIterator.previous();
            OLogSequenceNumber prevLSN = prevRecord.getLsn();
            assert (prevLSN.getPosition() >= 0L);
            while (unassignedRecordsIterator.hasPrevious()) {
                OWALRecord record = (OWALRecord)unassignedRecordsIterator.previous();
                OLogSequenceNumber lsn = record.getLsn();
                if (lsn.getPosition() < 0L) {
                    long position = OCASDiskWriteAheadLog.calculatePosition(record, prevRecord, this.pageSize, this.maxRecordSize);
                    OLogSequenceNumber newLSN = new OLogSequenceNumber(lsn.getSegment(), position);
                    if (record.getLsn().getPosition() < 0L) {
                        record.setLsn(newLSN);
                    }
                }
                prevRecord = record;
            }
        }
    }

    private OMilestoneWALRecord logMilestoneRecord() {
        OMilestoneWALRecord milestoneRecord = new OMilestoneWALRecord();
        milestoneRecord.setLsn(new OLogSequenceNumber(this.currentSegment, -1L));
        this.records.offer(milestoneRecord);
        this.calculateRecordsLSNs();
        return milestoneRecord;
    }

    @Override
    public OLogSequenceNumber end() {
        return this.end.get();
    }

    private static long calculatePosition(OWALRecord record, OWALRecord prevRecord, int pageSize, int maxRecordSize) {
        assert (prevRecord.getLsn().getSegment() <= record.getLsn().getSegment()) : "prev segment " + prevRecord.getLsn().getSegment() + " segment " + record.getLsn().getSegment();
        if (prevRecord instanceof OStartWALRecord) {
            assert (prevRecord.getLsn().getSegment() == record.getLsn().getSegment());
            if (record instanceof OMilestoneWALRecord) {
                record.setDistance(0);
                record.setDiskSize(prevRecord.getDiskSize());
            } else {
                int recordLength = ((OWriteableWALRecord)record).getBinaryContentLen();
                int length = OCASWALPage.calculateSerializedSize(recordLength);
                int pages = length / maxRecordSize;
                int offset = length - pages * maxRecordSize;
                int distance = pages == 0 ? length : (pages - 1) * pageSize + offset + maxRecordSize + 18;
                record.setDistance(distance);
                record.setDiskSize(distance + prevRecord.getDiskSize());
            }
            return prevRecord.getLsn().getPosition();
        }
        if (prevRecord instanceof OMilestoneWALRecord) {
            if (record instanceof OMilestoneWALRecord) {
                record.setDistance(0);
                if (prevRecord.getLsn().getSegment() == record.getLsn().getSegment()) {
                    record.setDiskSize(prevRecord.getDiskSize());
                    return prevRecord.getLsn().getPosition();
                }
                record.setDiskSize(prevRecord.getDiskSize());
                return 18L;
            }
            int recordLength = ((OWriteableWALRecord)record).getBinaryContentLen();
            int length = OCASWALPage.calculateSerializedSize(recordLength);
            int pages = length / maxRecordSize;
            int offset = length - pages * maxRecordSize;
            int distance = pages == 0 ? length : (pages - 1) * pageSize + offset + maxRecordSize + 18;
            record.setDistance(distance);
            int disksize = offset == 0 ? distance - 18 : distance;
            assert (prevRecord.getLsn().getSegment() == record.getLsn().getSegment());
            record.setDiskSize(disksize + prevRecord.getDiskSize());
            return prevRecord.getLsn().getPosition();
        }
        if (record instanceof OMilestoneWALRecord) {
            long pageIndex;
            if (prevRecord.getLsn().getSegment() == record.getLsn().getSegment()) {
                long newPosition;
                long pageIndex2;
                long end = prevRecord.getLsn().getPosition() + (long)prevRecord.getDistance();
                int pageOffset = (int)(end - (pageIndex2 = end / (long)pageSize) * (long)pageSize);
                if (pageOffset > 18) {
                    newPosition = (pageIndex2 + 1L) * (long)pageSize + 18L;
                    record.setDiskSize((int)((pageIndex2 + 1L) * (long)pageSize - end) + 18);
                } else {
                    newPosition = end;
                    record.setDiskSize(18);
                }
                record.setDistance(0);
                return newPosition;
            }
            long prevPosition = prevRecord.getLsn().getPosition();
            long end = prevPosition + (long)prevRecord.getDistance();
            int pageOffset = (int)(end - (pageIndex = end / (long)pageSize) * (long)pageSize);
            if (pageOffset == 18) {
                record.setDiskSize(18);
            } else {
                int pageFreeSpace = pageSize - pageOffset;
                record.setDiskSize(pageFreeSpace + 18);
            }
            record.setDistance(0);
            return 18L;
        }
        assert (prevRecord.getLsn().getSegment() == record.getLsn().getSegment());
        long start = (long)prevRecord.getDistance() + prevRecord.getLsn().getPosition();
        int freeSpace = pageSize - (int)(start % (long)pageSize);
        int startOffset = pageSize - freeSpace;
        int recordLength = ((OWriteableWALRecord)record).getBinaryContentLen();
        int length = OCASWALPage.calculateSerializedSize(recordLength);
        if (length < freeSpace) {
            record.setDistance(length);
            if (startOffset == 18) {
                record.setDiskSize(length + 18);
            } else {
                record.setDiskSize(length);
            }
        } else {
            int firstChunk = freeSpace;
            int pages = (length -= freeSpace) / maxRecordSize;
            int offset = length - pages * maxRecordSize;
            int distance = firstChunk + pages * pageSize + offset + 18;
            record.setDistance(distance);
            int diskSize = distance;
            if (offset == 0) {
                diskSize -= 18;
            }
            if (startOffset == 18) {
                diskSize += 18;
            }
            record.setDiskSize(diskSize);
        }
        return start;
    }

    private void fireEventsFor(OLogSequenceNumber lsn) {
        Iterator eventsToFire = this.events.headMap((Object)lsn, true).values().iterator();
        while (eventsToFire.hasNext()) {
            ((Runnable)eventsToFire.next()).run();
            eventsToFire.remove();
        }
    }

    private String getSegmentName(long segment) {
        return this.storageName + "." + segment + ".wal";
    }

    static {
        commitExecutor.setMaximumPoolSize(1);
    }

    private static final class WrittenUpTo {
        private final OLogSequenceNumber lsn;
        private final long position;

        WrittenUpTo(OLogSequenceNumber lsn, long position) {
            this.lsn = lsn;
            this.position = position;
        }
    }

    private final class RecordsWriter
    implements Runnable {
        private final boolean forceSync;
        private final boolean fullWrite;
        private final boolean reschedule;

        private RecordsWriter(boolean forceSync, boolean fullWrite, boolean reschedule) {
            this.forceSync = forceSync;
            this.fullWrite = fullWrite;
            this.reschedule = reschedule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block58: {
                if (OCASDiskWriteAheadLog.this.stopWrite) {
                    return;
                }
                try {
                    if (OCASDiskWriteAheadLog.this.printPerformanceStatistic) {
                        this.printReport();
                    }
                    long ts = System.nanoTime();
                    boolean makeFSync = this.forceSync || ts - OCASDiskWriteAheadLog.this.lastFSyncTs > (long)(OCASDiskWriteAheadLog.this.fsyncInterval * 1000000);
                    long qSize = OCASDiskWriteAheadLog.this.queueSize.get();
                    if (qSize > 0L || this.fullWrite || makeFSync) {
                        CountDownLatch fl = new CountDownLatch(1);
                        OCASDiskWriteAheadLog.this.flushLatch.lazySet(fl);
                        try {
                            OWALRecord record;
                            OWALRecord lastRecord;
                            OMilestoneWALRecord milestoneRecord;
                            if (makeFSync || this.fullWrite) {
                                OCASDiskWriteAheadLog.this.segmentLock.sharedLock();
                                try {
                                    milestoneRecord = OCASDiskWriteAheadLog.this.logMilestoneRecord();
                                }
                                finally {
                                    OCASDiskWriteAheadLog.this.segmentLock.sharedUnlock();
                                }
                                lastRecord = null;
                            } else {
                                Cursor cursor = OCASDiskWriteAheadLog.this.records.peekLast();
                                assert (cursor != null);
                                lastRecord = (OWALRecord)cursor.getItem();
                                assert (lastRecord != null);
                                if (lastRecord.getLsn().getPosition() == -1L) {
                                    OCASDiskWriteAheadLog.this.calculateRecordsLSNs();
                                }
                                assert (lastRecord.getLsn().getPosition() >= 0L);
                                milestoneRecord = null;
                            }
                            while ((record = (OWALRecord)OCASDiskWriteAheadLog.this.records.peek()) != milestoneRecord) {
                                OWriteableWALRecord writeableRecord;
                                OLogSequenceNumber lsn = record.getLsn();
                                assert (lsn.getSegment() >= OCASDiskWriteAheadLog.this.segmentId);
                                if (record instanceof OMilestoneWALRecord || record instanceof OStartWALRecord) {
                                    if (lastRecord == record) break;
                                    OCASDiskWriteAheadLog.this.records.poll();
                                    continue;
                                }
                                if (OCASDiskWriteAheadLog.this.segmentId != lsn.getSegment()) {
                                    if (OCASDiskWriteAheadLog.this.walFile != null) {
                                        if (OCASDiskWriteAheadLog.this.writeBufferPointer != null) {
                                            this.writeBuffer(OCASDiskWriteAheadLog.this.walFile, OCASDiskWriteAheadLog.this.writeBuffer, OCASDiskWriteAheadLog.this.writeBufferPointer, OCASDiskWriteAheadLog.this.lastLSN, OCASDiskWriteAheadLog.this.checkPointLSN);
                                        }
                                        OCASDiskWriteAheadLog.this.writeBufferPointer = null;
                                        OCASDiskWriteAheadLog.this.writeBuffer = null;
                                        OCASDiskWriteAheadLog.this.writeBufferPageIndex = -1;
                                        OCASDiskWriteAheadLog.this.checkPointLSN = null;
                                        OCASDiskWriteAheadLog.this.lastLSN = null;
                                        try {
                                            if (OCASDiskWriteAheadLog.this.writeFuture != null) {
                                                OCASDiskWriteAheadLog.this.writeFuture.get();
                                            }
                                        }
                                        catch (InterruptedException e) {
                                            OLogManager.instance().errorNoDb(this, "WAL write was interrupted", e, new Object[0]);
                                        }
                                        assert (OCASDiskWriteAheadLog.this.walFile.position() == OCASDiskWriteAheadLog.this.currentPosition);
                                        OCASDiskWriteAheadLog.this.fileCloseQueueSize.incrementAndGet();
                                        OCASDiskWriteAheadLog.this.fileCloseQueue.offer(new OPair<Long, OWALFile>(OCASDiskWriteAheadLog.this.segmentId, OCASDiskWriteAheadLog.this.walFile));
                                    }
                                    OCASDiskWriteAheadLog.this.segmentId = lsn.getSegment();
                                    OCASDiskWriteAheadLog.this.walFile = OWALFile.createWriteWALFile(OCASDiskWriteAheadLog.this.walLocation.resolve(OCASDiskWriteAheadLog.this.getSegmentName(OCASDiskWriteAheadLog.this.segmentId)), OCASDiskWriteAheadLog.this.allowDirectIO, OCASDiskWriteAheadLog.this.blockSize);
                                    assert (lsn.getPosition() == 18L);
                                    OCASDiskWriteAheadLog.this.currentPosition = 0L;
                                }
                                if (!(writeableRecord = (OWriteableWALRecord)record).isWritten()) {
                                    int written = 0;
                                    int recordContentBinarySize = writeableRecord.getBinaryContentLen();
                                    int bytesToWrite = 4 + recordContentBinarySize;
                                    ByteBuffer recordContent = writeableRecord.getBinaryContent();
                                    recordContent.position(0);
                                    byte[] recordSize = null;
                                    int recordSizeWritten = -1;
                                    boolean recordSizeIsWritten = false;
                                    while (written < bytesToWrite) {
                                        if (OCASDiskWriteAheadLog.this.writeBuffer == null || OCASDiskWriteAheadLog.this.writeBuffer.remaining() == 0) {
                                            if (OCASDiskWriteAheadLog.this.writeBufferPointer != null) {
                                                this.writeBuffer(OCASDiskWriteAheadLog.this.walFile, OCASDiskWriteAheadLog.this.writeBuffer, OCASDiskWriteAheadLog.this.writeBufferPointer, OCASDiskWriteAheadLog.this.lastLSN, OCASDiskWriteAheadLog.this.checkPointLSN);
                                            }
                                            OCASDiskWriteAheadLog.this.writeBufferPointer = OCASDiskWriteAheadLog.this.allocator.allocate(OCASDiskWriteAheadLog.this.bufferSize, OCASDiskWriteAheadLog.this.blockSize);
                                            OCASDiskWriteAheadLog.this.writeBuffer = OCASDiskWriteAheadLog.this.writeBufferPointer.getNativeByteBuffer().order(ByteOrder.nativeOrder());
                                            OCASDiskWriteAheadLog.this.writeBufferPageIndex = -1;
                                            OCASDiskWriteAheadLog.this.checkPointLSN = null;
                                            OCASDiskWriteAheadLog.this.lastLSN = null;
                                        }
                                        if (OCASDiskWriteAheadLog.this.writeBuffer.position() % OCASDiskWriteAheadLog.this.pageSize == 0) {
                                            OCASDiskWriteAheadLog.this.writeBufferPageIndex++;
                                            OCASDiskWriteAheadLog.this.writeBuffer.position(OCASDiskWriteAheadLog.this.writeBuffer.position() + 18);
                                        }
                                        assert (written != 0 || OCASDiskWriteAheadLog.this.currentPosition + (long)OCASDiskWriteAheadLog.this.writeBuffer.position() == lsn.getPosition()) : OCASDiskWriteAheadLog.access$2100(OCASDiskWriteAheadLog.this) + (long)OCASDiskWriteAheadLog.access$1600(OCASDiskWriteAheadLog.this).position() + " vs " + lsn.getPosition();
                                        int chunkSize = Math.min(bytesToWrite - written, (OCASDiskWriteAheadLog.this.writeBufferPageIndex + 1) * OCASDiskWriteAheadLog.this.pageSize - OCASDiskWriteAheadLog.this.writeBuffer.position());
                                        assert (chunkSize <= OCASDiskWriteAheadLog.this.maxRecordSize);
                                        assert (chunkSize + OCASDiskWriteAheadLog.this.writeBuffer.position() <= (OCASDiskWriteAheadLog.this.writeBufferPageIndex + 1) * OCASDiskWriteAheadLog.this.pageSize);
                                        assert (OCASDiskWriteAheadLog.this.writeBuffer.position() > OCASDiskWriteAheadLog.this.writeBufferPageIndex * OCASDiskWriteAheadLog.this.pageSize);
                                        if (!recordSizeIsWritten) {
                                            if (recordSizeWritten > 0) {
                                                OCASDiskWriteAheadLog.this.writeBuffer.put(recordSize, recordSizeWritten, 4 - recordSizeWritten);
                                                written += 4 - recordSizeWritten;
                                                recordSize = null;
                                                recordSizeWritten = -1;
                                                recordSizeIsWritten = true;
                                                continue;
                                            }
                                            if (4 <= chunkSize) {
                                                OCASDiskWriteAheadLog.this.writeBuffer.putInt(recordContentBinarySize);
                                                written += 4;
                                                recordSize = null;
                                                recordSizeWritten = -1;
                                                recordSizeIsWritten = true;
                                                continue;
                                            }
                                            recordSize = new byte[4];
                                            OIntegerSerializer.INSTANCE.serializeNative(recordContentBinarySize, recordSize, 0, new Object[0]);
                                            recordSizeWritten = (OCASDiskWriteAheadLog.this.writeBufferPageIndex + 1) * OCASDiskWriteAheadLog.this.pageSize - OCASDiskWriteAheadLog.this.writeBuffer.position();
                                            written += recordSizeWritten;
                                            OCASDiskWriteAheadLog.this.writeBuffer.put(recordSize, 0, recordSizeWritten);
                                            continue;
                                        }
                                        recordContent.limit(recordContent.position() + chunkSize);
                                        OCASDiskWriteAheadLog.this.writeBuffer.put(recordContent);
                                        written += chunkSize;
                                    }
                                    OCASDiskWriteAheadLog.this.lastLSN = lsn;
                                    if (writeableRecord.isUpdateMasterRecord()) {
                                        OCASDiskWriteAheadLog.this.checkPointLSN = OCASDiskWriteAheadLog.this.lastLSN;
                                    }
                                    OCASDiskWriteAheadLog.this.queueSize.addAndGet(-writeableRecord.getDiskSize());
                                    writeableRecord.written();
                                    writeableRecord.freeBinaryContent();
                                }
                                if (lastRecord == record) break;
                                OCASDiskWriteAheadLog.this.records.poll();
                            }
                            if ((makeFSync || this.fullWrite) && OCASDiskWriteAheadLog.this.writeBufferPointer != null) {
                                this.writeBuffer(OCASDiskWriteAheadLog.this.walFile, OCASDiskWriteAheadLog.this.writeBuffer, OCASDiskWriteAheadLog.this.writeBufferPointer, OCASDiskWriteAheadLog.this.lastLSN, OCASDiskWriteAheadLog.this.checkPointLSN);
                                OCASDiskWriteAheadLog.this.writeBufferPointer = null;
                                OCASDiskWriteAheadLog.this.writeBuffer = null;
                                OCASDiskWriteAheadLog.this.writeBufferPageIndex = -1;
                                OCASDiskWriteAheadLog.this.checkPointLSN = null;
                                OCASDiskWriteAheadLog.this.lastLSN = null;
                            }
                        }
                        finally {
                            fl.countDown();
                        }
                        if (qSize > 0L && ts - OCASDiskWriteAheadLog.this.segmentAdditionTs >= OCASDiskWriteAheadLog.this.segmentsInterval) {
                            for (OSegmentOverflowListener listener : OCASDiskWriteAheadLog.this.segmentOverflowListeners) {
                                listener.onSegmentOverflow(OCASDiskWriteAheadLog.this.currentSegment);
                            }
                        }
                    }
                    if (!makeFSync) break block58;
                    try {
                        try {
                            if (OCASDiskWriteAheadLog.this.writeFuture != null) {
                                OCASDiskWriteAheadLog.this.writeFuture.get();
                            }
                        }
                        catch (InterruptedException e) {
                            OLogManager.instance().errorNoDb(this, "WAL write was interrupted", e, new Object[0]);
                        }
                        assert (OCASDiskWriteAheadLog.this.walFile.position() == OCASDiskWriteAheadLog.this.currentPosition);
                        OCASDiskWriteAheadLog.this.writeFuture = writeExecutor.submit(() -> {
                            try {
                                int cqSize;
                                long startTs = 0L;
                                if (OCASDiskWriteAheadLog.this.printPerformanceStatistic) {
                                    startTs = System.nanoTime();
                                }
                                if ((cqSize = OCASDiskWriteAheadLog.this.fileCloseQueueSize.get()) > 0) {
                                    OPair pair;
                                    for (int counter = 0; counter < cqSize && (pair = (OPair)OCASDiskWriteAheadLog.this.fileCloseQueue.poll()) != null; ++counter) {
                                        OWALFile file = (OWALFile)pair.value;
                                        assert (file.position() % (long)OCASDiskWriteAheadLog.this.pageSize == 0L);
                                        if (OCASDiskWriteAheadLog.this.callFsync) {
                                            file.force(true);
                                        }
                                        file.close();
                                        OCASDiskWriteAheadLog.this.fileCloseQueueSize.decrementAndGet();
                                    }
                                }
                                if (OCASDiskWriteAheadLog.this.callFsync) {
                                    OCASDiskWriteAheadLog.this.walFile.force(true);
                                }
                                OCASDiskWriteAheadLog.this.updateCheckpoint(OCASDiskWriteAheadLog.this.writtenCheckpoint);
                                OCASDiskWriteAheadLog.this.flushedLSN = ((WrittenUpTo)OCASDiskWriteAheadLog.this.writtenUpTo.get()).lsn;
                                OCASDiskWriteAheadLog.this.fireEventsFor(OCASDiskWriteAheadLog.this.flushedLSN);
                                if (OCASDiskWriteAheadLog.this.printPerformanceStatistic) {
                                    long endTs = System.nanoTime();
                                    OCASDiskWriteAheadLog.this.fsyncTime = OCASDiskWriteAheadLog.this.fsyncTime + (endTs - startTs);
                                    OCASDiskWriteAheadLog.this.fsyncCount++;
                                }
                            }
                            catch (IOException e) {
                                OLogManager.instance().errorNoDb(this, "Error during FSync of WAL data", e, new Object[0]);
                                throw e;
                            }
                            return null;
                        });
                        OCASDiskWriteAheadLog.this.checkFreeSpace();
                    }
                    finally {
                        OCASDiskWriteAheadLog.this.lastFSyncTs = ts;
                    }
                }
                catch (IOException | ExecutionException e) {
                    OLogManager.instance().errorNoDb(this, "Error during WAL writing", e, new Object[0]);
                    throw new IllegalStateException(e);
                }
                catch (Error | RuntimeException e) {
                    OLogManager.instance().errorNoDb(this, "Error during WAL writing", e, new Object[0]);
                    throw e;
                }
                finally {
                    if (this.reschedule && !OCASDiskWriteAheadLog.this.stopWrite) {
                        OCASDiskWriteAheadLog.this.recordsWriterFuture = commitExecutor.schedule(this, (long)OCASDiskWriteAheadLog.this.commitDelay, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }

        private void writeBuffer(OWALFile file, ByteBuffer buffer, OPointer pointer, OLogSequenceNumber lastLSN, OLogSequenceNumber checkpointLSN) throws IOException {
            if (buffer.position() <= 18) {
                OCASDiskWriteAheadLog.this.allocator.deallocate(pointer);
                return;
            }
            int maxPage = (buffer.position() + OCASDiskWriteAheadLog.this.pageSize - 1) / OCASDiskWriteAheadLog.this.pageSize;
            int lastPageSize = buffer.position() - (maxPage - 1) * OCASDiskWriteAheadLog.this.pageSize;
            if (lastPageSize <= 18) {
                --maxPage;
                lastPageSize = OCASDiskWriteAheadLog.this.pageSize;
            }
            int start = 0;
            int page = 0;
            while (start < maxPage * OCASDiskWriteAheadLog.this.pageSize) {
                int pageSize = page < maxPage - 1 ? OCASDiskWriteAheadLog.this.pageSize : lastPageSize;
                buffer.limit(start + pageSize);
                buffer.position(start + 8);
                buffer.putLong(4013014191L);
                buffer.position(start + 16);
                buffer.putShort((short)pageSize);
                buffer.position(start + 18);
                XXHash64 xxHash64 = xxHashFactory.hash64();
                long hash = xxHash64.hash(buffer, -1756908916L);
                buffer.position(start + 0);
                buffer.putLong(hash);
                start += OCASDiskWriteAheadLog.this.pageSize;
                ++page;
            }
            buffer.position(0);
            int limit = maxPage * OCASDiskWriteAheadLog.this.pageSize;
            buffer.limit(limit);
            try {
                if (OCASDiskWriteAheadLog.this.writeFuture != null) {
                    OCASDiskWriteAheadLog.this.writeFuture.get();
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().errorNoDb(this, "WAL write was interrupted", e, new Object[0]);
            }
            catch (Exception e) {
                OLogManager.instance().errorNoDb(this, "Error during WAL write", e, new Object[0]);
                throw OException.wrapException(new OStorageException("Error during WAL data write"), e);
            }
            assert (file.position() == OCASDiskWriteAheadLog.this.currentPosition);
            OCASDiskWriteAheadLog.this.currentPosition = OCASDiskWriteAheadLog.this.currentPosition + (long)buffer.limit();
            long expectedPosition = OCASDiskWriteAheadLog.this.currentPosition;
            OCASDiskWriteAheadLog.this.writeFuture = writeExecutor.submit(() -> {
                try {
                    long startTs = 0L;
                    if (OCASDiskWriteAheadLog.this.printPerformanceStatistic) {
                        startTs = System.nanoTime();
                    }
                    assert (buffer.position() == 0);
                    assert (file.position() % (long)OCASDiskWriteAheadLog.this.pageSize == 0L);
                    assert (buffer.limit() == limit);
                    while (buffer.remaining() > 0) {
                        int initialPos = buffer.position();
                        int written = file.write(buffer);
                        assert (buffer.position() == initialPos + written);
                    }
                    assert (file.position() == expectedPosition);
                    if (lastLSN != null) {
                        WrittenUpTo written = (WrittenUpTo)OCASDiskWriteAheadLog.this.writtenUpTo.get();
                        assert (written == null || written.lsn.compareTo(lastLSN) < 0);
                        if (written == null) {
                            OCASDiskWriteAheadLog.this.writtenUpTo.lazySet(new WrittenUpTo(lastLSN, buffer.limit()));
                        } else if (written.lsn.getSegment() == lastLSN.getSegment()) {
                            OCASDiskWriteAheadLog.this.writtenUpTo.lazySet(new WrittenUpTo(lastLSN, written.position + (long)buffer.limit()));
                        } else {
                            OCASDiskWriteAheadLog.this.writtenUpTo.lazySet(new WrittenUpTo(lastLSN, buffer.limit()));
                        }
                    }
                    if (checkpointLSN != null) {
                        assert (OCASDiskWriteAheadLog.this.writtenCheckpoint == null || OCASDiskWriteAheadLog.this.writtenCheckpoint.compareTo(checkpointLSN) < 0);
                        OCASDiskWriteAheadLog.this.writtenCheckpoint = checkpointLSN;
                    }
                    if (OCASDiskWriteAheadLog.this.printPerformanceStatistic) {
                        long endTs = System.nanoTime();
                        OCASDiskWriteAheadLog.this.bytesWrittenSum = OCASDiskWriteAheadLog.this.bytesWrittenSum + (long)buffer.limit();
                        OCASDiskWriteAheadLog.this.bytesWrittenTime = OCASDiskWriteAheadLog.this.bytesWrittenTime + (endTs - startTs);
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().errorNoDb(this, "Error during WAL data write", e, new Object[0]);
                    throw e;
                }
                finally {
                    OCASDiskWriteAheadLog.this.allocator.deallocate(pointer);
                }
                return null;
            });
        }

        private void printReport() {
            long reportInterval;
            long ts = System.nanoTime();
            if (OCASDiskWriteAheadLog.this.reportTs == -1L) {
                OCASDiskWriteAheadLog.this.reportTs = ts;
                reportInterval = 0L;
            } else {
                reportInterval = ts - OCASDiskWriteAheadLog.this.reportTs;
            }
            if (reportInterval >= (long)OCASDiskWriteAheadLog.this.statisticPrintInterval * 1000000000L) {
                long bytesWritten = OCASDiskWriteAheadLog.this.bytesWrittenSum;
                long writtenTime = OCASDiskWriteAheadLog.this.bytesWrittenTime;
                long fsyncTime = OCASDiskWriteAheadLog.this.fsyncTime;
                long fsyncCount = OCASDiskWriteAheadLog.this.fsyncCount;
                long threadsWaitingCount = OCASDiskWriteAheadLog.this.threadsWaitingCount.sum();
                long threadsWaitingSum = OCASDiskWriteAheadLog.this.threadsWaitingSum.sum();
                OLogManager.instance().infoNoDb(this, "WAL stat:%s: %d KB was written, write speed is %d KB/s. FSync count %d. Avg. fsync time %d ms. %d times threads were waiting for WAL. Avg wait interval %d ms.", OCASDiskWriteAheadLog.this.storageName, bytesWritten / 1024L, writtenTime > 0L ? 1000000000L * bytesWritten / writtenTime / 1024L : -1L, fsyncCount, fsyncCount > 0L ? fsyncTime / fsyncCount / 1000000L : -1L, threadsWaitingCount, threadsWaitingCount > 0L ? threadsWaitingSum / threadsWaitingCount / 1000000L : -1L);
                OCASDiskWriteAheadLog oCASDiskWriteAheadLog = OCASDiskWriteAheadLog.this;
                oCASDiskWriteAheadLog.bytesWrittenSum = oCASDiskWriteAheadLog.bytesWrittenSum - bytesWritten;
                oCASDiskWriteAheadLog = OCASDiskWriteAheadLog.this;
                oCASDiskWriteAheadLog.bytesWrittenTime = oCASDiskWriteAheadLog.bytesWrittenTime - writtenTime;
                oCASDiskWriteAheadLog = OCASDiskWriteAheadLog.this;
                oCASDiskWriteAheadLog.fsyncTime = oCASDiskWriteAheadLog.fsyncTime - fsyncTime;
                oCASDiskWriteAheadLog = OCASDiskWriteAheadLog.this;
                oCASDiskWriteAheadLog.fsyncCount = oCASDiskWriteAheadLog.fsyncCount - fsyncCount;
                OCASDiskWriteAheadLog.this.threadsWaitingSum.add(-threadsWaitingSum);
                OCASDiskWriteAheadLog.this.threadsWaitingCount.add(-threadsWaitingCount);
                OCASDiskWriteAheadLog.this.reportTs = ts;
            }
        }
    }
}

