/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.engine;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OPrefixBTree;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OPrefixBTreeIndexEngine
implements OIndexEngine {
    public static final int VERSION = 1;
    public static final String DATA_FILE_EXTENSION = ".pbt";
    public static final String NULL_BUCKET_FILE_EXTENSION = ".npt";
    private final OPrefixBTree<Object> prefixTree;
    private final int version;
    private final String name;

    public OPrefixBTreeIndexEngine(String name, OAbstractPaginatedStorage storage, int version) {
        this.name = name;
        this.version = version;
        this.prefixTree = new OPrefixBTree(name, DATA_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, storage);
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void flush() {
    }

    @Override
    public void create(OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Set<String> clustersToIndex, Map<String, String> engineProperties, ODocument metadata, OEncryption encryption) {
        try {
            this.prefixTree.create(keySerializer, valueSerializer, nullPointerSupport, encryption);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during creation of index " + this.name), e);
        }
    }

    @Override
    public void delete() {
        try {
            this.prefixTree.delete();
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during deletion of index " + this.name), e);
        }
    }

    @Override
    public void deleteWithoutLoad(String indexName) {
        try {
            this.prefixTree.deleteWithoutLoad();
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during deletion of index " + this.name), e);
        }
    }

    @Override
    public void load(String indexName, OBinarySerializer valueSerializer, boolean isAutomatic, OBinarySerializer keySerializer, OType[] keyTypes, boolean nullPointerSupport, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
        this.prefixTree.load(indexName, keySerializer, valueSerializer, nullPointerSupport, encryption);
    }

    @Override
    public boolean contains(Object key) {
        if (key == null) {
            return this.prefixTree.get(null) != null;
        }
        return this.prefixTree.get(key.toString()) != null;
    }

    @Override
    public boolean remove(Object key) {
        try {
            if (key == null) {
                return this.prefixTree.remove(null) != null;
            }
            return this.prefixTree.remove(key.toString()) != null;
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during removal of key " + key + " in index " + this.name), e);
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void clear() {
        try {
            this.prefixTree.clear();
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during clear of index " + this.name), e);
        }
    }

    @Override
    public void close() {
        this.prefixTree.close();
    }

    @Override
    public Object get(Object key) {
        if (key != null) {
            return this.prefixTree.get(key.toString());
        }
        return this.prefixTree.get(null);
    }

    @Override
    public OIndexCursor cursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        String firstKey = this.prefixTree.firstKey();
        if (firstKey == null) {
            return new NullCursor();
        }
        return new OSBTreeIndexCursor(this.prefixTree.iterateEntriesMajor(firstKey, true, true), valuesTransformer);
    }

    @Override
    public OIndexCursor descCursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        String lastKey = this.prefixTree.lastKey();
        if (lastKey == null) {
            return new NullCursor();
        }
        return new OSBTreeIndexCursor(this.prefixTree.iterateEntriesMinor(lastKey, true, false), valuesTransformer);
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        return new OIndexKeyCursor(){
            private final OPrefixBTree.OSBTreeKeyCursor<String> sbTreeKeyCursor;
            {
                this.sbTreeKeyCursor = OPrefixBTreeIndexEngine.this.prefixTree.keyCursor();
            }

            @Override
            public Object next(int prefetchSize) {
                return this.sbTreeKeyCursor.next(prefetchSize);
            }
        };
    }

    @Override
    public void put(Object key, Object value) {
        try {
            if (key == null) {
                this.prefixTree.put(null, value);
            } else {
                this.prefixTree.put(key.toString(), value);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during insertion of key " + key + " in index " + this.name), e);
        }
    }

    @Override
    public void update(Object key, OIndexKeyUpdater<Object> updater) {
        try {
            if (key == null) {
                this.prefixTree.update(null, updater, null);
            } else {
                this.prefixTree.update(key.toString(), updater, null);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during update of key " + key + " in index " + this.name), e);
        }
    }

    @Override
    public boolean validatedPut(Object key, OIdentifiable value, OIndexEngine.Validator<Object, OIdentifiable> validator) {
        try {
            if (key == null) {
                return this.prefixTree.validatedPut(null, value, validator);
            }
            return this.prefixTree.validatedPut(key.toString(), value, validator);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during update of key " + key + " in index " + this.name), e);
        }
    }

    @Override
    public Object getFirstKey() {
        return this.prefixTree.firstKey();
    }

    @Override
    public Object getLastKey() {
        return this.prefixTree.lastKey();
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return new OSBTreeIndexCursor(this.prefixTree.iterateEntriesBetween(rangeFrom.toString(), fromInclusive, rangeTo.toString(), toInclusive, ascSortOrder), transformer);
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return new OSBTreeIndexCursor(this.prefixTree.iterateEntriesMajor(fromKey == null ? null : fromKey.toString(), isInclusive, ascSortOrder), transformer);
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return new OSBTreeIndexCursor(this.prefixTree.iterateEntriesMinor(toKey == null ? null : toKey.toString(), isInclusive, ascSortOrder), transformer);
    }

    @Override
    public long size(OIndexEngine.ValuesTransformer transformer) {
        Object nullValue;
        if (transformer == null) {
            return this.prefixTree.size();
        }
        int counter = 0;
        if (this.prefixTree.isNullPointerSupport() && (nullValue = this.prefixTree.get(null)) != null) {
            counter += transformer.transformFromValue(nullValue).size();
        }
        String firstKey = this.prefixTree.firstKey();
        String lastKey = this.prefixTree.lastKey();
        if (firstKey != null && lastKey != null) {
            OPrefixBTree.OSBTreeCursor<String, Object> cursor = this.prefixTree.iterateEntriesBetween(firstKey.toString(), true, lastKey.toString(), true, true);
            Map.Entry<String, Object> entry = cursor.next(-1);
            while (entry != null) {
                counter += transformer.transformFromValue(entry.getValue()).size();
                entry = cursor.next(-1);
            }
            return counter;
        }
        return counter;
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return true;
    }

    @Override
    public boolean acquireAtomicExclusiveLock(Object key) {
        this.prefixTree.acquireAtomicExclusiveLock();
        return true;
    }

    @Override
    public String getIndexNameByKey(Object key) {
        return this.name;
    }

    private static class NullCursor
    extends OIndexAbstractCursor {
        private NullCursor() {
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            return null;
        }
    }

    private static final class OSBTreeIndexCursor
    extends OIndexAbstractCursor {
        private final OPrefixBTree.OSBTreeCursor<String, Object> treeCursor;
        private final OIndexEngine.ValuesTransformer valuesTransformer;
        private Iterator<OIdentifiable> currentIterator = OEmptyIterator.IDENTIFIABLE_INSTANCE;
        private Object currentKey = null;

        private OSBTreeIndexCursor(OPrefixBTree.OSBTreeCursor<String, Object> treeCursor, OIndexEngine.ValuesTransformer valuesTransformer) {
            this.treeCursor = treeCursor;
            this.valuesTransformer = valuesTransformer;
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            if (this.valuesTransformer == null) {
                Map.Entry<String, Object> entry = this.treeCursor.next(this.getPrefetchSize());
                return entry;
            }
            if (this.currentIterator == null) {
                return null;
            }
            while (!this.currentIterator.hasNext()) {
                Map.Entry<String, Object> p = this.treeCursor.next(this.getPrefetchSize());
                Map.Entry<String, Object> entry = p;
                if (entry == null) {
                    this.currentIterator = null;
                    return null;
                }
                this.currentKey = entry.getKey();
                this.currentIterator = this.valuesTransformer.transformFromValue(entry.getValue()).iterator();
            }
            final OIdentifiable value = this.currentIterator.next();
            return new Map.Entry<Object, OIdentifiable>(){

                @Override
                public Object getKey() {
                    return currentKey;
                }

                @Override
                public OIdentifiable getValue() {
                    return value;
                }

                @Override
                public OIdentifiable setValue(OIdentifiable value2) {
                    throw new UnsupportedOperationException("setValue");
                }
            };
        }
    }
}

