/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexUpdateAction;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.iterator.OEmptyMapEntryIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.index.sbtree.local.ONullBucket;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OPrefixBTreeBucket;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OPrefixBTreeException;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTreeValue;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTreeValuePage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class OPrefixBTree<V>
extends ODurableComponent {
    private static final int MAX_EMBEDDED_VALUE_SIZE = OGlobalConfiguration.SBTREE_MAX_EMBEDDED_VALUE_SIZE.getValueAsInteger();
    private static final int MAX_PATH_LENGTH = OGlobalConfiguration.SBTREE_MAX_DEPTH.getValueAsInteger();
    private static final long ROOT_INDEX = 0L;
    private final Comparator<Object> comparator = ODefaultComparator.INSTANCE;
    private final String nullFileExtension;
    private long fileId;
    private long nullBucketFileId = -1L;
    private OBinarySerializer<String> keySerializer;
    private OBinarySerializer<V> valueSerializer;
    private boolean nullPointerSupport;
    private final AtomicLong bonsayFileId = new AtomicLong(0L);
    private OEncryption encryption;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPrefixBTree(String name, String dataFileExtension, String nullFileExtension, OAbstractPaginatedStorage storage) {
        super(storage, name, dataFileExtension, name + dataFileExtension);
        this.acquireExclusiveLock();
        try {
            this.nullFileExtension = nullFileExtension;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(OBinarySerializer<String> keySerializer, OBinarySerializer<V> valueSerializer, boolean nullPointerSupport, OEncryption encryption) throws IOException {
        assert (keySerializer != null);
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                this.encryption = encryption;
                this.keySerializer = keySerializer;
                this.valueSerializer = valueSerializer;
                this.nullPointerSupport = nullPointerSupport;
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                if (nullPointerSupport) {
                    this.nullBucketFileId = this.addFile(atomicOperation, this.getName() + this.nullFileExtension);
                }
                OCacheEntry rootCacheEntry = this.addPage(atomicOperation, this.fileId, false);
                try {
                    OPrefixBTreeBucket<V> rootBucket = new OPrefixBTreeBucket<V>(rootCacheEntry, true, keySerializer, valueSerializer, encryption, "");
                    rootBucket.setTreeSize(0L);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, rootCacheEntry);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    public boolean isNullPointerSupport() {
        this.acquireSharedLock();
        try {
            boolean bl = this.nullPointerSupport;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * Exception decompiling
     */
    public V get(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 25[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void put(String key, V value) throws IOException {
        this.put(key, value, null);
    }

    public boolean validatedPut(String key, V value, OIndexEngine.Validator<String, V> validator) throws IOException {
        return this.put(key, value, validator);
    }

    private boolean put(String key, V value, OIndexEngine.Validator<String, V> validator) throws IOException {
        return this.update(key, (x, bonsayFileId) -> {
            OIndexUpdateAction<Object> changed = OIndexUpdateAction.changed(value);
            return changed;
        }, validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean update(String key, OIndexKeyUpdater<V> updater, OIndexEngine.Validator<String, V> validator) throws IOException {
        rollback = false;
        atomicOperation = this.startAtomicOperation(true);
        try {
            block42: {
                block44: {
                    block41: {
                        block40: {
                            block38: {
                                block39: {
                                    if (!OPrefixBTree.$assertionsDisabled && atomicOperation == null) {
                                        throw new AssertionError();
                                    }
                                    this.acquireExclusiveLock();
                                    this.checkNullSupport(key);
                                    if (key == null) ** GOTO lbl88
                                    key = this.keySerializer.preprocess(key, new Object[]{OType.STRING});
                                    bucketSearchResult = this.findBucketForUpdate(key, atomicOperation);
                                    keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false);
                                    keyBucket = new OPrefixBTreeBucket<Object>(keyBucketCacheEntry, this.keySerializer, this.valueSerializer, this.encryption);
                                    oldRawValue = BucketUpdateSearchResult.access$100(bucketSearchResult) > -1 ? keyBucket.getRawValue(BucketUpdateSearchResult.access$100(bucketSearchResult)) : null;
                                    oldValue = oldRawValue == null ? null : (V)this.valueSerializer.deserializeNativeObject(oldRawValue, 0);
                                    updatedValue = updater.update(oldValue, this.bonsayFileId);
                                    if (!updatedValue.isChange()) ** GOTO lbl80
                                    value = updatedValue.getValue();
                                    if (validator == null) ** GOTO lbl45
                                    failure = true;
                                    ignored = false;
                                    result = validator.validate(key, oldValue, value);
                                    if (result != OIndexEngine.Validator.IGNORE) break block38;
                                    ignored = true;
                                    failure = false;
                                    var16_29 = false;
                                    if (!failure && !ignored) break block39;
                                    this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                                }
                                this.releaseExclusiveLock();
                                return var16_29;
                            }
                            value = result;
                            failure = false;
                            break block40;
                            {
                                catch (Throwable var17_32) {
                                    throw var17_32;
                                }
                            }
                            finally {
                                if (failure || ignored) {
                                    this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                                }
                            }
                        }
                        v0 = createLinkToTheValue = (serializeValue = this.valueSerializer.serializeNativeAsWhole(value, new Object[0])).length > OPrefixBTree.MAX_EMBEDDED_VALUE_SIZE;
                        if (!OPrefixBTree.$assertionsDisabled && createLinkToTheValue) {
                            throw new AssertionError();
                        }
                        if (BucketUpdateSearchResult.access$100(bucketSearchResult) < 0) ** GOTO lbl64
                        if (!OPrefixBTree.$assertionsDisabled && oldRawValue == null) {
                            throw new AssertionError();
                        }
                        if (oldRawValue.length != serializeValue.length) break block41;
                        keyBucket.updateValue(BucketUpdateSearchResult.access$100(bucketSearchResult), serializeValue);
                        this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                        var17_33 = true;
                        this.releaseExclusiveLock();
                        return var17_33;
                    }
                    keyBucket.remove(BucketUpdateSearchResult.access$100(bucketSearchResult));
                    insertionIndex = BucketUpdateSearchResult.access$100(bucketSearchResult);
                    sizeDiff = 0;
                    break block44;
lbl64:
                    // 1 sources

                    insertionIndex = -BucketUpdateSearchResult.access$100(bucketSearchResult) - 1;
                    sizeDiff = 1;
                }
                while (!keyBucket.addEntry(insertionIndex, new OPrefixBTreeBucket.SBTreeEntry<Object>(-1, -1, key, new OSBTreeValue<Object>(false, -1L, value)), true)) {
                    bucketSearchResult = this.splitBucket(keyBucket, keyBucketCacheEntry, BucketUpdateSearchResult.access$200(bucketSearchResult), BucketUpdateSearchResult.access$300(bucketSearchResult), BucketUpdateSearchResult.access$400(bucketSearchResult), insertionIndex, key, atomicOperation);
                    insertionIndex = BucketUpdateSearchResult.access$100(bucketSearchResult);
                    parentIndex = bucketSearchResult.getLastPathItem();
                    if (parentIndex != keyBucketCacheEntry.getPageIndex()) {
                        this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                        keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false);
                    }
                    keyBucket = new OPrefixBTreeBucket<V>(keyBucketCacheEntry, this.keySerializer, this.valueSerializer, this.encryption);
                }
                this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                if (sizeDiff != 0) {
                    this.updateSize(sizeDiff, atomicOperation);
                }
                ** GOTO lbl129
lbl80:
                // 1 sources

                if (updatedValue.isRemove()) {
                    this.removeKey(atomicOperation, bucketSearchResult.getLastPathItem(), BucketUpdateSearchResult.access$100(bucketSearchResult));
                    this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                } else if (updatedValue.isNothing()) {
                    this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                }
                ** GOTO lbl129
lbl88:
                // 1 sources

                isNew = false;
                if (this.getFilledUpTo(atomicOperation, this.nullBucketFileId) == 0L) {
                    cacheEntry = this.addPage(atomicOperation, this.nullBucketFileId, false);
                    isNew = true;
                } else {
                    cacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false);
                }
                sizeDiff = 0;
                nullBucket = new ONullBucket<Object>(cacheEntry, this.valueSerializer, isNew);
                oldValue = nullBucket.getValue();
                oldValueValue = oldValue == null ? null : (V)this.readValue(oldValue, atomicOperation);
                updatedValue = updater.update(oldValueValue, this.bonsayFileId);
                if (!updatedValue.isChange()) ** GOTO lbl115
                value = updatedValue.getValue();
                treeValue = new OSBTreeValue<Object>(false, -1L, value);
                if (validator == null || (result = validator.validate(null, oldValueValue, value)) != OIndexEngine.Validator.IGNORE) break block42;
                var16_31 = false;
                this.releasePageFromWrite(atomicOperation, cacheEntry);
                this.releaseExclusiveLock();
                return var16_31;
            }
            try {
                block43: {
                    if (oldValue != null) {
                        sizeDiff = -1;
                    }
                    nullBucket.setValue(treeValue);
                    break block43;
lbl115:
                    // 1 sources

                    if (updatedValue.isRemove()) {
                        this.removeNullBucket(atomicOperation);
                    } else if (updatedValue.isNothing()) {
                        // empty if block
                    }
                    break block43;
                    {
                        catch (Throwable var19_35) {
                            throw var19_35;
                        }
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                }
                this.updateSize(++sizeDiff, atomicOperation);
lbl129:
                // 4 sources

                cacheEntry = true;
            }
            catch (Throwable var20_36) {
                try {
                    this.releaseExclusiveLock();
                    throw var20_36;
                }
                catch (Exception e) {
                    rollback = true;
                    throw e;
                }
            }
            this.releaseExclusiveLock();
            return cacheEntry;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    public void close(boolean flush) {
        this.acquireExclusiveLock();
        try {
            this.readCache.closeFile(this.fileId, flush, this.writeCache);
            if (this.nullPointerSupport) {
                this.readCache.closeFile(this.nullBucketFileId, flush, this.writeCache);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            this.acquireExclusiveLock();
            try {
                OCacheEntry cacheEntry;
                this.truncateFile(atomicOperation, this.fileId);
                if (this.nullPointerSupport) {
                    this.truncateFile(atomicOperation, this.nullBucketFileId);
                }
                if ((cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false)) == null) {
                    cacheEntry = this.addPage(atomicOperation, this.fileId, false);
                }
                try {
                    OPrefixBTreeBucket<V> rootBucket = new OPrefixBTreeBucket<V>(cacheEntry, true, this.keySerializer, this.valueSerializer, this.encryption, "");
                    rootBucket.setTreeSize(0L);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, cacheEntry);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    public void delete() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                this.deleteFile(atomicOperation, this.fileId);
                if (this.nullPointerSupport) {
                    this.deleteFile(atomicOperation, this.nullBucketFileId);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWithoutLoad() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                if (this.isFileExists(atomicOperation, this.getFullName())) {
                    long fileId = this.openFile(atomicOperation, this.getFullName());
                    this.deleteFile(atomicOperation, fileId);
                }
                if (this.isFileExists(atomicOperation, this.getName() + this.nullFileExtension)) {
                    long nullFileId = this.openFile(atomicOperation, this.getName() + this.nullFileExtension);
                    this.deleteFile(atomicOperation, nullFileId);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    public void load(String name, OBinarySerializer<String> keySerializer, OBinarySerializer<V> valueSerializer, boolean nullPointerSupport, OEncryption encryption) {
        this.acquireExclusiveLock();
        try {
            this.encryption = encryption;
            this.nullPointerSupport = nullPointerSupport;
            OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
            this.fileId = this.openFile(atomicOperation, this.getFullName());
            if (nullPointerSupport) {
                this.nullBucketFileId = this.openFile(atomicOperation, name + this.nullFileExtension);
            }
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
        }
        catch (IOException e) {
            throw OException.wrapException(new OPrefixBTreeException("Exception during loading of sbtree " + name, this), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public V remove(String key) throws IOException {
        rollback = false;
        atomicOperation = this.startAtomicOperation(true);
        try {
            block13: {
                block12: {
                    this.acquireExclusiveLock();
                    try {
                        if (key == null) ** GOTO lbl26
                        bucketSearchResult = this.findBucket(key = this.keySerializer.preprocess(key, new Object[]{OType.STRING}), atomicOperation);
                        if (BucketSearchResult.access$000(bucketSearchResult) >= 0) break block12;
                        var6_6 = null;
                    }
                    catch (Throwable var7_9) {
                        try {
                            this.releaseExclusiveLock();
                            throw var7_9;
                        }
                        catch (Exception e) {
                            rollback = true;
                            throw e;
                        }
                    }
                    this.releaseExclusiveLock();
                    return var6_6;
                }
                removedValue = this.valueSerializer.deserializeNativeObject(this.removeKey(atomicOperation, bucketSearchResult.getLastPathItem(), BucketSearchResult.access$000(bucketSearchResult)), 0);
                ** GOTO lbl33
lbl26:
                // 1 sources

                if (this.getFilledUpTo(atomicOperation, this.nullBucketFileId) != 0L) break block13;
                var5_5 = null;
                this.releaseExclusiveLock();
                return var5_5;
            }
            removedValue = this.removeNullBucket(atomicOperation);
lbl33:
            // 2 sources

            var5_4 = removedValue;
            this.releaseExclusiveLock();
            return var5_4;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V removeNullBucket(OAtomicOperation atomicOperation) throws IOException {
        V removedValue;
        OCacheEntry nullCacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false);
        try {
            ONullBucket<V> nullBucket = new ONullBucket<V>(nullCacheEntry, this.valueSerializer, false);
            OSBTreeValue<V> treeValue = nullBucket.getValue();
            if (treeValue != null) {
                removedValue = this.readValue(treeValue, atomicOperation);
                nullBucket.removeValue();
            } else {
                removedValue = null;
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, nullCacheEntry);
        }
        if (removedValue != null) {
            this.updateSize(-1L, atomicOperation);
        }
        return removedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] removeKey(OAtomicOperation atomicOperation, long pageIndex, int itemIndex) throws IOException {
        byte[] removedValue;
        OCacheEntry keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false);
        try {
            OPrefixBTreeBucket<V> keyBucket = new OPrefixBTreeBucket<V>(keyBucketCacheEntry, this.keySerializer, this.valueSerializer, this.encryption);
            removedValue = keyBucket.getRawValue(itemIndex);
            keyBucket.remove(itemIndex);
            this.updateSize(-1L, atomicOperation);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
        }
        return removedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeCursor<String, V> iterateEntriesMinor(String key, boolean inclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                OSBTreeCursor<String, V> oSBTreeCursor;
                this.acquireSharedLock();
                try {
                    if (ascSortOrder) break block8;
                    oSBTreeCursor = this.iterateEntriesMinorDesc(key, inclusive);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oSBTreeCursor;
            }
            OSBTreeCursor<String, V> oSBTreeCursor = this.iterateEntriesMinorAsc(key, inclusive);
            this.releaseSharedLock();
            return oSBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeCursor<String, V> iterateEntriesMajor(String key, boolean inclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                OSBTreeCursor<String, V> oSBTreeCursor;
                this.acquireSharedLock();
                try {
                    if (!ascSortOrder) break block8;
                    oSBTreeCursor = this.iterateEntriesMajorAsc(key, inclusive);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oSBTreeCursor;
            }
            OSBTreeCursor<String, V> oSBTreeCursor = this.iterateEntriesMajorDesc(key, inclusive);
            this.releaseSharedLock();
            return oSBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    public String firstKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String lastKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public OSBTreeKeyCursor<String> keyCursor() {
        return new OSBTreeFullKeyCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeCursor<String, V> iterateEntriesBetween(String keyFrom, boolean fromInclusive, String keyTo, boolean toInclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            block8: {
                OSBTreeCursor<String, V> oSBTreeCursor;
                this.acquireSharedLock();
                try {
                    if (!ascSortOrder) break block8;
                    oSBTreeCursor = this.iterateEntriesBetweenAscOrder(keyFrom, fromInclusive, keyTo, toInclusive);
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oSBTreeCursor;
            }
            OSBTreeCursor<String, V> oSBTreeCursor = this.iterateEntriesBetweenDescOrder(keyFrom, fromInclusive, keyTo, toInclusive);
            this.releaseSharedLock();
            return oSBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    public void flush() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            this.acquireSharedLock();
            try {
                this.writeCache.flush();
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    private void checkNullSupport(String key) {
        if (key == null && !this.nullPointerSupport) {
            throw new OPrefixBTreeException("Null keys are not supported.", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSize(long diffSize, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rootCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false);
        try {
            OPrefixBTreeBucket<V> rootBucket = new OPrefixBTreeBucket<V>(rootCacheEntry, this.keySerializer, this.valueSerializer, this.encryption);
            rootBucket.setTreeSize(rootBucket.getTreeSize() + diffSize);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rootCacheEntry);
        }
    }

    private OSBTreeCursor<String, V> iterateEntriesMinorDesc(String key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, new Object[]{OType.STRING});
        return new OSBTreeCursorBackward(null, key, false, inclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSBTreeCursor<String, V> iterateEntriesMinorAsc(String key, boolean inclusive) {
        this.acquireSharedLock();
        try {
            key = this.keySerializer.preprocess(key, new Object[]{OType.STRING});
            OSBTreeCursorForward oSBTreeCursorForward = new OSBTreeCursorForward(null, key, false, inclusive);
            return oSBTreeCursorForward;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private OSBTreeCursor<String, V> iterateEntriesMajorAsc(String key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, new Object[]{OType.STRING});
        return new OSBTreeCursorForward(key, null, inclusive, false);
    }

    private OSBTreeCursor<String, V> iterateEntriesMajorDesc(String key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, new Object[]{OType.STRING});
        return new OSBTreeCursorBackward(key, null, inclusive, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult firstItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 0L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        int itemIndex = 0;
        try {
            OPrefixBTreeBucket<V> bucket = new OPrefixBTreeBucket<V>(cacheEntry, this.keySerializer, this.valueSerializer, this.encryption);
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (bucket.isEmpty() || itemIndex > bucket.size()) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = Math.abs(pagePathItemUnit.itemIndex);
                    } else {
                        if (itemIndex < bucket.size()) {
                            path.add(new PagePathItemUnit(bucketIndex, -(itemIndex + 1)));
                            bucketIndex = bucket.getLeft(itemIndex);
                        } else {
                            path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                            bucketIndex = bucket.getRight(itemIndex - 1);
                        }
                        itemIndex = 0;
                    }
                } else if (bucket.isEmpty()) {
                    if (path.isEmpty()) {
                        pagePathItemUnit = null;
                        return pagePathItemUnit;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = Math.abs(pagePathItemUnit.itemIndex);
                } else {
                    ArrayList<Long> resultPath = new ArrayList<Long>(path.size() + 1);
                    ArrayList<Integer> items = new ArrayList<Integer>(path.size() + 1);
                    Object object = path.iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            resultPath.add(bucketIndex);
                            items.add(1);
                            object = new BucketSearchResult(0, resultPath, items);
                            return object;
                        }
                        PagePathItemUnit pathItemUnit = (PagePathItemUnit)object.next();
                        resultPath.add(pathItemUnit.pageIndex);
                        items.add(pathItemUnit.itemIndex);
                    }
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new OPrefixBTreeBucket<V>(cacheEntry, this.keySerializer, this.valueSerializer, this.encryption);
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult lastItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 0L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        OPrefixBTreeBucket<V> bucket = new OPrefixBTreeBucket<V>(cacheEntry, this.keySerializer, this.valueSerializer, this.encryption);
        int itemIndex = bucket.size() - 1;
        try {
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (itemIndex < -1) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = Math.abs(pagePathItemUnit.itemIndex) - 2;
                    } else {
                        if (itemIndex > -1) {
                            path.add(new PagePathItemUnit(bucketIndex, itemIndex + 1));
                            bucketIndex = bucket.getRight(itemIndex);
                        } else {
                            path.add(new PagePathItemUnit(bucketIndex, -1));
                            bucketIndex = bucket.getLeft(0);
                        }
                        itemIndex = OPrefixBTreeBucket.MAX_PAGE_SIZE_BYTES + 1;
                    }
                } else if (bucket.isEmpty()) {
                    if (path.isEmpty()) {
                        pagePathItemUnit = null;
                        return pagePathItemUnit;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = Math.abs(pagePathItemUnit.itemIndex) - 2;
                } else {
                    ArrayList<Long> resultPath = new ArrayList<Long>(path.size() + 1);
                    ArrayList<Integer> items = new ArrayList<Integer>(path.size() + 1);
                    Iterator iterator = path.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            resultPath.add(bucketIndex);
                            int lastItem = bucket.size();
                            items.add(lastItem);
                            BucketSearchResult bucketSearchResult = new BucketSearchResult(lastItem - 1, resultPath, items);
                            return bucketSearchResult;
                        }
                        PagePathItemUnit pathItemUnit = (PagePathItemUnit)iterator.next();
                        resultPath.add(pathItemUnit.pageIndex);
                        items.add(pathItemUnit.itemIndex);
                    }
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new OPrefixBTreeBucket<V>(cacheEntry, this.keySerializer, this.valueSerializer, this.encryption);
                if (itemIndex != OPrefixBTreeBucket.MAX_PAGE_SIZE_BYTES + 1) continue;
                itemIndex = bucket.size() - 1;
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    private OSBTreeCursor<String, V> iterateEntriesBetweenAscOrder(String keyFrom, boolean fromInclusive, String keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, new Object[]{OType.STRING});
        keyTo = this.keySerializer.preprocess(keyTo, new Object[]{OType.STRING});
        return new OSBTreeCursorForward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private OSBTreeCursor<String, V> iterateEntriesBetweenDescOrder(String keyFrom, boolean fromInclusive, String keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, new Object[]{OType.STRING});
        keyTo = this.keySerializer.preprocess(keyTo, new Object[]{OType.STRING});
        return new OSBTreeCursorBackward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private BucketUpdateSearchResult splitBucket(OPrefixBTreeBucket<V> bucketToSplit, OCacheEntry bucketToSplitEntry, List<Long> path, List<String> leftBoundaries, List<String> rightBoundaries, int keyIndex, String keyToInsert, OAtomicOperation atomicOperation) throws IOException {
        ArrayList<byte[]> rightEntries;
        int startRightIndex;
        String separator;
        long pageIndex = path.get(path.size() - 1);
        boolean splitLeaf = bucketToSplit.isLeaf();
        int bucketSize = bucketToSplit.size();
        int indexToSplit = bucketSize >>> 1;
        if (bucketSize < 100) {
            String separationKey;
            String separationKeyRight = bucketToSplit.getKeyWithoutPrefix(indexToSplit);
            if (splitLeaf) {
                if (indexToSplit > 0) {
                    String separationKeyLeft = bucketToSplit.getKeyWithoutPrefix(indexToSplit - 1);
                    separationKey = bucketToSplit.getBucketPrefix() + OPrefixBTree.findMinSeparationKey(separationKeyLeft, separationKeyRight);
                } else {
                    separationKey = bucketToSplit.getBucketPrefix() + separationKeyRight;
                }
            } else {
                separationKey = bucketToSplit.getBucketPrefix() + separationKeyRight;
            }
            separator = separationKey;
        } else {
            int diff = (int)((double)bucketSize * 0.1) / 2;
            int startSeparationIndex = indexToSplit - diff;
            int endSeparationIndex = indexToSplit + diff + 1;
            if (splitLeaf) {
                String minSeparationKey;
                String prevSeparationKey = bucketToSplit.getKeyWithoutPrefix(startSeparationIndex - 1);
                String separationKey = bucketToSplit.getKeyWithoutPrefix(startSeparationIndex);
                String absMinKey = minSeparationKey = OPrefixBTree.findMinSeparationKey(prevSeparationKey, separationKey);
                int absMinIndex = startSeparationIndex;
                for (int i = startSeparationIndex + 1; i < endSeparationIndex; ++i) {
                    separationKey = bucketToSplit.getKeyWithoutPrefix(i);
                    minSeparationKey = OPrefixBTree.findMinSeparationKey(prevSeparationKey, separationKey);
                    if (absMinKey.length() > minSeparationKey.length()) {
                        absMinKey = separationKey;
                        absMinIndex = i;
                    }
                    prevSeparationKey = separationKey;
                }
                separator = bucketToSplit.getBucketPrefix() + absMinKey;
                indexToSplit = absMinIndex;
            } else {
                String absMinKey = null;
                int absMinIndex = -1;
                for (int i = startSeparationIndex; i < endSeparationIndex; ++i) {
                    String separationKey = bucketToSplit.getKeyWithoutPrefix(i);
                    if (absMinKey != null && absMinKey.length() <= separationKey.length()) continue;
                    absMinKey = separationKey;
                    absMinIndex = i;
                }
                separator = bucketToSplit.getBucketPrefix() + absMinKey;
                indexToSplit = absMinIndex;
            }
        }
        int n = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1;
        if (pageIndex != 0L) {
            rightEntries = new ArrayList<byte[]>(indexToSplit);
            for (int i = startRightIndex; i < bucketSize; ++i) {
                rightEntries.add((byte[])bucketToSplit.getEntry(i));
            }
            return this.splitNonRootBucket(path, leftBoundaries, rightBoundaries, keyIndex, keyToInsert, pageIndex, bucketToSplit, splitLeaf, indexToSplit, separator, rightEntries, atomicOperation);
        }
        rightEntries = new ArrayList(indexToSplit);
        for (int i = startRightIndex; i < bucketSize; ++i) {
            rightEntries.add(bucketToSplit.getRawEntry(i));
        }
        return this.splitRootBucket(path, keyIndex, keyToInsert, bucketToSplitEntry, bucketToSplit, splitLeaf, indexToSplit, separator, rightEntries, atomicOperation);
    }

    private static String findMinSeparationKey(String keyLeft, String keyRight) {
        int minLen = Math.min(keyLeft.length(), keyRight.length());
        for (int i = 0; i < minLen; ++i) {
            if (keyLeft.charAt(i) == keyRight.charAt(i)) continue;
            return keyRight.substring(0, i + 1);
        }
        if (keyRight.length() == minLen) {
            return keyRight;
        }
        return keyRight.substring(0, minLen + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketUpdateSearchResult splitNonRootBucket(List<Long> path, List<String> leftBoundaries, List<String> rightBoundaries, int keyIndex, String keyToInsert, long pageIndex, OPrefixBTreeBucket<V> bucketToSplit, boolean splitLeaf, int indexToSplit, String separationKey, List<OPrefixBTreeBucket.SBTreeEntry<V>> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry = this.addPage(atomicOperation, this.fileId, false);
        String leftBoundary = leftBoundaries.get(leftBoundaries.size() - 2);
        String rightBoundary = rightBoundaries.get(rightBoundaries.size() - 2);
        String leftBucketPrefix = leftBoundary != null ? OPrefixBTree.findCommonPrefix(leftBoundary, separationKey) : "";
        String rightBucketPrefix = rightBoundary != null ? OPrefixBTree.findCommonPrefix(separationKey, rightBoundary) : "";
        try {
            BucketUpdateSearchResult bucketUpdateSearchResult;
            block18: {
                ArrayList<String> resultRightBoundaries;
                ArrayList<String> resultLeftBoundaries;
                ArrayList<Long> resultPath;
                int insertionIndex;
                OPrefixBTreeBucket parentBucket;
                OCacheEntry parentCacheEntry;
                block16: {
                    BucketUpdateSearchResult bucketUpdateSearchResult2;
                    block17: {
                        OPrefixBTreeBucket<V> newRightBucket = new OPrefixBTreeBucket<V>(rightBucketEntry, splitLeaf, this.keySerializer, this.valueSerializer, this.encryption, rightBucketPrefix);
                        newRightBucket.addAllWithPrefix(rightEntries, rightBucketPrefix);
                        bucketToSplit.shrinkWithPrefix(indexToSplit, leftBucketPrefix);
                        long parentIndex = path.get(path.size() - 2);
                        parentCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false);
                        try {
                            parentBucket = new OPrefixBTreeBucket(parentCacheEntry, this.keySerializer, this.valueSerializer, this.encryption);
                            OPrefixBTreeBucket.SBTreeEntry parentEntry = new OPrefixBTreeBucket.SBTreeEntry((int)pageIndex, (int)rightBucketEntry.getPageIndex(), separationKey, null);
                            insertionIndex = parentBucket.find(separationKey);
                            assert (insertionIndex < 0);
                            insertionIndex = -insertionIndex - 1;
                            while (!parentBucket.addEntry(insertionIndex, parentEntry, true)) {
                                BucketUpdateSearchResult bucketSearchResult = this.splitBucket(parentBucket, parentCacheEntry, path.subList(0, path.size() - 1), leftBoundaries.subList(0, leftBoundaries.size() - 1), rightBoundaries.subList(0, rightBoundaries.size() - 1), insertionIndex, separationKey, atomicOperation);
                                parentIndex = bucketSearchResult.getLastPathItem();
                                path = bucketSearchResult.path;
                                leftBoundaries = bucketSearchResult.leftBoundaries;
                                rightBoundaries = bucketSearchResult.rightBoundaries;
                                insertionIndex = bucketSearchResult.itemIndex;
                                path.add(null);
                                leftBoundaries.add(null);
                                rightBoundaries.add(null);
                                if (parentIndex != parentCacheEntry.getPageIndex()) {
                                    this.releasePageFromWrite(atomicOperation, parentCacheEntry);
                                    parentCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false);
                                }
                                parentBucket = new OPrefixBTreeBucket<V>(parentCacheEntry, this.keySerializer, this.valueSerializer, this.encryption);
                            }
                            resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
                            resultLeftBoundaries = new ArrayList<String>(leftBoundaries.subList(0, leftBoundaries.size() - 1));
                            resultRightBoundaries = new ArrayList<String>(rightBoundaries.subList(0, rightBoundaries.size() - 1));
                            if (this.comparator.compare(keyToInsert, separationKey) >= 0) break block16;
                            resultPath.add(pageIndex);
                            resultRightBoundaries.add(separationKey);
                            if (insertionIndex > 0) {
                                resultLeftBoundaries.add(parentBucket.getBucketPrefix() + parentBucket.getKeyWithoutPrefix(insertionIndex - 1));
                            } else {
                                resultLeftBoundaries.add(null);
                            }
                            bucketUpdateSearchResult2 = new BucketUpdateSearchResult(keyIndex, resultPath, resultLeftBoundaries, resultRightBoundaries);
                            if (parentCacheEntry == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (parentCacheEntry != null) {
                                this.releasePageFromWrite(atomicOperation, parentCacheEntry);
                            }
                            throw throwable;
                        }
                        this.releasePageFromWrite(atomicOperation, parentCacheEntry);
                    }
                    return bucketUpdateSearchResult2;
                }
                resultPath.add(rightBucketEntry.getPageIndex());
                resultLeftBoundaries.add(separationKey);
                if (insertionIndex < parentBucket.size() - 1) {
                    resultRightBoundaries.add(parentBucket.getBucketPrefix() + parentBucket.getKeyWithoutPrefix(insertionIndex + 1));
                } else {
                    resultRightBoundaries.add(null);
                }
                bucketUpdateSearchResult = new BucketUpdateSearchResult(splitLeaf ? keyIndex - indexToSplit : keyIndex - indexToSplit - 1, resultPath, resultLeftBoundaries, resultRightBoundaries);
                if (parentCacheEntry == null) break block18;
                this.releasePageFromWrite(atomicOperation, parentCacheEntry);
            }
            return bucketUpdateSearchResult;
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
    }

    private static String findCommonPrefix(String keyOne, String keyTwo) {
        int commonLen = Math.min(keyOne.length(), keyTwo.length());
        int commonIndex = -1;
        String suffix = "";
        int i = 0;
        while (i < commonLen) {
            int res = keyOne.charAt(i) - keyTwo.charAt(i);
            if (res != 0) {
                if (res != -1 || i != commonLen - 1 || commonLen != keyTwo.length()) break;
                suffix = keyOne.charAt(i) + "";
                break;
            }
            commonIndex = i++;
        }
        if (commonIndex == -1) {
            return "";
        }
        return keyOne.substring(0, commonIndex + 1) + suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketUpdateSearchResult splitRootBucket(List<Long> path, int keyIndex, String keyToInsert, OCacheEntry bucketEntry, OPrefixBTreeBucket<V> bucketToSplit, boolean splitLeaf, int indexToSplit, String separationKey, List<byte[]> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        long treeSize = bucketToSplit.getTreeSize();
        ArrayList<byte[]> leftEntries = new ArrayList<byte[]>(indexToSplit);
        for (int i = 0; i < indexToSplit; ++i) {
            leftEntries.add(bucketToSplit.getRawEntry(i));
        }
        OCacheEntry leftBucketEntry = this.addPage(atomicOperation, this.fileId, false);
        OCacheEntry rightBucketEntry = this.addPage(atomicOperation, this.fileId, false);
        try {
            OPrefixBTreeBucket<V> newLeftBucket = new OPrefixBTreeBucket<V>(leftBucketEntry, splitLeaf, this.keySerializer, this.valueSerializer, this.encryption, "");
            newLeftBucket.addAllNoPrefix(leftEntries);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, leftBucketEntry);
        }
        try {
            OPrefixBTreeBucket<V> newRightBucket = new OPrefixBTreeBucket<V>(rightBucketEntry, splitLeaf, this.keySerializer, this.valueSerializer, this.encryption, "");
            newRightBucket.addAllNoPrefix(rightEntries);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        bucketToSplit = new OPrefixBTreeBucket<V>(bucketEntry, false, this.keySerializer, this.valueSerializer, this.encryption, "");
        bucketToSplit.setTreeSize(treeSize);
        bucketToSplit.addEntry(0, new OPrefixBTreeBucket.SBTreeEntry((int)leftBucketEntry.getPageIndex(), (int)rightBucketEntry.getPageIndex(), separationKey, null), true);
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        ArrayList<Object> resultLeftBoundaries = new ArrayList<Object>();
        ArrayList<Object> resultRightBoundaries = new ArrayList<Object>();
        resultLeftBoundaries.add(null);
        resultLeftBoundaries.add(null);
        resultRightBoundaries.add(null);
        resultRightBoundaries.add(null);
        if (this.comparator.compare(keyToInsert, separationKey) < 0) {
            resultPath.add(leftBucketEntry.getPageIndex());
            return new BucketUpdateSearchResult(keyIndex, resultPath, resultLeftBoundaries, resultRightBoundaries);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        return new BucketUpdateSearchResult(splitLeaf ? keyIndex - indexToSplit : keyIndex - indexToSplit - 1, resultPath, resultLeftBoundaries, resultRightBoundaries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketUpdateSearchResult findBucketForUpdate(String key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 0L;
        ArrayList<Long> path = new ArrayList<Long>();
        ArrayList<String> leftBoundaries = new ArrayList<String>();
        ArrayList<String> rightBoundaries = new ArrayList<String>();
        while (true) {
            if (path.size() > MAX_PATH_LENGTH) {
                throw new OPrefixBTreeException("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query. Key = " + key, this);
            }
            path.add(pageIndex);
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                int entryIndex;
                OPrefixBTreeBucket<V> keyBucket = new OPrefixBTreeBucket<V>(bucketEntry, this.keySerializer, this.valueSerializer, this.encryption);
                int index = keyBucket.find(key);
                if (keyBucket.isLeaf()) {
                    leftBoundaries.add(null);
                    rightBoundaries.add(null);
                    BucketUpdateSearchResult bucketUpdateSearchResult = new BucketUpdateSearchResult(index, path, leftBoundaries, rightBoundaries);
                    return bucketUpdateSearchResult;
                }
                boolean right = true;
                if (index >= 0) {
                    entryIndex = index;
                } else {
                    int insertionIndex = -index - 1;
                    if (insertionIndex >= keyBucket.size()) {
                        entryIndex = insertionIndex - 1;
                    } else {
                        entryIndex = insertionIndex;
                        right = false;
                    }
                }
                OPrefixBTreeBucket.SBTreeEntry<V> entry = keyBucket.getEntry(entryIndex);
                if (right) {
                    pageIndex = entry.rightChild;
                    leftBoundaries.add(entry.key);
                    if (entryIndex < keyBucket.size() - 1) {
                        rightBoundaries.add(keyBucket.getBucketPrefix() + keyBucket.getKeyWithoutPrefix(entryIndex + 1));
                        continue;
                    }
                    rightBoundaries.add(null);
                    continue;
                }
                pageIndex = entry.leftChild;
                rightBoundaries.add(entry.key);
                if (entryIndex > 0) {
                    leftBoundaries.add(keyBucket.getBucketPrefix() + keyBucket.getKeyWithoutPrefix(entryIndex - 1));
                    continue;
                }
                leftBoundaries.add(null);
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(String key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 0L;
        ArrayList<Long> path = new ArrayList<Long>();
        ArrayList<Integer> items = new ArrayList<Integer>();
        while (true) {
            if (path.size() > MAX_PATH_LENGTH) {
                throw new OPrefixBTreeException("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.", this);
            }
            path.add(pageIndex);
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                int itemIndex;
                int entryIndex;
                OPrefixBTreeBucket<V> keyBucket = new OPrefixBTreeBucket<V>(bucketEntry, this.keySerializer, this.valueSerializer, this.encryption);
                int index = keyBucket.find(key);
                if (index >= 0) {
                    entryIndex = index;
                    itemIndex = entryIndex + 1;
                } else {
                    int insertionIndex = -index - 1;
                    if (insertionIndex >= keyBucket.size()) {
                        entryIndex = insertionIndex - 1;
                        itemIndex = entryIndex + 1;
                    } else {
                        entryIndex = insertionIndex;
                        itemIndex = -(entryIndex + 1);
                    }
                }
                if (keyBucket.isLeaf()) {
                    items.add(index);
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, path, items);
                    return bucketSearchResult;
                }
                items.add(itemIndex);
                if (itemIndex > 0) {
                    pageIndex = keyBucket.getRight(entryIndex);
                    continue;
                }
                pageIndex = keyBucket.getLeft(entryIndex);
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
                continue;
            }
            break;
        }
    }

    private V readValue(OSBTreeValue<V> sbTreeValue, OAtomicOperation atomicOperation) throws IOException {
        if (!sbTreeValue.isLink()) {
            return sbTreeValue.getValue();
        }
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, sbTreeValue.getLink(), false);
        OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, false);
        int totalSize = valuePage.getSize();
        int currentSize = 0;
        byte[] value = new byte[totalSize];
        while (currentSize < totalSize) {
            currentSize = valuePage.readBinaryContent(value, currentSize);
            long nextPage = valuePage.getNextPage();
            if (nextPage < 0L) continue;
            this.releasePageFromRead(atomicOperation, cacheEntry);
            cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, nextPage, false);
            valuePage = new OSBTreeValuePage(cacheEntry, false);
        }
        this.releasePageFromRead(atomicOperation, cacheEntry);
        return this.valueSerializer.deserializeNativeObject(value, 0);
    }

    private Map.Entry<String, V> convertToMapEntry(OPrefixBTreeBucket.SBTreeEntry<V> treeEntry, OAtomicOperation atomicOperation) throws IOException {
        final String key = treeEntry.key;
        final Object value = this.readValue(treeEntry.value, atomicOperation);
        return new Map.Entry<String, V>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                throw new UnsupportedOperationException("setValue");
            }
        };
    }

    static /* synthetic */ OAtomicOperationsManager access$1200(OPrefixBTree x0) {
        return x0.atomicOperationsManager;
    }

    static /* synthetic */ void access$1300(OPrefixBTree x0) {
        x0.acquireSharedLock();
    }

    static /* synthetic */ BucketSearchResult access$1400(OPrefixBTree x0, OAtomicOperation x1) throws IOException {
        return x0.firstItem(x1);
    }

    static /* synthetic */ BucketSearchResult access$1500(OPrefixBTree x0, String x1, OAtomicOperation x2) throws IOException {
        return x0.findBucket(x1, x2);
    }

    static /* synthetic */ long access$1800(OPrefixBTree x0) {
        return x0.fileId;
    }

    static /* synthetic */ OCacheEntry access$1900(OPrefixBTree x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ OBinarySerializer access$2000(OPrefixBTree x0) {
        return x0.keySerializer;
    }

    static /* synthetic */ OBinarySerializer access$2100(OPrefixBTree x0) {
        return x0.valueSerializer;
    }

    static /* synthetic */ OEncryption access$2200(OPrefixBTree x0) {
        return x0.encryption;
    }

    static /* synthetic */ void access$2300(OPrefixBTree x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ OCacheEntry access$2400(OPrefixBTree x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ OCacheEntry access$2500(OPrefixBTree x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$2600(OPrefixBTree x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ void access$2700(OPrefixBTree x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ OCacheEntry access$2800(OPrefixBTree x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ Map.Entry access$2900(OPrefixBTree x0, OPrefixBTreeBucket.SBTreeEntry x1, OAtomicOperation x2) throws IOException {
        return x0.convertToMapEntry(x1, x2);
    }

    static /* synthetic */ void access$3000(OPrefixBTree x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ void access$3100(OPrefixBTree x0) {
        x0.releaseSharedLock();
    }

    static /* synthetic */ OAtomicOperationsManager access$3200(OPrefixBTree x0) {
        return x0.atomicOperationsManager;
    }

    static /* synthetic */ OAtomicOperationsManager access$3300(OPrefixBTree x0) {
        return x0.atomicOperationsManager;
    }

    static /* synthetic */ void access$3400(OPrefixBTree x0) {
        x0.acquireSharedLock();
    }

    static /* synthetic */ OCacheEntry access$3500(OPrefixBTree x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$3600(OPrefixBTree x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ OCacheEntry access$3700(OPrefixBTree x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ OCacheEntry access$3800(OPrefixBTree x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$3900(OPrefixBTree x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ void access$4000(OPrefixBTree x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ OCacheEntry access$4100(OPrefixBTree x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ Comparator access$4200(OPrefixBTree x0) {
        return x0.comparator;
    }

    static /* synthetic */ void access$4300(OPrefixBTree x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ void access$4400(OPrefixBTree x0) {
        x0.releaseSharedLock();
    }

    static /* synthetic */ OAtomicOperationsManager access$4500(OPrefixBTree x0) {
        return x0.atomicOperationsManager;
    }

    static /* synthetic */ OAtomicOperationsManager access$4600(OPrefixBTree x0) {
        return x0.atomicOperationsManager;
    }

    static /* synthetic */ void access$4700(OPrefixBTree x0) {
        x0.acquireSharedLock();
    }

    static /* synthetic */ BucketSearchResult access$4800(OPrefixBTree x0, OAtomicOperation x1) throws IOException {
        return x0.lastItem(x1);
    }

    static /* synthetic */ OCacheEntry access$4900(OPrefixBTree x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$5000(OPrefixBTree x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ OCacheEntry access$5100(OPrefixBTree x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ OCacheEntry access$5200(OPrefixBTree x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$5300(OPrefixBTree x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ void access$5400(OPrefixBTree x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ OCacheEntry access$5500(OPrefixBTree x0, OAtomicOperation x1, long x2, long x3, boolean x4) throws IOException {
        return x0.loadPageForRead(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$5600(OPrefixBTree x0, OAtomicOperation x1, OCacheEntry x2) {
        x0.releasePageFromRead(x1, x2);
    }

    static /* synthetic */ void access$5700(OPrefixBTree x0) {
        x0.releaseSharedLock();
    }

    static /* synthetic */ OAtomicOperationsManager access$5800(OPrefixBTree x0) {
        return x0.atomicOperationsManager;
    }

    private final class OSBTreeCursorBackward
    implements OSBTreeCursor<String, V> {
        private final String fromKey;
        private String toKey;
        private final boolean fromKeyInclusive;
        private boolean toKeyInclusive;
        private final List<Map.Entry<String, V>> dataCache = new ArrayList();
        private Iterator<Map.Entry<String, V>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OSBTreeCursorBackward(String fromKey, String toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (toKey == null) {
                this.toKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map.Entry<String, V> next(int prefetchSize) {
            if (this.dataCacheIterator == null) {
                return null;
            }
            if (this.dataCacheIterator.hasNext()) {
                entry = this.dataCacheIterator.next();
                this.toKey = entry.getKey();
                this.toKeyInclusive = false;
                return entry;
            }
            this.dataCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            OPrefixBTree.access$4600(OPrefixBTree.this).acquireReadLock(OPrefixBTree.this);
            try {
                block40: {
                    block41: {
                        OPrefixBTree.access$4700(OPrefixBTree.this);
                        atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                        bucketSearchResult = this.toKey != null ? OPrefixBTree.access$1500(OPrefixBTree.this, this.toKey, atomicOperation) : OPrefixBTree.access$4800(OPrefixBTree.this, atomicOperation);
                        if (bucketSearchResult == null) {
                            this.dataCacheIterator = null;
                            var4_6 = null;
                            return var4_6;
                        }
                        pageIndex = bucketSearchResult.getLastPathItem();
                        itemIndex = BucketSearchResult.access$000(bucketSearchResult) >= 0 ? (this.toKeyInclusive != false ? BucketSearchResult.access$000(bucketSearchResult) : BucketSearchResult.access$000(bucketSearchResult) - 1) : -BucketSearchResult.access$000(bucketSearchResult) - 2;
                        currentPath = new LinkedList<ORawPair<Object, Object>>();
                        for (i = 0; i < BucketSearchResult.access$1600(bucketSearchResult).size(); ++i) {
                            currentPath.add(new ORawPair<E, E>(BucketSearchResult.access$1600(bucketSearchResult).get(i), BucketSearchResult.access$1700(bucketSearchResult).get(i)));
                        }
                        cacheEntry = OPrefixBTree.access$4900(OPrefixBTree.this, atomicOperation, OPrefixBTree.access$1800(OPrefixBTree.this), pageIndex, false);
                        bucket = new OPrefixBTreeBucket<V>(cacheEntry, OPrefixBTree.access$2000(OPrefixBTree.this), OPrefixBTree.access$2100(OPrefixBTree.this), OPrefixBTree.access$2200(OPrefixBTree.this));
                        block23: while (this.dataCache.size() < prefetchSize) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                if (itemIndex < 0) {
                                    OPrefixBTree.access$5000(OPrefixBTree.this, atomicOperation, cacheEntry);
                                    cacheEntry = null;
                                    currentPath.removeLast();
                                    pathItem = (ORawPair<Long, Integer>)currentPath.peekLast();
                                    break block40;
                                }
                                entry = OPrefixBTree.access$2900(OPrefixBTree.this, bucket.getEntry(itemIndex), atomicOperation);
                                --itemIndex;
                                if (this.toKey != null && (this.toKeyInclusive == false ? OPrefixBTree.access$4200(OPrefixBTree.this).compare(entry.getKey(), this.toKey) >= 0 : OPrefixBTree.access$4200(OPrefixBTree.this).compare(entry.getKey(), this.toKey) > 0)) continue block23;
                                if (this.fromKey == null || !(this.fromKeyInclusive != false ? OPrefixBTree.access$4200(OPrefixBTree.this).compare(entry.getKey(), this.fromKey) < 0 : OPrefixBTree.access$4200(OPrefixBTree.this).compare(entry.getKey(), this.fromKey) <= 0)) {
                                    this.dataCache.add(entry);
                                    continue block23;
                                }
                                break block41;
                                break;
                            }
                        }
                        break block41;
                        finally {
                            if (cacheEntry != null) {
                                OPrefixBTree.access$5600(OPrefixBTree.this, atomicOperation, cacheEntry);
                            }
                        }
                        finally {
                            OPrefixBTree.access$5700(OPrefixBTree.this);
                        }
                    }
                    if (this.dataCache.isEmpty()) {
                        this.dataCacheIterator = null;
                        return null;
                    }
                    this.dataCacheIterator = this.dataCache.iterator();
                    entry = this.dataCacheIterator.next();
                    this.toKey = entry.getKey();
                    this.toKeyInclusive = false;
                    return entry;
                }
                while (pathItem != null) {
                    pathIndex = (Long)pathItem.getFirst();
                    pathItemIndex = (Integer)pathItem.getSecond();
                    parentBucketCacheEntry = OPrefixBTree.access$5100(OPrefixBTree.this, atomicOperation, OPrefixBTree.access$1800(OPrefixBTree.this), pathIndex, false);
                    try {
                        parentBucket = new OPrefixBTreeBucket<V>(parentBucketCacheEntry, OPrefixBTree.access$2000(OPrefixBTree.this), OPrefixBTree.access$2100(OPrefixBTree.this), OPrefixBTree.access$2200(OPrefixBTree.this));
                        cItemIndex = Math.abs(pathItemIndex) - 1;
                        if (pathItemIndex < 0) {
                            --cItemIndex;
                        }
                        currentPath.removeLast();
                        if (cItemIndex < 0) {
                            pathItem = (ORawPair)currentPath.peekLast();
                            continue;
                        }
                        pathItem = new ORawPair<Long, Integer>(pathIndex, -(cItemIndex + 1));
                        currentPath.add(pathItem);
                        cacheEntry = OPrefixBTree.access$5200(OPrefixBTree.this, atomicOperation, OPrefixBTree.access$1800(OPrefixBTree.this), parentBucket.getLeft(cItemIndex), false);
                        bucket = new OPrefixBTreeBucket<V>(cacheEntry, OPrefixBTree.access$2000(OPrefixBTree.this), OPrefixBTree.access$2100(OPrefixBTree.this), OPrefixBTree.access$2200(OPrefixBTree.this));
                        break;
                    }
                    finally {
                        OPrefixBTree.access$5300(OPrefixBTree.this, atomicOperation, parentBucketCacheEntry);
                    }
                }
                if (pathItem == null) {
                    if (this.dataCache.isEmpty()) {
                        this.dataCacheIterator = null;
                        pathIndex = null;
                        return pathIndex;
                    }
                    this.dataCacheIterator = this.dataCache.iterator();
                    entry = this.dataCacheIterator.next();
                    this.toKey = entry.getKey();
                    this.toKeyInclusive = false;
                    var12_19 = entry;
                    return var12_19;
                }
                while (true) {
                    if (bucket.isLeaf()) {
                        currentPath.add(new ORawPair<Long, Integer>(cacheEntry.getPageIndex(), 0));
                        itemIndex = bucket.size() - 1;
                        ** continue;
                    }
                    lastIndex = bucket.size() - 1;
                    currentPath.add(new ORawPair<Long, Integer>(cacheEntry.getPageIndex(), lastIndex + 1));
                    childIndex = bucket.getRight(lastIndex);
                    OPrefixBTree.access$5400(OPrefixBTree.this, atomicOperation, cacheEntry);
                    cacheEntry = OPrefixBTree.access$5500(OPrefixBTree.this, atomicOperation, OPrefixBTree.access$1800(OPrefixBTree.this), childIndex, false);
                    bucket = new OPrefixBTreeBucket<V>(cacheEntry, OPrefixBTree.access$2000(OPrefixBTree.this), OPrefixBTree.access$2100(OPrefixBTree.this), OPrefixBTree.access$2200(OPrefixBTree.this));
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OPrefixBTreeException("Error during element iteration", OPrefixBTree.this), e);
            }
            finally {
                OPrefixBTree.access$5800(OPrefixBTree.this).releaseReadLock(OPrefixBTree.this);
            }
        }
    }

    private final class OSBTreeCursorForward
    implements OSBTreeCursor<String, V> {
        private String fromKey;
        private final String toKey;
        private boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private final List<Map.Entry<String, V>> dataCache = new ArrayList();
        private Iterator<Map.Entry<String, V>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OSBTreeCursorForward(String fromKey, String toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (fromKey == null) {
                this.fromKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map.Entry<String, V> next(int prefetchSize) {
            if (this.dataCacheIterator == null) {
                return null;
            }
            if (this.dataCacheIterator.hasNext()) {
                entry = this.dataCacheIterator.next();
                this.fromKey = entry.getKey();
                this.fromKeyInclusive = false;
                return entry;
            }
            this.dataCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            if (prefetchSize == 0) {
                prefetchSize = 1;
            }
            OPrefixBTree.access$3300(OPrefixBTree.this).acquireReadLock(OPrefixBTree.this);
            try {
                block41: {
                    block42: {
                        OPrefixBTree.access$3400(OPrefixBTree.this);
                        atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                        bucketSearchResult = this.fromKey != null ? OPrefixBTree.access$1500(OPrefixBTree.this, this.fromKey, atomicOperation) : OPrefixBTree.access$1400(OPrefixBTree.this, atomicOperation);
                        if (bucketSearchResult == null) {
                            this.dataCacheIterator = null;
                            var4_6 = null;
                            return var4_6;
                        }
                        pageIndex = bucketSearchResult.getLastPathItem();
                        itemIndex = BucketSearchResult.access$000(bucketSearchResult) >= 0 ? (this.fromKeyInclusive != false ? BucketSearchResult.access$000(bucketSearchResult) : BucketSearchResult.access$000(bucketSearchResult) + 1) : -BucketSearchResult.access$000(bucketSearchResult) - 1;
                        currentPath = new LinkedList<ORawPair<Object, Object>>();
                        for (i = 0; i < BucketSearchResult.access$1600(bucketSearchResult).size(); ++i) {
                            currentPath.add(new ORawPair<E, E>(BucketSearchResult.access$1600(bucketSearchResult).get(i), BucketSearchResult.access$1700(bucketSearchResult).get(i)));
                        }
                        cacheEntry = OPrefixBTree.access$3500(OPrefixBTree.this, atomicOperation, OPrefixBTree.access$1800(OPrefixBTree.this), pageIndex, false);
                        bucket = new OPrefixBTreeBucket<V>(cacheEntry, OPrefixBTree.access$2000(OPrefixBTree.this), OPrefixBTree.access$2100(OPrefixBTree.this), OPrefixBTree.access$2200(OPrefixBTree.this));
                        block23: while (this.dataCache.size() < prefetchSize) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                if (itemIndex >= bucket.size()) {
                                    OPrefixBTree.access$3600(OPrefixBTree.this, atomicOperation, cacheEntry);
                                    cacheEntry = null;
                                    currentPath.removeLast();
                                    pathItem = (ORawPair<Long, Integer>)currentPath.peekLast();
                                    break block41;
                                }
                                entry = OPrefixBTree.access$2900(OPrefixBTree.this, bucket.getEntry(itemIndex), atomicOperation);
                                ++itemIndex;
                                if (this.fromKey != null && (this.fromKeyInclusive == false ? OPrefixBTree.access$4200(OPrefixBTree.this).compare(entry.getKey(), this.fromKey) <= 0 : OPrefixBTree.access$4200(OPrefixBTree.this).compare(entry.getKey(), this.fromKey) < 0)) continue block23;
                                if (this.toKey == null || !(this.toKeyInclusive != false ? OPrefixBTree.access$4200(OPrefixBTree.this).compare(entry.getKey(), this.toKey) > 0 : OPrefixBTree.access$4200(OPrefixBTree.this).compare(entry.getKey(), this.toKey) >= 0)) {
                                    this.dataCache.add(entry);
                                    continue block23;
                                }
                                break block42;
                                break;
                            }
                        }
                        break block42;
                        finally {
                            if (cacheEntry != null) {
                                OPrefixBTree.access$4300(OPrefixBTree.this, atomicOperation, cacheEntry);
                            }
                        }
                        finally {
                            OPrefixBTree.access$4400(OPrefixBTree.this);
                        }
                    }
                    if (this.dataCache.isEmpty()) {
                        this.dataCacheIterator = null;
                        return null;
                    }
                    this.dataCacheIterator = this.dataCache.iterator();
                    entry = this.dataCacheIterator.next();
                    this.fromKey = entry.getKey();
                    this.fromKeyInclusive = false;
                    return entry;
                }
                while (pathItem != null) {
                    pathIndex = (Long)pathItem.getFirst();
                    pathItemIndex = (Integer)pathItem.getSecond();
                    parentBucketCacheEntry = OPrefixBTree.access$3700(OPrefixBTree.this, atomicOperation, OPrefixBTree.access$1800(OPrefixBTree.this), pathIndex, false);
                    try {
                        parentBucket = new OPrefixBTreeBucket<V>(parentBucketCacheEntry, OPrefixBTree.access$2000(OPrefixBTree.this), OPrefixBTree.access$2100(OPrefixBTree.this), OPrefixBTree.access$2200(OPrefixBTree.this));
                        cItemIndex = Math.abs(pathItemIndex) - 1;
                        if (pathItemIndex > 0) {
                            ++cItemIndex;
                        }
                        currentPath.removeLast();
                        if (cItemIndex >= parentBucket.size()) {
                            pathItem = (ORawPair)currentPath.peekLast();
                            continue;
                        }
                        pathItem = new ORawPair<Long, Integer>(pathIndex, cItemIndex + 1);
                        currentPath.add(pathItem);
                        cacheEntry = OPrefixBTree.access$3800(OPrefixBTree.this, atomicOperation, OPrefixBTree.access$1800(OPrefixBTree.this), parentBucket.getRight(cItemIndex), false);
                        bucket = new OPrefixBTreeBucket<V>(cacheEntry, OPrefixBTree.access$2000(OPrefixBTree.this), OPrefixBTree.access$2100(OPrefixBTree.this), OPrefixBTree.access$2200(OPrefixBTree.this));
                        break;
                    }
                    finally {
                        OPrefixBTree.access$3900(OPrefixBTree.this, atomicOperation, parentBucketCacheEntry);
                    }
                }
                if (pathItem == null) {
                    if (this.dataCache.isEmpty()) {
                        this.dataCacheIterator = null;
                        pathIndex = null;
                        return pathIndex;
                    }
                    this.dataCacheIterator = this.dataCache.iterator();
                    entry = this.dataCacheIterator.next();
                    this.fromKey = entry.getKey();
                    this.fromKeyInclusive = false;
                    var12_22 = entry;
                    return var12_22;
                }
                while (true) {
                    if (bucket.isLeaf()) {
                        currentPath.add(new ORawPair<Long, Integer>(cacheEntry.getPageIndex(), 0));
                        itemIndex = 0;
                        ** continue;
                    }
                    currentPath.add(new ORawPair<Long, Integer>(cacheEntry.getPageIndex(), -1));
                    childIndex = bucket.getLeft(0);
                    OPrefixBTree.access$4000(OPrefixBTree.this, atomicOperation, cacheEntry);
                    cacheEntry = OPrefixBTree.access$4100(OPrefixBTree.this, atomicOperation, OPrefixBTree.access$1800(OPrefixBTree.this), childIndex, false);
                    bucket = new OPrefixBTreeBucket<V>(cacheEntry, OPrefixBTree.access$2000(OPrefixBTree.this), OPrefixBTree.access$2100(OPrefixBTree.this), OPrefixBTree.access$2200(OPrefixBTree.this));
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OPrefixBTreeException("Error during element iteration", OPrefixBTree.this), e);
            }
            finally {
                OPrefixBTree.access$4500(OPrefixBTree.this).releaseReadLock(OPrefixBTree.this);
            }
        }
    }

    public class OSBTreeFullKeyCursor
    implements OSBTreeKeyCursor<String> {
        private List<String> keysCache = new ArrayList<String>();
        private Iterator<String> keysIterator = new OEmptyIterator<String>();
        private String lastKey;

        OSBTreeFullKeyCursor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String next(int prefetchSize) {
            if (this.keysIterator == null) {
                return null;
            }
            if (this.keysIterator.hasNext()) {
                this.lastKey = this.keysIterator.next();
                return this.lastKey;
            }
            this.keysCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            if (prefetchSize == 0) {
                prefetchSize = 1;
            }
            OPrefixBTree.access$1200(OPrefixBTree.this).acquireReadLock(OPrefixBTree.this);
            try {
                OPrefixBTree.access$1300(OPrefixBTree.this);
                atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                bucketSearchResult = this.lastKey == null ? OPrefixBTree.access$1400(OPrefixBTree.this, atomicOperation) : OPrefixBTree.access$1500(OPrefixBTree.this, this.lastKey, atomicOperation);
                if (bucketSearchResult == null) {
                    var4_5 = null;
                    return var4_5;
                }
                itemIndex = BucketSearchResult.access$000(bucketSearchResult) >= 0 ? (this.lastKey == null ? BucketSearchResult.access$000(bucketSearchResult) : BucketSearchResult.access$000(bucketSearchResult) + 1) : -BucketSearchResult.access$000(bucketSearchResult) - 1;
                pageIndex = bucketSearchResult.getLastPathItem();
                currentPath = new LinkedList<ORawPair<Object, Object>>();
                for (i = 0; i < BucketSearchResult.access$1600(bucketSearchResult).size(); ++i) {
                    currentPath.add(new ORawPair<E, E>(BucketSearchResult.access$1600(bucketSearchResult).get(i), BucketSearchResult.access$1700(bucketSearchResult).get(i)));
                }
                cacheEntry = OPrefixBTree.access$1900(OPrefixBTree.this, atomicOperation, OPrefixBTree.access$1800(OPrefixBTree.this), pageIndex, false);
                bucket = new OPrefixBTreeBucket<V>(cacheEntry, OPrefixBTree.access$2000(OPrefixBTree.this), OPrefixBTree.access$2100(OPrefixBTree.this), OPrefixBTree.access$2200(OPrefixBTree.this));
                block23: while (true) {
                    if (this.keysCache.size() < prefetchSize) ** GOTO lbl38
                    {
                        if (this.keysCache.isEmpty()) {
                            this.keysCache = null;
                            this.keysIterator = null;
                            return null;
                        }
                        this.keysIterator = this.keysCache.iterator();
                        return this.keysIterator.next();
lbl38:
                        // 2 sources

                        while (true) {
                            if (itemIndex >= bucket.size()) {
                                OPrefixBTree.access$2300(OPrefixBTree.this, atomicOperation, cacheEntry);
                                cacheEntry = null;
                                currentPath.removeLast();
                                pathItem = (ORawPair<Long, Integer>)currentPath.peekLast();
                                break block23;
                            }
                            entry = OPrefixBTree.access$2900(OPrefixBTree.this, bucket.getEntry(itemIndex), atomicOperation);
                            ++itemIndex;
                            this.keysCache.add((String)entry.getKey());
                            continue block23;
                            break;
                        }
                        finally {
                            if (cacheEntry != null) {
                                OPrefixBTree.access$3000(OPrefixBTree.this, atomicOperation, cacheEntry);
                            }
                        }
                        ** finally { 
lbl56:
                        // 1 sources

                        OPrefixBTree.access$3100(OPrefixBTree.this);
                    }
                    break;
                }
                while (pathItem != null) {
                    pathIndex = (Long)pathItem.getFirst();
                    pathItemIndex = (Integer)pathItem.getSecond();
                    parentBucketCacheEntry = OPrefixBTree.access$2400(OPrefixBTree.this, atomicOperation, OPrefixBTree.access$1800(OPrefixBTree.this), pathIndex, false);
                    try {
                        parentBucket = new OPrefixBTreeBucket<V>(parentBucketCacheEntry, OPrefixBTree.access$2000(OPrefixBTree.this), OPrefixBTree.access$2100(OPrefixBTree.this), OPrefixBTree.access$2200(OPrefixBTree.this));
                        cItemIndex = Math.abs(pathItemIndex) - 1;
                        if (pathItemIndex > 0) {
                            ++cItemIndex;
                        }
                        currentPath.removeLast();
                        if (cItemIndex >= parentBucket.size()) {
                            pathItem = (ORawPair)currentPath.peekLast();
                            continue;
                        }
                        pathItem = new ORawPair<Long, Integer>(pathIndex, cItemIndex + 1);
                        currentPath.add(pathItem);
                        cacheEntry = OPrefixBTree.access$2500(OPrefixBTree.this, atomicOperation, OPrefixBTree.access$1800(OPrefixBTree.this), parentBucket.getRight(cItemIndex), false);
                        bucket = new OPrefixBTreeBucket<V>(cacheEntry, OPrefixBTree.access$2000(OPrefixBTree.this), OPrefixBTree.access$2100(OPrefixBTree.this), OPrefixBTree.access$2200(OPrefixBTree.this));
                        break;
                    }
                    finally {
                        OPrefixBTree.access$2600(OPrefixBTree.this, atomicOperation, parentBucketCacheEntry);
                    }
                }
                if (pathItem == null) {
                    if (this.keysCache.isEmpty()) {
                        this.keysCache = null;
                        this.keysIterator = null;
                        pathIndex = null;
                        return pathIndex;
                    }
                    this.keysIterator = this.keysCache.iterator();
                    pathIndex = this.lastKey = this.keysIterator.next();
                    return pathIndex;
                }
                while (true) {
                    if (bucket.isLeaf()) {
                        currentPath.add(new ORawPair<Long, Integer>(cacheEntry.getPageIndex(), 0));
                        itemIndex = 0;
                        ** continue;
                    }
                    currentPath.add(new ORawPair<Long, Integer>(cacheEntry.getPageIndex(), -1));
                    childIndex = bucket.getLeft(0);
                    OPrefixBTree.access$2700(OPrefixBTree.this, atomicOperation, cacheEntry);
                    cacheEntry = OPrefixBTree.access$2800(OPrefixBTree.this, atomicOperation, OPrefixBTree.access$1800(OPrefixBTree.this), childIndex, false);
                    bucket = new OPrefixBTreeBucket<V>(cacheEntry, OPrefixBTree.access$2000(OPrefixBTree.this), OPrefixBTree.access$2100(OPrefixBTree.this), OPrefixBTree.access$2200(OPrefixBTree.this));
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OPrefixBTreeException("Error during element iteration", OPrefixBTree.this), e);
            }
            finally {
                OPrefixBTree.access$3200(OPrefixBTree.this).releaseReadLock(OPrefixBTree.this);
            }
        }
    }

    private static final class PagePathItemUnit {
        private final long pageIndex;
        private final int itemIndex;

        private PagePathItemUnit(long pageIndex, int itemIndex) {
            this.pageIndex = pageIndex;
            this.itemIndex = itemIndex;
        }
    }

    private static class BucketSearchResult {
        private final int itemIndex;
        private final List<Long> path;
        private final List<Integer> items;

        private BucketSearchResult(int itemIndex, List<Long> path, List<Integer> items) {
            this.itemIndex = itemIndex;
            this.path = path;
            this.items = items;
        }

        long getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }

        static /* synthetic */ int access$000(BucketSearchResult x0) {
            return x0.itemIndex;
        }

        static /* synthetic */ List access$1600(BucketSearchResult x0) {
            return x0.path;
        }

        static /* synthetic */ List access$1700(BucketSearchResult x0) {
            return x0.items;
        }
    }

    private static class BucketUpdateSearchResult {
        private final int itemIndex;
        private final List<Long> path;
        private final List<String> leftBoundaries;
        private final List<String> rightBoundaries;

        private BucketUpdateSearchResult(int itemIndex, List<Long> path, List<String> leftBoundaries, List<String> rightBoundaries) {
            this.itemIndex = itemIndex;
            this.path = path;
            this.leftBoundaries = leftBoundaries;
            this.rightBoundaries = rightBoundaries;
        }

        long getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }
    }

    public static interface OSBTreeKeyCursor<String> {
        public String next(int var1);
    }

    public static interface OSBTreeCursor<String, V> {
        public Map.Entry<String, V> next(int var1);
    }
}

