/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTreeValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class OPrefixBTreeBucket<V>
extends ODurablePage {
    private static final int BUCKET_PREFIX_OFFSET = 28;
    private int freePointerOffset;
    private int sizeOffset;
    private int isLeafOffset;
    private int treeSizeOffset;
    private int positionsArrayOffset;
    private final boolean isLeaf;
    private final OBinarySerializer<String> keySerializer;
    private final OBinarySerializer<V> valueSerializer;
    private final Comparator<? super Object> comparator = ODefaultComparator.INSTANCE;
    private final OEncryption encryption;
    private String bucketPrefix;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    OPrefixBTreeBucket(OCacheEntry cacheEntry, boolean isLeaf, OBinarySerializer<String> keySerializer, OBinarySerializer<V> valueSerializer, OEncryption encryption, String bucketPrefix) {
        super(cacheEntry);
        int bucketPrefixSize;
        this.isLeaf = isLeaf;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.encryption = encryption;
        if (encryption == null) {
            byte[] serializedPrefix = keySerializer.serializeNativeAsWhole(bucketPrefix, new Object[0]);
            this.setBinaryValue(28, serializedPrefix);
            bucketPrefixSize = serializedPrefix.length;
        } else {
            byte[] serializedPrefix = keySerializer.serializeNativeAsWhole(bucketPrefix, new Object[0]);
            byte[] encryptedPrefix = encryption.encrypt(serializedPrefix);
            this.setIntValue(28, encryptedPrefix.length);
            this.setBinaryValue(32, encryptedPrefix);
            bucketPrefixSize = encryptedPrefix.length + 4;
        }
        this.bucketPrefix = bucketPrefix;
        this.calculateOffsets(bucketPrefixSize);
        this.setIntValue(this.freePointerOffset, MAX_PAGE_SIZE_BYTES);
        this.setIntValue(this.sizeOffset, 0);
        this.setByteValue(this.isLeafOffset, (byte)(isLeaf ? 1 : 0));
        this.setLongValue(this.treeSizeOffset, 0L);
    }

    private void calculateOffsets(int bucketPrefixSize) {
        this.freePointerOffset = bucketPrefixSize + 28 + 4;
        this.sizeOffset = this.freePointerOffset + 4;
        this.isLeafOffset = this.sizeOffset + 4;
        this.treeSizeOffset = this.isLeafOffset + 1;
        this.positionsArrayOffset = this.treeSizeOffset + 8;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public OPrefixBTreeBucket(OCacheEntry cacheEntry, OBinarySerializer<String> keySerializer, OBinarySerializer<V> valueSerializer, OEncryption encryption) {
        super(cacheEntry);
        int commonPrefixSize;
        this.encryption = encryption;
        if (encryption == null) {
            commonPrefixSize = this.getObjectSizeInDirectMemory(keySerializer, 28);
            this.bucketPrefix = this.deserializeFromDirectMemory(keySerializer, 28);
        } else {
            int encryptedSize = this.getIntValue(28);
            byte[] encryptedKey = this.getBinaryValue(32, encryptedSize);
            byte[] serializedPrefix = encryption.decrypt(encryptedKey);
            this.bucketPrefix = keySerializer.deserializeNativeObject(serializedPrefix, 0);
            commonPrefixSize = encryptedSize + 4;
        }
        this.calculateOffsets(commonPrefixSize);
        this.isLeaf = this.getByteValue(this.isLeafOffset) > 0;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    void setTreeSize(long size) {
        this.setLongValue(this.treeSizeOffset, size);
    }

    long getTreeSize() {
        return this.getLongValue(this.treeSizeOffset);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String getBucketPrefix() {
        return this.bucketPrefix;
    }

    public int find(String key) {
        int size = this.size();
        int low = 0;
        int high = size - 1;
        if (key.length() < this.bucketPrefix.length()) {
            return -1;
        }
        if (!key.startsWith(this.bucketPrefix)) {
            if (key.compareTo(this.bucketPrefix) > 0) {
                return -(size + 1);
            }
            return -1;
        }
        key = key.substring(this.bucketPrefix.length());
        while (low <= high) {
            int mid = low + high >>> 1;
            String midVal = this.getKeyWithoutPrefix(mid);
            int cmp = this.comparator.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void remove(int entryIndex) {
        int entrySize;
        int entryPosition = this.getIntValue(this.positionsArrayOffset + entryIndex * 4);
        int keySize = this.encryption == null ? this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition) : this.getIntValue(entryPosition) + 4;
        if (this.isLeaf) {
            if (this.valueSerializer.isFixedLength()) {
                entrySize = keySize + this.valueSerializer.getFixedLength() + 1;
            } else {
                assert (this.getByteValue(entryPosition + keySize) == 0);
                entrySize = keySize + this.getObjectSizeInDirectMemory(this.valueSerializer, entryPosition + 1 + keySize) + 1;
            }
        } else {
            throw new IllegalStateException("Remove is applies to leaf buckets only");
        }
        int size = this.getIntValue(this.sizeOffset);
        if (entryIndex < size - 1) {
            this.moveData(this.positionsArrayOffset + (entryIndex + 1) * 4, this.positionsArrayOffset + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(this.sizeOffset, --size);
        int freePointer = this.getIntValue(this.freePointerOffset);
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        this.setIntValue(this.freePointerOffset, freePointer + entrySize);
        int currentPositionOffset = this.positionsArrayOffset;
        for (int i = 0; i < size; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
    }

    public int size() {
        return this.getIntValue(this.sizeOffset);
    }

    public SBTreeEntry<V> getEntry(int entryIndex) {
        String key;
        int entryPosition = this.getIntValue(entryIndex * 4 + this.positionsArrayOffset);
        if (this.isLeaf) {
            boolean isLinkValue;
            String key2;
            if (this.encryption == null) {
                key2 = this.deserializeFromDirectMemory(this.keySerializer, entryPosition);
                entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
            } else {
                int encryptionSize = this.getIntValue(entryPosition);
                byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptionSize);
                entryPosition += encryptedKey.length;
                byte[] serializedKey = this.encryption.decrypt(encryptedKey);
                key2 = this.keySerializer.deserializeNativeObject(serializedKey, 0);
            }
            boolean bl = isLinkValue = this.getByteValue(entryPosition) > 0;
            assert (!isLinkValue);
            V value = this.deserializeFromDirectMemory(this.valueSerializer, entryPosition + 1);
            return new SBTreeEntry<V>(-1, -1, this.bucketPrefix + key2, new OSBTreeValue<V>(false, -1L, value));
        }
        int leftChild = this.getIntValue(entryPosition);
        int rightChild = this.getIntValue(entryPosition += 4);
        entryPosition += 4;
        if (this.encryption == null) {
            key = this.deserializeFromDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptionSize = this.getIntValue(entryPosition);
            byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptionSize);
            byte[] serializedKey = this.encryption.decrypt(encryptedKey);
            key = this.keySerializer.deserializeNativeObject(serializedKey, 0);
        }
        return new SBTreeEntry(leftChild, rightChild, this.bucketPrefix + key, null);
    }

    public int getLeft(int entryIndex) {
        assert (!this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + this.positionsArrayOffset);
        return this.getIntValue(entryPosition);
    }

    public int getRight(int entryIndex) {
        assert (!this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + this.positionsArrayOffset);
        return this.getIntValue(entryPosition + 4);
    }

    public OSBTreeValue<V> getValue(int entryIndex) {
        assert (this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + this.positionsArrayOffset);
        if (this.encryption == null) {
            entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            entryPosition += 4 + encryptedSize;
        }
        boolean isLinkValue = this.getByteValue(entryPosition) > 0;
        long link = -1L;
        Object value = null;
        if (isLinkValue) {
            link = this.deserializeFromDirectMemory(OLongSerializer.INSTANCE, entryPosition + 1);
        } else {
            value = this.deserializeFromDirectMemory(this.valueSerializer, entryPosition + 1);
        }
        return new OSBTreeValue<Object>(link >= 0L, link, value);
    }

    byte[] getRawValue(int entryIndex) {
        assert (this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + this.positionsArrayOffset);
        if (this.encryption == null) {
            entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            entryPosition += 4 + encryptedSize;
        }
        assert (this.getByteValue(entryPosition) == 0);
        int valueSize = this.getObjectSizeInDirectMemory(this.valueSerializer, entryPosition + 1);
        return this.getBinaryValue(entryPosition + 1, valueSize);
    }

    String getKeyWithoutPrefix(int index) {
        int entryPosition = this.getIntValue(index * 4 + this.positionsArrayOffset);
        if (!this.isLeaf) {
            entryPosition += 8;
        }
        if (this.encryption == null) {
            return this.deserializeFromDirectMemory(this.keySerializer, entryPosition);
        }
        int encryptedSize = this.getIntValue(entryPosition);
        byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptedSize);
        byte[] serializedKey = this.encryption.decrypt(encryptedKey);
        return this.keySerializer.deserializeNativeObject(serializedKey, 0);
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    void addAllNoPrefix(List<byte[]> rawEntries) {
        for (int i = 0; i < rawEntries.size(); ++i) {
            this.appendRawEntry(i, rawEntries.get(i));
        }
        this.setIntValue(this.sizeOffset, rawEntries.size());
    }

    void addAllWithPrefix(List<SBTreeEntry<V>> entries, String bucketPrefix) {
        int bucketPrefixSize;
        byte[] serializedPrefix;
        if (this.encryption == null) {
            serializedPrefix = this.keySerializer.serializeNativeAsWhole(bucketPrefix, new Object[0]);
            this.setBinaryValue(28, serializedPrefix);
            bucketPrefixSize = serializedPrefix.length;
        } else {
            serializedPrefix = this.keySerializer.serializeNativeAsWhole(bucketPrefix, new Object[0]);
            byte[] encryptedPrefix = this.encryption.encrypt(serializedPrefix);
            this.setIntValue(28, encryptedPrefix.length);
            this.setBinaryValue(32, encryptedPrefix);
            bucketPrefixSize = encryptedPrefix.length + 4;
        }
        this.calculateOffsets(bucketPrefixSize);
        this.setIntValue(this.freePointerOffset, MAX_PAGE_SIZE_BYTES);
        this.setIntValue(this.sizeOffset, 0);
        this.setByteValue(this.isLeafOffset, (byte)(this.isLeaf ? 1 : 0));
        this.setLongValue(this.treeSizeOffset, 0L);
        this.bucketPrefix = bucketPrefix;
        for (int i = 0; i < entries.size(); ++i) {
            SBTreeEntry<V> entry = entries.get(i);
            this.addEntry(i, entry, false);
        }
    }

    void shrinkWithPrefix(int newSize, String bucketPrefix) {
        int bucketPrefixSize;
        byte[] serializedPrefix;
        ArrayList<SBTreeEntry<V>> treeEntries = new ArrayList<SBTreeEntry<V>>(newSize);
        for (int i = 0; i < newSize; ++i) {
            treeEntries.add(this.getEntry(i));
        }
        long treeSize = this.getLongValue(this.treeSizeOffset);
        if (this.encryption == null) {
            serializedPrefix = this.keySerializer.serializeNativeAsWhole(bucketPrefix, new Object[0]);
            this.setBinaryValue(28, serializedPrefix);
            bucketPrefixSize = serializedPrefix.length;
        } else {
            serializedPrefix = this.keySerializer.serializeNativeAsWhole(bucketPrefix, new Object[0]);
            byte[] encryptedPrefix = this.encryption.encrypt(serializedPrefix);
            this.setIntValue(28, encryptedPrefix.length);
            this.setBinaryValue(32, encryptedPrefix);
            bucketPrefixSize = encryptedPrefix.length + 4;
        }
        this.calculateOffsets(bucketPrefixSize);
        this.bucketPrefix = bucketPrefix;
        this.setIntValue(this.freePointerOffset, MAX_PAGE_SIZE_BYTES);
        this.setIntValue(this.sizeOffset, 0);
        this.setByteValue(this.isLeafOffset, (byte)(this.isLeaf ? 1 : 0));
        this.setLongValue(this.treeSizeOffset, treeSize);
        int index = 0;
        for (SBTreeEntry sBTreeEntry : treeEntries) {
            this.addEntry(index, sBTreeEntry, false);
            ++index;
        }
    }

    byte[] getRawEntry(int entryIndex) {
        int keySize;
        int entryPosition;
        int startEntryPosition = entryPosition = this.getIntValue(entryIndex * 4 + this.positionsArrayOffset);
        if (this.isLeaf) {
            int keySize2;
            if (this.encryption == null) {
                keySize2 = this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
            } else {
                int encryptedSize = this.getIntValue(entryPosition);
                keySize2 = 4 + encryptedSize;
            }
            assert (this.getByteValue(entryPosition += keySize2) == 0);
            int valueSize = this.getObjectSizeInDirectMemory(this.valueSerializer, entryPosition + 1);
            return this.getBinaryValue(startEntryPosition, keySize2 + valueSize + 1);
        }
        entryPosition += 8;
        if (this.encryption == null) {
            keySize = this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            keySize = 4 + encryptedSize;
        }
        return this.getBinaryValue(startEntryPosition, keySize + 8);
    }

    private void appendRawEntry(int index, byte[] rawEntry) {
        int freePointer = this.getIntValue(this.freePointerOffset);
        this.setIntValue(this.freePointerOffset, freePointer -= rawEntry.length);
        this.setIntValue(this.positionsArrayOffset + index * 4, freePointer);
        this.setBinaryValue(freePointer, rawEntry);
    }

    public boolean addEntry(int index, SBTreeEntry<V> treeEntry, boolean updateNeighbors) {
        int keySize;
        assert (treeEntry.key.startsWith(this.bucketPrefix));
        String key = treeEntry.key.substring(this.bucketPrefix.length());
        byte[] serializedKey = this.keySerializer.serializeNativeAsWhole(key, new Object[]{OType.STRING});
        byte[] encryptedKey = null;
        if (this.encryption == null) {
            keySize = serializedKey.length;
        } else {
            encryptedKey = this.encryption.encrypt(serializedKey);
            keySize = encryptedKey.length + 4;
        }
        int valueSize = 0;
        int entrySize = keySize;
        if (this.isLeaf) {
            valueSize = this.valueSerializer.isFixedLength() ? this.valueSerializer.getFixedLength() : this.valueSerializer.getObjectSize(treeEntry.value.getValue(), new Object[0]);
            entrySize += valueSize + 1;
        } else {
            entrySize += 8;
        }
        int size = this.size();
        int freePointer = this.getIntValue(this.freePointerOffset);
        if (freePointer - entrySize < (size + 1) * 4 + this.positionsArrayOffset) {
            return false;
        }
        if (index <= size - 1) {
            this.moveData(this.positionsArrayOffset + index * 4, this.positionsArrayOffset + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(this.freePointerOffset, freePointer -= entrySize);
        this.setIntValue(this.positionsArrayOffset + index * 4, freePointer);
        this.setIntValue(this.sizeOffset, size + 1);
        if (this.isLeaf) {
            if (this.encryption == null) {
                freePointer += this.setBinaryValue(freePointer, serializedKey);
            } else {
                this.setIntValue(freePointer, encryptedKey.length);
                freePointer += 4;
                freePointer += this.setBinaryValue(freePointer, encryptedKey);
            }
            freePointer += this.setByteValue(freePointer, treeEntry.value.isLink() ? (byte)1 : 0);
            byte[] serializedValue = this.valueSerializer.serializeNativeAsWhole(treeEntry.value.getValue(), new Object[0]);
            this.setBinaryValue(freePointer, serializedValue);
        } else {
            freePointer += this.setIntValue(freePointer, treeEntry.leftChild);
            freePointer += this.setIntValue(freePointer, treeEntry.rightChild);
            if (this.encryption == null) {
                this.setBinaryValue(freePointer, serializedKey);
            } else {
                this.setIntValue(freePointer, encryptedKey.length);
                this.setBinaryValue(freePointer += 4, encryptedKey);
            }
            if (updateNeighbors && ++size > 1) {
                if (index < size - 1) {
                    int nextEntryPosition = this.getIntValue(this.positionsArrayOffset + (index + 1) * 4);
                    this.setIntValue(nextEntryPosition, treeEntry.rightChild);
                }
                if (index > 0) {
                    int prevEntryPosition = this.getIntValue(this.positionsArrayOffset + (index - 1) * 4);
                    this.setIntValue(prevEntryPosition + 4, treeEntry.leftChild);
                }
            }
        }
        return true;
    }

    void updateValue(int index, byte[] value) {
        int entryPosition = this.getIntValue(index * 4 + this.positionsArrayOffset);
        if (this.encryption == null) {
            entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedValue = this.getIntValue(entryPosition);
            entryPosition += 4 + encryptedValue;
        }
        assert (this.getByteValue(entryPosition) == 0);
        this.setBinaryValue(++entryPosition, value);
    }

    public static final class SBTreeEntry<V>
    implements Comparable<SBTreeEntry<V>> {
        private final Comparator<? super String> comparator = ODefaultComparator.INSTANCE;
        final int leftChild;
        final int rightChild;
        public String key;
        public final OSBTreeValue<V> value;

        public SBTreeEntry(int leftChild, int rightChild, String key, OSBTreeValue<V> value) {
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SBTreeEntry that = (SBTreeEntry)o;
            return this.leftChild == that.leftChild && this.rightChild == that.rightChild && Objects.equals(this.comparator, that.comparator) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.comparator, this.leftChild, this.rightChild, this.key, this.value);
        }

        public String toString() {
            return "SBTreeEntry{leftChild=" + this.leftChild + ", rightChild=" + this.rightChild + ", key=" + this.key + ", value=" + this.value + '}';
        }

        @Override
        public int compareTo(SBTreeEntry<V> other) {
            return this.comparator.compare(this.key, other.key);
        }
    }
}

