/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManager;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase1Task;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase1TaskResult;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionResultPayload;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ONewDistributedResponseManager
implements ODistributedResponseManager {
    private final OTransactionPhase1Task iRequest;
    private final Collection<String> iNodes;
    private final Set<String> nodesConcurToTheQuorum;
    private final int availableNodes;
    private final int expectedResponses;
    private final int quorum;
    private final long timeout;
    private volatile int responseCount;
    private final List<String> debugNodeReplied = new ArrayList<String>();
    private volatile Map<Integer, List<OTransactionResultPayload>> resultsByType = new HashMap<Integer, List<OTransactionResultPayload>>();
    private volatile boolean finished = false;
    private volatile boolean quorumReached = false;
    private volatile Object finalResult;

    public ONewDistributedResponseManager(OTransactionPhase1Task iRequest, Collection<String> iNodes, Set<String> nodesConcurToTheQuorum, int availableNodes, int expectedResponses, int quorum) {
        this.iRequest = iRequest;
        this.iNodes = iNodes;
        this.nodesConcurToTheQuorum = nodesConcurToTheQuorum;
        this.availableNodes = availableNodes;
        this.expectedResponses = expectedResponses;
        this.quorum = quorum;
        this.timeout = iRequest.getSynchronousTimeout(expectedResponses);
    }

    public synchronized boolean setLocalResult(String localNodeName, Object localResult) {
        return this.addResult((OTransactionResultPayload)localResult);
    }

    public ODistributedResponse getFinalResponse() {
        return null;
    }

    public Object getGenericFinalResponse() {
        return this.finalResult;
    }

    public synchronized void removeServerBecauseUnreachable(String node) {
        ++this.responseCount;
        this.checkFinished(new ArrayList<OTransactionResultPayload>());
    }

    public synchronized boolean waitForSynchronousResponses() throws InterruptedException {
        boolean interrupted = false;
        while (true) {
            try {
                if (!this.quorumReached) {
                    this.wait(this.timeout);
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return this.quorumReached;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
    }

    public long getSynchTimeout() {
        return 0L;
    }

    public void cancel() {
    }

    public Set<String> getExpectedNodes() {
        return this.nodesConcurToTheQuorum;
    }

    public List<String> getRespondingNodes() {
        return this.debugNodeReplied;
    }

    public Collection<String> getConflictServers() {
        return null;
    }

    public Set<String> getServersWithoutFollowup() {
        return null;
    }

    public boolean addFollowupToServer(String node) {
        return false;
    }

    public boolean isSynchronousWaiting() {
        return false;
    }

    public ODistributedResponse getQuorumResponse() {
        return null;
    }

    public ODistributedRequestId getMessageId() {
        return null;
    }

    public ODistributedRequest getRequest() {
        return null;
    }

    public Object getResponseFromServer(String server) {
        return null;
    }

    public int getQuorum() {
        return 0;
    }

    public boolean executeInLock(OCallable<Boolean, ODistributedResponseManager> oCallable) {
        return false;
    }

    public synchronized boolean collectResponse(OTransactionPhase1TaskResult response, String senderNodeName) {
        this.debugNodeReplied.add(senderNodeName);
        return this.addResult(response.getResultPayload());
    }

    private boolean addResult(OTransactionResultPayload result) {
        List<OTransactionResultPayload> results = this.resultsByType.get(result.getResponseType());
        if (results == null) {
            results = new ArrayList<OTransactionResultPayload>();
            results.add(result);
            this.resultsByType.put(result.getResponseType(), results);
        } else {
            results.add(result);
        }
        ++this.responseCount;
        this.checkFinished(results);
        return this.finished;
    }

    private void checkFinished(List<OTransactionResultPayload> results) {
        if (results.size() >= this.quorum) {
            if (!this.quorumReached) {
                this.quorumReached = true;
                this.finalResult = results;
                this.notifyAll();
            }
            if (this.responseCount == this.expectedResponses) {
                this.finished = true;
            }
        } else if (this.responseCount == this.expectedResponses) {
            if (this.quorumReached) {
                this.finished = true;
            } else {
                this.finished = true;
                this.finalResult = null;
                this.finalResult = null;
                this.notifyAll();
            }
        }
    }

    public synchronized List<OTransactionResultPayload> getAllResponses() {
        ArrayList<OTransactionResultPayload> allResults = new ArrayList<OTransactionResultPayload>();
        for (List<OTransactionResultPayload> res : this.resultsByType.values()) {
            allResults.addAll(res);
        }
        return allResults;
    }

    public boolean collectResponse(ODistributedResponse response) {
        if (response.getPayload() instanceof OTransactionPhase1TaskResult) {
            return this.collectResponse((OTransactionPhase1TaskResult)response.getPayload(), response.getSenderNodeName());
        }
        if (response.getPayload() instanceof RuntimeException) {
            return this.collectResponse(new OTransactionPhase1TaskResult(new OTxException((RuntimeException)response.getPayload())), response.getSenderNodeName());
        }
        return this.collectResponse(new OTransactionPhase1TaskResult(new OTxException((RuntimeException)new ODistributedException("unknown payload:" + response.getPayload()))), response.getSenderNodeName());
    }

    public synchronized boolean isQuorumReached() {
        return this.quorumReached;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public void timeout() {
    }

    public long getSentOn() {
        return 0L;
    }

    public List<String> getMissingNodes() {
        return null;
    }

    public String getDatabaseName() {
        return null;
    }
}

