/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ONewDistributedTxContextImpl
implements ODistributedTxContext {
    private final ODistributedDatabaseImpl shared;
    private final ODistributedRequestId id;
    private final OTransactionInternal tx;
    private final long startedOn;
    private final List<ORID> lockedRids = new ArrayList<ORID>();
    private final List<Object> lockedKeys = new ArrayList<Object>();
    private Status status;

    public ONewDistributedTxContextImpl(ODistributedDatabaseImpl shared, ODistributedRequestId reqId, OTransactionInternal tx) {
        this.shared = shared;
        this.id = reqId;
        this.tx = tx;
        this.startedOn = System.currentTimeMillis();
    }

    public void lockIndexKey(Object key) {
        this.shared.getIndexKeyLockManager().lock(key);
        this.lockedKeys.add(key);
    }

    public void lock(ORID rid) {
        this.shared.getRecordLockManager().lock((Object)rid);
        this.lockedRids.add(rid);
    }

    public void lock(ORID rid, long timeout) {
        this.shared.getRecordLockManager().lock((Object)rid);
        this.lockedRids.add(rid);
    }

    public void addUndoTask(ORemoteTask undoTask) {
        throw new UnsupportedOperationException();
    }

    public ODistributedRequestId getReqId() {
        return this.id;
    }

    public synchronized void begin(ODatabaseDocumentInternal database, boolean local) {
        throw new UnsupportedOperationException();
    }

    public synchronized void commit(ODatabaseDocumentInternal database) {
        ((ODatabaseDocumentDistributed)database).internalCommit2pc(this);
    }

    public void fix(ODatabaseDocumentInternal database, List<ORemoteTask> fixTasks) {
        throw new UnsupportedOperationException();
    }

    public Set<ORecordId> rollback(ODatabaseDocumentInternal database) {
        return new HashSet<ORecordId>();
    }

    public void destroy() {
        this.unlock();
    }

    public void clearUndo() {
        throw new UnsupportedOperationException();
    }

    public void unlock() {
        for (ORID lockedRid : this.lockedRids) {
            this.shared.getRecordLockManager().unlock((Object)lockedRid);
        }
        this.lockedRids.clear();
        for (Object lockedKey : this.lockedKeys) {
            this.shared.getIndexKeyLockManager().unlock(lockedKey);
        }
        this.lockedKeys.clear();
    }

    public long getStartedOn() {
        return this.startedOn;
    }

    public Set<ORecordId> cancel(ODistributedServerManager current, ODatabaseDocumentInternal database) {
        return null;
    }

    public boolean isCanceled() {
        return false;
    }

    public OTransactionInternal getTransaction() {
        return this.tx;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public static enum Status {
        FAILED,
        SUCCESS,
        TIMEDOUT;

    }
}

