/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.task.OCopyDatabaseChunkTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class OSyncReceiver
implements Runnable {
    private ODistributedAbstractPlugin distributed;
    private final String databaseName;
    private final ODistributedDatabaseChunk firstChunk;
    private final AtomicReference<ODistributedMomentum> momentum;
    private final String fileName;
    private final String iNode;
    private final String dbPath;
    private final File file;
    private final CountDownLatch done = new CountDownLatch(1);

    public OSyncReceiver(ODistributedAbstractPlugin distributed, String databaseName, ODistributedDatabaseChunk firstChunk, AtomicReference<ODistributedMomentum> momentum, String fileName, String iNode, String dbPath, File file) {
        this.distributed = distributed;
        this.databaseName = databaseName;
        this.firstChunk = firstChunk;
        this.momentum = momentum;
        this.fileName = fileName;
        this.iNode = iNode;
        this.dbPath = dbPath;
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Thread.currentThread().setName("OrientDB installDatabase node=" + this.distributed.nodeName + " db=" + this.databaseName);
            ODistributedDatabaseChunk chunk = this.firstChunk;
            this.momentum.set(chunk.getMomentum());
            FileOutputStream fOut = new FileOutputStream(this.fileName, false);
            try {
                long fileSize = this.distributed.writeDatabaseChunk(1, chunk, fOut);
                int chunkNum = 2;
                while (!chunk.last) {
                    ODistributedResponse response = this.distributed.sendRequest(this.databaseName, null, OMultiValue.getSingletonList((Object)this.iNode), (ORemoteTask)new OCopyDatabaseChunkTask(chunk.filePath, chunkNum, chunk.offset + (long)chunk.buffer.length, false), this.distributed.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                    Object result = response.getPayload();
                    if (!(result instanceof Boolean)) {
                        if (result instanceof Exception) {
                            ODistributedServerLog.error((Object)this, (String)this.distributed.nodeName, (String)this.iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on installing database %s in %s (chunk #%d)", (Throwable)((Exception)result), (Object[])new Object[]{this.databaseName, this.dbPath, chunkNum});
                        } else if (result instanceof ODistributedDatabaseChunk) {
                            chunk = (ODistributedDatabaseChunk)result;
                            fileSize += this.distributed.writeDatabaseChunk(chunkNum, chunk, fOut);
                        }
                    }
                    ++chunkNum;
                }
                fOut.flush();
                this.done.countDown();
                new File(this.file.getAbsolutePath() + ".completed").createNewFile();
                ODistributedServerLog.info((Object)this, (String)this.distributed.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Database copied correctly, size=%s", (Object[])new Object[]{OFileUtils.getSizeAsString((long)fileSize)});
            }
            finally {
                try {
                    fOut.flush();
                    ((OutputStream)fOut).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, (String)this.distributed.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on transferring database '%s' to '%s'", (Throwable)e, (Object[])new Object[]{this.databaseName, this.fileName});
            throw OException.wrapException((OException)new ODistributedException("Error on transferring database"), (Throwable)e);
        }
    }

    public CountDownLatch getLatch() {
        return this.done;
    }
}

