/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.sql.executor;

import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.task.OCloseQueryTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFetchQueryPageTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;

public class ODistributedResultSet
implements OResultSet {
    private String queryId;
    private List<OResult> data;
    private ODatabaseDocumentDistributed database;
    private String nodeName;
    int nextItem = -1;
    boolean finished = false;

    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.nextItem < 0) {
            throw new IllegalStateException();
        }
        if (this.data.size() < this.nextItem) {
            return true;
        }
        this.fetchNextBlock();
        return this.data.size() < this.nextItem;
    }

    public OResult next() {
        if (this.nextItem < 0) {
            throw new IllegalStateException();
        }
        if (this.finished) {
            throw new NoSuchElementException();
        }
        if (this.data.size() < this.nextItem) {
            return this.data.get(this.nextItem++);
        }
        this.fetchNextBlock();
        if (this.finished || this.data.size() >= this.nextItem) {
            throw new NoSuchElementException();
        }
        return this.data.get(this.nextItem++);
    }

    private void fetchNextBlock() {
        OFetchQueryPageTask task = new OFetchQueryPageTask(this.queryId);
        ODistributedResponse result = this.database.executeTaskOnNode((ORemoteTask)task, this.nodeName);
        this.setData((List)result.getPayload());
    }

    public void close() {
        OCloseQueryTask task = new OCloseQueryTask(this.queryId);
        this.database.executeTaskOnNode((ORemoteTask)task, this.nodeName);
        this.finished = true;
    }

    public Optional<OExecutionPlan> getExecutionPlan() {
        return null;
    }

    public Map<String, Long> getQueryStats() {
        return null;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public void setData(List<OResult> data) {
        this.data = data;
        this.nextItem = 0;
        this.finished = data.size() == 0;
    }

    public void setDatabase(ODatabaseDocumentDistributed database) {
        this.database = database;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }
}

