/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.OStreamable;
import com.orientechnologies.orient.core.serialization.OStreamableHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionResultPayload;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxConcurrentModification;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxException;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxLockTimeout;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxSuccess;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxUniqueIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OTransactionPhase1TaskResult
implements OStreamable {
    private OTransactionResultPayload resultPayload;

    public OTransactionPhase1TaskResult() {
    }

    public OTransactionPhase1TaskResult(OTransactionResultPayload resultPayload) {
        this.resultPayload = resultPayload;
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeInt(this.resultPayload.getResponseType());
        switch (this.resultPayload.getResponseType()) {
            case 1: 
            case 2: {
                break;
            }
            case 4: {
                OTxConcurrentModification pl = (OTxConcurrentModification)this.resultPayload;
                out.writeInt(pl.getRecordId().getClusterId());
                out.writeLong(pl.getRecordId().getClusterPosition());
                out.writeInt(pl.getVersion());
                break;
            }
            case 5: {
                OTxException pl2 = (OTxException)this.resultPayload;
                OStreamableHelper.toStream((DataOutput)out, (Object)pl2.getException());
                break;
            }
            case 3: {
                OTxUniqueIndex pl3 = (OTxUniqueIndex)this.resultPayload;
                out.writeInt(pl3.getRecordId().getClusterId());
                out.writeLong(pl3.getRecordId().getClusterPosition());
                String indexName = pl3.getIndex();
                byte[] indexNameBytes = indexName.getBytes();
                out.writeInt(indexNameBytes.length);
                out.write(indexNameBytes);
                if (pl3.getKey() == null) {
                    out.writeInt(-1);
                    break;
                }
                OType type = OType.getTypeByValue((Object)pl3.getKey());
                out.writeInt(type.getId());
                byte[] keyBytes = ORecordSerializerNetworkV37.INSTANCE.serializeValue(pl3.getKey(), type);
                out.writeInt(keyBytes.length);
                out.write(keyBytes);
            }
        }
    }

    public void fromStream(DataInput in) throws IOException {
        int type = in.readInt();
        switch (type) {
            case 1: {
                this.resultPayload = new OTxSuccess();
                break;
            }
            case 2: {
                this.resultPayload = new OTxLockTimeout();
                break;
            }
            case 4: {
                ORecordId rid = new ORecordId(in.readInt(), in.readLong());
                int version = in.readInt();
                this.resultPayload = new OTxConcurrentModification(rid, version);
                break;
            }
            case 5: {
                RuntimeException exception = (RuntimeException)OStreamableHelper.fromStream((DataInput)in);
                this.resultPayload = new OTxException(exception);
                break;
            }
            case 3: {
                Object keyValue;
                ORecordId rid2 = new ORecordId(in.readInt(), in.readLong());
                int indexNameSize = in.readInt();
                byte[] indexNameBytes = new byte[indexNameSize];
                in.readFully(indexNameBytes);
                String indexName = new String(indexNameBytes);
                int type2Id = in.readInt();
                if (type2Id == -1) {
                    keyValue = null;
                } else {
                    OType type2 = OType.getById((byte)((byte)type2Id));
                    int keySize = in.readInt();
                    byte[] keyBytes = new byte[keySize];
                    in.readFully(keyBytes);
                    keyValue = ORecordSerializerNetworkV37.INSTANCE.deserializeValue(keyBytes, type2);
                }
                this.resultPayload = new OTxUniqueIndex(rid2, indexName, keyValue);
            }
        }
    }

    public OTransactionResultPayload getResultPayload() {
        return this.resultPayload;
    }
}

