/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OVariableParser;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.etl.OETLComponent;
import com.orientechnologies.orient.etl.OETLProcessor;
import java.util.logging.Level;

public abstract class OETLAbstractComponent
implements OETLComponent {
    protected OETLProcessor processor;
    protected OCommandContext context;
    protected String output;
    protected String ifExpression;
    protected ODocument configuration;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + "]");
    }

    @Override
    public void configure(ODocument iConfiguration, OCommandContext iContext) {
        this.context = iContext;
        this.configuration = iConfiguration;
        this.ifExpression = (String)iConfiguration.field("if");
    }

    @Override
    public void begin(ODatabaseDocument db) {
        if (this.configuration.containsField("output")) {
            this.output = (String)this.configuration.field("output");
        }
    }

    @Override
    public void end() {
    }

    @Override
    public void setProcessor(OETLProcessor processor) {
        this.processor = processor;
    }

    protected String getCommonConfigurationParameters() {
        return "{log:{optional:true,description:'Can be any of [NONE, ERROR, INFO, DEBUG]. Default is INFO'}},{if:{optional:true,description:'Conditional expression. If true, the block is executed, otherwise is skipped'}},{output:{optional:true,description:'Variable name to store the transformer output. If null, the output will be passed to the pipeline as input for the next component.'}}";
    }

    public String toString() {
        return this.getName();
    }

    protected boolean skip(Object input) {
        OSQLFilter ifFilter = this.getIfFilter();
        if (ifFilter != null) {
            ODocument doc = input instanceof OIdentifiable ? (ODocument)((OIdentifiable)input).getRecord() : null;
            this.log(Level.FINE, "Evaluating conditional expression if=%s...", ifFilter);
            Object result = ifFilter.evaluate((OIdentifiable)doc, null, this.context);
            if (!(result instanceof Boolean)) {
                throw new OConfigurationException("'if' expression in Transformer " + this.getName() + " returned '" + result + "' instead of boolean");
            }
            return (Boolean)result == false;
        }
        return false;
    }

    protected OSQLFilter getIfFilter() {
        if (this.ifExpression != null) {
            return new OSQLFilter(this.ifExpression, this.context, null);
        }
        return null;
    }

    protected void log(Level iLevel, String iText, Object ... iArgs) {
        this.log(iLevel, iText, null, iArgs);
    }

    protected void log(Level iLevel, String iText, Exception exception, Object ... iArgs) {
        Long extractedNum;
        Long l = extractedNum = this.context != null ? (Long)this.context.getVariable("extractedNum") : null;
        if (extractedNum != null) {
            OLogManager.instance().log((Object)this, iLevel, "[" + extractedNum + ":" + this.getName() + "]  " + iText, (Throwable)exception, true, null, iArgs);
        } else {
            OLogManager.instance().log((Object)this, iLevel, "[" + this.getName() + "] " + iText, (Throwable)exception, true, null, iArgs);
        }
    }

    protected String stringArray2Json(Object[] iObject) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append('[');
        for (int i = 0; i < iObject.length; ++i) {
            Object value;
            if (i > 0) {
                buffer.append(',');
            }
            if ((value = iObject[i]) == null) continue;
            buffer.append("'");
            buffer.append(value.toString());
            buffer.append("'");
        }
        buffer.append(']');
        return buffer.toString();
    }

    protected Object resolve(Object content) {
        String contentAsString;
        if (this.context == null || content == null) {
            return content;
        }
        Object value = content instanceof String ? ((contentAsString = (String)content).startsWith("$") && !contentAsString.startsWith("${") ? this.context.getVariable(content.toString()) : OVariableParser.resolveVariables((String)contentAsString, (String)"${", (String)"}", variable -> this.context.getVariable(variable))) : content;
        if (value instanceof String) {
            value = OVariableParser.resolveVariables((String)((String)value), (String)"={", (String)"}", variable -> new OSQLPredicate(variable).evaluate(this.context));
        }
        return value;
    }
}

