/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.etl.OETLExtractedItem;
import com.orientechnologies.orient.etl.OETLProcessHaltedException;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.loader.OETLLoader;
import com.orientechnologies.orient.etl.transformer.OETLTransformer;
import java.util.List;
import java.util.logging.Level;

public class OETLPipeline {
    protected final OETLProcessor processor;
    protected final List<OETLTransformer> transformers;
    protected final OETLLoader loader;
    protected final OCommandContext context;
    protected final Level logLevel;
    protected final int maxRetries;
    protected boolean haltOnError;
    protected ODatabasePool pool;

    public OETLPipeline(OETLProcessor processor, List<OETLTransformer> transformers, OETLLoader loader, Level logLevel, int maxRetries, boolean haltOnError) {
        this.processor = processor;
        this.transformers = transformers;
        this.loader = loader;
        this.logLevel = logLevel;
        this.maxRetries = maxRetries;
        this.haltOnError = haltOnError;
        this.context = new OBasicCommandContext();
    }

    public synchronized void begin() {
        this.loader.beginLoader(this);
        for (OETLTransformer transformer : this.transformers) {
            transformer.setContext(this.context);
            ODatabaseSession db = this.pool.acquire();
            transformer.begin((ODatabaseDocument)db);
            db.close();
        }
    }

    public void setPool(ODatabasePool pool) {
        this.pool = pool;
    }

    public OCommandContext getContext() {
        return this.context;
    }

    protected Object execute(OETLExtractedItem source) {
        int retry = 0;
        do {
            ODatabaseSession db = this.pool.acquire();
            db.activateOnCurrentThread();
            try {
                Object current = source.payload;
                this.context.setVariable("extractedNum", (Object)source.num);
                this.context.setVariable("extractedPayload", source.payload);
                for (OETLTransformer t : this.transformers) {
                    current = t.transform((ODatabaseDocument)db, current);
                    if (current != null) continue;
                    OETLContextWrapper.getInstance().getMessageHandler().warn((Object)this, "Transformer [%s] returned null, skip rest of pipeline execution", new Object[]{t});
                }
                if (current != null) {
                    this.loader.load((ODatabaseDocument)db, current, this.context);
                }
                db.commit();
                Object object = current;
                return object;
            }
            catch (ONeedRetryException e) {
                this.loader.rollback((ODatabaseDocument)db);
                OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "Error in pipeline execution, retry = %d/%d (exception=)", new Object[]{++retry, this.maxRetries, e});
            }
            catch (OETLProcessHaltedException e) {
                OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "Pipeline execution halted");
                this.processor.getStats().incrementErrors();
                this.loader.rollback((ODatabaseDocument)db);
                throw e;
            }
            catch (Exception e) {
                OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "Error in Pipeline execution: %s", new Object[]{e});
                this.processor.getStats().incrementErrors();
                if (!this.haltOnError) {
                    Object var5_9 = null;
                    return var5_9;
                }
                this.loader.rollback((ODatabaseDocument)db);
                throw OException.wrapException((OException)new OETLProcessHaltedException("Halt"), (Throwable)e);
            }
            finally {
                db.close();
            }
        } while (retry < this.maxRetries);
        return this;
    }

    public void end() {
    }
}

