/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl;

import com.orientechnologies.orient.etl.OETLExtractedItem;
import com.orientechnologies.orient.etl.OETLPipeline;
import java.util.concurrent.BlockingQueue;

final class OETLPipelineWorker
implements Runnable {
    private final BlockingQueue<OETLExtractedItem> queue;
    private final OETLPipeline pipeline;

    public OETLPipelineWorker(BlockingQueue<OETLExtractedItem> queue, OETLPipeline pipeline) {
        this.queue = queue;
        this.pipeline = pipeline;
        pipeline.begin();
    }

    @Override
    public void run() {
        try {
            OETLExtractedItem content;
            while (true) {
                content = this.queue.take();
                if (content.finished) break;
                this.pipeline.execute(content);
            }
            this.pipeline.end();
            this.queue.put(content);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

